/*
 * Decompiled with CFR 0.152.
 */
package deepboof.io.caffe;

import caffe.Caffe;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.GeneratedMessage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.List;

public class PrintWeightCrap {
    public static CharSequence fromFile(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        return Charset.forName("8859_1").newDecoder().decode(bbuf);
    }

    static void tabString(String message) {
        String[] lines;
        for (String line : lines = message.split("\n")) {
            System.out.println("  " + line);
        }
    }

    static void printLayers(List<Caffe.V1LayerParameter> layers) {
        System.out.println("---------- Total V1LayerParameter = " + layers.size());
        for (int i = 0; i < layers.size(); ++i) {
            List<Caffe.BlobProto> blobs;
            GeneratedMessage param;
            Caffe.V1LayerParameter layer = layers.get(i);
            System.out.println("------------------------------------------------------");
            System.out.println("name         = " + layer.getName());
            System.out.println("type         = " + (Object)((Object)layer.getType()));
            System.out.println("has data     = " + layer.hasDataParam());
            List<String> bottoms = layer.getBottomList();
            List<String> tops = layer.getTopList();
            for (String s : tops) {
                System.out.println("top          = " + s);
            }
            for (String s : bottoms) {
                System.out.println("bottom       = " + s);
            }
            if (layer.getParamList().size() > 0) {
                List<String> paramList = layer.getParamList();
                System.out.println("parameter list  " + paramList.size());
                for (String w : paramList) {
                    System.out.println("     " + w);
                }
            }
            if (layer.hasDataParam()) {
                System.out.println("Data Param");
                param = layer.getDataParam();
                PrintWeightCrap.tabString(param.toString());
            }
            if (layer.hasConvolutionParam()) {
                System.out.println("Convolution Param");
                param = layer.getConvolutionParam();
                PrintWeightCrap.tabString(param.toString());
            }
            if (layer.hasDropoutParam()) {
                System.out.println("Dropout Param");
                param = layer.getDropoutParam();
                PrintWeightCrap.tabString(param.toString());
            }
            if (layer.hasInnerProductParam()) {
                System.out.println("Inner Product Param");
                param = layer.getInnerProductParam();
                PrintWeightCrap.tabString(param.toString());
            }
            if (layer.hasLrnParam()) {
                System.out.println("LRN Param");
                param = layer.getLrnParam();
                PrintWeightCrap.tabString(param.toString());
            }
            if (layer.hasPoolingParam()) {
                System.out.println("Pooling Param");
                param = layer.getPoolingParam();
                PrintWeightCrap.tabString(param.toString());
            }
            if ((blobs = layer.getBlobsList()).size() <= 0) continue;
            System.out.println("Blobs  size = " + blobs.size());
            for (Caffe.BlobProto blob : blobs) {
                System.out.println("   --- blob");
                if (blob.hasShape()) {
                    Caffe.BlobShape shape = blob.getShape();
                    System.out.print("  shape = ");
                    for (int j = 0; j < shape.getDimCount(); ++j) {
                        System.out.print(" " + shape.getDim(j));
                    }
                    System.out.println();
                }
                if (blob.hasNum()) {
                    System.out.println("  num = " + blob.getNum());
                }
                if (blob.hasChannels()) {
                    System.out.println("  channels = " + blob.getChannels());
                }
                if (blob.hasHeight()) {
                    System.out.println("  height = " + blob.getHeight());
                }
                if (blob.hasWidth()) {
                    System.out.println("  width = " + blob.getWidth());
                }
                System.out.println("  data count = " + blob.getDataCount());
                System.out.println("  diff count = " + blob.getDiffCount());
            }
        }
        System.out.println();
    }

    public static void printLayer(List<Caffe.LayerParameter> layers) {
        System.out.println("---------- Total LayerParameter = " + layers.size());
        for (int i = 0; i < layers.size(); ++i) {
            int j;
            Caffe.LayerParameter layer = layers.get(i);
            System.out.println("------------------------------------------------------");
            System.out.println("name         = " + layer.getName());
            System.out.println("type         = " + layer.getType());
            List<String> bottoms = layer.getBottomList();
            List<String> tops = layer.getTopList();
            for (String s : tops) {
                System.out.println("top          = " + s);
            }
            for (String s : bottoms) {
                System.out.println("bottom       = " + s);
            }
            if (!layer.hasConvolutionParam()) continue;
            System.out.println("Convolution Parameters:");
            Caffe.ConvolutionParameter param = layer.getConvolutionParam();
            for (j = 0; j < param.getKernelSizeCount(); ++j) {
                System.out.println("  kernel size    = " + param.getKernelSize(j));
            }
            System.out.println("  num out = " + param.getNumOutput());
            for (j = 0; j < param.getStrideCount(); ++j) {
                System.out.println("  stride  = " + param.getStride(j));
            }
        }
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        String path = "data/caffe_models/alexnet/bvlc_alexnet.caffemodel";
        CodedInputStream input = CodedInputStream.newInstance((InputStream)new FileInputStream(path));
        input.setSizeLimit(0x20000000);
        System.out.println("Before");
        Caffe.NetParameter parameters = Caffe.NetParameter.parseFrom(input);
        System.out.println("After");
        System.out.println("name = " + parameters.getName());
        System.out.println("   getInputDimCount()  = " + parameters.getInputDimCount());
        System.out.println("   getLayerList().size() = " + parameters.getLayerList().size());
        System.out.println("   getLayersList().size() = " + parameters.getLayersList().size());
        System.out.println("   getInputShapeCount() = " + parameters.getInputShapeCount());
        List<Caffe.LayerParameter> layers = parameters.getLayerList();
        PrintWeightCrap.printLayers(parameters.getLayersList());
        PrintWeightCrap.printLayer(parameters.getLayerList());
    }
}

