/*
 * Decompiled with CFR 0.152.
 */
package deepboof.misc;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.Planar;
import deepboof.tensors.Tensor_F32;

public class DataManipulationOps {
    public static void normalize(GrayF32 image, float mean, float stdev) {
        for (int y = 0; y < image.height; ++y) {
            int index;
            int end = index + image.width;
            for (index = image.startIndex + y * image.stride; index < end; ++index) {
                image.data[index] = (image.data[index] - mean) / stdev;
            }
        }
    }

    public static void imageToTensor(Planar<GrayF32> input, Tensor_F32 output, int miniBatch) {
        if (input.isSubimage()) {
            throw new RuntimeException("Subimages not accepted");
        }
        if (output.getDimension() != 4) {
            throw new IllegalArgumentException("Output should be 4-DOF.  batch + spatial (channel,height,width)");
        }
        if (output.length(1) != input.getNumBands()) {
            throw new IllegalArgumentException("Number of bands don't match");
        }
        if (output.length(2) != input.getHeight()) {
            throw new IllegalArgumentException("Spatial height doesn't match");
        }
        if (output.length(3) != input.getWidth()) {
            throw new IllegalArgumentException("Spatial width doesn't match");
        }
        for (int i = 0; i < input.getNumBands(); ++i) {
            GrayF32 band = (GrayF32)input.getBand(i);
            int indexOut = output.idx(miniBatch, i, 0, 0);
            int length = input.width * input.height;
            System.arraycopy(band.data, 0, output.d, indexOut, length);
        }
    }
}

