/*
 * Decompiled with CFR 0.152.
 */
package deepboof.factory;

import deepboof.Tensor;
import deepboof.forward.ConfigPadding;
import deepboof.impl.forward.standard.BaseSpatialPadding2D;
import deepboof.impl.forward.standard.ClippedPadding2D_F32;
import deepboof.impl.forward.standard.ClippedPadding2D_F64;
import deepboof.impl.forward.standard.ConstantPadding2D_F32;
import deepboof.impl.forward.standard.ConstantPadding2D_F64;
import deepboof.tensors.Tensor_F32;
import deepboof.tensors.Tensor_F64;

public class FactoryForwards {
    public static <T extends Tensor<T>> BaseSpatialPadding2D<T> spatialPadding(ConfigPadding config, Class<T> type) {
        if (type == Tensor_F64.class) {
            switch (config.type) {
                case ZERO: 
                case MAX_NEGATIVE: {
                    return new ConstantPadding2D_F64(config);
                }
                case CLIPPED: {
                    return new ClippedPadding2D_F64(config);
                }
            }
        } else if (type == Tensor_F32.class) {
            switch (config.type) {
                case ZERO: 
                case MAX_NEGATIVE: {
                    return new ConstantPadding2D_F32(config);
                }
                case CLIPPED: {
                    return new ClippedPadding2D_F32(config);
                }
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }
}

