/*
 * Decompiled with CFR 0.152.
 */
package deepboof;

import deepboof.BaseTensor;
import deepboof.misc.TensorOps;

public abstract class Tensor<T extends Tensor<T>>
extends BaseTensor {
    public int startIndex = 0;
    public boolean subtensor = false;
    public int[] strides = new int[0];

    public abstract double getDouble(int ... var1);

    public abstract Object getData();

    public abstract void setData(Object var1);

    public Tensor<T> reshape(int ... shape) {
        if (this.shape.length != shape.length) {
            this.shape = new int[shape.length];
        }
        System.arraycopy(shape, 0, this.shape, 0, shape.length);
        return this.reshape();
    }

    public Tensor<T> reshape(int length0) {
        if (this.shape.length != 1) {
            this.shape = new int[1];
        }
        this.shape[0] = length0;
        return this.reshape();
    }

    public Tensor<T> reshape(int length1, int length0) {
        if (this.shape.length != 2) {
            this.shape = new int[2];
        }
        this.shape[0] = length1;
        this.shape[1] = length0;
        return this.reshape();
    }

    public Tensor<T> reshape(int length2, int length1, int length0) {
        if (this.shape.length != 3) {
            this.shape = new int[3];
        }
        this.shape[0] = length2;
        this.shape[1] = length1;
        this.shape[2] = length0;
        return this.reshape();
    }

    public Tensor<T> reshape(int length3, int length2, int length1, int length0) {
        if (this.shape.length != 4) {
            this.shape = new int[4];
        }
        this.shape[0] = length3;
        this.shape[1] = length2;
        this.shape[2] = length1;
        this.shape[3] = length0;
        return this.reshape();
    }

    public Tensor<T> reshape(int length4, int length3, int length2, int length1, int length0) {
        if (this.shape.length != 5) {
            this.shape = new int[5];
        }
        this.shape[0] = length4;
        this.shape[1] = length3;
        this.shape[2] = length2;
        this.shape[3] = length1;
        this.shape[4] = length0;
        return this.reshape();
    }

    public Tensor<T> reshape() {
        int N = TensorOps.tensorLength(this.shape);
        this.computeStrides();
        if (this.innerArrayLength() < N + this.startIndex) {
            if (this.subtensor) {
                throw new IllegalArgumentException("Can't reshape sub-tensors if it requires the data array to grow");
            }
            if (this.startIndex != 0) {
                throw new RuntimeException("BUG: Not a sub-tensor and startIndex isn't zero!");
            }
            this.innerArrayGrow(N);
        }
        return this;
    }

    protected abstract void innerArrayGrow(int var1);

    protected abstract int innerArrayLength();

    public int idx(int ... coordinate) {
        int index = 0;
        for (int i = 0; i < coordinate.length; ++i) {
            index += coordinate[i] * this.strides[i];
        }
        return index + this.startIndex;
    }

    public int idx(int axis0) {
        return this.startIndex + axis0;
    }

    public int idx(int axis1, int axis0) {
        return this.startIndex + axis1 * this.strides[0] + axis0;
    }

    public int idx(int axis2, int axis1, int axis0) {
        return this.startIndex + axis2 * this.strides[0] + axis1 * this.strides[1] + axis0;
    }

    public int idx(int axis3, int axis2, int axis1, int axis0) {
        return this.startIndex + axis3 * this.strides[0] + axis2 * this.strides[1] + axis1 * this.strides[2] + axis0;
    }

    public int idx(int axis4, int axis3, int axis2, int axis1, int axis0) {
        return this.startIndex + axis4 * this.strides[0] + axis3 * this.strides[1] + axis2 * this.strides[2] + axis1 * this.strides[3] + axis0;
    }

    public void computeStrides() {
        if (this.strides.length != this.shape.length) {
            this.strides = new int[this.shape.length];
        }
        int N = 1;
        for (int i = this.shape.length - 1; i >= 0; --i) {
            this.strides[i] = N;
            N *= this.shape[i];
        }
    }

    public int stride(int index) {
        if (index < 0) {
            return this.strides[this.strides.length + index];
        }
        return this.strides[index];
    }

    public void copyShape(int[] shape) {
        if (shape.length != this.shape.length) {
            throw new IllegalArgumentException("Dimension of input shape and actual shape must be the same");
        }
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = this.shape[i];
        }
    }

    @Override
    public int length(int dimension) {
        if (dimension < 0) {
            return this.shape[this.shape.length + dimension];
        }
        return this.shape[dimension];
    }

    public int length() {
        if (this.shape.length == 0) {
            return 0;
        }
        return this.shape[0] * this.strides[0];
    }

    public abstract T create(int ... var1);

    public T createLike() {
        return this.create(this.shape);
    }

    @Override
    public int[] createCoor() {
        return new int[this.getDimension()];
    }

    public int[] indexToCoor(int index, int[] storage) {
        if (storage == null) {
            storage = this.createCoor();
        }
        for (int i = 0; i < storage.length; ++i) {
            storage[i] = index / this.strides[i];
            index -= storage[i] * this.strides[i];
        }
        return storage;
    }

    public T setTo(T original) {
        this.reshape(((BaseTensor)original).getShape());
        System.arraycopy(((Tensor)original).getData(), ((Tensor)original).startIndex, this.getData(), this.startIndex, this.length());
        return (T)this;
    }

    public abstract Tensor<T> zero();

    public T copy() {
        Tensor out = this.createLike();
        out.setTo((Tensor)this);
        return (T)out;
    }

    public boolean isSub() {
        return this.subtensor;
    }

    public T subtensor(int startIndex, int[] shape) {
        T out = this.create(new int[0]);
        ((Tensor)out).setData(this.getData());
        ((Tensor)out).startIndex = startIndex;
        ((Tensor)out).shape = shape;
        ((Tensor)out).subtensor = true;
        ((Tensor)out).computeStrides();
        return out;
    }
}

