/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.deepsymmetry.beatlink.DeviceAnnouncement;

public class DeviceListener {
    private static final Logger logger = Logger.getLogger(DeviceListener.class.getName());
    public static final int ANNOUNCEMENT_PORT = 50000;
    public static final int MAXIMUM_AGE = 5000;
    private static DatagramSocket socket;
    private static final Map<InetAddress, DeviceAnnouncement> devices;

    public static synchronized boolean isActive() {
        return socket != null;
    }

    private static void expireDevices() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<InetAddress, DeviceAnnouncement>> it = devices.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<InetAddress, DeviceAnnouncement> entry = it.next();
            if (now - entry.getValue().getTimestamp() <= 5000L) continue;
            it.remove();
        }
    }

    public static synchronized void start() throws SocketException {
        if (!DeviceListener.isActive()) {
            socket = new DatagramSocket(50000);
            byte[] buffer = new byte[512];
            final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            Thread receiver = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (DeviceListener.isActive()) {
                        block5: {
                            try {
                                socket.receive(packet);
                            }
                            catch (IOException e) {
                                if (!DeviceListener.isActive()) break block5;
                                logger.log(Level.WARNING, "Problem reading from DeviceAnnouncement socket, stopping", e);
                                DeviceListener.stop();
                            }
                        }
                        try {
                            if (packet.getLength() != 54) continue;
                            DeviceAnnouncement announcement = new DeviceAnnouncement(packet);
                            devices.put(announcement.getAddress(), announcement);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Problem parsing DeviceAnnouncement packet", e);
                        }
                    }
                }
            });
            receiver.setDaemon(true);
            receiver.start();
        }
    }

    public static synchronized void stop() {
        if (DeviceListener.isActive()) {
            socket.close();
            socket = null;
            devices.clear();
        }
    }

    public static List<DeviceAnnouncement> currentDevices() {
        DeviceListener.expireDevices();
        return Collections.unmodifiableList(new ArrayList<DeviceAnnouncement>(devices.values()));
    }

    private DeviceListener() {
    }

    static {
        devices = new HashMap<InetAddress, DeviceAnnouncement>();
    }
}

