/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.Util;

public class CdjStatus
extends DeviceUpdate {
    public static final int STATUS_FLAGS = 137;
    public static final int ON_AIR_FLAG = 8;
    public static final int SYNCED_FLAG = 16;
    public static final int MASTER_FLAG = 32;
    public static final int PLAYING_FLAG = 64;
    private final PlayState1 playState1;
    private final PlayState2 playState2;
    private final PlayState3 playState3;
    private final int pitch;
    private final int bpm;

    public PlayState1 getPlayState1() {
        return this.playState1;
    }

    public PlayState2 getPlayState2() {
        return this.playState2;
    }

    public PlayState3 getPlayState3() {
        return this.playState3;
    }

    private PlayState1 findPlayState1() {
        switch (this.packetBytes[123]) {
            case 0: {
                return PlayState1.NO_TRACK;
            }
            case 3: {
                return PlayState1.PLAYING;
            }
            case 4: {
                return PlayState1.LOOPING;
            }
            case 5: {
                return PlayState1.PAUSED;
            }
            case 6: {
                return PlayState1.CUED;
            }
            case 9: {
                return PlayState1.SEARCHING;
            }
            case 17: {
                return PlayState1.ENDED;
            }
        }
        return PlayState1.UNKNOWN;
    }

    private PlayState2 findPlayState2() {
        switch (this.packetBytes[139]) {
            case 122: {
                return PlayState2.MOVING;
            }
            case 126: {
                return PlayState2.STOPPED;
            }
        }
        return PlayState2.UNKNOWN;
    }

    private PlayState3 findPlayState3() {
        switch (this.packetBytes[157]) {
            case 0: {
                return PlayState3.NO_TRACK;
            }
            case 1: {
                return PlayState3.PAUSED_OR_REVERSE;
            }
            case 9: {
                return PlayState3.FORWARD_VINYL;
            }
            case 13: {
                return PlayState3.FORWARD_CDJ;
            }
        }
        return PlayState3.UNKNOWN;
    }

    public CdjStatus(DatagramPacket packet) {
        super(packet, "CDJ status", 212);
        this.pitch = (int)Util.bytesToNumber(this.packetBytes, 141, 3);
        this.bpm = (int)Util.bytesToNumber(this.packetBytes, 146, 2);
        this.playState1 = this.findPlayState1();
        this.playState2 = this.findPlayState2();
        this.playState3 = this.findPlayState3();
    }

    public int getPitch() {
        return this.pitch;
    }

    public int getPitch(int number) {
        switch (number) {
            case 1: {
                return this.pitch;
            }
            case 2: {
                return (int)Util.bytesToNumber(this.packetBytes, 153, 3);
            }
            case 3: {
                return (int)Util.bytesToNumber(this.packetBytes, 193, 3);
            }
            case 4: {
                return (int)Util.bytesToNumber(this.packetBytes, 197, 3);
            }
        }
        throw new IllegalArgumentException("Pitch number must be between 1 and 4");
    }

    public int getBpm() {
        return this.bpm;
    }

    public int getBeatWithinBar() {
        return this.packetBytes[92];
    }

    @Override
    public boolean isTempoMaster() {
        return (this.packetBytes[137] & 0x20) > 0;
    }

    @Override
    public double getEffectiveTempo() {
        return (double)this.bpm * Util.pitchToMultiplier(this.pitch) / 100.0;
    }

    public boolean isPlaying() {
        return (this.packetBytes[137] & 0x40) > 0;
    }

    public boolean isSynced() {
        return (this.packetBytes[137] & 0x10) > 0;
    }

    public boolean isOnAir() {
        return (this.packetBytes[137] & 8) > 0;
    }

    public boolean isLocalUsbLoaded() {
        return this.packetBytes[111] == 0;
    }

    public boolean isLocalUsbUnloading() {
        return this.packetBytes[111] == 2;
    }

    public boolean isLocalUsbEmpty() {
        return this.packetBytes[111] == 4;
    }

    public boolean isTrackLoaded() {
        return this.playState1 != PlayState1.NO_TRACK;
    }

    public boolean isLooping() {
        return this.playState1 == PlayState1.LOOPING;
    }

    public boolean isPaused() {
        return this.playState1 == PlayState1.PAUSED || this.playState1 == PlayState1.CUED;
    }

    public boolean isCued() {
        return this.playState1 == PlayState1.CUED;
    }

    public boolean isSearching() {
        return this.playState1 == PlayState1.SEARCHING;
    }

    public boolean isAtEnd() {
        return this.playState1 == PlayState1.ENDED;
    }

    public boolean isPlayingForwards() {
        return this.playState1 == PlayState1.PLAYING && this.playState3 != PlayState3.PAUSED_OR_REVERSE;
    }

    public boolean isPlayingBackwards() {
        return this.playState1 == PlayState1.PLAYING && this.playState3 == PlayState3.PAUSED_OR_REVERSE;
    }

    public boolean isPlayingVinylMode() {
        return this.playState3 == PlayState3.FORWARD_VINYL;
    }

    public boolean isPlayingCdjMode() {
        return this.playState3 == PlayState3.FORWARD_CDJ;
    }

    public boolean isLinkedUsbAvailable() {
        return this.packetBytes[117] != 0;
    }

    public boolean isBusy() {
        return this.packetBytes[39] != 0;
    }

    public int getTrackNumber() {
        return (int)Util.bytesToNumber(this.packetBytes, 50, 2);
    }

    public int getSyncNumber() {
        return (int)Util.bytesToNumber(this.packetBytes, 134, 2);
    }

    public int getBeatNumber() {
        return (int)Util.bytesToNumber(this.packetBytes, 160, 4);
    }

    public int getCueCountdown() {
        return (int)Util.bytesToNumber(this.packetBytes, 164, 2);
    }

    public String formatCueCountdown() {
        int count = this.getCueCountdown();
        if (count == 511) {
            return "--.-";
        }
        if (count >= 1 && count <= 256) {
            int bars = (count - 1) / 4;
            int beats = (count - 1) % 4 + 1;
            return String.format("%02d.%d", bars, beats);
        }
        if (count == 0) {
            return "00.0";
        }
        return "??.?";
    }

    public long getPacketNumber() {
        return Util.bytesToNumber(this.packetBytes, 200, 4);
    }

    public String toString() {
        return "CDJ status: Device " + this.deviceNumber + ", name: " + this.deviceName + ", busy? " + this.isBusy() + ", pitch: " + String.format("%+.2f%%", Util.pitchToPercentage(this.pitch)) + ", track: " + this.getTrackNumber() + ", track BPM: " + String.format("%.1f", (double)this.bpm / 100.0) + ", effective BPM: " + String.format("%.1f", this.getEffectiveTempo()) + ", beat: " + this.getBeatNumber() + ", beat within bar: " + this.getBeatWithinBar() + ", cue: " + this.formatCueCountdown() + ", Playing? " + this.isPlaying() + ", Master? " + this.isTempoMaster() + ", Synced? " + this.isSynced() + ", On-Air? " + this.isOnAir();
    }

    public static enum PlayState3 {
        NO_TRACK,
        PAUSED_OR_REVERSE,
        FORWARD_VINYL,
        FORWARD_CDJ,
        UNKNOWN;

    }

    public static enum PlayState2 {
        MOVING,
        STOPPED,
        UNKNOWN;

    }

    public static enum PlayState1 {
        NO_TRACK,
        PLAYING,
        LOOPING,
        PAUSED,
        CUED,
        SEARCHING,
        ENDED,
        UNKNOWN;

    }
}

