/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.Util;

public class MixerStatus
extends DeviceUpdate {
    public static final int STATUS_FLAGS = 39;
    private final int bpm;

    public MixerStatus(DatagramPacket packet) {
        super(packet, "Mixer update", 56);
        this.bpm = (int)Util.bytesToNumber(this.packetBytes, 46, 2);
    }

    public int getBpm() {
        return this.bpm;
    }

    public int getBeatWithinBar() {
        return this.packetBytes[55];
    }

    @Override
    public boolean isTempoMaster() {
        return (this.packetBytes[39] & 0x20) > 0;
    }

    @Override
    public double getEffectiveTempo() {
        return (double)this.bpm / 100.0;
    }

    public String toString() {
        return "Mixer status: Device " + this.deviceNumber + ", name: " + this.deviceName + ", BPM: " + String.format("%.1f", (double)this.bpm / 100.0) + ", beat within bar: " + this.getBeatWithinBar();
    }
}

