/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;

public class DeviceFinder {
    private static final Logger logger = Logger.getLogger(DeviceFinder.class.getName());
    public static final int ANNOUNCEMENT_PORT = 50000;
    public static final int MAXIMUM_AGE = 10000;
    private static DatagramSocket socket;
    private static final Map<InetAddress, DeviceAnnouncement> devices;
    private static final Set<DeviceAnnouncementListener> listeners;

    public static synchronized boolean isActive() {
        return socket != null;
    }

    private static synchronized void expireDevices() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<InetAddress, DeviceAnnouncement>> it = devices.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<InetAddress, DeviceAnnouncement> entry = it.next();
            if (now - entry.getValue().getTimestamp() <= 10000L) continue;
            DeviceFinder.deliverLostAnnouncement(entry.getValue());
            it.remove();
        }
    }

    private static synchronized void updateDevices(DeviceAnnouncement announcement) {
        devices.put(announcement.getAddress(), announcement);
    }

    private static synchronized boolean isDeviceKnown(DeviceAnnouncement announcement) {
        return devices.containsKey(announcement.getAddress());
    }

    public static synchronized void start() throws SocketException {
        if (!DeviceFinder.isActive()) {
            socket = new DatagramSocket(50000);
            byte[] buffer = new byte[512];
            final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            Thread receiver = new Thread(null, new Runnable(){

                @Override
                public void run() {
                    while (DeviceFinder.isActive()) {
                        boolean received;
                        try {
                            if (DeviceFinder.currentDevices().isEmpty()) {
                                socket.setSoTimeout(0);
                            } else {
                                socket.setSoTimeout(1000);
                            }
                            received = true;
                            socket.receive(packet);
                        }
                        catch (SocketTimeoutException ste) {
                            received = false;
                        }
                        catch (IOException e) {
                            if (DeviceFinder.isActive()) {
                                logger.log(Level.WARNING, "Problem reading from DeviceAnnouncement socket, stopping", e);
                                DeviceFinder.stop();
                            }
                            received = false;
                        }
                        try {
                            if (received && (!VirtualCdj.isActive() || !packet.getAddress().equals(VirtualCdj.getLocalAddress())) && packet.getLength() == 54 && Util.validateHeader(packet, 6, "device announcement")) {
                                DeviceAnnouncement announcement = new DeviceAnnouncement(packet);
                                if (!DeviceFinder.isDeviceKnown(announcement)) {
                                    DeviceFinder.deliverFoundAnnouncement(announcement);
                                }
                                DeviceFinder.updateDevices(announcement);
                            }
                            DeviceFinder.expireDevices();
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Problem processing DeviceAnnouncement packet", e);
                        }
                    }
                }
            }, "beat-link DeviceFinder receiver");
            receiver.setDaemon(true);
            receiver.start();
        }
    }

    public static synchronized void stop() {
        if (DeviceFinder.isActive()) {
            Set<DeviceAnnouncement> lastDevices = DeviceFinder.currentDevices();
            socket.close();
            socket = null;
            for (DeviceAnnouncement announcement : lastDevices) {
                DeviceFinder.deliverLostAnnouncement(announcement);
            }
            devices.clear();
        }
    }

    public static Set<DeviceAnnouncement> currentDevices() {
        if (!DeviceFinder.isActive()) {
            throw new IllegalStateException("DeviceFinder is not active");
        }
        DeviceFinder.expireDevices();
        return Collections.unmodifiableSet(new HashSet<DeviceAnnouncement>(devices.values()));
    }

    public static synchronized void addDeviceAnnouncementListener(DeviceAnnouncementListener listener) {
        if (listener != null) {
            listeners.add(listener);
        }
    }

    public static synchronized void removeDeviceAnnouncementListener(DeviceAnnouncementListener listener) {
        if (listener != null) {
            listeners.remove(listener);
        }
    }

    public static synchronized Set<DeviceAnnouncementListener> getDeviceAnnouncementListeners() {
        return Collections.unmodifiableSet(new HashSet<DeviceAnnouncementListener>(listeners));
    }

    private static void deliverFoundAnnouncement(final DeviceAnnouncement announcement) {
        for (final DeviceAnnouncementListener listener : DeviceFinder.getDeviceAnnouncementListeners()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.deviceFound(announcement);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Problem delivering device found announcement to listener", e);
                    }
                }
            });
        }
    }

    private static void deliverLostAnnouncement(final DeviceAnnouncement announcement) {
        for (final DeviceAnnouncementListener listener : DeviceFinder.getDeviceAnnouncementListeners()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.deviceLost(announcement);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Problem delivering device lost announcement to listener", e);
                    }
                }
            });
        }
    }

    private DeviceFinder() {
    }

    static {
        devices = new HashMap<InetAddress, DeviceAnnouncement>();
        listeners = new HashSet<DeviceAnnouncementListener>();
    }
}

