/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.deepsymmetry.beatlink.Beat;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.MasterListener;
import org.deepsymmetry.beatlink.MixerStatus;
import org.deepsymmetry.beatlink.Util;

public class VirtualCdj {
    private static final Logger logger = Logger.getLogger(VirtualCdj.class.getName());
    public static final int UPDATE_PORT = 50002;
    private static DatagramSocket socket;
    private static InetAddress broadcastAddress;
    private static final Map<InetAddress, DeviceUpdate> updates;
    private static int announceInterval;
    private static byte[] announcementBytes;
    private static DeviceUpdate tempoMaster;
    private static double tempoEpsilon;
    private static double masterTempo;
    private static final Set<MasterListener> masterListeners;
    private static final Set<DeviceUpdateListener> updateListeners;

    public static synchronized boolean isActive() {
        return socket != null;
    }

    public static synchronized InetAddress getLocalAddress() {
        VirtualCdj.ensureActive();
        return socket.getLocalAddress();
    }

    public static synchronized InetAddress getBroadcastAddress() {
        VirtualCdj.ensureActive();
        return broadcastAddress;
    }

    public static synchronized byte getDeviceNumber() {
        return announcementBytes[36];
    }

    public static synchronized void setDeviceNumber(byte number) {
        VirtualCdj.announcementBytes[36] = number;
    }

    public static synchronized int getAnnounceInterval() {
        return announceInterval;
    }

    public static synchronized void setAnnounceInterval(int interval) {
        if (interval < 200 || interval > 2000) {
            throw new IllegalArgumentException("Interval must be between 200 and 2000");
        }
        announceInterval = interval;
    }

    public static synchronized String getDeviceName() {
        return new String(announcementBytes, 12, 20).trim();
    }

    public static synchronized void setDeviceName(String name) {
        if (name.getBytes().length > 20) {
            throw new IllegalArgumentException("name cannot be more than 20 bytes long");
        }
        Arrays.fill(announcementBytes, 12, 32, (byte)0);
        System.arraycopy(name.getBytes(), 0, announcementBytes, 12, name.getBytes().length);
    }

    private static void ensureActive() {
        if (!VirtualCdj.isActive()) {
            throw new IllegalStateException("VirtualCdj is not active");
        }
    }

    public static synchronized DeviceUpdate getTempoMaster() {
        VirtualCdj.ensureActive();
        return tempoMaster;
    }

    private static synchronized void setTempoMaster(DeviceUpdate newMaster) {
        if (newMaster == null && tempoMaster != null || newMaster != null && (tempoMaster == null || !newMaster.getAddress().equals(tempoMaster.getAddress()))) {
            VirtualCdj.deliverMasterChangedAnnouncement(newMaster);
        }
        tempoMaster = newMaster;
    }

    public static synchronized double getTempoEpsilon() {
        return tempoEpsilon;
    }

    public static synchronized void setTempoEpsilon(double epsilon) {
        tempoEpsilon = epsilon;
    }

    public static synchronized double getMasterTempo() {
        VirtualCdj.ensureActive();
        return masterTempo;
    }

    private static synchronized void setMasterTempo(double newTempo) {
        if (tempoMaster != null && Math.abs(newTempo - masterTempo) > tempoEpsilon) {
            VirtualCdj.deliverTempoChangedAnnouncement(newTempo);
            masterTempo = newTempo;
        }
    }

    private static DeviceUpdate buildUpdate(DatagramPacket packet) {
        int length = packet.getLength();
        byte kind = packet.getData()[10];
        if (length == 56 && kind == 41 && Util.validateHeader(packet, 41, "Mixer Status")) {
            return new MixerStatus(packet);
        }
        if ((length == 212 || length == 208) && kind == 10 && Util.validateHeader(packet, 10, "CDJ Status")) {
            return new CdjStatus(packet);
        }
        logger.log(Level.WARNING, "Unrecognized device update packet with length " + length + " and kind " + kind);
        return null;
    }

    private static synchronized void processUpdate(DeviceUpdate update) {
        updates.put(update.getAddress(), update);
        if (update.isTempoMaster()) {
            VirtualCdj.setTempoMaster(update);
            VirtualCdj.setMasterTempo(update.getEffectiveTempo());
        } else if (tempoMaster != null && tempoMaster.getAddress().equals(update.getAddress())) {
            VirtualCdj.setTempoMaster(null);
        }
        VirtualCdj.deliverDeviceUpdate(update);
    }

    static synchronized void processBeat(Beat beat) {
        if (VirtualCdj.isActive() && beat.isTempoMaster()) {
            VirtualCdj.setMasterTempo(beat.getEffectiveTempo());
            VirtualCdj.deliverBeatAnnouncement(beat);
        }
    }

    private static InterfaceAddress findMatchingAddress(DeviceAnnouncement aDevice, NetworkInterface networkInterface) {
        for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
            if (address.getBroadcast() == null || !Util.sameNetwork(address.getNetworkPrefixLength(), aDevice.getAddress(), address.getAddress())) continue;
            return address;
        }
        return null;
    }

    private static synchronized boolean createVirtualCdj() throws SocketException {
        NetworkInterface matchedInterface = null;
        InterfaceAddress matchedAddress = null;
        DeviceAnnouncement aDevice = DeviceFinder.currentDevices().iterator().next();
        for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            matchedAddress = VirtualCdj.findMatchingAddress(aDevice, networkInterface);
            if (matchedAddress == null) continue;
            matchedInterface = networkInterface;
            break;
        }
        if (matchedAddress == null) {
            logger.log(Level.WARNING, "Unable to find network interface to communicate with " + aDevice + ", giving up.");
            return false;
        }
        System.arraycopy(matchedInterface.getHardwareAddress(), 0, announcementBytes, 38, 6);
        System.arraycopy(matchedAddress.getAddress().getAddress(), 0, announcementBytes, 44, 4);
        broadcastAddress = matchedAddress.getBroadcast();
        socket = new DatagramSocket(50002, matchedAddress.getAddress());
        byte[] buffer = new byte[512];
        final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        Thread receiver = new Thread(null, new Runnable(){

            @Override
            public void run() {
                while (VirtualCdj.isActive()) {
                    boolean received;
                    try {
                        socket.receive(packet);
                        received = true;
                    }
                    catch (IOException e) {
                        if (VirtualCdj.isActive()) {
                            logger.log(Level.WARNING, "Problem reading from DeviceStatus socket, stopping", e);
                            VirtualCdj.stop();
                        }
                        received = false;
                    }
                    try {
                        DeviceUpdate update;
                        if (!received || packet.getAddress() == socket.getLocalAddress() || (update = VirtualCdj.buildUpdate(packet)) == null) continue;
                        VirtualCdj.processUpdate(update);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Problem processing device update packet", e);
                    }
                }
            }
        }, "beat-link VirtualCdj status receiver");
        receiver.setDaemon(true);
        receiver.setPriority(10);
        receiver.start();
        Thread announcer = new Thread(null, new Runnable(){

            @Override
            public void run() {
                while (VirtualCdj.isActive()) {
                    VirtualCdj.sendAnnouncement(broadcastAddress);
                }
            }
        }, "beat-link VirtualCdj announcement sender");
        announcer.setDaemon(true);
        announcer.start();
        return true;
    }

    public static boolean start() throws SocketException {
        if (!VirtualCdj.isActive()) {
            DeviceFinder.start();
            for (int i = 0; DeviceFinder.currentDevices().isEmpty() && i < 20; ++i) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interrupted waiting for devices, giving up", e);
                    return false;
                }
            }
            if (DeviceFinder.currentDevices().isEmpty()) {
                logger.log(Level.WARNING, "No DJ Link devices found, giving up");
                return false;
            }
            return VirtualCdj.createVirtualCdj();
        }
        return true;
    }

    public static synchronized void stop() {
        if (VirtualCdj.isActive()) {
            socket.close();
            socket = null;
            broadcastAddress = null;
            updates.clear();
            VirtualCdj.setMasterTempo(0.0);
            VirtualCdj.setTempoMaster(null);
        }
    }

    private static void sendAnnouncement(InetAddress broadcastAddress) {
        try {
            DatagramPacket announcement = new DatagramPacket(announcementBytes, announcementBytes.length, broadcastAddress, 50000);
            socket.send(announcement);
            Thread.sleep(announceInterval);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to send announcement packet, shutting down", e);
            VirtualCdj.stop();
        }
    }

    public static synchronized Set<DeviceUpdate> getLatestStatus() {
        VirtualCdj.ensureActive();
        HashSet<DeviceUpdate> result = new HashSet<DeviceUpdate>();
        long now = System.currentTimeMillis();
        for (DeviceUpdate update : updates.values()) {
            if (now - update.getTimestamp() > 10000L) continue;
            result.add(update);
        }
        return Collections.unmodifiableSet(result);
    }

    public static DeviceUpdate getLatestStatusFor(DeviceUpdate device) {
        VirtualCdj.ensureActive();
        return updates.get(device.getAddress());
    }

    public static DeviceUpdate getLatestStatusFor(DeviceAnnouncement device) {
        VirtualCdj.ensureActive();
        return updates.get(device.getAddress());
    }

    public static synchronized DeviceUpdate getLatestStatusFor(int deviceNumber) {
        VirtualCdj.ensureActive();
        for (DeviceUpdate update : updates.values()) {
            if (update.getDeviceNumber() != deviceNumber) continue;
            return update;
        }
        return null;
    }

    public static synchronized void addMasterListener(MasterListener listener) {
        if (listener != null) {
            masterListeners.add(listener);
        }
    }

    public static synchronized void removeMasterListener(MasterListener listener) {
        if (listener != null) {
            masterListeners.remove(listener);
        }
    }

    public static synchronized Set<MasterListener> getMasterListeners() {
        return Collections.unmodifiableSet(new HashSet<MasterListener>(masterListeners));
    }

    private static void deliverMasterChangedAnnouncement(DeviceUpdate update) {
        for (MasterListener listener : VirtualCdj.getMasterListeners()) {
            try {
                listener.masterChanged(update);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Problem delivering master changed announcement to listener", e);
            }
        }
    }

    private static void deliverTempoChangedAnnouncement(double tempo) {
        for (MasterListener listener : VirtualCdj.getMasterListeners()) {
            try {
                listener.tempoChanged(tempo);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Problem delivering tempo changed announcement to listener", e);
            }
        }
    }

    private static void deliverBeatAnnouncement(Beat beat) {
        for (MasterListener listener : VirtualCdj.getMasterListeners()) {
            try {
                listener.newBeat(beat);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Problem delivering master beat announcement to listener", e);
            }
        }
    }

    public static synchronized void addUpdateListener(DeviceUpdateListener listener) {
        if (listener != null) {
            updateListeners.add(listener);
        }
    }

    public static synchronized void removeUpdateListener(DeviceUpdateListener listener) {
        if (listener != null) {
            updateListeners.remove(listener);
        }
    }

    public static synchronized Set<DeviceUpdateListener> getUpdateListeners() {
        return Collections.unmodifiableSet(new HashSet<DeviceUpdateListener>(updateListeners));
    }

    private static void deliverDeviceUpdate(DeviceUpdate update) {
        for (DeviceUpdateListener listener : VirtualCdj.getUpdateListeners()) {
            try {
                listener.received(update);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Problem delivering device update to listener", e);
            }
        }
    }

    private VirtualCdj() {
    }

    static {
        updates = new HashMap<InetAddress, DeviceUpdate>();
        announceInterval = 1500;
        announcementBytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 6, 0, 98, 101, 97, 116, 45, 108, 105, 110, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 54, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0};
        tempoEpsilon = 1.0E-4;
        masterListeners = new HashSet<MasterListener>();
        updateListeners = new HashSet<DeviceUpdateListener>();
    }
}

