/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;

public class Beat
extends DeviceUpdate {
    private final int pitch;
    private final int bpm;

    public Beat(DatagramPacket packet) {
        super(packet, "Beat announcement", 96);
        this.pitch = (int)Util.bytesToNumber(this.packetBytes, 85, 3);
        this.bpm = (int)Util.bytesToNumber(this.packetBytes, 90, 2);
    }

    public int getPitch() {
        return this.pitch;
    }

    public int getBpm() {
        return this.bpm;
    }

    @Override
    public int getBeatWithinBar() {
        return this.packetBytes[92];
    }

    @Override
    public boolean isBeatWithinBarMeaningful() {
        if (VirtualCdj.isActive()) {
            return VirtualCdj.getLatestStatusFor(this).isBeatWithinBarMeaningful();
        }
        return this.deviceNumber < 33;
    }

    public String toString() {
        return "Beat: Device " + this.deviceNumber + ", name: " + this.deviceName + ", pitch: " + String.format("%+.2f%%", Util.pitchToPercentage(this.pitch)) + ", track BPM: " + String.format("%.1f", (double)this.bpm / 100.0) + ", effective BPM: " + String.format("%.1f", this.getEffectiveTempo()) + ", beat within bar: " + this.getBeatWithinBar();
    }

    @Override
    public boolean isTempoMaster() {
        DeviceUpdate master = VirtualCdj.getTempoMaster();
        return master != null && master.getAddress().equals(this.address);
    }

    @Override
    public double getEffectiveTempo() {
        return (double)this.bpm * Util.pitchToMultiplier(this.pitch) / 100.0;
    }
}

