/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.deepsymmetry.beatlink.Beat;
import org.deepsymmetry.beatlink.BeatListener;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;

public class BeatFinder {
    private static final Logger logger = Logger.getLogger(BeatFinder.class.getName());
    public static final int BEAT_PORT = 50001;
    private static DatagramSocket socket;
    private static final Set<BeatListener> listeners;

    public static synchronized boolean isActive() {
        return socket != null;
    }

    public static synchronized void start() throws SocketException {
        if (!BeatFinder.isActive()) {
            socket = new DatagramSocket(50001);
            byte[] buffer = new byte[512];
            final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            Thread receiver = new Thread(null, new Runnable(){

                @Override
                public void run() {
                    while (BeatFinder.isActive()) {
                        boolean received;
                        try {
                            socket.receive(packet);
                            received = true;
                        }
                        catch (IOException e) {
                            if (BeatFinder.isActive()) {
                                logger.log(Level.WARNING, "Problem reading from DeviceAnnouncement socket, stopping", e);
                                BeatFinder.stop();
                            }
                            received = false;
                        }
                        try {
                            if (!received || packet.getLength() != 96 || !Util.validateHeader(packet, 40, "beat")) continue;
                            BeatFinder.deliverBeat(new Beat(packet));
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Problem processing beat packet", e);
                        }
                    }
                }
            }, "beat-link BeatFinder receiver");
            receiver.setDaemon(true);
            receiver.setPriority(10);
            receiver.start();
        }
    }

    public static synchronized void stop() {
        if (BeatFinder.isActive()) {
            socket.close();
            socket = null;
        }
    }

    public static synchronized void addBeatListener(BeatListener listener) {
        if (listener != null) {
            listeners.add(listener);
        }
    }

    public static synchronized void removeBeatListener(BeatListener listener) {
        if (listener != null) {
            listeners.remove(listener);
        }
    }

    public static synchronized Set<BeatListener> getBeatListeners() {
        return Collections.unmodifiableSet(new HashSet<BeatListener>(listeners));
    }

    private static void deliverBeat(Beat beat) {
        VirtualCdj.processBeat(beat);
        for (BeatListener listener : BeatFinder.getBeatListeners()) {
            try {
                listener.newBeat(beat);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Problem delivering beat announcement to listener", e);
            }
        }
    }

    static {
        listeners = new HashSet<BeatListener>();
    }
}

