/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.TrackMetadata;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFinder {
    private static final Logger logger = LoggerFactory.getLogger((String)MetadataFinder.class.getName());
    public static final int METADATA_PORT = 1051;
    private static byte[][][] usbPacketTemplates = new byte[][][]{new byte[][]{{17, -121, 35, 73, -82, 17, -1, -1, -1, -2, 16, 0, 0, 15, 1, 20, 0, 0, 0, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 3}, {17, -121, 35, 73, -82, 17, 3, -128, 1, 104, 16, 32, 2, 15, 2, 20, 0, 0, 0, 12, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 3, 1, 3, 1, 17}, {17, -121, 35, 73, -82, 17, 3, -128, 1, 105, 16, 48, 0, 15, 6, 20, 0, 0, 0, 12, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 17, 3, 1, 3, 1, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0}}, new byte[][]{{17, -121, 35, 73, -82, 17, -1, -1, -1, -2, 16, 0, 0, 15, 1, 20, 0, 0, 0, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 3}, {17, -121, 35, 73, -82, 17, 3, -128, 0, 89, 16, 32, 2, 15, 2, 20, 0, 0, 0, 12, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 3, 1, 3, 1, 17}, {17, -121, 35, 73, -82, 17, 3, -128, 0, 90, 16, 48, 0, 15, 6, 20, 0, 0, 0, 12, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 17, 3, 1, 3, 1, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0}}, new byte[][]{{17, -121, 35, 73, -82, 17, -1, -1, -1, -2, 16, 0, 0, 15, 1, 20, 0, 0, 0, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 2}, {17, -121, 35, 73, -82, 17, 3, -128, 0, 75, 16, 32, 2, 15, 2, 20, 0, 0, 0, 12, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 2, 1, 3, 1, 17}, {17, -121, 35, 73, -82, 17, 3, -128, 0, 76, 16, 48, 0, 15, 6, 20, 0, 0, 0, 12, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 17, 2, 1, 3, 1, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0}}, new byte[][]{{17, -121, 35, 73, -82, 17, -1, -1, -1, -2, 16, 0, 0, 15, 1, 20, 0, 0, 0, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 3}, {17, -121, 35, 73, -82, 17, 3, -128, 1, 72, 16, 32, 2, 15, 2, 20, 0, 0, 0, 12, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 3, 1, 3, 1, 17}, {17, -121, 35, 73, -82, 17, 3, -128, 1, 73, 16, 48, 0, 15, 6, 20, 0, 0, 0, 12, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 17, 3, 1, 3, 1, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0}}};
    private static byte[][][] sdPacketTemplates = new byte[][][]{new byte[][]{{17, -121, 35, 73, -82, 17, -1, -1, -1, -2, 16, 0, 0, 15, 1, 20, 0, 0, 0, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 3}, {17, -121, 35, 73, -82, 17, 3, -128, 0, -2, 16, 32, 2, 15, 2, 20, 0, 0, 0, 12, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 3, 1, 2, 1, 17}, {17, -121, 35, 73, -82, 17, 3, -128, 0, -1, 16, 48, 0, 15, 6, 20, 0, 0, 0, 12, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 17, 3, 1, 2, 1, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0}}, new byte[][]{{17, -121, 35, 73, -82, 17, -1, -1, -1, -2, 16, 0, 0, 15, 1, 20, 0, 0, 0, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 3}, {17, -121, 35, 73, -82, 17, 3, -128, 0, -85, 16, 32, 2, 15, 2, 20, 0, 0, 0, 12, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 3, 1, 2, 1, 17}, {17, -121, 35, 73, -82, 17, 3, -128, 0, -84, 16, 48, 0, 15, 6, 20, 0, 0, 0, 12, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 17, 3, 1, 2, 1, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0}}, new byte[][]{{17, -121, 35, 73, -82, 17, -1, -1, -1, -2, 16, 0, 0, 15, 1, 20, 0, 0, 0, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 2}, {17, -121, 35, 73, -82, 17, 3, -128, 2, 52, 16, 32, 2, 15, 2, 20, 0, 0, 0, 12, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 2, 1, 2, 1, 17}, {17, -121, 35, 73, -82, 17, 3, -128, 2, 53, 16, 48, 0, 15, 6, 20, 0, 0, 0, 12, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 17, 2, 1, 2, 1, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0}}, new byte[][]{{17, -121, 35, 73, -82, 17, -1, -1, -1, -2, 16, 0, 0, 15, 1, 20, 0, 0, 0, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 3}, {17, -121, 35, 73, -82, 17, 3, -128, 1, 36, 16, 32, 2, 15, 2, 20, 0, 0, 0, 12, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 3, 1, 2, 1, 17}, {17, -121, 35, 73, -82, 17, 3, -128, 1, 37, 16, 48, 0, 15, 6, 20, 0, 0, 0, 12, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 17, 3, 1, 2, 1, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0, 17, 0, 0, 0, 10, 17, 0, 0, 0, 0}}};
    private static byte[] initialPacket = new byte[]{17, 0, 0, 0, 1};
    private static final Map<Integer, TrackMetadata> metadata = new HashMap<Integer, TrackMetadata>();
    private static final Map<InetAddress, CdjStatus> lastUpdates = new HashMap<InetAddress, CdjStatus>();
    private static LinkedBlockingDeque<CdjStatus> pendingUpdates = new LinkedBlockingDeque(100);
    private static DeviceUpdateListener listener = new DeviceUpdateListener(){

        @Override
        public void received(DeviceUpdate update) {
            if (update instanceof CdjStatus && !pendingUpdates.offerLast((CdjStatus)update)) {
                logger.warn("Discarding CDJ update because our queue is backed up.");
            }
        }
    };
    private static boolean running = false;
    private static Thread queueHandler;

    public static TrackMetadata requestMetadataFrom(CdjStatus status) {
        if (status.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.NO_TRACK || status.getRekordboxId() == 0) {
            return null;
        }
        return MetadataFinder.requestMetadataFrom(status.getTrackSourcePlayer(), status.getTrackSourceSlot(), status.getRekordboxId());
    }

    private static byte[] receiveBytes(InputStream is) throws IOException {
        byte[] buffer = new byte[8192];
        int len = is.read(buffer);
        byte[] result = new byte[len];
        System.arraycopy(buffer, 0, result, 0, len);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrackMetadata requestMetadataFrom(int player, CdjStatus.TrackSourceSlot slot, int rekordboxId) {
        byte[][] templates;
        DeviceAnnouncement deviceAnnouncement = DeviceFinder.getLatestAnnouncementFrom(player);
        if (deviceAnnouncement == null || player < 1 || player > 4) {
            return null;
        }
        if (slot == CdjStatus.TrackSourceSlot.USB_SLOT) {
            templates = usbPacketTemplates[player - 1];
        } else if (slot == CdjStatus.TrackSourceSlot.SD_SLOT) {
            templates = sdPacketTemplates[player - 1];
        } else {
            return null;
        }
        Socket socket = null;
        try {
            socket = new Socket(deviceAnnouncement.getAddress(), 1051);
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            socket.setSoTimeout(3000);
            os.write(initialPacket);
            MetadataFinder.receiveBytes(is);
            os.write(templates[0]);
            MetadataFinder.receiveBytes(is);
            byte[] buffer = new byte[templates[1].length + 4];
            System.arraycopy(templates[1], 0, buffer, 0, templates[1].length);
            buffer[buffer.length - 4] = (byte)(rekordboxId >> 24);
            buffer[buffer.length - 3] = (byte)(rekordboxId >> 16);
            buffer[buffer.length - 2] = (byte)(rekordboxId >> 8);
            buffer[buffer.length - 1] = (byte)rekordboxId;
            os.write(buffer);
            MetadataFinder.receiveBytes(is);
            os.write(templates[2]);
            byte[] result = MetadataFinder.receiveBytes(is);
            TrackMetadata trackMetadata = new TrackMetadata(player, result);
            return trackMetadata;
        }
        catch (Exception e) {
            logger.warn("Problem requesting metadata", (Throwable)e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.warn("Problem closing metadata request socket", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static synchronized boolean isRunning() {
        return running;
    }

    private static synchronized void clearMetadata(CdjStatus update) {
        metadata.remove(update.deviceNumber);
        lastUpdates.remove(update.address);
    }

    private static synchronized void updateMetadata(CdjStatus update, TrackMetadata data) {
        metadata.put(update.deviceNumber, data);
        lastUpdates.put(update.address, update);
    }

    public static synchronized Map<Integer, TrackMetadata> getLatestMetadata() {
        return Collections.unmodifiableMap(new TreeMap<Integer, TrackMetadata>(metadata));
    }

    public static synchronized TrackMetadata getLatestMetadataFor(int player) {
        return metadata.get(player);
    }

    public static TrackMetadata getLatestMetadataFor(DeviceUpdate update) {
        return MetadataFinder.getLatestMetadataFor(update.deviceNumber);
    }

    private static void handleUpdate(CdjStatus update) {
        if (update.getTrackSourcePlayer() >= 1 && update.getTrackSourcePlayer() <= 4) {
            if (update.getTrackType() != CdjStatus.TrackType.REKORDBOX || update.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.NO_TRACK || update.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.UNKNOWN || update.getRekordboxId() == 0) {
                MetadataFinder.clearMetadata(update);
            } else {
                CdjStatus lastStatus = lastUpdates.get(update.address);
                if (lastStatus == null || lastStatus.getTrackSourceSlot() != update.getTrackSourceSlot() || lastStatus.getTrackSourcePlayer() != update.getTrackSourcePlayer() || lastStatus.getRekordboxId() != update.getRekordboxId()) {
                    try {
                        TrackMetadata data = MetadataFinder.requestMetadataFrom(update);
                        if (data != null) {
                            MetadataFinder.updateMetadata(update, data);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Problem requesting track metadata from update" + update, (Throwable)e);
                    }
                }
            }
        }
    }

    public static synchronized void start() throws Exception {
        if (!running) {
            VirtualCdj.start();
            VirtualCdj.addUpdateListener(listener);
            queueHandler = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (MetadataFinder.isRunning()) {
                        try {
                            MetadataFinder.handleUpdate((CdjStatus)pendingUpdates.take());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
            running = true;
            queueHandler.start();
        }
    }

    public static synchronized void stop() {
        if (running) {
            VirtualCdj.removeUpdateListener(listener);
            running = false;
            pendingUpdates.clear();
            queueHandler.interrupt();
            queueHandler = null;
            lastUpdates.clear();
            metadata.clear();
        }
    }
}

