/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.UnsupportedEncodingException;
import org.deepsymmetry.beatlink.Util;

public class TrackMetadata {
    private final long timestamp = System.currentTimeMillis();
    private final int deviceNumber;
    private final byte[] packetBytes;
    private final String title;
    private final String artist;

    public byte[] getRawMetadata() {
        byte[] result = new byte[this.packetBytes.length];
        System.arraycopy(this.packetBytes, 0, result, 0, this.packetBytes.length);
        return result;
    }

    public TrackMetadata(int device, byte[] buffer) throws UnsupportedEncodingException {
        this.deviceNumber = device;
        this.packetBytes = buffer;
        int titleLength = (int)Util.bytesToNumber(this.packetBytes, 90, 4);
        this.title = new String(this.packetBytes, 94, 2 * (titleLength - 1), "UTF-16");
        int artistLength = (int)Util.bytesToNumber(this.packetBytes, 184 + 2 * titleLength, 4);
        this.artist = new String(this.packetBytes, 188 + 2 * titleLength, 2 * (artistLength - 1), "UTF-16");
    }

    public String toString() {
        return "Track Metadata: Title: " + this.title + ", Artist: " + this.artist;
    }
}

