/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.deepsymmetry.beatlink.Util;

public abstract class DeviceUpdate {
    protected final InetAddress address;
    protected final long timestamp = System.nanoTime();
    protected final String deviceName;
    protected final int deviceNumber;
    protected final byte[] packetBytes;

    public DeviceUpdate(DatagramPacket packet, String name, int length) {
        if (packet.getLength() != length) {
            throw new IllegalArgumentException(name + " packet must be " + length + " bytes long");
        }
        this.address = packet.getAddress();
        this.packetBytes = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, this.packetBytes, 0, packet.getLength());
        this.deviceName = new String(this.packetBytes, 11, 20).trim();
        this.deviceNumber = Util.unsign(this.packetBytes[33]);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public int getDeviceNumber() {
        return this.deviceNumber;
    }

    public byte[] getPacketBytes() {
        byte[] result = new byte[this.packetBytes.length];
        System.arraycopy(this.packetBytes, 0, result, 0, this.packetBytes.length);
        return result;
    }

    public abstract boolean isTempoMaster();

    public abstract double getEffectiveTempo();

    public abstract int getBeatWithinBar();

    public abstract boolean isBeatWithinBarMeaningful();
}

