/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingDeque;
import javax.imageio.ImageIO;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.TrackMetadata;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFinder {
    private static final Logger logger = LoggerFactory.getLogger((String)MetadataFinder.class.getName());
    private static byte[] initialPacket = new byte[]{17, 0, 0, 0, 1};
    private static byte[] messageSeparator = new byte[]{17, -121, 35, 73, -82, 17};
    private static byte[] setupPacket = new byte[]{16, 0, 0, 15, 1, 20, 0, 0, 0, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0};
    private static byte[] specifyTrackForMetadataPacket = new byte[]{16, 32, 2, 15, 2, 20, 0, 0, 0, 12, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 1, 0, 1, 17, 0, 0, 0, 0};
    private static byte[] finishMetadataQueryPacket = new byte[]{16, 48, 0, 15, 6, 20, 0, 0, 0, 12, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 17, 0, 1, 0, 1, 17, 0, 0, 0, 0, 17, 0, 0, 0, 11, 17, 0, 0, 0, 0, 17, 0, 0, 0, 11, 17, 0, 0, 0, 0};
    private static byte[] finalMetadataField = new byte[]{16, 66, 1, 15, 0, 20, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] artworkRequestPacket = new byte[]{16, 32, 3, 15, 2, 20, 0, 0, 0, 12, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 8, 0, 1, 17, 0, 0, 0, 0};
    private static final Map<Integer, TrackMetadata> metadata = new HashMap<Integer, TrackMetadata>();
    private static final Map<InetAddress, CdjStatus> lastUpdates = new HashMap<InetAddress, CdjStatus>();
    private static LinkedBlockingDeque<CdjStatus> pendingUpdates = new LinkedBlockingDeque(100);
    private static DeviceUpdateListener updateListener = new DeviceUpdateListener(){

        @Override
        public void received(DeviceUpdate update) {
            if (update instanceof CdjStatus && !pendingUpdates.offerLast((CdjStatus)update)) {
                logger.warn("Discarding CDJ update because our queue is backed up.");
            }
        }
    };
    private static final Map<Integer, Integer> dbServerPorts = new HashMap<Integer, Integer>();
    private static final int DB_SERVER_QUERY_PORT = 12523;
    private static final byte[] DB_SERVER_QUERY_PACKET = new byte[]{0, 0, 0, 15, 82, 101, 109, 111, 116, 101, 68, 66, 83, 101, 114, 118, 101, 114, 0};
    private static DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(final DeviceAnnouncement announcement) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MetadataFinder.requestPlayerDBServerPort(announcement);
                }
            }).start();
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            MetadataFinder.setPlayerDBServerPort(announcement.getNumber(), -1);
            MetadataFinder.clearMetadata(announcement);
        }
    };
    private static boolean running = false;
    private static Thread queueHandler;
    private static Set<Integer> activeRequests;

    public static TrackMetadata requestMetadataFrom(CdjStatus status) {
        if (status.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.NO_TRACK || status.getRekordboxId() == 0) {
            return null;
        }
        return MetadataFinder.requestMetadataFrom(status.getTrackSourcePlayer(), status.getTrackSourceSlot(), status.getRekordboxId());
    }

    private static List<byte[]> splitMetadataFields(byte[] metadata) {
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        int begin = 0;
        block0: for (int i = 0; i < metadata.length - messageSeparator.length + 1; ++i) {
            for (int j = 0; j < messageSeparator.length; ++j) {
                if (metadata[i + j] != messageSeparator[j]) continue block0;
            }
            fields.add(Arrays.copyOfRange(metadata, begin, i));
            begin = i + messageSeparator.length;
        }
        fields.add(Arrays.copyOfRange(metadata, begin, metadata.length));
        return fields;
    }

    private static void setIdBytes(byte[] buffer, int offset, int id) {
        buffer[offset] = (byte)(id >> 24);
        buffer[offset + 1] = (byte)(id >> 16);
        buffer[offset + 2] = (byte)(id >> 8);
        buffer[offset + 3] = (byte)id;
    }

    private static byte[] buildPacket(int messageId, byte[] payload) {
        byte[] result = new byte[payload.length + messageSeparator.length + 4];
        System.arraycopy(messageSeparator, 0, result, 0, messageSeparator.length);
        MetadataFinder.setIdBytes(result, messageSeparator.length, messageId);
        System.arraycopy(payload, 0, result, messageSeparator.length + 4, payload.length);
        return result;
    }

    private static byte[] buildSetupPacket(byte fromPlayer) {
        byte[] payload = new byte[setupPacket.length];
        System.arraycopy(setupPacket, 0, payload, 0, setupPacket.length);
        payload[payload.length - 1] = fromPlayer;
        return MetadataFinder.buildPacket(-2, payload);
    }

    private static byte[] receiveBytes(InputStream is) throws IOException {
        byte[] buffer = new byte[8192];
        int len = is.read(buffer);
        if (len < 1) {
            throw new IOException("receiveBytes read " + len + " bytes.");
        }
        return Arrays.copyOf(buffer, len);
    }

    private static byte[] readResponseWithExpectedSize(InputStream is, int size, String description) throws IOException {
        byte[] result = MetadataFinder.receiveBytes(is);
        if (result.length != size) {
            logger.warn("Expected " + size + " bytes while reading " + description + " response, received " + result.length);
        }
        return result;
    }

    private static int chooseAskingPlayerNumber(int player, CdjStatus.TrackSourceSlot slot) {
        byte fakeDevice = VirtualCdj.getDeviceNumber();
        if (slot == CdjStatus.TrackSourceSlot.COLLECTION || fakeDevice >= 1 && fakeDevice <= 4) {
            return fakeDevice;
        }
        for (DeviceAnnouncement candidate : DeviceFinder.currentDevices()) {
            DeviceUpdate lastUpdate;
            int realDevice = candidate.getNumber();
            if (realDevice == player || realDevice < 1 || realDevice > 4 || (lastUpdate = VirtualCdj.getLatestStatusFor(realDevice)) == null || !(lastUpdate instanceof CdjStatus) || ((CdjStatus)lastUpdate).getTrackSourcePlayer() == player) continue;
            return candidate.getNumber();
        }
        throw new IllegalStateException("No player number available to query player " + player + ". If they are on the network, they must be using Link to play a track from that player, " + "so we can't use their ID.");
    }

    private static final byte byteRepresentingSlot(CdjStatus.TrackSourceSlot slot) {
        switch (slot) {
            case SD_SLOT: {
                return 2;
            }
            case USB_SLOT: {
                return 3;
            }
            case COLLECTION: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Cannot query metadata for slot " + (Object)((Object)slot));
    }

    private static boolean endsWith(byte[] buffer, byte[] ending) {
        if (buffer.length >= ending.length) {
            for (int i = 0; i < ending.length; ++i) {
                if (ending[i] == buffer[i + buffer.length - ending.length]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static byte[] readFullMetadataResponse(InputStream is, int messageId) throws IOException {
        byte[] endMarker = MetadataFinder.buildPacket(messageId, finalMetadataField);
        byte[] result = new byte[]{};
        do {
            byte[] part;
            int read;
            if ((read = is.read(part = new byte[8192])) < 1) {
                throw new IOException("Unable to read complete metadata response");
            }
            int existingSize = result.length;
            result = Arrays.copyOf(result, existingSize + read);
            System.arraycopy(part, 0, result, existingSize, read);
        } while (!MetadataFinder.endsWith(result, endMarker));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrackMetadata requestMetadataFrom(int player, CdjStatus.TrackSourceSlot slot, int rekordboxId) {
        DeviceAnnouncement deviceAnnouncement = DeviceFinder.getLatestAnnouncementFrom(player);
        int dbServerPort = MetadataFinder.getPlayerDBServerPort(player);
        if (deviceAnnouncement == null || dbServerPort < 0) {
            return null;
        }
        byte posingAsPlayerNumber = (byte)MetadataFinder.chooseAskingPlayerNumber(player, slot);
        byte slotByte = MetadataFinder.byteRepresentingSlot(slot);
        Socket socket = null;
        try {
            socket = new Socket(deviceAnnouncement.getAddress(), dbServerPort);
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            socket.setSoTimeout(3000);
            os.write(initialPacket);
            MetadataFinder.readResponseWithExpectedSize(is, 5, "initial packet");
            os.write(MetadataFinder.buildSetupPacket(posingAsPlayerNumber));
            MetadataFinder.readResponseWithExpectedSize(is, 42, "connection setup");
            byte[] payload = new byte[specifyTrackForMetadataPacket.length];
            System.arraycopy(specifyTrackForMetadataPacket, 0, payload, 0, specifyTrackForMetadataPacket.length);
            payload[23] = posingAsPlayerNumber;
            payload[25] = slotByte;
            MetadataFinder.setIdBytes(payload, payload.length - 4, rekordboxId);
            os.write(MetadataFinder.buildPacket(1, payload));
            MetadataFinder.readResponseWithExpectedSize(is, 42, "track metadata id message");
            payload = new byte[finishMetadataQueryPacket.length];
            System.arraycopy(finishMetadataQueryPacket, 0, payload, 0, finishMetadataQueryPacket.length);
            payload[23] = posingAsPlayerNumber;
            payload[25] = slotByte;
            MetadataFinder.setIdBytes(payload, payload.length - 4, rekordboxId);
            os.write(MetadataFinder.buildPacket(2, payload));
            List<byte[]> fields = MetadataFinder.splitMetadataFields(MetadataFinder.readFullMetadataResponse(is, 2));
            BufferedImage artwork = MetadataFinder.requestArtwork(is, os, 3, posingAsPlayerNumber, slotByte, fields);
            TrackMetadata trackMetadata = new TrackMetadata(fields, artwork);
            return trackMetadata;
        }
        catch (Exception e) {
            logger.warn("Problem requesting metadata", (Throwable)e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.warn("Problem closing metadata request socket", (Throwable)e);
                }
            }
        }
        return null;
    }

    private static BufferedImage requestArtwork(InputStream is, OutputStream os, int messageId, byte ourDeviceNumber, byte slot, List<byte[]> fields) throws IOException {
        byte[] chunk;
        Iterator<byte[]> iterator = fields.iterator();
        iterator.next();
        iterator.next();
        byte[] field = iterator.next();
        int artworkId = (int)Util.bytesToNumber(field, field.length - 19, 4);
        if (artworkId < 1) {
            return null;
        }
        byte[] payload = new byte[artworkRequestPacket.length];
        System.arraycopy(artworkRequestPacket, 0, payload, 0, artworkRequestPacket.length);
        payload[23] = ourDeviceNumber;
        payload[25] = slot;
        MetadataFinder.setIdBytes(payload, payload.length - 4, artworkId);
        os.write(MetadataFinder.buildPacket(messageId, payload));
        byte[] header = new byte[52];
        int received = is.read(header);
        if (received < header.length) {
            throw new IOException("Received partial header trying to read artwork, only " + received + " of 52 bytes.");
        }
        int imageLength = (int)Util.bytesToNumber(header, 48, 4);
        byte[] artBytes = new byte[imageLength];
        int pos = 0;
        do {
            chunk = MetadataFinder.receiveBytes(is);
            System.arraycopy(chunk, 0, artBytes, pos, chunk.length);
        } while ((pos += chunk.length) < imageLength);
        return ImageIO.read(new ByteArrayInputStream(artBytes));
    }

    public static synchronized int getPlayerDBServerPort(int player) {
        Integer result = dbServerPorts.get(player);
        if (result == null) {
            return -1;
        }
        return result;
    }

    private static synchronized void setPlayerDBServerPort(int player, int port) {
        dbServerPorts.put(player, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requestPlayerDBServerPort(DeviceAnnouncement announcement) {
        Socket socket = null;
        try {
            socket = new Socket(announcement.getAddress(), 12523);
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            socket.setSoTimeout(3000);
            os.write(DB_SERVER_QUERY_PACKET);
            byte[] response = MetadataFinder.readResponseWithExpectedSize(is, 2, "database server port query packet");
            if (response.length == 2) {
                MetadataFinder.setPlayerDBServerPort(announcement.getNumber(), (int)Util.bytesToNumber(response, 0, 2));
            }
        }
        catch (ConnectException ce) {
            logger.info("Player " + announcement.getNumber() + " doesn't answer rekordbox port queries, connection refused. Won't attempt to request metadata.");
        }
        catch (Exception e) {
            logger.warn("Problem requesting database server port number", (Throwable)e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.warn("Problem closing database server port request socket", (Throwable)e);
                }
            }
        }
    }

    public static synchronized boolean isRunning() {
        return running;
    }

    private static synchronized void clearMetadata(CdjStatus update) {
        metadata.remove(update.deviceNumber);
        lastUpdates.remove(update.address);
    }

    private static synchronized void clearMetadata(DeviceAnnouncement announcement) {
        metadata.remove(announcement.getNumber());
        lastUpdates.remove(announcement.getAddress());
    }

    private static synchronized void updateMetadata(CdjStatus update, TrackMetadata data) {
        metadata.put(update.deviceNumber, data);
        lastUpdates.put(update.address, update);
    }

    public static synchronized Map<Integer, TrackMetadata> getLatestMetadata() {
        return Collections.unmodifiableMap(new TreeMap<Integer, TrackMetadata>(metadata));
    }

    public static synchronized TrackMetadata getLatestMetadataFor(int player) {
        return metadata.get(player);
    }

    public static TrackMetadata getLatestMetadataFor(DeviceUpdate update) {
        return MetadataFinder.getLatestMetadataFor(update.deviceNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleUpdate(final CdjStatus update) {
        if (update.getTrackType() != CdjStatus.TrackType.REKORDBOX || update.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.NO_TRACK || update.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.UNKNOWN || update.getRekordboxId() == 0) {
            MetadataFinder.clearMetadata(update);
        } else {
            CdjStatus lastStatus = lastUpdates.get(update.address);
            if (lastStatus == null || lastStatus.getTrackSourceSlot() != update.getTrackSourceSlot() || lastStatus.getTrackSourcePlayer() != update.getTrackSourcePlayer() || lastStatus.getRekordboxId() != update.getRekordboxId()) {
                Set<Integer> set = activeRequests;
                synchronized (set) {
                    if (!activeRequests.contains(update.getTrackSourcePlayer())) {
                        activeRequests.add(update.getTrackSourcePlayer());
                        new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    TrackMetadata data = MetadataFinder.requestMetadataFrom(update);
                                    if (data != null) {
                                        MetadataFinder.updateMetadata(update, data);
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn("Problem requesting track metadata from update" + update, (Throwable)e);
                                }
                                finally {
                                    Set set = activeRequests;
                                    synchronized (set) {
                                        activeRequests.remove(update.getTrackSourcePlayer());
                                    }
                                }
                            }
                        }).start();
                    }
                }
            }
        }
    }

    public static synchronized void start() throws Exception {
        if (!running) {
            DeviceFinder.start();
            DeviceFinder.addDeviceAnnouncementListener(announcementListener);
            for (DeviceAnnouncement device : DeviceFinder.currentDevices()) {
                MetadataFinder.requestPlayerDBServerPort(device);
            }
            VirtualCdj.start();
            VirtualCdj.addUpdateListener(updateListener);
            queueHandler = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (MetadataFinder.isRunning()) {
                        try {
                            MetadataFinder.handleUpdate((CdjStatus)pendingUpdates.take());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
            running = true;
            queueHandler.start();
        }
    }

    public static synchronized void stop() {
        if (running) {
            VirtualCdj.removeUpdateListener(updateListener);
            running = false;
            pendingUpdates.clear();
            queueHandler.interrupt();
            queueHandler = null;
            lastUpdates.clear();
            metadata.clear();
        }
    }

    static {
        activeRequests = new HashSet<Integer>();
    }
}

