/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.deepsymmetry.beatlink.Util;

public class TrackMetadata {
    private final List<byte[]> rawFields;
    private final String title;
    private final String artist;
    private final int length;
    private final String album;
    private final String comment;
    private final String key;
    private final String genre;
    private final String label;
    private final int artworkId;
    private final BufferedImage artwork;

    public List<byte[]> getRawFields() {
        LinkedList<byte[]> result = new LinkedList<byte[]>();
        for (byte[] field : this.rawFields) {
            byte[] copy = new byte[field.length];
            System.arraycopy(field, 0, copy, 0, field.length);
            result.add(copy);
        }
        return result;
    }

    private String extractString(byte[] field) throws UnsupportedEncodingException {
        int length;
        if (field.length > 46 && (length = (int)Util.bytesToNumber(field, 42, 4)) > 0) {
            return new String(field, 46, 2 * (length - 1), "UTF-16");
        }
        return "";
    }

    public TrackMetadata(List<byte[]> fields, BufferedImage artwork) throws UnsupportedEncodingException {
        this.rawFields = fields;
        this.artwork = artwork;
        Iterator<byte[]> iterator = fields.iterator();
        iterator.next();
        iterator.next();
        byte[] field = iterator.next();
        this.title = this.extractString(field);
        this.artworkId = (int)Util.bytesToNumber(field, field.length - 19, 4);
        this.artist = this.extractString(iterator.next());
        this.album = this.extractString(iterator.next());
        this.length = (int)Util.bytesToNumber(iterator.next(), 32, 4);
        iterator.next();
        this.comment = this.extractString(iterator.next());
        this.key = this.extractString(iterator.next());
        iterator.next();
        iterator.next();
        this.genre = this.extractString(iterator.next());
        this.label = this.extractString(iterator.next());
    }

    public String toString() {
        return "Track Metadata: Title: " + this.title + ", Artist: " + this.artist + ", Album: " + this.album + ", Length: " + this.length + ", Comment: " + this.comment + ", Key: " + this.key + ", Genre: " + this.genre + ", Label: " + this.label + ", artwork ID: " + this.artworkId;
    }

    public String getArtist() {
        return this.artist;
    }

    public BufferedImage getArtwork() {
        return this.artwork;
    }

    public int getArtworkId() {
        return this.artworkId;
    }

    public String getComment() {
        return this.comment;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLength() {
        return this.length;
    }

    public String getTitle() {
        return this.title;
    }
}

