/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.deepsymmetry.beatlink.Beat;
import org.deepsymmetry.beatlink.BeatListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeatFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(BeatFinder.class);
    public static final int BEAT_PORT = 50001;
    private final AtomicReference<DatagramSocket> socket = new AtomicReference<Object>(null);
    private final Set<BeatListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final BeatFinder ourInstance = new BeatFinder();

    @Override
    public boolean isRunning() {
        return this.socket.get() != null;
    }

    public synchronized void start() throws SocketException {
        if (!this.isRunning()) {
            this.socket.set(new DatagramSocket(50001));
            this.deliverLifecycleAnnouncement(logger, true);
            byte[] buffer = new byte[512];
            final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            Thread receiver = new Thread(null, new Runnable(){

                @Override
                public void run() {
                    while (BeatFinder.this.isRunning()) {
                        boolean received;
                        try {
                            ((DatagramSocket)BeatFinder.this.socket.get()).receive(packet);
                            received = true;
                        }
                        catch (IOException e) {
                            if (BeatFinder.this.isRunning()) {
                                logger.warn("Problem reading from DeviceAnnouncement socket, stopping", (Throwable)e);
                                BeatFinder.this.stop();
                            }
                            received = false;
                        }
                        try {
                            if (!received || packet.getLength() != 96 || !Util.validateHeader(packet, 40, "beat")) continue;
                            BeatFinder.this.deliverBeat(new Beat(packet));
                        }
                        catch (Exception e) {
                            logger.warn("Problem processing beat packet", (Throwable)e);
                        }
                    }
                }
            }, "beat-link BeatFinder receiver");
            receiver.setDaemon(true);
            receiver.setPriority(10);
            receiver.start();
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.socket.get().close();
            this.socket.set(null);
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    public void addBeatListener(BeatListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeBeatListener(BeatListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public Set<BeatListener> getBeatListeners() {
        return Collections.unmodifiableSet(new HashSet<BeatListener>(this.listeners));
    }

    private void deliverBeat(Beat beat) {
        VirtualCdj.getInstance().processBeat(beat);
        for (BeatListener listener : this.getBeatListeners()) {
            try {
                listener.newBeat(beat);
            }
            catch (Exception e) {
                logger.warn("Problem delivering beat announcement to listener", (Throwable)e);
            }
        }
    }

    public static BeatFinder getInstance() {
        return ourInstance;
    }

    private BeatFinder() {
    }

    public String toString() {
        return "BeatFinder[active:" + this.isRunning() + "]";
    }
}

