/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.Util;

public class CdjStatus
extends DeviceUpdate {
    public static final int STATUS_FLAGS = 137;
    public static final int ON_AIR_FLAG = 8;
    public static final int SYNCED_FLAG = 16;
    public static final int MASTER_FLAG = 32;
    public static final int PLAYING_FLAG = 64;
    private final int trackSourcePlayer;
    public static final Map<Byte, TrackSourceSlot> TRACK_SOURCE_SLOT_MAP;
    private final TrackSourceSlot trackSourceSlot;
    public static final Map<Byte, TrackType> TRACK_TYPE_MAP;
    private final TrackType trackType;
    private final int rekordboxId;
    public static final Map<Byte, PlayState1> PLAY_STATE_1_MAP;
    private final PlayState1 playState1;
    public static final Map<Byte, PlayState2> PLAY_STATE_2_MAP;
    private final PlayState2 playState2;
    public static final Map<Byte, PlayState3> PLAY_STATE_3_MAP;
    private final PlayState3 playState3;
    private final int pitch;
    private final int bpm;
    private final String firmwareVersion;

    public int getTrackSourcePlayer() {
        return this.trackSourcePlayer;
    }

    public TrackSourceSlot getTrackSourceSlot() {
        return this.trackSourceSlot;
    }

    public TrackType getTrackType() {
        return this.trackType;
    }

    public int getRekordboxId() {
        return this.rekordboxId;
    }

    public PlayState1 getPlayState1() {
        return this.playState1;
    }

    public PlayState2 getPlayState2() {
        return this.playState2;
    }

    public PlayState3 getPlayState3() {
        return this.playState3;
    }

    private TrackSourceSlot findTrackSourceSlot() {
        TrackSourceSlot result = TRACK_SOURCE_SLOT_MAP.get(this.packetBytes[41]);
        if (result == null) {
            return TrackSourceSlot.UNKNOWN;
        }
        return result;
    }

    private TrackType findTrackType() {
        TrackType result = TRACK_TYPE_MAP.get(this.packetBytes[42]);
        if (result == null) {
            return TrackType.UNKNOWN;
        }
        return result;
    }

    private PlayState1 findPlayState1() {
        PlayState1 result = PLAY_STATE_1_MAP.get(this.packetBytes[123]);
        if (result == null) {
            return PlayState1.UNKNOWN;
        }
        return result;
    }

    private PlayState2 findPlayState2() {
        switch (this.packetBytes[139]) {
            case -6: 
            case 106: 
            case 122: {
                return PlayState2.MOVING;
            }
            case -2: 
            case 110: 
            case 126: {
                return PlayState2.STOPPED;
            }
        }
        return PlayState2.UNKNOWN;
    }

    private PlayState3 findPlayState3() {
        PlayState3 result = PLAY_STATE_3_MAP.get(this.packetBytes[157]);
        if (result == null) {
            return PlayState3.UNKNOWN;
        }
        return result;
    }

    public CdjStatus(DatagramPacket packet) {
        super(packet, "CDJ status", packet.getLength());
        if (this.packetBytes.length != 208 && this.packetBytes.length != 212 && this.packetBytes.length != 284 && this.packetBytes.length != 292) {
            throw new IllegalArgumentException("CDJ status packet must be 208, 212, 284, or 292 bytes long");
        }
        this.trackSourcePlayer = this.packetBytes[40];
        this.trackSourceSlot = this.findTrackSourceSlot();
        this.trackType = this.findTrackType();
        this.rekordboxId = (int)Util.bytesToNumber(this.packetBytes, 44, 4);
        this.pitch = (int)Util.bytesToNumber(this.packetBytes, 141, 3);
        this.bpm = (int)Util.bytesToNumber(this.packetBytes, 146, 2);
        this.playState1 = this.findPlayState1();
        this.playState2 = this.findPlayState2();
        this.playState3 = this.findPlayState3();
        this.firmwareVersion = new String(this.packetBytes, 124, 4).trim();
    }

    @Override
    public int getPitch() {
        return this.pitch;
    }

    public int getPitch(int number) {
        switch (number) {
            case 1: {
                return this.pitch;
            }
            case 2: {
                return (int)Util.bytesToNumber(this.packetBytes, 153, 3);
            }
            case 3: {
                return (int)Util.bytesToNumber(this.packetBytes, 193, 3);
            }
            case 4: {
                return (int)Util.bytesToNumber(this.packetBytes, 197, 3);
            }
        }
        throw new IllegalArgumentException("Pitch number must be between 1 and 4");
    }

    @Override
    public int getBpm() {
        return this.bpm;
    }

    @Override
    public int getBeatWithinBar() {
        return this.packetBytes[166];
    }

    @Override
    public boolean isBeatWithinBarMeaningful() {
        return this.getBeatWithinBar() > 0;
    }

    @Override
    public boolean isTempoMaster() {
        return (this.packetBytes[137] & 0x20) > 0;
    }

    @Override
    public double getEffectiveTempo() {
        return (double)this.bpm * Util.pitchToMultiplier(this.pitch) / 100.0;
    }

    public boolean isPlaying() {
        if (this.packetBytes.length == 212) {
            return (this.packetBytes[137] & 0x40) > 0;
        }
        PlayState1 state = this.getPlayState1();
        return state == PlayState1.PLAYING || state == PlayState1.LOOPING || state == PlayState1.SEARCHING && this.getPlayState2() == PlayState2.MOVING;
    }

    public boolean isSynced() {
        return (this.packetBytes[137] & 0x10) > 0;
    }

    public boolean isOnAir() {
        return (this.packetBytes[137] & 8) > 0;
    }

    public boolean isLocalUsbLoaded() {
        return this.packetBytes[111] == 0;
    }

    public boolean isLocalUsbUnloading() {
        return this.packetBytes[111] == 2;
    }

    public boolean isLocalUsbEmpty() {
        return this.packetBytes[111] == 4;
    }

    public boolean isLocalSdLoaded() {
        return this.packetBytes[115] == 0;
    }

    public boolean isLocalSdUnloading() {
        return this.packetBytes[115] == 2;
    }

    public boolean isLocalSdEmpty() {
        return this.packetBytes[115] == 4;
    }

    public boolean isTrackLoaded() {
        return this.playState1 != PlayState1.NO_TRACK;
    }

    public boolean isLooping() {
        return this.playState1 == PlayState1.LOOPING;
    }

    public boolean isPaused() {
        return this.playState1 == PlayState1.PAUSED || this.playState1 == PlayState1.CUED;
    }

    public boolean isCued() {
        return this.playState1 == PlayState1.CUED;
    }

    public boolean isSearching() {
        return this.playState1 == PlayState1.SEARCHING;
    }

    public boolean isAtEnd() {
        return this.playState1 == PlayState1.ENDED;
    }

    public boolean isPlayingForwards() {
        return this.playState1 == PlayState1.PLAYING && this.playState3 != PlayState3.PAUSED_OR_REVERSE;
    }

    public boolean isPlayingBackwards() {
        return this.playState1 == PlayState1.PLAYING && this.playState3 == PlayState3.PAUSED_OR_REVERSE;
    }

    public boolean isPlayingVinylMode() {
        return this.playState3 == PlayState3.FORWARD_VINYL;
    }

    public boolean isPlayingCdjMode() {
        return this.playState3 == PlayState3.FORWARD_CDJ;
    }

    public boolean isLinkMediaAvailable() {
        return this.packetBytes[117] != 0;
    }

    public boolean isBusy() {
        return this.packetBytes[39] != 0;
    }

    public int getTrackNumber() {
        return (int)Util.bytesToNumber(this.packetBytes, 50, 2);
    }

    public int getSyncNumber() {
        return (int)Util.bytesToNumber(this.packetBytes, 134, 2);
    }

    public int getBeatNumber() {
        long result = Util.bytesToNumber(this.packetBytes, 160, 4);
        if (result != 0xFFFFFFFFL) {
            return (int)result;
        }
        return -1;
    }

    public int getCueCountdown() {
        return (int)Util.bytesToNumber(this.packetBytes, 164, 2);
    }

    public String formatCueCountdown() {
        int count = this.getCueCountdown();
        if (count == 511) {
            return "--.-";
        }
        if (count >= 1 && count <= 256) {
            int bars = (count - 1) / 4;
            int beats = (count - 1) % 4 + 1;
            return String.format("%02d.%d", bars, beats);
        }
        if (count == 0) {
            return "00.0";
        }
        return "??.?";
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public long getPacketNumber() {
        return Util.bytesToNumber(this.packetBytes, 200, 4);
    }

    @Override
    public String toString() {
        return "CdjStatus[device:" + this.deviceNumber + ", name:" + this.deviceName + ", address:" + this.address.getHostAddress() + ", timestamp:" + this.timestamp + ", busy? " + this.isBusy() + ", pitch:" + String.format("%+.2f%%", Util.pitchToPercentage(this.pitch)) + ", rekordboxId:" + this.getRekordboxId() + ", from player:" + this.getTrackSourcePlayer() + ", in slot:" + (Object)((Object)this.getTrackSourceSlot()) + ", track type:" + (Object)((Object)this.getTrackType()) + ", track:" + this.getTrackNumber() + ", track BPM:" + String.format("%.1f", (double)this.bpm / 100.0) + ", effective BPM:" + String.format("%.1f", this.getEffectiveTempo()) + ", beat:" + this.getBeatNumber() + ", beatWithinBar:" + this.getBeatWithinBar() + ", isBeatWithinBarMeaningful? " + this.isBeatWithinBarMeaningful() + ", cue: " + this.formatCueCountdown() + ", Playing? " + this.isPlaying() + ", Master? " + this.isTempoMaster() + ", Synced? " + this.isSynced() + ", On-Air? " + this.isOnAir() + "]";
    }

    static {
        HashMap<Byte, Enum> scratch = new HashMap<Byte, Enum>();
        for (TrackSourceSlot trackSourceSlot : TrackSourceSlot.values()) {
            scratch.put(trackSourceSlot.protocolValue, trackSourceSlot);
        }
        TRACK_SOURCE_SLOT_MAP = Collections.unmodifiableMap(scratch);
        scratch = new HashMap();
        for (Enum enum_ : TrackType.values()) {
            scratch.put(((TrackType)enum_).protocolValue, enum_);
        }
        TRACK_TYPE_MAP = Collections.unmodifiableMap(scratch);
        scratch = new HashMap();
        for (Enum enum_ : PlayState1.values()) {
            scratch.put(((PlayState1)enum_).protocolValue, enum_);
        }
        PLAY_STATE_1_MAP = Collections.unmodifiableMap(scratch);
        scratch = new HashMap();
        for (Enum enum_ : PlayState2.values()) {
            scratch.put(((PlayState2)enum_).protocolValue, enum_);
        }
        PLAY_STATE_2_MAP = Collections.unmodifiableMap(scratch);
        scratch = new HashMap();
        for (Enum enum_ : PlayState3.values()) {
            scratch.put(((PlayState3)enum_).protocolValue, enum_);
        }
        PLAY_STATE_3_MAP = Collections.unmodifiableMap(scratch);
    }

    public static enum PlayState3 {
        NO_TRACK(0),
        PAUSED_OR_REVERSE(1),
        FORWARD_VINYL(9),
        FORWARD_CDJ(13),
        UNKNOWN(-1);

        public final byte protocolValue;

        private PlayState3(int value) {
            this.protocolValue = (byte)value;
        }
    }

    public static enum PlayState2 {
        MOVING(122),
        STOPPED(126),
        UNKNOWN(-1);

        public final byte protocolValue;

        private PlayState2(int value) {
            this.protocolValue = (byte)value;
        }
    }

    public static enum PlayState1 {
        NO_TRACK(0),
        LOADING(2),
        PLAYING(3),
        LOOPING(4),
        PAUSED(5),
        CUED(6),
        CUE_PLAYING(7),
        CUE_SCRATCHING(8),
        SEARCHING(9),
        ENDED(17),
        UNKNOWN(-1);

        public final byte protocolValue;

        private PlayState1(int value) {
            this.protocolValue = (byte)value;
        }
    }

    public static enum TrackType {
        NO_TRACK(0),
        REKORDBOX(1),
        UNANALYZED(2),
        CD_DIGITAL_AUDIO(5),
        UNKNOWN(-1);

        public final byte protocolValue;

        private TrackType(int value) {
            this.protocolValue = (byte)value;
        }
    }

    public static enum TrackSourceSlot {
        NO_TRACK(0),
        CD_SLOT(1),
        SD_SLOT(2),
        USB_SLOT(3),
        COLLECTION(4),
        UNKNOWN(-1);

        public final byte protocolValue;

        private TrackSourceSlot(int value) {
            this.protocolValue = (byte)value;
        }
    }
}

