/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.slf4j.Logger;

public abstract class LifecycleParticipant {
    private final Set<LifecycleListener> lifecycleListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public void addLifecycleListener(LifecycleListener listener) {
        if (listener != null) {
            this.lifecycleListeners.add(listener);
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        if (listener != null) {
            this.lifecycleListeners.remove(listener);
        }
    }

    public Set<LifecycleListener> getLifecycleListeners() {
        return Collections.unmodifiableSet(new HashSet<LifecycleListener>(this.lifecycleListeners));
    }

    protected void deliverLifecycleAnnouncement(final Logger logger, final boolean starting) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (LifecycleListener listener : LifecycleParticipant.this.getLifecycleListeners()) {
                    try {
                        if (starting) {
                            listener.started(LifecycleParticipant.this);
                            continue;
                        }
                        listener.stopped(LifecycleParticipant.this);
                    }
                    catch (Exception e) {
                        logger.warn("Problem delivering lifecycle announcement to listener", (Throwable)e);
                    }
                }
            }
        }, "Lifecycle announcement delivery").start();
    }

    public abstract boolean isRunning();

    protected void ensureRunning() {
        if (!this.isRunning()) {
            throw new IllegalStateException(this.getClass().getName() + " is not running");
        }
    }
}

