/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    private static final byte[] EXPECTED_HEADER = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76};

    public static boolean validateHeader(DatagramPacket packet, int kind, String name) {
        boolean valid = true;
        byte[] data = packet.getData();
        for (int i = 0; i < EXPECTED_HEADER.length; ++i) {
            if (EXPECTED_HEADER[i] == data[i]) continue;
            logger.warn("Header mismatch at byte " + i + " of " + name + " packet: expecting " + EXPECTED_HEADER[i] + ", found " + data[i]);
            valid = false;
        }
        if (data[10] != (byte)kind) {
            logger.warn("Expecting " + name + " packet to have kind value " + kind + ", but found " + data[10]);
            valid = false;
        }
        return valid;
    }

    public static int unsign(byte b) {
        return b & 0xFF;
    }

    public static long bytesToNumber(byte[] buffer, int start, int length) {
        long result = 0L;
        for (int index = start; index < start + length; ++index) {
            result = (result << 8) + (long)Util.unsign(buffer[index]);
        }
        return result;
    }

    public static long bytesToNumberLittleEndian(byte[] buffer, int start, int length) {
        long result = 0L;
        for (int index = start + length - 1; index >= start; --index) {
            result = (result << 8) + (long)Util.unsign(buffer[index]);
        }
        return result;
    }

    public static long addressToLong(InetAddress address) {
        long result = 0L;
        for (byte element : address.getAddress()) {
            result = (result << 8) + (long)Util.unsign(element);
        }
        return result;
    }

    public static boolean sameNetwork(int prefixLength, InetAddress address1, InetAddress address2) {
        long prefixMask = 0xFFFFFFFFL & (long)(-1 << 32 - prefixLength);
        return (Util.addressToLong(address1) & prefixMask) == (Util.addressToLong(address2) & prefixMask);
    }

    public static double pitchToPercentage(long pitch) {
        return (double)(pitch - 1048567L) / 10485.76;
    }

    public static double pitchToMultiplier(long pitch) {
        return (double)pitch / 1048576.0;
    }

    public static void writeFully(ByteBuffer buffer, WritableByteChannel channel) throws IOException {
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
    }

    public static long halfFrameToTime(long halfFrame) {
        return halfFrame * 100L / 15L;
    }

    public static int timeToHalfFrame(long milliseconds) {
        return (int)(milliseconds * 15L / 100L);
    }

    private Util() {
    }
}

