/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;

public class CueList {
    public final Message rawMessage;
    public final List<Entry> entries;

    public int getHotCueCount() {
        return (int)((NumberField)this.rawMessage.arguments.get(5)).getValue();
    }

    public int getMemoryPointCount() {
        return (int)((NumberField)this.rawMessage.arguments.get(6)).getValue();
    }

    public CueList(Message message) {
        this.rawMessage = message;
        byte[] entryBytes = ((BinaryField)message.arguments.get(3)).getValueAsArray();
        int entryCount = entryBytes.length / 36;
        ArrayList<Entry> scratch = new ArrayList<Entry>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            int offset = i * 36;
            byte cueFlag = entryBytes[offset + 1];
            byte hotCueNumber = entryBytes[offset + 2];
            if (cueFlag == 0 && hotCueNumber == 0) continue;
            long position = Util.bytesToNumberLittleEndian(entryBytes, offset + 12, 4);
            if (entryBytes[offset] != 0) {
                long endPosition = Util.bytesToNumberLittleEndian(entryBytes, offset + 16, 4);
                scratch.add(new Entry(hotCueNumber, position, endPosition));
                continue;
            }
            scratch.add(new Entry(hotCueNumber, position));
        }
        Collections.sort(scratch, new Comparator<Entry>(){

            @Override
            public int compare(Entry entry1, Entry entry2) {
                int result = (int)(entry1.cuePosition - entry2.cuePosition);
                if (result == 0) {
                    int h1 = entry1.hotCueNumber != 0 ? 1 : 0;
                    int h2 = entry2.hotCueNumber != 0 ? 1 : 0;
                    result = h1 - h2;
                }
                return result;
            }
        });
        this.entries = Collections.unmodifiableList(scratch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CueList cueList = (CueList)o;
        return this.entries != null ? this.entries.equals(cueList.entries) : cueList.entries == null;
    }

    public int hashCode() {
        return this.entries != null ? this.entries.hashCode() : 0;
    }

    public String toString() {
        return "Cue List[entries: " + this.entries + "]";
    }

    public static class Entry {
        public final int hotCueNumber;
        public final boolean isLoop;
        public final long cuePosition;
        public final long cueTime;
        public final long loopPosition;
        public final long loopTime;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.hotCueNumber != entry.hotCueNumber) {
                return false;
            }
            if (this.isLoop != entry.isLoop) {
                return false;
            }
            if (this.cuePosition != entry.cuePosition) {
                return false;
            }
            if (this.cueTime != entry.cueTime) {
                return false;
            }
            if (this.loopPosition != entry.loopPosition) {
                return false;
            }
            return this.loopTime == entry.loopTime;
        }

        public int hashCode() {
            int result = this.hotCueNumber;
            result = 31 * result + (this.isLoop ? 1 : 0);
            result = 31 * result + (int)(this.cuePosition ^ this.cuePosition >>> 32);
            result = 31 * result + (int)(this.cueTime ^ this.cueTime >>> 32);
            result = 31 * result + (int)(this.loopPosition ^ this.loopPosition >>> 32);
            result = 31 * result + (int)(this.loopTime ^ this.loopTime >>> 32);
            return result;
        }

        public Entry(int number, long position) {
            this.hotCueNumber = number;
            this.cuePosition = position;
            this.cueTime = Util.halfFrameToTime(position);
            this.isLoop = false;
            this.loopPosition = 0L;
            this.loopTime = 0L;
        }

        public Entry(int number, long startPosition, long endPosition) {
            this.hotCueNumber = number;
            this.cuePosition = startPosition;
            this.cueTime = Util.halfFrameToTime(startPosition);
            this.isLoop = true;
            this.loopPosition = endPosition;
            this.loopTime = Util.halfFrameToTime(endPosition);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.hotCueNumber == 0) {
                if (this.isLoop) {
                    sb.append("Loop[");
                } else {
                    sb.append("Memory Point[");
                }
            } else {
                sb.append("Hot Cue ").append((char)(this.hotCueNumber + 64)).append('[');
            }
            sb.append("time ").append(this.cueTime).append("ms");
            if (this.isLoop) {
                sb.append(", loop time ").append(this.loopTime).append("ms");
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

