/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.AlbumArt;
import org.deepsymmetry.beatlink.data.ArtFinder;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridFinder;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataCacheCreationListener;
import org.deepsymmetry.beatlink.data.MetadataCacheListener;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Field;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(MetadataFinder.class);
    private final int MENU_TIMEOUT = 20;
    private static final String CACHE_PREFIX = "BLTMetaCache/";
    private static final String CACHE_FORMAT_ENTRY = "BLTMetaCache/version";
    private static final String CACHE_METADATA_ENTRY_PREFIX = "BLTMetaCache/metadata/";
    private static final String CACHE_ART_ENTRY_PREFIX = "BLTMetaCache/artwork/";
    private static final String CACHE_BEAT_GRID_ENTRY_PREFIX = "BLTMetaCache/beatGrid/";
    private static final String CACHE_CUE_LIST_ENTRY_PREFIX = "BLTMetaCache/cueList/";
    private static final String CACHE_WAVEFORM_PREVIEW_ENTRY_PREFIX = "BLTMetaCache/wavePrev/";
    private static final String CACHE_WAVEFORM_DETAIL_ENTRY_PREFIX = "BLTMetaCache/waveform/";
    public static final String CACHE_FORMAT_IDENTIFIER = "BeatLink Metadata Cache version 1";
    private static final Message MENU_FOOTER_MESSAGE = new Message(0L, Message.KnownType.MENU_FOOTER, new Field[0]);
    private final AtomicLong cachePauseInterval = new AtomicLong(50L);
    private final Map<DeckReference, TrackMetadata> hotCache = new ConcurrentHashMap<DeckReference, TrackMetadata>();
    private final LinkedBlockingDeque<CdjStatus> pendingUpdates = new LinkedBlockingDeque(100);
    private final DeviceUpdateListener updateListener = new DeviceUpdateListener(){

        @Override
        public void received(DeviceUpdate update) {
            logger.debug("Received device update {}", (Object)update);
            if (update instanceof CdjStatus && !MetadataFinder.this.pendingUpdates.offerLast((CdjStatus)update)) {
                logger.warn("Discarding CDJ update because our queue is backed up.");
            }
        }
    };
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            logger.debug("Currently nothing for MetadataFinder to do when devices appear.");
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            MetadataFinder.this.clearMetadata(announcement);
            MetadataFinder.this.detachMetadataCache(SlotReference.getSlotReference(announcement.getNumber(), CdjStatus.TrackSourceSlot.SD_SLOT));
            MetadataFinder.this.detachMetadataCache(SlotReference.getSlotReference(announcement.getNumber(), CdjStatus.TrackSourceSlot.USB_SLOT));
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean passive = new AtomicBoolean(false);
    private Thread queueHandler;
    private final Set<Integer> activeRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<SlotReference, ZipFile> metadataCacheFiles = new ConcurrentHashMap<SlotReference, ZipFile>();
    private final Set<File> autoAttachCacheFiles = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger autoAttachProbeCount = new AtomicInteger(5);
    private final Set<SlotReference> mediaMounts = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<MountListener> mountListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<MetadataCacheListener> cacheListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<TrackMetadataListener> trackListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("MetadataFinder won't automatically start just because {} has.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (MetadataFinder.this.isRunning()) {
                logger.info("MetadataFinder stopping because {} has.", (Object)sender);
                MetadataFinder.this.stop();
            }
        }
    };
    private static final MetadataFinder ourInstance = new MetadataFinder();

    public TrackMetadata requestMetadataFrom(CdjStatus status) {
        if (status.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.NO_TRACK || status.getRekordboxId() == 0) {
            return null;
        }
        return this.requestMetadataFrom(new DataReference(status.getTrackSourcePlayer(), status.getTrackSourceSlot(), status.getRekordboxId()));
    }

    public TrackMetadata requestMetadataFrom(DataReference track) {
        return this.requestMetadataInternal(track, false);
    }

    private TrackMetadata requestMetadataInternal(final DataReference track, boolean failIfPassive) {
        ZipFile cache = this.getMetadataCache(SlotReference.getSlotReference(track));
        if (cache != null) {
            return this.getCachedMetadata(cache, track);
        }
        if (this.passive.get() && failIfPassive) {
            return null;
        }
        ConnectionManager.ClientTask<TrackMetadata> task = new ConnectionManager.ClientTask<TrackMetadata>(){

            @Override
            public TrackMetadata useClient(Client client) throws Exception {
                return MetadataFinder.this.queryMetadata(track, client);
            }
        };
        try {
            return ConnectionManager.getInstance().invokeWithClientSession(track.player, task, "requesting metadata");
        }
        catch (Exception e) {
            logger.error("Problem requesting metadata, returning null", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackMetadata queryMetadata(DataReference track, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                Message response = client.menuRequest(Message.KnownType.METADATA_REQ, Message.MenuIdentifier.MAIN_MENU, track.slot, new NumberField(track.rekordboxId));
                long count = response.getMenuResultsCount();
                if (count == -1L) {
                    TrackMetadata trackMetadata = null;
                    return trackMetadata;
                }
                CueList cueList = this.getCueList(track.rekordboxId, track.slot, client);
                List<Message> items = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, track.slot, response);
                TrackMetadata trackMetadata = new TrackMetadata(track, items, cueList);
                return trackMetadata;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock the player for menu operations");
    }

    private CueList getCueList(int rekordboxId, CdjStatus.TrackSourceSlot slot, Client client) throws IOException {
        Message response = client.simpleRequest(Message.KnownType.CUE_LIST_REQ, null, client.buildRMS1(Message.MenuIdentifier.DATA, slot), new NumberField(rekordboxId));
        if (response.knownType == Message.KnownType.CUE_LIST) {
            return new CueList(response);
        }
        logger.error("Unexpected response type when requesting cue list: {}", (Object)response);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> getFullTrackList(CdjStatus.TrackSourceSlot slot, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                Message response = client.menuRequest(Message.KnownType.TRACK_LIST_REQ, Message.MenuIdentifier.MAIN_MENU, slot, NumberField.WORD_0);
                long count = response.getMenuResultsCount();
                if (count == -1L || count == 0L) {
                    List<Message> list = Collections.emptyList();
                    return list;
                }
                List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, response);
                return list;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock the player for menu operations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackMetadata getCachedMetadata(ZipFile cache, DataReference track) {
        ZipEntry entry = cache.getEntry(this.getMetadataEntryName(track.rekordboxId));
        if (entry != null) {
            DataInputStream is = null;
            try {
                is = new DataInputStream(cache.getInputStream(entry));
                LinkedList<Message> items = new LinkedList<Message>();
                Message current = Message.read(is);
                while (current.messageType.getValue() == Message.KnownType.MENU_ITEM.protocolValue) {
                    items.add(current);
                    current = Message.read(is);
                }
                TrackMetadata trackMetadata = new TrackMetadata(track, items, this.getCachedCueList(cache, track.rekordboxId));
                return trackMetadata;
            }
            catch (IOException e) {
                logger.error("Problem reading metadata from cache file, returning null", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing ZipFile input stream for reading metadata entry", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CueList getCachedCueList(ZipFile cache, int rekordboxId) {
        ZipEntry entry = cache.getEntry(this.getCueListEntryName(rekordboxId));
        if (entry != null) {
            DataInputStream is = null;
            try {
                is = new DataInputStream(cache.getInputStream(entry));
                Message message = Message.read(is);
                CueList cueList = new CueList(message);
                return cueList;
            }
            catch (IOException e) {
                logger.error("Problem reading cue list from cache file, returning null", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing ZipFile input stream for reading cue list", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> getPlaylistItems(CdjStatus.TrackSourceSlot slot, int sortOrder, int playlistOrFolderId, boolean folder, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                Message response = client.menuRequest(Message.KnownType.PLAYLIST_REQ, Message.MenuIdentifier.MAIN_MENU, slot, new NumberField(sortOrder), new NumberField(playlistOrFolderId), new NumberField(folder ? 1L : 0L));
                long count = response.getMenuResultsCount();
                if (count == -1L || count == 0L) {
                    List<Message> list = Collections.emptyList();
                    return list;
                }
                List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, response);
                return list;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock player for menu operations.");
    }

    public List<Message> requestPlaylistItemsFrom(int player, final CdjStatus.TrackSourceSlot slot, final int sortOrder, final int playlistOrFolderId, final boolean folder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            @Override
            public List<Message> useClient(Client client) throws Exception {
                return MetadataFinder.this.getPlaylistItems(slot, sortOrder, playlistOrFolderId, folder, client);
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(player, task, "requesting playlist information");
    }

    public void createMetadataCache(SlotReference slot, int playlistId, File cache) throws Exception {
        this.createMetadataCache(slot, playlistId, cache, null);
    }

    public void setCachePauseInterval(long milliseconds) {
        this.cachePauseInterval.set(milliseconds);
    }

    public long getCachePauseInterval() {
        return this.cachePauseInterval.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTracksToCache(List<Message> trackListEntries, int playlistId, Client client, SlotReference slot, File cache, MetadataCacheCreationListener listener) throws IOException, TimeoutException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        ZipOutputStream zos = null;
        Channel channel = null;
        HashSet<Integer> artworkAdded = new HashSet<Integer>();
        try {
            fos = new FileOutputStream(cache);
            bos = new BufferedOutputStream(fos);
            zos = new ZipOutputStream(bos);
            zos.setMethod(8);
            zos.putNextEntry(new ZipEntry(CACHE_FORMAT_ENTRY));
            String formatEntry = "BeatLink Metadata Cache version 1:" + playlistId + ":" + trackListEntries.size();
            zos.write(formatEntry.getBytes("UTF-8"));
            channel = Channels.newChannel(zos);
            int totalToCopy = trackListEntries.size();
            int tracksCopied = 0;
            for (Message entry : trackListEntries) {
                if (entry.getMenuItemType() == Message.MenuItemType.UNKNOWN) {
                    logger.warn("Encountered unrecognized track list entry item type: {}", (Object)entry);
                }
                int rekordboxId = (int)((NumberField)entry.arguments.get(1)).getValue();
                TrackMetadata track = this.copyTrackToCache(client, slot, zos, (WritableByteChannel)channel, artworkAdded, rekordboxId);
                if (listener != null && !listener.cacheCreationContinuing(track, ++tracksCopied, totalToCopy)) {
                    logger.info("Track metadata cache creation canceled by listener");
                    if (!cache.delete()) {
                        logger.warn("Unable to delete metadata cache file, {}", (Object)cache);
                    }
                    return;
                }
                Thread.sleep(this.cachePauseInterval.get());
            }
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while building metadata cache file, aborting", (Throwable)e);
            if (!cache.delete()) {
                logger.warn("Unable to delete metadata cache file, {}", (Object)cache);
            }
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Exception e) {
                logger.error("Problem closing byte channel for writing to metadata cache", (Throwable)e);
            }
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (Exception e) {
                logger.error("Problem closing Zip Output Stream of metadata cache", (Throwable)e);
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                logger.error("Problem closing Buffered Output Stream of metadata cache", (Throwable)e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                logger.error("Problem closing File Output Stream of metadata cache", (Throwable)e);
            }
        }
    }

    private TrackMetadata copyTrackToCache(Client client, SlotReference slot, ZipOutputStream zos, WritableByteChannel channel, Set<Integer> artworkAdded, int rekordboxId) throws IOException, TimeoutException, InterruptedException {
        WaveformDetail detail;
        WaveformPreview preview;
        CueList cueList;
        BeatGrid beatGrid;
        TrackMetadata track = this.queryMetadata(new DataReference(slot, rekordboxId), client);
        if (track != null) {
            logger.debug("Adding metadata with ID {}", (Object)track.trackReference.rekordboxId);
            zos.putNextEntry(new ZipEntry(this.getMetadataEntryName(track.trackReference.rekordboxId)));
            for (Message metadataItem : track.rawItems) {
                metadataItem.write(channel);
            }
        } else {
            logger.warn("Unable to retrieve metadata with ID {}", (Object)rekordboxId);
            return null;
        }
        MENU_FOOTER_MESSAGE.write(channel);
        if (track.getArtworkId() != 0 && !artworkAdded.contains(track.getArtworkId())) {
            logger.debug("Adding artwork with ID {}", (Object)track.getArtworkId());
            zos.putNextEntry(new ZipEntry(this.getArtworkEntryName(track.getArtworkId())));
            AlbumArt art = ArtFinder.getInstance().getArtwork(track.getArtworkId(), slot, client);
            if (art != null) {
                Util.writeFully(art.getRawBytes(), channel);
                artworkAdded.add(track.getArtworkId());
            }
        }
        if ((beatGrid = BeatGridFinder.getInstance().getBeatGrid(rekordboxId, slot, client)) != null) {
            logger.debug("Adding beat grid with ID {}", (Object)rekordboxId);
            zos.putNextEntry(new ZipEntry(this.getBeatGridEntryName(rekordboxId)));
            Util.writeFully(beatGrid.getRawData(), channel);
        }
        if ((cueList = this.getCueList(rekordboxId, slot.slot, client)) != null) {
            logger.debug("Adding cue list entry with ID {}", (Object)rekordboxId);
            zos.putNextEntry(new ZipEntry(this.getCueListEntryName(rekordboxId)));
            cueList.rawMessage.write(channel);
        }
        if ((preview = WaveformFinder.getInstance().getWaveformPreview(rekordboxId, slot, client)) != null) {
            logger.debug("Adding waveform preview entry with ID {}", (Object)rekordboxId);
            zos.putNextEntry(new ZipEntry(this.getWaveformPreviewEntryName(rekordboxId)));
            preview.rawMessage.write(channel);
        }
        if ((detail = WaveformFinder.getInstance().getWaveformDetail(rekordboxId, slot, client)) != null) {
            logger.debug("Adding waveform detail entry with ID {}", (Object)rekordboxId);
            zos.putNextEntry(new ZipEntry(this.getWaveformDetailEntryName(rekordboxId)));
            detail.rawMessage.write(channel);
        }
        return track;
    }

    private String getMetadataEntryName(int rekordboxId) {
        return CACHE_METADATA_ENTRY_PREFIX + rekordboxId;
    }

    String getArtworkEntryName(int artworkId) {
        return CACHE_ART_ENTRY_PREFIX + artworkId + ".jpg";
    }

    String getBeatGridEntryName(int rekordboxId) {
        return CACHE_BEAT_GRID_ENTRY_PREFIX + rekordboxId;
    }

    private String getCueListEntryName(int rekordboxId) {
        return CACHE_CUE_LIST_ENTRY_PREFIX + rekordboxId;
    }

    String getWaveformPreviewEntryName(int rekordboxId) {
        return CACHE_WAVEFORM_PREVIEW_ENTRY_PREFIX + rekordboxId;
    }

    String getWaveformDetailEntryName(int rekordboxId) {
        return CACHE_WAVEFORM_DETAIL_ENTRY_PREFIX + rekordboxId;
    }

    public void createMetadataCache(final SlotReference slot, final int playlistId, final File cache, final MetadataCacheCreationListener listener) throws Exception {
        ConnectionManager.ClientTask<Object> task = new ConnectionManager.ClientTask<Object>(){

            @Override
            public Object useClient(Client client) throws Exception {
                List trackList = playlistId == 0 ? MetadataFinder.this.getFullTrackList(slot.slot, client) : MetadataFinder.this.getPlaylistItems(slot.slot, 0, playlistId, false, client);
                MetadataFinder.this.copyTracksToCache(trackList, playlistId, client, slot, cache, listener);
                return null;
            }
        };
        if (cache.exists() && !cache.delete()) {
            logger.warn("Unable to delete cache file, {}", (Object)cache);
        }
        ConnectionManager.getInstance().invokeWithClientSession(slot.player, task, "building metadata cache");
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    public boolean isPassive() {
        return this.passive.get();
    }

    public void setPassive(boolean passive) {
        this.passive.set(passive);
    }

    private void clearDeck(CdjStatus update) {
        if (this.hotCache.remove(DeckReference.getDeckReference(update.getDeviceNumber(), 0)) != null) {
            this.deliverTrackMetadataUpdate(update.getDeviceNumber(), null);
        }
    }

    private void clearMetadata(DeviceAnnouncement announcement) {
        int player = announcement.getNumber();
        for (DeckReference deck : new HashSet<DeckReference>(this.hotCache.keySet())) {
            if (deck.player != player) continue;
            this.hotCache.remove(deck);
        }
    }

    private void updateMetadata(CdjStatus update, TrackMetadata data) {
        this.hotCache.put(DeckReference.getDeckReference(update.getDeviceNumber(), 0), data);
        if (data.getCueList() != null) {
            for (CueList.Entry entry : data.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                this.hotCache.put(DeckReference.getDeckReference(update.getDeviceNumber(), entry.hotCueNumber), data);
            }
        }
        this.deliverTrackMetadataUpdate(update.getDeviceNumber(), data);
    }

    public Map<DeckReference, TrackMetadata> getLoadedTracks() {
        this.ensureRunning();
        return Collections.unmodifiableMap(new HashMap<DeckReference, TrackMetadata>(this.hotCache));
    }

    public TrackMetadata getLatestMetadataFor(int player) {
        this.ensureRunning();
        return this.hotCache.get(DeckReference.getDeckReference(player, 0));
    }

    public TrackMetadata getLatestMetadataFor(DeviceUpdate update) {
        return this.getLatestMetadataFor(update.getDeviceNumber());
    }

    public void attachMetadataCache(SlotReference slot, File cache) throws IOException {
        this.ensureRunning();
        if (slot.player < 1 || slot.player > 4 || DeviceFinder.getInstance().getLatestAnnouncementFrom(slot.player) == null) {
            throw new IllegalArgumentException("unable to attach metadata cache for player " + slot.player);
        }
        ZipFile newCache = this.openMetadataCache(cache);
        this.attachMetadataCacheInternal(slot, newCache);
    }

    private void attachMetadataCacheInternal(SlotReference slot, ZipFile cache) {
        ZipFile oldCache = this.metadataCacheFiles.put(slot, cache);
        if (oldCache != null) {
            try {
                oldCache.close();
            }
            catch (IOException e) {
                logger.error("Problem closing previous metadata cache", (Throwable)e);
            }
        }
        this.deliverCacheUpdate(slot, cache);
    }

    private ZipFile openMetadataCache(File cache) throws IOException {
        ZipFile newCache = new ZipFile(cache, 1);
        String tag = this.getCacheFormatEntry(newCache);
        if (tag == null || !tag.startsWith(CACHE_FORMAT_IDENTIFIER)) {
            try {
                newCache.close();
            }
            catch (Exception e) {
                logger.error("Problem re-closing newly opened candidate metadata cache", (Throwable)e);
            }
            throw new IOException("File does not contain a Beat Link metadata cache: " + cache + " (looking for format identifier \"" + CACHE_FORMAT_IDENTIFIER + "\", found: " + tag);
        }
        return newCache;
    }

    private String getCacheFormatEntry(ZipFile cache) throws IOException {
        ZipEntry zipEntry = cache.getEntry(CACHE_FORMAT_ENTRY);
        InputStream is = cache.getInputStream(zipEntry);
        Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
        String tag = null;
        if (s.hasNext()) {
            tag = s.next();
        }
        return tag;
    }

    public int getCacheSourcePlaylist(ZipFile cache) throws IOException {
        String tag = this.getCacheFormatEntry(cache);
        return Integer.parseInt(tag.split(":")[1]);
    }

    public int getCacheTrackCount(ZipFile cache) throws IOException {
        String tag = this.getCacheFormatEntry(cache);
        return Integer.parseInt(tag.split(":")[2]);
    }

    public void detachMetadataCache(SlotReference slot) {
        ZipFile oldCache = this.metadataCacheFiles.remove(slot);
        if (oldCache != null) {
            try {
                oldCache.close();
            }
            catch (IOException e) {
                logger.error("Problem closing metadata cache", (Throwable)e);
            }
            this.deliverCacheUpdate(slot, null);
        }
    }

    public void addAutoAttachCacheFile(File metadataCacheFile) throws IOException {
        ZipFile opened = this.openMetadataCache(metadataCacheFile);
        opened.close();
        if (this.autoAttachCacheFiles.add(metadataCacheFile)) {
            for (SlotReference slot : this.getMountedMediaSlots()) {
                this.tryAutoAttaching(slot);
            }
        }
    }

    public void removeAutoAttacheCacheFile(File metadataCacheFile) {
        this.autoAttachCacheFiles.remove(metadataCacheFile);
    }

    public List<File> getAutoAttachCacheFiles() {
        ArrayList<File> currentFiles = new ArrayList<File>(this.autoAttachCacheFiles);
        Collections.sort(currentFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return Collections.unmodifiableList(currentFiles);
    }

    public void setAutoAttachProbeCount(int numTracks) {
        if (numTracks < 1) {
            throw new IllegalArgumentException("numTracks must be positive");
        }
        this.autoAttachProbeCount.set(numTracks);
    }

    public int getAutoAttachProbeCount() {
        return this.autoAttachProbeCount.get();
    }

    private void tryAutoAttaching(final SlotReference slot) {
        if (!this.getMountedMediaSlots().contains(slot)) {
            logger.error("Unable to auto-attach cache to empty slot {}", (Object)slot);
            return;
        }
        if (this.getMetadataCache(slot) != null) {
            logger.info("Not auto-attaching to slot {}; already has a cache attached.", (Object)slot);
            return;
        }
        if (this.autoAttachCacheFiles.isEmpty()) {
            logger.debug("No auto-attach files configured.");
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionManager.ClientTask<Object> task = new ConnectionManager.ClientTask<Object>(){

                    @Override
                    public Object useClient(Client client) throws Exception {
                        MetadataFinder.this.tryAutoAttachingWithConnection(slot, client);
                        return null;
                    }
                };
                try {
                    ConnectionManager.getInstance().invokeWithClientSession(slot.player, task, "trying to auto-attach metadata cache");
                }
                catch (Exception e) {
                    logger.error("Problem trying to auto-attach metadata cache for slot " + slot, (Throwable)e);
                }
            }
        }, "Metadata cache file auto-attachment attempt").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryAutoAttachingWithConnection(SlotReference slot, Client client) throws IOException, InterruptedException, TimeoutException {
        Map<Integer, LinkedList<ZipFile>> candidateGroups = this.gatherCandidateAttachmentGroups();
        for (Map.Entry<Integer, LinkedList<ZipFile>> entry : candidateGroups.entrySet()) {
            ArrayList<Integer> tracksToSample;
            LinkedList<ZipFile> candidates;
            block11: {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        int playlistId = entry.getKey();
                        candidates = entry.getValue();
                        long count = this.getTrackCount(slot.slot, client, playlistId);
                        if (count == -1L || count == 0L) {
                            candidates.clear();
                        }
                        Iterator candidateIterator = candidates.iterator();
                        while (candidateIterator.hasNext()) {
                            ZipFile candidate = (ZipFile)candidateIterator.next();
                            if ((long)this.getCacheTrackCount(candidate) == count) continue;
                            candidateIterator.remove();
                        }
                        if (candidates.isEmpty()) continue;
                        tracksToSample = this.chooseTrackSample(slot, client, (int)count);
                        break block11;
                    }
                    finally {
                        client.unlockForMenuOperations();
                        continue;
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
            for (int trackId : tracksToSample) {
                logger.info("Comparing track " + trackId + " with " + candidates.size() + " metadata cache file(s).");
                DataReference reference = new DataReference(slot, trackId);
                TrackMetadata track = this.queryMetadata(reference, client);
                if (track == null) {
                    logger.warn("Unable to retrieve metadata when attempting cache auto-attach for slot {}, giving up", (Object)slot);
                    return;
                }
                for (int i = candidates.size() - 1; i >= 0; --i) {
                    if (track.equals(this.getCachedMetadata(candidates.get(i), reference))) continue;
                    candidates.remove(i);
                }
                if (!candidates.isEmpty()) continue;
                break;
            }
            if (candidates.isEmpty()) continue;
            ZipFile match = candidates.get(0);
            logger.info("Auto-attaching metadata cache " + match.getName() + " to slot " + slot);
            this.attachMetadataCacheInternal(slot, match);
            return;
        }
    }

    private Map<Integer, LinkedList<ZipFile>> gatherCandidateAttachmentGroups() {
        TreeMap<Integer, LinkedList<ZipFile>> candidateGroups = new TreeMap<Integer, LinkedList<ZipFile>>();
        Iterator<File> iterator = this.autoAttachCacheFiles.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                ZipFile candidate = this.openMetadataCache(file);
                int playlistId = this.getCacheSourcePlaylist(candidate);
                if (candidateGroups.get(playlistId) == null) {
                    candidateGroups.put(playlistId, new LinkedList());
                }
                ((LinkedList)candidateGroups.get(playlistId)).add(candidate);
            }
            catch (Exception e) {
                logger.error("Unable to open metadata cache file " + file + ", discarding", (Throwable)e);
                iterator.remove();
            }
        }
        return candidateGroups;
    }

    private ArrayList<Integer> chooseTrackSample(SlotReference slot, Client client, int count) throws IOException {
        int tracksLeft = count;
        int samplesNeeded = Math.min(tracksLeft, this.autoAttachProbeCount.get());
        ArrayList<Integer> tracksToSample = new ArrayList<Integer>(samplesNeeded);
        int offset = 0;
        Random random = new Random();
        while (samplesNeeded > 0) {
            int rand = random.nextInt(tracksLeft);
            if (rand < samplesNeeded) {
                --samplesNeeded;
                tracksToSample.add(this.findTrackIdAtOffset(slot, client, offset));
            }
            --tracksLeft;
            ++offset;
        }
        return tracksToSample;
    }

    private long getTrackCount(CdjStatus.TrackSourceSlot slot, Client client, int playlistId) throws IOException {
        Message response = playlistId == 0 ? client.menuRequest(Message.KnownType.TRACK_LIST_REQ, Message.MenuIdentifier.MAIN_MENU, slot, NumberField.WORD_0) : client.menuRequest(Message.KnownType.PLAYLIST_REQ, Message.MenuIdentifier.MAIN_MENU, slot, NumberField.WORD_0, new NumberField(playlistId), NumberField.WORD_0);
        return response.getMenuResultsCount();
    }

    private int findTrackIdAtOffset(SlotReference slot, Client client, int offset) throws IOException {
        Message entry = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot.slot, offset, 1).get(0);
        if (entry.getMenuItemType() == Message.MenuItemType.UNKNOWN) {
            logger.warn("Encountered unrecognized track list entry item type: {}", (Object)entry);
        }
        return (int)((NumberField)entry.arguments.get(1)).getValue();
    }

    private void flushHotCacheSlot(SlotReference slot) {
        for (Map.Entry<DeckReference, TrackMetadata> entry : new HashMap<DeckReference, TrackMetadata>(this.hotCache).entrySet()) {
            if (slot != SlotReference.getSlotReference(entry.getValue().trackReference)) continue;
            logger.debug("Evicting cached metadata in response to unmount report {}", (Object)entry.getValue());
            this.hotCache.remove(entry.getKey());
        }
    }

    public ZipFile getMetadataCache(SlotReference slot) {
        return this.metadataCacheFiles.get(slot);
    }

    private void recordMount(SlotReference slot) {
        if (this.mediaMounts.add(slot)) {
            this.deliverMountUpdate(slot, true);
        }
    }

    private void removeMount(SlotReference slot) {
        if (this.mediaMounts.remove(slot)) {
            this.deliverMountUpdate(slot, false);
        }
    }

    public Set<SlotReference> getMountedMediaSlots() {
        return Collections.unmodifiableSet(new HashSet<SlotReference>(this.mediaMounts));
    }

    public void addMountListener(MountListener listener) {
        if (listener != null) {
            this.mountListeners.add(listener);
        }
    }

    public void removeMountListener(MountListener listener) {
        if (listener != null) {
            this.mountListeners.remove(listener);
        }
    }

    public Set<MountListener> getMountListeners() {
        return Collections.unmodifiableSet(new HashSet<MountListener>(this.mountListeners));
    }

    private void deliverMountUpdate(SlotReference slot, boolean mounted) {
        if (mounted) {
            logger.info("Reporting media mounted in " + slot);
        } else {
            logger.info("Reporting media removed from " + slot);
        }
        for (MountListener listener : this.getMountListeners()) {
            try {
                if (mounted) {
                    listener.mediaMounted(slot);
                    continue;
                }
                listener.mediaUnmounted(slot);
            }
            catch (Exception e) {
                logger.warn("Problem delivering mount update to listener", (Throwable)e);
            }
        }
        if (mounted) {
            this.tryAutoAttaching(slot);
        }
    }

    public void addCacheListener(MetadataCacheListener listener) {
        if (listener != null) {
            this.cacheListeners.add(listener);
        }
    }

    public void removeCacheListener(MetadataCacheListener listener) {
        if (listener != null) {
            this.cacheListeners.remove(listener);
        }
    }

    public Set<MetadataCacheListener> getCacheListeners() {
        return Collections.unmodifiableSet(new HashSet<MetadataCacheListener>(this.cacheListeners));
    }

    private void deliverCacheUpdate(SlotReference slot, ZipFile cache) {
        for (MetadataCacheListener listener : this.getCacheListeners()) {
            try {
                if (cache == null) {
                    listener.cacheDetached(slot);
                    continue;
                }
                listener.cacheAttached(slot, cache);
            }
            catch (Exception e) {
                logger.warn("Problem delivering metadata cache update to listener", (Throwable)e);
            }
        }
    }

    public void addTrackMetadataListener(TrackMetadataListener listener) {
        if (listener != null) {
            this.trackListeners.add(listener);
        }
    }

    public void removeTrackMetadataListener(TrackMetadataListener listener) {
        if (listener != null) {
            this.trackListeners.remove(listener);
        }
    }

    public Set<TrackMetadataListener> getTrackMetadataListeners() {
        return Collections.unmodifiableSet(new HashSet<TrackMetadataListener>(this.trackListeners));
    }

    private void deliverTrackMetadataUpdate(int player, TrackMetadata metadata) {
        if (!this.getTrackMetadataListeners().isEmpty()) {
            TrackMetadataUpdate update = new TrackMetadataUpdate(player, metadata);
            for (TrackMetadataListener listener : this.getTrackMetadataListeners()) {
                try {
                    listener.metadataChanged(update);
                }
                catch (Exception e) {
                    logger.warn("Problem delivering track metadata update to listener", (Throwable)e);
                }
            }
        }
    }

    private void handleUpdate(final CdjStatus update) {
        SlotReference slot;
        if (update.isLocalUsbEmpty()) {
            slot = SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.USB_SLOT);
            this.detachMetadataCache(slot);
            this.flushHotCacheSlot(slot);
            this.removeMount(slot);
        } else if (update.isLocalUsbLoaded()) {
            this.recordMount(SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.USB_SLOT));
        }
        if (update.isLocalSdEmpty()) {
            slot = SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.SD_SLOT);
            this.detachMetadataCache(slot);
            this.flushHotCacheSlot(slot);
            this.removeMount(slot);
        } else if (update.isLocalSdLoaded()) {
            this.recordMount(SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.SD_SLOT));
        }
        if (update.getTrackType() != CdjStatus.TrackType.REKORDBOX || update.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.NO_TRACK || update.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.UNKNOWN || update.getRekordboxId() == 0) {
            this.clearDeck(update);
        } else {
            TrackMetadata lastMetadata = this.hotCache.get(DeckReference.getDeckReference(update.getDeviceNumber(), 0));
            final DataReference trackReference = new DataReference(update.getTrackSourcePlayer(), update.getTrackSourceSlot(), update.getRekordboxId());
            if (lastMetadata == null || !lastMetadata.trackReference.equals(trackReference)) {
                for (TrackMetadata cached : this.hotCache.values()) {
                    if (!cached.trackReference.equals(trackReference)) continue;
                    this.updateMetadata(update, cached);
                    return;
                }
                if (this.activeRequests.add(update.getTrackSourcePlayer())) {
                    this.clearDeck(update);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                TrackMetadata data = MetadataFinder.this.requestMetadataInternal(trackReference, true);
                                if (data != null) {
                                    MetadataFinder.this.updateMetadata(update, data);
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Problem requesting track metadata from update" + update, (Throwable)e);
                            }
                            finally {
                                MetadataFinder.this.activeRequests.remove(update.getTrackSourcePlayer());
                            }
                        }
                    }, "MetadataFinder metadata request").start();
                }
            }
        }
    }

    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            ConnectionManager.getInstance().addLifecycleListener(this.lifecycleListener);
            ConnectionManager.getInstance().start();
            DeviceFinder.getInstance().start();
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            VirtualCdj.getInstance().addLifecycleListener(this.lifecycleListener);
            VirtualCdj.getInstance().start();
            VirtualCdj.getInstance().addUpdateListener(this.updateListener);
            this.queueHandler = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (MetadataFinder.this.isRunning()) {
                        try {
                            MetadataFinder.this.handleUpdate((CdjStatus)MetadataFinder.this.pendingUpdates.take());
                        }
                        catch (InterruptedException e) {
                            logger.debug("Interrupted, presumably due to MetadataFinder shutdown.", (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.error("Problem handling CDJ status update.", (Throwable)e);
                        }
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            VirtualCdj.getInstance().removeUpdateListener(this.updateListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            final HashSet<DeckReference> dyingCache = new HashSet<DeckReference>(this.hotCache.keySet());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (DeckReference deck : dyingCache) {
                        if (deck.hotCue != 0) continue;
                        MetadataFinder.this.deliverTrackMetadataUpdate(deck.player, null);
                    }
                }
            });
            this.hotCache.clear();
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    public static MetadataFinder getInstance() {
        return ourInstance;
    }

    private MetadataFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetadataFinder[").append("running:").append(this.isRunning()).append(", passive:").append(this.isPassive());
        if (this.isRunning()) {
            sb.append(", loadedTracks:").append(this.getLoadedTracks()).append(", mountedMediaSlots:").append(this.getMountedMediaSlots());
            sb.append(", metadataCacheFiles:").append(this.metadataCacheFiles);
        }
        return sb.append("]").toString();
    }
}

