/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.deepsymmetry.beatlink.data.DataReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlbumArt {
    private static final Logger logger = LoggerFactory.getLogger(AlbumArt.class);
    public final DataReference artReference;
    private final ByteBuffer rawBytes;

    public ByteBuffer getRawBytes() {
        this.rawBytes.rewind();
        return this.rawBytes.slice();
    }

    public BufferedImage getImage() {
        ByteBuffer artwork = this.getRawBytes();
        artwork.rewind();
        byte[] imageBytes = new byte[artwork.remaining()];
        artwork.get(imageBytes);
        try {
            return ImageIO.read(new ByteArrayInputStream(imageBytes));
        }
        catch (IOException e) {
            logger.error("Weird! Caught exception creating image from artwork bytes", (Throwable)e);
            return null;
        }
    }

    AlbumArt(DataReference artReference, ByteBuffer rawBytes) {
        this.artReference = artReference;
        this.rawBytes = rawBytes;
    }

    public String toString() {
        return "AlbumArt[artReference=" + this.artReference + ", size=" + this.getRawBytes().remaining() + " bytes]";
    }
}

