/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.nio.ByteBuffer;
import javax.swing.JComponent;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.WaveformDetailComponent;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Message;

public class WaveformDetail {
    public static final int LEADING_JUNK_BYTES = 19;
    public final DataReference dataReference;
    public final Message rawMessage;

    public ByteBuffer getData() {
        return ((BinaryField)this.rawMessage.arguments.get(3)).getValue();
    }

    public int getFrameCount() {
        return this.getData().remaining() - 19;
    }

    public long getTotalTime() {
        return Util.halfFrameToTime(this.getFrameCount());
    }

    public JComponent createViewComponent(TrackMetadata metadata, BeatGrid beatGrid) {
        return new WaveformDetailComponent(this, metadata, beatGrid);
    }

    public WaveformDetail(DataReference reference, Message message) {
        this.dataReference = reference;
        this.rawMessage = message;
    }

    public String toString() {
        return "WaveformDetail[dataReference=" + this.dataReference + ", size:" + this.getData().remaining() + "]";
    }
}

