/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformDetailUpdate;
import org.deepsymmetry.beatlink.data.WaveformListener;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.beatlink.data.WaveformPreviewUpdate;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveformFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(WaveformFinder.class);
    private final Map<DeckReference, WaveformPreview> previewHotCache = new ConcurrentHashMap<DeckReference, WaveformPreview>();
    private final Map<DeckReference, WaveformDetail> detailHotCache = new ConcurrentHashMap<DeckReference, WaveformDetail>();
    private final AtomicBoolean findDetails = new AtomicBoolean(false);
    private final LinkedBlockingDeque<TrackMetadataUpdate> pendingUpdates = new LinkedBlockingDeque(100);
    private final TrackMetadataListener metadataListener = new TrackMetadataListener(){

        @Override
        public void metadataChanged(TrackMetadataUpdate update) {
            logger.debug("Received metadata update {}", (Object)update);
            if (!WaveformFinder.this.pendingUpdates.offerLast(update)) {
                logger.warn("Discarding metadata update because our queue is backed up.");
            }
        }
    };
    private final MountListener mountListener = new MountListener(){

        @Override
        public void mediaMounted(SlotReference slot) {
            logger.debug("WaveformFinder doesn't yet need to do anything in response to a media mount.");
        }

        @Override
        public void mediaUnmounted(SlotReference slot) {
            for (Map.Entry entry : new HashMap(WaveformFinder.this.previewHotCache).entrySet()) {
                if (slot != SlotReference.getSlotReference(((WaveformPreview)entry.getValue()).dataReference)) continue;
                logger.debug("Evicting cached waveform preview in response to unmount report {}", entry.getValue());
                WaveformFinder.this.previewHotCache.remove(entry.getKey());
            }
            for (Map.Entry entry : new HashMap(WaveformFinder.this.detailHotCache).entrySet()) {
                if (slot != SlotReference.getSlotReference(((WaveformDetail)entry.getValue()).dataReference)) continue;
                logger.debug("Evicting cached waveform detail in response to unmount report {}", entry.getValue());
                WaveformFinder.this.detailHotCache.remove(entry.getKey());
            }
        }
    };
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            logger.debug("Currently nothing for WaveformFinder to do when devices appear.");
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            logger.info("Clearing waveforms in response to the loss of a device, {}", (Object)announcement);
            WaveformFinder.this.clearWaveforms(announcement);
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread queueHandler;
    private final Set<Integer> activePreviewRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Integer> activeDetailRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WaveformListener> waveformListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("The WaveformFinder does not auto-start when {} does.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (WaveformFinder.this.isRunning()) {
                logger.info("WaveformFinder stopping because {} has.", (Object)sender);
                WaveformFinder.this.stop();
            }
        }
    };
    private static final WaveformFinder ourInstance = new WaveformFinder();

    public final void setFindDetails(boolean findDetails) {
        this.findDetails.set(findDetails);
        if (findDetails) {
            this.primeCache();
        } else {
            final HashSet<DeckReference> dyingCache = new HashSet<DeckReference>(this.detailHotCache.keySet());
            this.detailHotCache.clear();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (DeckReference deck : dyingCache) {
                        WaveformFinder.this.deliverWaveformDetailUpdate(deck.player, null);
                    }
                }
            });
        }
    }

    public final boolean isFindingDetails() {
        return this.findDetails.get();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    private void clearDeckPreview(TrackMetadataUpdate update) {
        if (this.previewHotCache.remove(DeckReference.getDeckReference(update.player, 0)) != null) {
            this.deliverWaveformPreviewUpdate(update.player, null);
        }
    }

    private void clearDeckDetail(TrackMetadataUpdate update) {
        if (this.detailHotCache.remove(DeckReference.getDeckReference(update.player, 0)) != null) {
            this.deliverWaveformDetailUpdate(update.player, null);
        }
    }

    private void clearDeck(TrackMetadataUpdate update) {
        this.clearDeckPreview(update);
        this.clearDeckDetail(update);
    }

    private void clearWaveforms(DeviceAnnouncement announcement) {
        int player = announcement.getNumber();
        for (DeckReference deck : new HashSet<DeckReference>(this.previewHotCache.keySet())) {
            if (deck.player != player) continue;
            this.previewHotCache.remove(deck);
        }
        for (DeckReference deck : new HashSet<DeckReference>(this.detailHotCache.keySet())) {
            if (deck.player != player) continue;
            this.detailHotCache.remove(deck);
        }
    }

    private void updatePreview(TrackMetadataUpdate update, WaveformPreview preview) {
        this.previewHotCache.put(DeckReference.getDeckReference(update.player, 0), preview);
        if (update.metadata.getCueList() != null) {
            for (CueList.Entry entry : update.metadata.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                this.previewHotCache.put(DeckReference.getDeckReference(update.player, entry.hotCueNumber), preview);
            }
        }
        this.deliverWaveformPreviewUpdate(update.player, preview);
    }

    private void updateDetail(TrackMetadataUpdate update, WaveformDetail detail) {
        this.detailHotCache.put(DeckReference.getDeckReference(update.player, 0), detail);
        if (update.metadata.getCueList() != null) {
            for (CueList.Entry entry : update.metadata.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                this.detailHotCache.put(DeckReference.getDeckReference(update.player, entry.hotCueNumber), detail);
            }
        }
        this.deliverWaveformDetailUpdate(update.player, detail);
    }

    public Map<DeckReference, WaveformPreview> getLoadedPreviews() {
        this.ensureRunning();
        return Collections.unmodifiableMap(new HashMap<DeckReference, WaveformPreview>(this.previewHotCache));
    }

    public Map<DeckReference, WaveformDetail> getLoadedDetails() {
        this.ensureRunning();
        if (!this.isFindingDetails()) {
            throw new IllegalStateException("WaveformFinder is not configured to find waveform details.");
        }
        return Collections.unmodifiableMap(new HashMap<DeckReference, WaveformDetail>(this.detailHotCache));
    }

    public WaveformPreview getLatestPreviewFor(int player) {
        this.ensureRunning();
        return this.previewHotCache.get(DeckReference.getDeckReference(player, 0));
    }

    public WaveformPreview getLatestPreviewFor(DeviceUpdate update) {
        return this.getLatestPreviewFor(update.getDeviceNumber());
    }

    public WaveformDetail getLatestDetailFor(int player) {
        this.ensureRunning();
        return this.detailHotCache.get(DeckReference.getDeckReference(player, 0));
    }

    public WaveformDetail getLatestDetailFor(DeviceUpdate update) {
        return this.getLatestDetailFor(update.getDeviceNumber());
    }

    private WaveformPreview requestPreviewInternal(final DataReference trackReference, boolean failIfPassive) {
        ZipFile cache = MetadataFinder.getInstance().getMetadataCache(SlotReference.getSlotReference(trackReference));
        if (cache != null) {
            return this.getCachedWaveformPreview(cache, trackReference);
        }
        if (MetadataFinder.getInstance().isPassive() && failIfPassive) {
            return null;
        }
        ConnectionManager.ClientTask<WaveformPreview> task = new ConnectionManager.ClientTask<WaveformPreview>(){

            @Override
            public WaveformPreview useClient(Client client) throws Exception {
                return WaveformFinder.this.getWaveformPreview(trackReference.rekordboxId, SlotReference.getSlotReference(trackReference), client);
            }
        };
        try {
            return ConnectionManager.getInstance().invokeWithClientSession(trackReference.player, task, "requesting waveform preview");
        }
        catch (Exception e) {
            logger.error("Problem requesting waveform preview, returning null", (Throwable)e);
            return null;
        }
    }

    public WaveformPreview requestWaveformPreviewFrom(DataReference dataReference) {
        this.ensureRunning();
        for (WaveformPreview cached : this.previewHotCache.values()) {
            if (!cached.dataReference.equals(dataReference)) continue;
            return cached;
        }
        return this.requestPreviewInternal(dataReference, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaveformPreview getCachedWaveformPreview(ZipFile cache, DataReference dataReference) {
        ZipEntry entry = cache.getEntry(MetadataFinder.getInstance().getWaveformPreviewEntryName(dataReference.rekordboxId));
        if (entry != null) {
            DataInputStream is = null;
            try {
                is = new DataInputStream(cache.getInputStream(entry));
                Message message = Message.read(is);
                WaveformPreview waveformPreview = new WaveformPreview(dataReference, message);
                return waveformPreview;
            }
            catch (IOException e) {
                logger.error("Problem reading waveform preview from cache file, returning null", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing ZipFile input stream for waveform preview", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    WaveformPreview getWaveformPreview(int rekordboxId, SlotReference slot, Client client) throws IOException {
        Message response = client.simpleRequest(Message.KnownType.WAVE_PREVIEW_REQ, null, client.buildRMS1(Message.MenuIdentifier.DATA, slot.slot), NumberField.WORD_1, new NumberField(rekordboxId), NumberField.WORD_0);
        if (response.knownType == Message.KnownType.WAVE_PREVIEW) {
            return new WaveformPreview(new DataReference(slot, rekordboxId), response);
        }
        logger.error("Unexpected response type when requesting waveform preview: {}", (Object)response);
        return null;
    }

    private WaveformDetail requestDetailInternal(final DataReference trackReference, boolean failIfPassive) {
        ZipFile cache = MetadataFinder.getInstance().getMetadataCache(SlotReference.getSlotReference(trackReference));
        if (cache != null) {
            return this.getCachedWaveformDetail(cache, trackReference);
        }
        if (MetadataFinder.getInstance().isPassive() && failIfPassive) {
            return null;
        }
        ConnectionManager.ClientTask<WaveformDetail> task = new ConnectionManager.ClientTask<WaveformDetail>(){

            @Override
            public WaveformDetail useClient(Client client) throws Exception {
                return WaveformFinder.this.getWaveformDetail(trackReference.rekordboxId, SlotReference.getSlotReference(trackReference), client);
            }
        };
        try {
            return ConnectionManager.getInstance().invokeWithClientSession(trackReference.player, task, "requesting waveform detail");
        }
        catch (Exception e) {
            logger.error("Problem requesting waveform preview, returning null", (Throwable)e);
            return null;
        }
    }

    public WaveformDetail requestWaveformDetailFrom(DataReference dataReference) {
        this.ensureRunning();
        for (WaveformDetail cached : this.detailHotCache.values()) {
            if (!cached.dataReference.equals(dataReference)) continue;
            return cached;
        }
        return this.requestDetailInternal(dataReference, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaveformDetail getCachedWaveformDetail(ZipFile cache, DataReference dataReference) {
        ZipEntry entry = cache.getEntry(MetadataFinder.getInstance().getWaveformDetailEntryName(dataReference.rekordboxId));
        if (entry != null) {
            DataInputStream is = null;
            try {
                is = new DataInputStream(cache.getInputStream(entry));
                Message message = Message.read(is);
                WaveformDetail waveformDetail = new WaveformDetail(dataReference, message);
                return waveformDetail;
            }
            catch (IOException e) {
                logger.error("Problem reading waveform detail from cache file, returning null", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing ZipFile input stream for waveform detail", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    WaveformDetail getWaveformDetail(int rekordboxId, SlotReference slot, Client client) throws IOException {
        Message response = client.simpleRequest(Message.KnownType.WAVE_DETAIL_REQ, null, client.buildRMS1(Message.MenuIdentifier.MAIN_MENU, slot.slot), new NumberField(rekordboxId), NumberField.WORD_0);
        if (response.knownType == Message.KnownType.WAVE_DETAIL) {
            return new WaveformDetail(new DataReference(slot, rekordboxId), response);
        }
        logger.error("Unexpected response type when requesting waveform detail: {}", (Object)response);
        return null;
    }

    public void addWaveformListener(WaveformListener listener) {
        if (listener != null) {
            this.waveformListeners.add(listener);
        }
    }

    public void removeWaveformListener(WaveformListener listener) {
        if (listener != null) {
            this.waveformListeners.remove(listener);
        }
    }

    public Set<WaveformListener> getWaveformListeners() {
        return Collections.unmodifiableSet(new HashSet<WaveformListener>(this.waveformListeners));
    }

    private void deliverWaveformPreviewUpdate(final int player, final WaveformPreview preview) {
        if (!this.getWaveformListeners().isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaveformPreviewUpdate update = new WaveformPreviewUpdate(player, preview);
                    for (WaveformListener listener : WaveformFinder.this.getWaveformListeners()) {
                        try {
                            listener.previewChanged(update);
                        }
                        catch (Exception e) {
                            logger.warn("Problem delivering waveform preview update to listener", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private void deliverWaveformDetailUpdate(final int player, final WaveformDetail detail) {
        if (!this.getWaveformListeners().isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaveformDetailUpdate update = new WaveformDetailUpdate(player, detail);
                    for (WaveformListener listener : WaveformFinder.this.getWaveformListeners()) {
                        try {
                            listener.detailChanged(update);
                        }
                        catch (Exception e) {
                            logger.warn("Problem delivering waveform detail update to listener", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private void handleUpdate(final TrackMetadataUpdate update) {
        if (update.metadata == null) {
            this.clearDeck(update);
        } else {
            WaveformPreview lastPreview = this.previewHotCache.get(DeckReference.getDeckReference(update.player, 0));
            if (lastPreview == null || !lastPreview.dataReference.equals(update.metadata.trackReference)) {
                for (WaveformPreview cached : this.previewHotCache.values()) {
                    if (!cached.dataReference.equals(update.metadata.trackReference)) continue;
                    this.updatePreview(update, cached);
                    return;
                }
                if (this.activePreviewRequests.add(update.player)) {
                    this.clearDeckPreview(update);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                WaveformPreview preview = WaveformFinder.this.requestPreviewInternal(update.metadata.trackReference, true);
                                if (preview != null) {
                                    WaveformFinder.this.updatePreview(update, preview);
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Problem requesting waveform preview from update" + update, (Throwable)e);
                            }
                            finally {
                                WaveformFinder.this.activePreviewRequests.remove(update.player);
                            }
                        }
                    }).start();
                }
            }
            WaveformDetail lastDetail = this.detailHotCache.get(DeckReference.getDeckReference(update.player, 0));
            if (this.isFindingDetails() && (lastDetail == null || !lastDetail.dataReference.equals(update.metadata.trackReference))) {
                for (WaveformDetail cached : this.detailHotCache.values()) {
                    if (!cached.dataReference.equals(update.metadata.trackReference)) continue;
                    this.updateDetail(update, cached);
                    return;
                }
                if (this.activeDetailRequests.add(update.player)) {
                    this.clearDeckDetail(update);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                WaveformDetail detail = WaveformFinder.this.requestDetailInternal(update.metadata.trackReference, true);
                                if (detail != null) {
                                    WaveformFinder.this.updateDetail(update, detail);
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Problem requesting waveform detail from update" + update, (Throwable)e);
                            }
                            finally {
                                WaveformFinder.this.activeDetailRequests.remove(update.player);
                            }
                        }
                    }).start();
                }
            }
        }
    }

    private void primeCache() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry<DeckReference, TrackMetadata> entry : MetadataFinder.getInstance().getLoadedTracks().entrySet()) {
                    if (entry.getKey().hotCue != 0) continue;
                    WaveformFinder.this.handleUpdate(new TrackMetadataUpdate(entry.getKey().player, entry.getValue()));
                }
            }
        });
    }

    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            ConnectionManager.getInstance().addLifecycleListener(this.lifecycleListener);
            ConnectionManager.getInstance().start();
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            MetadataFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            MetadataFinder.getInstance().start();
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            MetadataFinder.getInstance().addMountListener(this.mountListener);
            this.queueHandler = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (WaveformFinder.this.isRunning()) {
                        try {
                            WaveformFinder.this.handleUpdate((TrackMetadataUpdate)WaveformFinder.this.pendingUpdates.take());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
            this.primeCache();
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            final HashSet<DeckReference> dyingPreviewCache = new HashSet<DeckReference>(this.previewHotCache.keySet());
            this.previewHotCache.clear();
            final HashSet<DeckReference> dyingDetailCache = new HashSet<DeckReference>(this.detailHotCache.keySet());
            this.detailHotCache.clear();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (DeckReference deck : dyingPreviewCache) {
                        if (deck.hotCue != 0) continue;
                        WaveformFinder.this.deliverWaveformPreviewUpdate(deck.player, null);
                    }
                    for (DeckReference deck : dyingDetailCache) {
                        if (deck.hotCue != 0) continue;
                        WaveformFinder.this.deliverWaveformDetailUpdate(deck.player, null);
                    }
                }
            });
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    public static WaveformFinder getInstance() {
        return ourInstance;
    }

    private WaveformFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WaveformFinder[running:").append(this.isRunning()).append(", passive:");
        sb.append(MetadataFinder.getInstance().isPassive()).append(", findingDetails:").append(this.isFindingDetails());
        if (this.isRunning()) {
            sb.append(", loadedPreviews:").append(this.getLoadedPreviews());
            if (this.isFindingDetails()) {
                sb.append(", loadedDetails:").append(this.getLoadedDetails());
            }
        }
        return sb.append("]").toString();
    }
}

