/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.Util;

public class MixerStatus
extends DeviceUpdate {
    public static final int STATUS_FLAGS = 39;
    private final int pitch;
    private final int bpm;

    public MixerStatus(DatagramPacket packet) {
        super(packet, "Mixer update", 56);
        this.pitch = (int)Util.bytesToNumber(this.packetBytes, 40, 4);
        this.bpm = (int)Util.bytesToNumber(this.packetBytes, 46, 2);
    }

    @Override
    public int getBpm() {
        return this.bpm;
    }

    @Override
    public int getBeatWithinBar() {
        return this.packetBytes[55];
    }

    @Override
    public boolean isBeatWithinBarMeaningful() {
        return false;
    }

    @Override
    public int getPitch() {
        return this.pitch;
    }

    @Override
    public boolean isTempoMaster() {
        return (this.packetBytes[39] & 0x20) > 0;
    }

    @Override
    public double getEffectiveTempo() {
        return (double)this.bpm * Util.pitchToMultiplier(this.pitch) / 100.0;
    }

    @Override
    public String toString() {
        return "MixerStatus[device:" + this.deviceNumber + ", name:" + this.deviceName + ", address:" + this.address.getHostAddress() + ", timestamp:" + this.timestamp + ", BPM:" + String.format("%.1f", (double)this.bpm / 100.0) + ", beat within bar:" + this.getBeatWithinBar() + ", isBeatWithBarMeaningful? " + this.isBeatWithinBarMeaningful() + "]";
    }
}

