/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.deepsymmetry.beatlink.Beat;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MasterListener;
import org.deepsymmetry.beatlink.MixerStatus;
import org.deepsymmetry.beatlink.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualCdj
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(VirtualCdj.class);
    public static final int UPDATE_PORT = 50002;
    private final AtomicReference<DatagramSocket> socket = new AtomicReference();
    private final AtomicReference<InetAddress> broadcastAddress = new AtomicReference();
    private final Map<InetAddress, DeviceUpdate> updates = new ConcurrentHashMap<InetAddress, DeviceUpdate>();
    private final AtomicBoolean useStandardPlayerNumber = new AtomicBoolean(false);
    private final AtomicInteger announceInterval = new AtomicInteger(1500);
    private static final byte[] announcementBytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 6, 0, 98, 101, 97, 116, 45, 108, 105, 110, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0};
    private final AtomicReference<DeviceUpdate> tempoMaster = new AtomicReference();
    private final AtomicLong tempoEpsilon = new AtomicLong(Double.doubleToLongBits(1.0E-4));
    private final AtomicLong masterTempo = new AtomicLong();
    private static final long SELF_ASSIGNMENT_WATCH_PERIOD = 4000L;
    private final LifecycleListener deviceFinderLifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("VirtualCDJ doesn't have anything to do when the DeviceFinder starts");
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (VirtualCdj.this.isRunning()) {
                logger.info("VirtualCDJ stopping because DeviceFinder has stopped.");
                VirtualCdj.this.stop();
            }
        }
    };
    private final Set<MasterListener> masterListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<DeviceUpdateListener> updateListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final VirtualCdj ourInstance = new VirtualCdj();

    @Override
    public boolean isRunning() {
        return this.socket.get() != null;
    }

    public InetAddress getLocalAddress() {
        this.ensureRunning();
        return this.socket.get().getLocalAddress();
    }

    public InetAddress getBroadcastAddress() {
        this.ensureRunning();
        return this.broadcastAddress.get();
    }

    public void setUseStandardPlayerNumber(boolean attempt) {
        this.useStandardPlayerNumber.set(attempt);
    }

    public boolean getUseStandardPlayerNumber() {
        return this.useStandardPlayerNumber.get();
    }

    public synchronized byte getDeviceNumber() {
        return announcementBytes[36];
    }

    public synchronized void setDeviceNumber(byte number) {
        if (number == 0 && this.isRunning()) {
            this.selfAssignDeviceNumber();
        } else {
            VirtualCdj.announcementBytes[36] = number;
        }
    }

    public int getAnnounceInterval() {
        return this.announceInterval.get();
    }

    public void setAnnounceInterval(int interval) {
        if (interval < 200 || interval > 2000) {
            throw new IllegalArgumentException("Interval must be between 200 and 2000");
        }
        this.announceInterval.set(interval);
    }

    public static String getDeviceName() {
        return new String(announcementBytes, 12, 20).trim();
    }

    public synchronized void setDeviceName(String name) {
        if (name.getBytes().length > 20) {
            throw new IllegalArgumentException("name cannot be more than 20 bytes long");
        }
        Arrays.fill(announcementBytes, 12, 32, (byte)0);
        System.arraycopy(name.getBytes(), 0, announcementBytes, 12, name.getBytes().length);
    }

    public DeviceUpdate getTempoMaster() {
        this.ensureRunning();
        return this.tempoMaster.get();
    }

    private void setTempoMaster(DeviceUpdate newMaster) {
        DeviceUpdate oldMaster = this.tempoMaster.getAndSet(newMaster);
        if (newMaster == null && oldMaster != null || newMaster != null && (oldMaster == null || !newMaster.getAddress().equals(oldMaster.getAddress()))) {
            this.deliverMasterChangedAnnouncement(newMaster);
        }
    }

    public double getTempoEpsilon() {
        return Double.longBitsToDouble(this.tempoEpsilon.get());
    }

    public void setTempoEpsilon(double epsilon) {
        this.tempoEpsilon.set(Double.doubleToLongBits(epsilon));
    }

    public double getMasterTempo() {
        this.ensureRunning();
        return Double.longBitsToDouble(this.masterTempo.get());
    }

    private void setMasterTempo(double newTempo) {
        double oldTempo = Double.longBitsToDouble(this.masterTempo.getAndSet(Double.doubleToLongBits(newTempo)));
        if (this.getTempoMaster() != null && Math.abs(newTempo - oldTempo) > this.getTempoEpsilon()) {
            this.deliverTempoChangedAnnouncement(newTempo);
        }
    }

    private DeviceUpdate buildUpdate(DatagramPacket packet) {
        int length = packet.getLength();
        byte kind = packet.getData()[10];
        if (length == 56 && kind == 41 && Util.validateHeader(packet, 41, "Mixer Status")) {
            return new MixerStatus(packet);
        }
        if ((length == 212 || length == 208 || length == 284 || length == 292) && kind == 10 && Util.validateHeader(packet, 10, "CDJ Status")) {
            return new CdjStatus(packet);
        }
        logger.warn("Unrecognized device update packet with length " + length + " and kind " + kind);
        return null;
    }

    private void processUpdate(DeviceUpdate update) {
        this.updates.put(update.getAddress(), update);
        if (update.isTempoMaster()) {
            this.setTempoMaster(update);
            this.setMasterTempo(update.getEffectiveTempo());
        } else {
            DeviceUpdate oldMaster = this.getTempoMaster();
            if (oldMaster != null && oldMaster.getAddress().equals(update.getAddress())) {
                this.setTempoMaster(null);
            }
        }
        this.deliverDeviceUpdate(update);
    }

    void processBeat(Beat beat) {
        if (this.isRunning() && beat.isTempoMaster()) {
            this.setMasterTempo(beat.getEffectiveTempo());
            this.deliverBeatAnnouncement(beat);
        }
    }

    private InterfaceAddress findMatchingAddress(DeviceAnnouncement aDevice, NetworkInterface networkInterface) {
        for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
            if (address.getBroadcast() == null || !Util.sameNetwork(address.getNetworkPrefixLength(), aDevice.getAddress(), address.getAddress())) continue;
            return address;
        }
        return null;
    }

    private boolean selfAssignDeviceNumber() {
        int startingNumber;
        long started;
        long now = System.currentTimeMillis();
        if (now - (started = DeviceFinder.getInstance().getFirstDeviceTime()) < 4000L) {
            try {
                Thread.sleep(4000L - (now - started));
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted waiting to self-assign device number, giving up.");
                return false;
            }
        }
        HashSet<Integer> numbersUsed = new HashSet<Integer>();
        for (DeviceAnnouncement device : DeviceFinder.getInstance().getCurrentDevices()) {
            numbersUsed.add(device.getNumber());
        }
        for (int result = startingNumber = this.getUseStandardPlayerNumber() ? 1 : 5; result < 16; ++result) {
            if (numbersUsed.contains(result)) continue;
            this.setDeviceNumber((byte)result);
            if (this.getUseStandardPlayerNumber() && result > 4) {
                logger.warn("Unable to self-assign a standard player number, all are in use. Using number " + result + ".");
            }
            return true;
        }
        logger.warn("Found no unused device numbers between " + startingNumber + " and 15, giving up.");
        return false;
    }

    private boolean createVirtualCdj() throws SocketException {
        NetworkInterface matchedInterface = null;
        InterfaceAddress matchedAddress = null;
        DeviceAnnouncement aDevice = DeviceFinder.getInstance().getCurrentDevices().iterator().next();
        for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            matchedAddress = this.findMatchingAddress(aDevice, networkInterface);
            if (matchedAddress == null) continue;
            matchedInterface = networkInterface;
            break;
        }
        if (matchedAddress == null) {
            logger.warn("Unable to find network interface to communicate with " + aDevice + ", giving up.");
            return false;
        }
        if (this.getDeviceNumber() == 0 && !this.selfAssignDeviceNumber()) {
            return false;
        }
        System.arraycopy(matchedInterface.getHardwareAddress(), 0, announcementBytes, 38, 6);
        System.arraycopy(matchedAddress.getAddress().getAddress(), 0, announcementBytes, 44, 4);
        this.broadcastAddress.set(matchedAddress.getBroadcast());
        this.socket.set(new DatagramSocket(50002, matchedAddress.getAddress()));
        DeviceFinder.getInstance().addIgnoredAddress(this.socket.get().getLocalAddress());
        byte[] buffer = new byte[512];
        final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        Thread receiver = new Thread(null, new Runnable(){

            @Override
            public void run() {
                while (VirtualCdj.this.isRunning()) {
                    boolean received;
                    try {
                        ((DatagramSocket)VirtualCdj.this.socket.get()).receive(packet);
                        received = true;
                    }
                    catch (IOException e) {
                        if (VirtualCdj.this.isRunning()) {
                            logger.warn("Problem reading from DeviceStatus socket, stopping", (Throwable)e);
                            VirtualCdj.this.stop();
                        }
                        received = false;
                    }
                    try {
                        DeviceUpdate update;
                        if (!received || packet.getAddress() == ((DatagramSocket)VirtualCdj.this.socket.get()).getLocalAddress() || (update = VirtualCdj.this.buildUpdate(packet)) == null) continue;
                        VirtualCdj.this.processUpdate(update);
                    }
                    catch (Exception e) {
                        logger.warn("Problem processing device update packet", (Throwable)e);
                    }
                }
            }
        }, "beat-link VirtualCdj status receiver");
        receiver.setDaemon(true);
        receiver.setPriority(10);
        receiver.start();
        Thread announcer = new Thread(null, new Runnable(){

            @Override
            public void run() {
                while (VirtualCdj.this.isRunning()) {
                    VirtualCdj.this.sendAnnouncement((InetAddress)VirtualCdj.this.broadcastAddress.get());
                }
            }
        }, "beat-link VirtualCdj announcement sender");
        announcer.setDaemon(true);
        announcer.start();
        this.deliverLifecycleAnnouncement(logger, true);
        return true;
    }

    public synchronized boolean start() throws SocketException {
        if (!this.isRunning()) {
            DeviceFinder.getInstance().addLifecycleListener(this.deviceFinderLifecycleListener);
            DeviceFinder.getInstance().start();
            for (int i = 0; DeviceFinder.getInstance().getCurrentDevices().isEmpty() && i < 20; ++i) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted waiting for devices, giving up", (Throwable)e);
                    return false;
                }
            }
            if (DeviceFinder.getInstance().getCurrentDevices().isEmpty()) {
                logger.warn("No DJ Link devices found, giving up");
                return false;
            }
            return this.createVirtualCdj();
        }
        return true;
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            DeviceFinder.getInstance().removeIgnoredAddress(this.socket.get().getLocalAddress());
            this.socket.get().close();
            this.socket.set(null);
            this.broadcastAddress.set(null);
            this.updates.clear();
            this.setTempoMaster(null);
            this.setDeviceNumber((byte)0);
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    private void sendAnnouncement(InetAddress broadcastAddress) {
        try {
            DatagramPacket announcement = new DatagramPacket(announcementBytes, announcementBytes.length, broadcastAddress, 50000);
            this.socket.get().send(announcement);
            Thread.sleep(this.getAnnounceInterval());
        }
        catch (Exception e) {
            logger.warn("Unable to send announcement packet, shutting down", (Throwable)e);
            this.stop();
        }
    }

    public Set<DeviceUpdate> getLatestStatus() {
        this.ensureRunning();
        HashSet<DeviceUpdate> result = new HashSet<DeviceUpdate>();
        long now = System.currentTimeMillis();
        for (DeviceUpdate update : this.updates.values()) {
            if (now - update.getTimestamp() > 10000L) continue;
            result.add(update);
        }
        return Collections.unmodifiableSet(result);
    }

    public DeviceUpdate getLatestStatusFor(DeviceUpdate device) {
        this.ensureRunning();
        return this.updates.get(device.getAddress());
    }

    public DeviceUpdate getLatestStatusFor(DeviceAnnouncement device) {
        this.ensureRunning();
        return this.updates.get(device.getAddress());
    }

    public DeviceUpdate getLatestStatusFor(int deviceNumber) {
        this.ensureRunning();
        for (DeviceUpdate update : this.updates.values()) {
            if (update.getDeviceNumber() != deviceNumber) continue;
            return update;
        }
        return null;
    }

    public void addMasterListener(MasterListener listener) {
        if (listener != null) {
            this.masterListeners.add(listener);
        }
    }

    public void removeMasterListener(MasterListener listener) {
        if (listener != null) {
            this.masterListeners.remove(listener);
        }
    }

    public Set<MasterListener> getMasterListeners() {
        return Collections.unmodifiableSet(new HashSet<MasterListener>(this.masterListeners));
    }

    private void deliverMasterChangedAnnouncement(DeviceUpdate update) {
        for (MasterListener listener : this.getMasterListeners()) {
            try {
                listener.masterChanged(update);
            }
            catch (Exception e) {
                logger.warn("Problem delivering master changed announcement to listener", (Throwable)e);
            }
        }
    }

    private void deliverTempoChangedAnnouncement(double tempo) {
        for (MasterListener listener : this.getMasterListeners()) {
            try {
                listener.tempoChanged(tempo);
            }
            catch (Exception e) {
                logger.warn("Problem delivering tempo changed announcement to listener", (Throwable)e);
            }
        }
    }

    private void deliverBeatAnnouncement(Beat beat) {
        for (MasterListener listener : this.getMasterListeners()) {
            try {
                listener.newBeat(beat);
            }
            catch (Exception e) {
                logger.warn("Problem delivering master beat announcement to listener", (Throwable)e);
            }
        }
    }

    public void addUpdateListener(DeviceUpdateListener listener) {
        if (listener != null) {
            this.updateListeners.add(listener);
        }
    }

    public void removeUpdateListener(DeviceUpdateListener listener) {
        if (listener != null) {
            this.updateListeners.remove(listener);
        }
    }

    public Set<DeviceUpdateListener> getUpdateListeners() {
        return Collections.unmodifiableSet(new HashSet<DeviceUpdateListener>(this.updateListeners));
    }

    private void deliverDeviceUpdate(DeviceUpdate update) {
        for (DeviceUpdateListener listener : this.getUpdateListeners()) {
            try {
                listener.received(update);
            }
            catch (Exception e) {
                logger.warn("Problem delivering device update to listener", (Throwable)e);
            }
        }
    }

    public static VirtualCdj getInstance() {
        return ourInstance;
    }

    private VirtualCdj() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualCdj[number:").append(this.getDeviceNumber()).append(", name:").append(VirtualCdj.getDeviceName());
        sb.append(", announceInterval:").append(this.getAnnounceInterval());
        sb.append(", useStandardPlayerNumber:").append(this.getUseStandardPlayerNumber());
        sb.append(", tempoEpsilon:").append(this.getTempoEpsilon()).append(", active:").append(this.isRunning());
        if (this.isRunning()) {
            sb.append(", localAddress:").append(this.getLocalAddress().getHostAddress());
            sb.append(", broadcastAddress:").append(this.getBroadcastAddress().getHostAddress());
            sb.append(", latestStatus:").append(this.getLatestStatus()).append(", masterTempo:").append(this.getMasterTempo());
            sb.append(", tempoMaster:").append(this.getTempoMaster());
        }
        return sb.append("]").toString();
    }
}

