/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaDetails {
    private static final Logger logger = LoggerFactory.getLogger(MediaDetails.class);
    public final SlotReference slotReference;
    public final CdjStatus.TrackType mediaType;
    public final String name;
    public final String creationDate;
    public final int trackCount;
    public final int playlistCount;
    public final long totalSize;
    public final long freeSpace;
    private static final Set<Integer> expectedStatusPacketSizes = new HashSet<Integer>(Collections.singletonList(192));
    public static final int MINIMUM_PACKET_SIZE = 192;

    public MediaDetails(DatagramPacket packet) {
        byte[] packetBytes = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, packetBytes, 0, packet.getLength());
        if (packetBytes.length < 192) {
            throw new IllegalArgumentException("Unable to create a MediaDetails object, packet too short: we need 192 bytes and were given only " + packetBytes.length);
        }
        int payloadLength = (int)Util.bytesToNumber(packetBytes, 34, 2);
        if (packetBytes.length != payloadLength + 36) {
            logger.warn("Received Media response packet with reported payload length of " + payloadLength + " and actual payload length of " + (packetBytes.length - 36));
        }
        if (!expectedStatusPacketSizes.contains(packetBytes.length)) {
            logger.warn("Processing Media response packets with unexpected lengths " + packetBytes.length + ".");
            expectedStatusPacketSizes.add(packetBytes.length);
        }
        byte hostPlayer = packetBytes[39];
        CdjStatus.TrackSourceSlot hostSLot = CdjStatus.TRACK_SOURCE_SLOT_MAP.get(packetBytes[43]);
        if (hostSLot == null) {
            throw new IllegalArgumentException("Unrecognized slot for media response:" + packetBytes[43]);
        }
        this.slotReference = SlotReference.getSlotReference(hostPlayer, hostSLot);
        CdjStatus.TrackType type = CdjStatus.TRACK_TYPE_MAP.get(packetBytes[170]);
        if (type == null) {
            throw new IllegalArgumentException("Unrecognized media type for media response:" + packetBytes[170]);
        }
        this.mediaType = type;
        try {
            this.name = new String(packetBytes, 44, 64, "UTF-16BE").trim();
            this.creationDate = new String(packetBytes, 108, 24, "UTF-16BE").trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java no longer supports UTF-16BE encoding?!", e);
        }
        this.trackCount = (int)Util.bytesToNumber(packetBytes, 166, 2);
        this.playlistCount = (int)Util.bytesToNumber(packetBytes, 174, 2);
        this.totalSize = Util.bytesToNumber(packetBytes, 176, 8);
        this.freeSpace = Util.bytesToNumber(packetBytes, 184, 8);
    }

    public String toString() {
        return "MediaDetails[slotReference:" + this.slotReference + ", name:" + this.name + ", creationDate:" + this.creationDate + ", mediaType:" + (Object)((Object)this.mediaType) + ", trackCount:" + this.trackCount + ", playlistCount:" + this.playlistCount + ", totalSize:" + this.totalSize + ", freeSpace:" + this.freeSpace + "]";
    }
}

