/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.DatagramPacket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixerStatus
extends DeviceUpdate {
    private static final Logger logger = LoggerFactory.getLogger(MixerStatus.class);
    public static final int STATUS_FLAGS = 39;
    public static final int MASTER_HAND_OFF = 54;
    private final int pitch;
    private final int bpm;
    private final int handingMasterToDevice;
    public static final int MINIMUM_PACKET_SIZE = 56;
    private static final Set<Integer> expectedStatusPacketSizes = new HashSet<Integer>(Collections.singletonList(56));

    public MixerStatus(DatagramPacket packet) {
        super(packet, "Mixer update", packet.getLength());
        if (this.packetBytes.length < 56) {
            throw new IllegalArgumentException("Unable to create a MixerStatus object, packet too short: we need 56 bytes and were given only " + this.packetBytes.length);
        }
        int payloadLength = (int)Util.bytesToNumber(this.packetBytes, 34, 2);
        if (this.packetBytes.length != payloadLength + 36) {
            logger.warn("Received Mixer status packet with reported payload length of " + payloadLength + " and actual payload length of " + (this.packetBytes.length - 36));
        }
        if (!expectedStatusPacketSizes.contains(this.packetBytes.length)) {
            logger.warn("Processing Mixer Status packets with unexpected lengths " + this.packetBytes.length + ".");
            expectedStatusPacketSizes.add(this.packetBytes.length);
        }
        this.pitch = (int)Util.bytesToNumber(this.packetBytes, 40, 4);
        this.bpm = (int)Util.bytesToNumber(this.packetBytes, 46, 2);
        this.handingMasterToDevice = Util.unsign(this.packetBytes[54]);
    }

    @Override
    public int getBpm() {
        return this.bpm;
    }

    @Override
    public int getBeatWithinBar() {
        return this.packetBytes[55];
    }

    @Override
    public boolean isBeatWithinBarMeaningful() {
        return false;
    }

    @Override
    public int getPitch() {
        return this.pitch;
    }

    @Override
    public boolean isTempoMaster() {
        return (this.packetBytes[39] & 0x20) > 0;
    }

    @Override
    public boolean isSynced() {
        return (this.packetBytes[39] & 0x10) > 0;
    }

    @Override
    public Integer getDeviceMasterIsBeingYieldedTo() {
        if (this.handingMasterToDevice == 255) {
            return null;
        }
        return this.handingMasterToDevice;
    }

    @Override
    public double getEffectiveTempo() {
        return (double)this.bpm * Util.pitchToMultiplier(this.pitch) / 100.0;
    }

    @Override
    public String toString() {
        return "MixerStatus[device:" + this.deviceNumber + ", name:" + this.deviceName + ", address:" + this.address.getHostAddress() + ", timestamp:" + this.timestamp + ", BPM:" + String.format("%.1f", (double)this.bpm / 100.0) + ", beat within bar:" + this.getBeatWithinBar() + ", isBeatWithBarMeaningful? " + this.isBeatWithinBarMeaningful() + ", handingMasterToDevice:" + this.handingMasterToDevice + "]";
    }
}

