/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.deepsymmetry.beatlink.Beat;
import org.deepsymmetry.beatlink.BeatFinder;
import org.deepsymmetry.beatlink.BeatListener;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridFinder;
import org.deepsymmetry.beatlink.data.TrackPositionListener;
import org.deepsymmetry.beatlink.data.TrackPositionUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(TimeFinder.class);
    private final ConcurrentHashMap<Integer, TrackPositionUpdate> positions = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, DeviceUpdate> updates = new ConcurrentHashMap();
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            logger.debug("Currently nothing for TimeFinder to do when devices appear.");
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            logger.info("Clearing position information in response to the loss of a device, {}", (Object)announcement);
            TimeFinder.this.positions.remove(announcement.getNumber());
            TimeFinder.this.updates.remove(announcement.getNumber());
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ConcurrentHashMap<TrackPositionListener, TrackPositionUpdate> trackPositionListeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<TrackPositionListener, Integer> listenerPlayerNumbers = new ConcurrentHashMap();
    private final TrackPositionUpdate NO_INFORMATION = new TrackPositionUpdate(0L, 0L, 0, false, false, 0.0, false, null);
    private final AtomicLong slack = new AtomicLong(50L);
    private final DeviceUpdateListener updateListener = new DeviceUpdateListener(){

        @Override
        public void received(DeviceUpdate update) {
            if (update instanceof CdjStatus) {
                TimeFinder.this.updates.put(update.getDeviceNumber(), update);
                BeatGrid beatGrid = BeatGridFinder.getInstance().getLatestBeatGridFor(update);
                int beatNumber = ((CdjStatus)update).getBeatNumber();
                if (beatGrid != null && beatNumber >= 0) {
                    boolean done = false;
                    TrackPositionUpdate lastPosition = (TrackPositionUpdate)TimeFinder.this.positions.get(update.getDeviceNumber());
                    while (!(done || lastPosition != null && lastPosition.timestamp >= update.getTimestamp())) {
                        TrackPositionUpdate newPosition = lastPosition == null || lastPosition.beatGrid != beatGrid ? new TrackPositionUpdate(update.getTimestamp(), TimeFinder.this.timeOfBeat(beatGrid, beatNumber, update), beatNumber, false, ((CdjStatus)update).isPlaying(), Util.pitchToMultiplier(update.getPitch()), ((CdjStatus)update).isPlayingBackwards(), beatGrid) : new TrackPositionUpdate(update.getTimestamp(), TimeFinder.this.interpolateTimeFromUpdate(lastPosition, (CdjStatus)update, beatGrid), beatNumber, false, ((CdjStatus)update).isPlaying(), Util.pitchToMultiplier(update.getPitch()), ((CdjStatus)update).isPlayingBackwards(), beatGrid);
                        done = lastPosition == null ? TimeFinder.this.positions.putIfAbsent(update.getDeviceNumber(), newPosition) == null : TimeFinder.this.positions.replace(update.getDeviceNumber(), lastPosition, newPosition);
                        if (!done) continue;
                        TimeFinder.this.updateListenersIfNeeded(update.getDeviceNumber(), newPosition);
                    }
                } else {
                    TimeFinder.this.positions.remove(update.getDeviceNumber());
                    TimeFinder.this.updateListenersIfNeeded(update.getDeviceNumber(), null);
                }
            }
        }
    };
    private final BeatListener beatListener = new BeatListener(){

        @Override
        public void newBeat(Beat beat) {
            if (beat.getDeviceNumber() < 16) {
                TimeFinder.this.updates.put(beat.getDeviceNumber(), beat);
                BeatGrid beatGrid = BeatGridFinder.getInstance().getLatestBeatGridFor(beat);
                if (beatGrid != null) {
                    boolean definitive;
                    int beatNumber;
                    TrackPositionUpdate lastPosition = (TrackPositionUpdate)TimeFinder.this.positions.get(beat.getDeviceNumber());
                    if (lastPosition == null || lastPosition.beatGrid != beatGrid) {
                        beatNumber = 1;
                        definitive = false;
                    } else {
                        beatNumber = Math.min(lastPosition.beatNumber + 1, beatGrid.beatCount);
                        definitive = true;
                    }
                    TrackPositionUpdate newPosition = new TrackPositionUpdate(beat.getTimestamp(), TimeFinder.this.timeOfBeat(beatGrid, beatNumber, beat), beatNumber, definitive, true, Util.pitchToMultiplier(beat.getPitch()), false, beatGrid);
                    TimeFinder.this.positions.put(beat.getDeviceNumber(), newPosition);
                    TimeFinder.this.updateListenersIfNeeded(beat.getDeviceNumber(), newPosition);
                } else {
                    TimeFinder.this.positions.remove(beat.getDeviceNumber());
                    TimeFinder.this.updateListenersIfNeeded(beat.getDeviceNumber(), null);
                }
            }
        }
    };
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("The TimeFinder does not auto-start when {} does.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (TimeFinder.this.isRunning()) {
                logger.info("TimeFinder stopping because {} has.", (Object)sender);
                TimeFinder.this.stop();
            }
        }
    };
    private static final TimeFinder ourInstance = new TimeFinder();

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    public Map<Integer, TrackPositionUpdate> getLatestPositions() {
        this.ensureRunning();
        return Collections.unmodifiableMap(new HashMap<Integer, TrackPositionUpdate>(this.positions));
    }

    public Map<Integer, DeviceUpdate> getLatestUpdates() {
        this.ensureRunning();
        return Collections.unmodifiableMap(new HashMap<Integer, DeviceUpdate>(this.updates));
    }

    public TrackPositionUpdate getLatestPositionFor(int player) {
        this.ensureRunning();
        return this.positions.get(player);
    }

    public TrackPositionUpdate getLatestPositionFor(DeviceUpdate update) {
        return this.getLatestPositionFor(update.getDeviceNumber());
    }

    public DeviceUpdate getLatestUpdateFor(int player) {
        this.ensureRunning();
        return this.updates.get(player);
    }

    private long interpolateTimeSinceUpdate(TrackPositionUpdate update, long currentTimestamp) {
        if (!update.playing) {
            return update.milliseconds;
        }
        long elapsedMillis = (currentTimestamp - update.timestamp) / 1000000L;
        long moved = Math.round(update.pitch * (double)elapsedMillis);
        if (update.reverse) {
            return update.milliseconds - moved;
        }
        return update.milliseconds + moved;
    }

    private long interpolateTimeFromUpdate(TrackPositionUpdate lastTrackUpdate, CdjStatus newDeviceUpdate, BeatGrid beatGrid) {
        long interpolated;
        int beatNumber = newDeviceUpdate.getBeatNumber();
        if (!lastTrackUpdate.playing) {
            if (lastTrackUpdate.beatNumber == beatNumber) {
                return lastTrackUpdate.milliseconds;
            }
            if (beatNumber < 0) {
                return -1L;
            }
            return this.timeOfBeat(beatGrid, beatNumber, newDeviceUpdate);
        }
        long elapsedMillis = (newDeviceUpdate.getTimestamp() - lastTrackUpdate.timestamp) / 1000000L;
        long moved = Math.round(lastTrackUpdate.pitch * (double)elapsedMillis);
        long l = interpolated = lastTrackUpdate.reverse ? lastTrackUpdate.milliseconds - moved : lastTrackUpdate.milliseconds + moved;
        if (Math.abs(beatGrid.findBeatAtTime(interpolated) - beatNumber) < 2) {
            return interpolated;
        }
        if (newDeviceUpdate.isPlayingForwards()) {
            return this.timeOfBeat(beatGrid, beatNumber, newDeviceUpdate);
        }
        return beatGrid.getTimeWithinTrack(Math.min(beatNumber + 1, beatGrid.beatCount));
    }

    public long getTimeFor(int player) {
        TrackPositionUpdate update = this.positions.get(player);
        if (update != null) {
            return this.interpolateTimeSinceUpdate(update, System.nanoTime());
        }
        return -1L;
    }

    public long getTimeFor(DeviceUpdate update) {
        return this.getTimeFor(update.getDeviceNumber());
    }

    public void addTrackPositionListener(int player, TrackPositionListener listener) {
        this.listenerPlayerNumbers.put(listener, player);
        TrackPositionUpdate currentPosition = this.positions.get(player);
        if (currentPosition != null) {
            listener.movementChanged(currentPosition);
            this.trackPositionListeners.put(listener, currentPosition);
        } else {
            this.trackPositionListeners.put(listener, this.NO_INFORMATION);
        }
    }

    public void removeTrackPositionListener(TrackPositionListener listener) {
        this.trackPositionListeners.remove(listener);
        this.listenerPlayerNumbers.remove(listener);
    }

    public long getSlack() {
        return this.slack.get();
    }

    public void setSlack(long slack) {
        this.slack.set(slack);
    }

    private boolean interpolationsDisagree(TrackPositionUpdate lastUpdate, TrackPositionUpdate currentUpdate) {
        long now = System.nanoTime();
        return Math.abs(this.interpolateTimeSinceUpdate(lastUpdate, now) - this.interpolateTimeSinceUpdate(currentUpdate, now)) > this.slack.get();
    }

    private void updateListenersIfNeeded(int player, TrackPositionUpdate update) {
        for (Map.Entry<TrackPositionListener, TrackPositionUpdate> entry : new HashMap<TrackPositionListener, TrackPositionUpdate>(this.trackPositionListeners).entrySet()) {
            if (player != this.listenerPlayerNumbers.get(entry.getKey())) continue;
            if (update == null) {
                if (entry.getValue() == this.NO_INFORMATION || !this.trackPositionListeners.replace(entry.getKey(), entry.getValue(), this.NO_INFORMATION)) continue;
                try {
                    entry.getKey().movementChanged(null);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering null movementChanged update", t);
                }
                continue;
            }
            TrackPositionUpdate lastUpdate = entry.getValue();
            if (lastUpdate != this.NO_INFORMATION && lastUpdate.playing == update.playing && !(Math.abs(lastUpdate.pitch - update.pitch) > 1.0E-6) && !this.interpolationsDisagree(lastUpdate, update) || !this.trackPositionListeners.replace(entry.getKey(), entry.getValue(), update)) continue;
            try {
                entry.getKey().movementChanged(update);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering movementChanged update", t);
            }
        }
    }

    private long timeOfBeat(BeatGrid beatGrid, int beatNumber, DeviceUpdate update) {
        if (beatNumber <= beatGrid.beatCount) {
            return beatGrid.getTimeWithinTrack(beatNumber);
        }
        logger.warn("Received beat number " + beatNumber + " from " + update.getDeviceName() + " " + update.getDeviceNumber() + ", but beat grid only goes up to beat " + beatGrid.beatCount + ". Packet: " + update);
        if (beatGrid.beatCount < 2) {
            return beatGrid.getTimeWithinTrack(1);
        }
        long lastTime = beatGrid.getTimeWithinTrack(beatGrid.beatCount);
        long lastInterval = lastTime - beatGrid.getTimeWithinTrack(beatGrid.beatCount - 1);
        return lastTime + lastInterval * (long)(beatNumber - beatGrid.beatCount);
    }

    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            BeatGridFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            BeatGridFinder.getInstance().start();
            VirtualCdj.getInstance().addUpdateListener(this.updateListener);
            VirtualCdj.getInstance().addLifecycleListener(this.lifecycleListener);
            VirtualCdj.getInstance().start();
            BeatFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            BeatFinder.getInstance().addBeatListener(this.beatListener);
            BeatFinder.getInstance().start();
            this.running.set(true);
            this.deliverLifecycleAnnouncement(logger, true);
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            BeatFinder.getInstance().removeBeatListener(this.beatListener);
            VirtualCdj.getInstance().removeUpdateListener(this.updateListener);
            this.running.set(false);
            this.positions.clear();
            this.updates.clear();
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    public static TimeFinder getInstance() {
        return ourInstance;
    }

    private TimeFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TimeFinder[running:").append(this.isRunning());
        if (this.isRunning()) {
            sb.append(", latestPositions:").append(this.getLatestPositions());
            sb.append(", latestUpdates:").append(this.getLatestUpdates());
        }
        return sb.append("]").toString();
    }
}

