/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridFinder;
import org.deepsymmetry.beatlink.data.BeatGridListener;
import org.deepsymmetry.beatlink.data.BeatGridUpdate;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.TimeFinder;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformDetailComponent;
import org.deepsymmetry.beatlink.data.WaveformDetailUpdate;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformListener;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.beatlink.data.WaveformPreviewUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveformPreviewComponent
extends JComponent {
    private static final Logger logger = LoggerFactory.getLogger(WaveformPreviewComponent.class);
    private static final int CUE_MARKER_TOP = 4;
    private static final int CUE_MARKER_HEIGHT = 4;
    private static final int POSITION_MARKER_TOP = 8;
    private static final int WAVEFORM_TOP = 10;
    private static final int WAVEFORM_HEIGHT = 31;
    private static final int PLAYBACK_BAR_TOP = 44;
    private static final int PLAYBACK_BAR_HEIGHT = 4;
    private static final int MINUTE_MARKER_TOP = 51;
    private static final int MINUTE_MARKER_HEIGHT = 4;
    private static final int POSITION_MARKER_HEIGHT = 42;
    private static final int VIEW_HEIGHT = 56;
    private static final int WAVEFORM_MARGIN = 4;
    public static final Color INTENSE_COLOR = new Color(116, 246, 244);
    public static final Color NORMAL_COLOR = new Color(43, 89, 255);
    public static final Color BRIGHT_PLAYED = new Color(75, 75, 75);
    public static final Color DIM_PLAYED = new Color(35, 35, 35);
    public static final Color DIM_UNPLAYED = new Color(170, 170, 170);
    private final AtomicInteger monitoredPlayer = new AtomicInteger(0);
    private final AtomicReference<WaveformPreview> preview = new AtomicReference();
    private final AtomicLong playbackPosition = new AtomicLong(0L);
    private final AtomicBoolean playing = new AtomicBoolean(false);
    private final AtomicReference<TrackMetadata> metadata = new AtomicReference();
    private final AtomicReference<BeatGrid> beatGrid = new AtomicReference();
    private final AtomicBoolean animating = new AtomicBoolean(false);
    private final TrackMetadataListener metadataListener = new TrackMetadataListener(){

        @Override
        public void metadataChanged(TrackMetadataUpdate update) {
            if (update.player == WaveformPreviewComponent.this.monitoredPlayer.get()) {
                WaveformPreviewComponent.this.metadata.set(update.metadata);
                WaveformPreviewComponent.this.repaint();
            }
        }
    };
    private final WaveformListener waveformListener = new WaveformListener(){

        @Override
        public void previewChanged(WaveformPreviewUpdate update) {
            if (update.player == WaveformPreviewComponent.this.monitoredPlayer.get()) {
                WaveformPreviewComponent.this.preview.set(update.preview);
                WaveformPreviewComponent.this.repaint();
            }
        }

        @Override
        public void detailChanged(WaveformDetailUpdate update) {
        }
    };
    private final BeatGridListener beatGridListener = new BeatGridListener(){

        @Override
        public void beatGridChanged(BeatGridUpdate update) {
            if (update.player == WaveformPreviewComponent.this.monitoredPlayer.get()) {
                WaveformPreviewComponent.this.beatGrid.set(update.beatGrid);
                WaveformPreviewComponent.this.repaint();
            }
        }
    };
    private final DeviceUpdateListener updateListener = new DeviceUpdateListener(){

        @Override
        public void received(DeviceUpdate update) {
            if (update instanceof CdjStatus && update.getDeviceNumber() == WaveformPreviewComponent.this.monitoredPlayer.get() && WaveformPreviewComponent.this.metadata.get() != null && WaveformPreviewComponent.this.beatGrid.get() != null) {
                CdjStatus status = (CdjStatus)update;
                WaveformPreviewComponent.this.setPlaying(status.isPlaying());
            }
        }
    };

    public void setPlaybackPosition(long milliseconds) {
        if (this.metadata.get() != null && this.playbackPosition.get() != milliseconds) {
            int right;
            int left;
            if (milliseconds > this.playbackPosition.get()) {
                left = Math.max(0, Math.min(408, this.millisecondsToX(this.playbackPosition.get()) - 6));
                right = Math.max(0, Math.min(408, this.millisecondsToX(milliseconds) + 6));
            } else {
                left = Math.max(0, Math.min(408, this.millisecondsToX(milliseconds) - 6));
                right = Math.max(0, Math.min(408, this.millisecondsToX(this.playbackPosition.get()) + 6));
            }
            this.playbackPosition.set(milliseconds);
            this.repaint(left, 0, right - left, 56);
        } else {
            this.playbackPosition.set(milliseconds);
        }
    }

    public void setPlaying(boolean playing) {
        boolean oldValue = this.playing.getAndSet(playing);
        if (this.metadata.get() != null && oldValue != playing) {
            int left = Math.max(0, Math.min(408, this.millisecondsToX(this.playbackPosition.get()) - 2));
            this.repaint(left, 0, 4, 56);
        }
    }

    public void setWaveformPreview(WaveformPreview preview, TrackMetadata metadata) {
        this.preview.set(preview);
        this.metadata.set(metadata);
        this.playbackPosition.set(0L);
        this.repaint();
    }

    public synchronized void setMonitoredPlayer(int player) {
        if (player < 0) {
            throw new IllegalArgumentException("player cannot be negative");
        }
        this.monitoredPlayer.set(player);
        if (player > 0) {
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            if (MetadataFinder.getInstance().isRunning()) {
                this.metadata.set(MetadataFinder.getInstance().getLatestMetadataFor(player));
            } else {
                this.metadata.set(null);
            }
            WaveformFinder.getInstance().addWaveformListener(this.waveformListener);
            if (WaveformFinder.getInstance().isRunning()) {
                this.preview.set(WaveformFinder.getInstance().getLatestPreviewFor(player));
            } else {
                this.preview.set(null);
            }
            BeatGridFinder.getInstance().addBeatGridListener(this.beatGridListener);
            if (BeatGridFinder.getInstance().isRunning()) {
                this.beatGrid.set(BeatGridFinder.getInstance().getLatestBeatGridFor(player));
            } else {
                this.beatGrid.set(null);
            }
            VirtualCdj.getInstance().addUpdateListener(this.updateListener);
            try {
                TimeFinder.getInstance().start();
                if (!this.animating.getAndSet(true)) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (WaveformPreviewComponent.this.animating.get()) {
                                try {
                                    Thread.sleep(33L);
                                }
                                catch (InterruptedException e) {
                                    logger.warn("Waveform animation thread interrupted; ending");
                                    WaveformPreviewComponent.this.animating.set(false);
                                }
                                WaveformPreviewComponent.this.setPlaybackPosition(TimeFinder.getInstance().getTimeFor(WaveformPreviewComponent.this.monitoredPlayer.get()));
                            }
                        }
                    }).start();
                }
            }
            catch (Exception e) {
                logger.error("Unable to start the TimeFinder to animate the waveform preview");
                this.animating.set(false);
            }
        } else {
            this.animating.set(false);
            VirtualCdj.getInstance().removeUpdateListener(this.updateListener);
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            WaveformFinder.getInstance().removeWaveformListener(this.waveformListener);
            this.metadata.set(null);
            this.preview.set(null);
            this.beatGrid.set(null);
        }
        this.repaint();
    }

    public WaveformPreviewComponent(int player) {
        this.setMonitoredPlayer(player);
    }

    public WaveformPreviewComponent(WaveformPreview preview, TrackMetadata metadata) {
        this.preview.set(preview);
        this.metadata.set(metadata);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(408, 56);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private int millisecondsToX(long milliseconds) {
        long duration = this.metadata.get().getDuration();
        if (duration < 1L) {
            return 0;
        }
        long result = milliseconds * 4L / (long)(this.metadata.get().getDuration() * 10);
        return 4 + Math.max(0, Math.min(400, (int)result));
    }

    @Override
    protected synchronized void paintComponent(Graphics g) {
        int x;
        Rectangle clipRect = g.getClipBounds();
        g.setColor(Color.BLACK);
        g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        ByteBuffer waveBytes = this.preview.get() == null ? null : this.preview.get().getData();
        for (x = clipRect.x; x <= clipRect.x + clipRect.width; ++x) {
            int segment = x - 4;
            if (segment < 0 || segment >= 400) continue;
            if (waveBytes != null) {
                int height = waveBytes.get(segment * 2) & 0x1F;
                int intensity = waveBytes.get(segment * 2 + 1) & 7;
                g.setColor(intensity >= 5 ? INTENSE_COLOR : NORMAL_COLOR);
                g.drawLine(x, 41, x, 41 - height);
            }
            if (this.metadata.get() == null) continue;
            if (x < this.millisecondsToX(this.playbackPosition.get()) - 1) {
                g.setColor(x % 2 == 0 ? BRIGHT_PLAYED : DIM_PLAYED);
                if (x == 4) {
                    g.drawLine(x, 44, x, 48);
                    continue;
                }
                g.drawLine(x, 44, x, 44);
                g.drawLine(x, 48, x, 48);
                continue;
            }
            if (x <= this.millisecondsToX(this.playbackPosition.get()) + 1) continue;
            g.setColor(x % 2 == 0 ? Color.WHITE : DIM_UNPLAYED);
            g.drawLine(x, 44, x, 48);
        }
        if (this.metadata.get() != null) {
            g.setColor(Color.WHITE);
            for (int time = 60; time < this.metadata.get().getDuration(); time += 60) {
                int x2 = this.millisecondsToX(time * 1000);
                g.drawLine(x2, 51, x2, 55);
            }
            x = this.millisecondsToX(this.playbackPosition.get());
            if (!this.playing.get()) {
                g.setColor(Color.RED);
            }
            g.fillRect(x - 1, 8, 2, 42);
        }
        if (this.metadata.get() != null && this.metadata.get().getCueList() != null) {
            for (CueList.Entry entry : this.metadata.get().getCueList().entries) {
                int x3 = this.millisecondsToX(entry.cueTime);
                if (x3 <= clipRect.x - 4 || x3 >= clipRect.x + clipRect.width + 4) continue;
                g.setColor(WaveformDetailComponent.cueColor(entry));
                for (int i = 0; i < 4; ++i) {
                    g.drawLine(x3 - 3 + i, 4 + i, x3 + 3 - i, 4 + i);
                }
            }
        }
    }

    @Override
    public String toString() {
        return "WaveformPreviewComponent[metadata=" + this.metadata.get() + ", waveformPreview=" + this.preview.get() + ", beatGrid=" + this.beatGrid.get() + ", playbackPosition=" + this.playbackPosition.get() + ", playing=" + this.playing.get() + ", monitoredPlayer=" + this.monitoredPlayer.get() + "]";
    }
}

