/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Message;

public class BeatGrid {
    public final DataReference dataReference;
    private final ByteBuffer rawData;
    public final int beatCount;
    private final int[] beatWithinBarValues;
    private final long[] timeWithinTrackValues;

    public ByteBuffer getRawData() {
        if (this.rawData != null) {
            this.rawData.rewind();
            return this.rawData.slice();
        }
        return null;
    }

    public BeatGrid(DataReference reference, Message message) {
        this(reference, ((BinaryField)message.arguments.get(3)).getValue());
    }

    public BeatGrid(DataReference reference, ByteBuffer buffer) {
        this.dataReference = reference;
        this.rawData = buffer;
        byte[] gridBytes = new byte[this.rawData.remaining()];
        this.rawData.get(gridBytes);
        this.beatCount = Math.max(0, (gridBytes.length - 20) / 16);
        this.beatWithinBarValues = new int[this.beatCount];
        this.timeWithinTrackValues = new long[this.beatCount];
        for (int beatNumber = 0; beatNumber < this.beatCount; ++beatNumber) {
            int base = 20 + beatNumber * 16;
            this.beatWithinBarValues[beatNumber] = Util.unsign(gridBytes[base]);
            this.timeWithinTrackValues[beatNumber] = Util.bytesToNumberLittleEndian(gridBytes, base + 4, 4);
        }
    }

    private int beatOffset(int beatNumber) {
        if (this.beatCount == 0) {
            throw new IllegalStateException("There are no beats in this beat grid.");
        }
        if (beatNumber < 1 || beatNumber > this.beatCount) {
            throw new IndexOutOfBoundsException("beatNumber (" + beatNumber + ") must be between 1 and " + this.beatCount);
        }
        return beatNumber - 1;
    }

    public long getTimeWithinTrack(int beatNumber) {
        if (beatNumber == 0) {
            return 0L;
        }
        return this.timeWithinTrackValues[this.beatOffset(beatNumber)];
    }

    public int getBeatWithinBar(int beatNumber) {
        return this.beatWithinBarValues[this.beatOffset(beatNumber)];
    }

    public int findBeatAtTime(long milliseconds) {
        int found = Arrays.binarySearch(this.timeWithinTrackValues, milliseconds);
        if (found >= 0) {
            return found + 1;
        }
        if (found == -1) {
            return found;
        }
        return -(found + 1);
    }

    public String toString() {
        return "BeatGrid[dataReference:" + this.dataReference + ", beats:" + this.beatCount + "]";
    }
}

