/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridFinder;
import org.deepsymmetry.beatlink.data.BeatGridListener;
import org.deepsymmetry.beatlink.data.BeatGridUpdate;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.TimeFinder;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformDetailUpdate;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformListener;
import org.deepsymmetry.beatlink.data.WaveformPreviewUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveformDetailComponent
extends JComponent {
    private static final Logger logger = LoggerFactory.getLogger(WaveformDetailComponent.class);
    private static final int BEAT_MARKER_HEIGHT = 4;
    private static final int CUE_MARKER_HEIGHT = 4;
    private static final int VERTICAL_MARGIN = 15;
    private static final int PLAYBACK_MARKER_WIDTH = 2;
    private static final Color PLAYBACK_MARKER_PLAYING = new Color(255, 255, 255, 235);
    private static final Color PLAYBACK_MARKER_STOPPED = new Color(255, 0, 0, 235);
    private static final Color LOOP_BACKGROUND = new Color(204, 121, 29);
    private static final Color[] COLOR_MAP = new Color[]{new Color(0, 0, 175), new Color(0, 52, 208), new Color(0, 119, 233), new Color(46, 205, 255), new Color(76, 210, 255), new Color(124, 218, 255), new Color(185, 222, 255), new Color(205, 233, 255)};
    private final AtomicInteger monitoredPlayer = new AtomicInteger(0);
    private final AtomicReference<WaveformDetail> waveform = new AtomicReference();
    private final AtomicLong playbackPosition = new AtomicLong(0L);
    private final AtomicInteger scale = new AtomicInteger(1);
    private final AtomicBoolean playing = new AtomicBoolean(false);
    private final AtomicReference<TrackMetadata> metadata = new AtomicReference();
    private final AtomicReference<BeatGrid> beatGrid = new AtomicReference();
    private final AtomicBoolean animating = new AtomicBoolean(false);
    private final TrackMetadataListener metadataListener = new TrackMetadataListener(){

        @Override
        public void metadataChanged(TrackMetadataUpdate update) {
            if (update.player == WaveformDetailComponent.this.monitoredPlayer.get()) {
                WaveformDetailComponent.this.metadata.set(update.metadata);
                WaveformDetailComponent.this.repaint();
            }
        }
    };
    private final WaveformListener waveformListener = new WaveformListener(){

        @Override
        public void previewChanged(WaveformPreviewUpdate update) {
        }

        @Override
        public void detailChanged(WaveformDetailUpdate update) {
            logger.debug("Got waveform detail update: {}", (Object)update);
            if (update.player == WaveformDetailComponent.this.monitoredPlayer.get()) {
                WaveformDetailComponent.this.waveform.set(update.detail);
                WaveformDetailComponent.this.repaint();
            }
        }
    };
    private final BeatGridListener beatGridListener = new BeatGridListener(){

        @Override
        public void beatGridChanged(BeatGridUpdate update) {
            if (update.player == WaveformDetailComponent.this.monitoredPlayer.get()) {
                WaveformDetailComponent.this.beatGrid.set(update.beatGrid);
                WaveformDetailComponent.this.repaint();
            }
        }
    };
    private final DeviceUpdateListener updateListener = new DeviceUpdateListener(){

        @Override
        public void received(DeviceUpdate update) {
            if (update instanceof CdjStatus && update.getDeviceNumber() == WaveformDetailComponent.this.monitoredPlayer.get() && WaveformDetailComponent.this.metadata.get() != null && WaveformDetailComponent.this.beatGrid.get() != null) {
                CdjStatus status = (CdjStatus)update;
                WaveformDetailComponent.this.setPlaying(status.isPlaying());
            }
        }
    };
    private static final int MAX_BEAT_SCALE = 9;

    public void setPlaybackPosition(long milliseconds) {
        long oldPosition = this.playbackPosition.getAndSet(milliseconds);
        if (oldPosition != milliseconds) {
            this.repaint();
        }
    }

    public void setScale(int scale) {
        if (scale < 1 || scale > 256) {
            throw new IllegalArgumentException("Scale must be between 1 and 256");
        }
        int oldScale = this.scale.getAndSet(scale);
        if (oldScale != scale) {
            this.repaint();
        }
    }

    public void setPlaying(boolean playing) {
        boolean oldValue = this.playing.getAndSet(playing);
        if (this.metadata.get() != null && oldValue != playing) {
            this.repaint(this.getWidth() / 2 - 2, 0, 4, this.getHeight());
        }
    }

    public void setWaveform(WaveformDetail waveform, TrackMetadata metadata, BeatGrid beatGrid) {
        this.waveform.set(waveform);
        this.metadata.set(metadata);
        this.beatGrid.set(beatGrid);
        this.playbackPosition.set(0L);
        this.repaint();
    }

    public synchronized void setMonitoredPlayer(int player) {
        if (player < 0) {
            throw new IllegalArgumentException("player cannot be negative");
        }
        this.monitoredPlayer.set(player);
        if (player > 0) {
            VirtualCdj.getInstance().addUpdateListener(this.updateListener);
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            if (MetadataFinder.getInstance().isRunning()) {
                this.metadata.set(MetadataFinder.getInstance().getLatestMetadataFor(player));
            } else {
                this.metadata.set(null);
            }
            WaveformFinder.getInstance().addWaveformListener(this.waveformListener);
            if (WaveformFinder.getInstance().isRunning() && WaveformFinder.getInstance().isFindingDetails()) {
                this.waveform.set(WaveformFinder.getInstance().getLatestDetailFor(player));
            } else {
                this.waveform.set(null);
            }
            BeatGridFinder.getInstance().addBeatGridListener(this.beatGridListener);
            if (BeatGridFinder.getInstance().isRunning()) {
                this.beatGrid.set(BeatGridFinder.getInstance().getLatestBeatGridFor(player));
            } else {
                this.beatGrid.set(null);
            }
            try {
                TimeFinder.getInstance().start();
                if (!this.animating.getAndSet(true)) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            int lastPosition = WaveformDetailComponent.this.getSegmentForX(0);
                            while (WaveformDetailComponent.this.animating.get()) {
                                try {
                                    Thread.sleep(33L);
                                }
                                catch (InterruptedException e) {
                                    logger.warn("Waveform animation thread interrupted; ending");
                                    WaveformDetailComponent.this.animating.set(false);
                                }
                                WaveformDetailComponent.this.setPlaybackPosition(TimeFinder.getInstance().getTimeFor(WaveformDetailComponent.this.monitoredPlayer.get()));
                                int newPosition = WaveformDetailComponent.this.getSegmentForX(0);
                                if (lastPosition == newPosition) continue;
                                lastPosition = newPosition;
                                WaveformDetailComponent.this.repaint();
                            }
                        }
                    }).start();
                }
            }
            catch (Exception e) {
                logger.error("Unable to start the TimeFinder to animate the waveform detail view");
                this.animating.set(false);
            }
        } else {
            this.animating.set(false);
            VirtualCdj.getInstance().removeUpdateListener(this.updateListener);
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            WaveformFinder.getInstance().removeWaveformListener(this.waveformListener);
            this.metadata.set(null);
            this.waveform.set(null);
            this.beatGrid.set(null);
        }
        this.repaint();
    }

    public WaveformDetailComponent(int player) {
        this.setMonitoredPlayer(player);
    }

    public WaveformDetailComponent(WaveformDetail waveform, TrackMetadata metadata, BeatGrid beatGrid) {
        this.waveform.set(waveform);
        this.metadata.set(metadata);
        this.beatGrid.set(beatGrid);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 92);
    }

    private int getSegmentForX(int x) {
        int playHead = x - this.getWidth() / 2;
        int offset = Util.timeToHalfFrame(this.playbackPosition.get()) / this.scale.get();
        return (playHead + offset) * this.scale.get();
    }

    private int millisecondsToX(long milliseconds) {
        int playHead = this.getWidth() / 2 + 2;
        long offset = milliseconds - this.playbackPosition.get();
        return playHead + Util.timeToHalfFrame(offset) / this.scale.get();
    }

    private int totalSegments(ByteBuffer waveBytes) {
        return waveBytes.remaining() - 19;
    }

    private int segmentHeight(int segment, ByteBuffer waveBytes) {
        int scale = this.scale.get();
        int sum = 0;
        for (int i = segment; i < segment + scale && i < this.totalSegments(waveBytes); ++i) {
            sum += waveBytes.get(i + 19) & 0x1F;
        }
        return sum / scale;
    }

    private Color segmentColor(int segment, ByteBuffer waveBytes) {
        int scale = this.scale.get();
        int sum = 0;
        for (int i = segment; i < segment + scale && i < this.totalSegments(waveBytes); ++i) {
            sum += (waveBytes.get(i + 19) & 0xE0) >> 5;
        }
        return COLOR_MAP[sum / scale];
    }

    public static Color cueColor(CueList.Entry entry) {
        if (entry.hotCueNumber > 0) {
            return Color.GREEN;
        }
        if (entry.isLoop) {
            return Color.ORANGE;
        }
        return Color.RED;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle clipRect = g.getClipBounds();
        g.setColor(Color.BLACK);
        g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        CueList cueList = null;
        if (this.metadata.get() != null) {
            cueList = this.metadata.get().getCueList();
        }
        int axis = this.getHeight() / 2;
        int maxHeight = axis - 15;
        if (cueList != null) {
            g.setColor(LOOP_BACKGROUND);
            for (CueList.Entry entry : cueList.entries) {
                if (!entry.isLoop) continue;
                int start = this.millisecondsToX(entry.cueTime);
                int end = this.millisecondsToX(entry.loopTime);
                g.fillRect(start, axis - maxHeight, end - start, maxHeight * 2);
            }
        }
        ByteBuffer waveBytes = this.waveform.get() == null ? null : this.waveform.get().getData();
        int lastBeat = 0;
        if (this.beatGrid.get() != null) {
            lastBeat = this.beatGrid.get().findBeatAtTime(Util.halfFrameToTime(this.getSegmentForX(clipRect.x - 1)));
        }
        for (int x = clipRect.x; x <= clipRect.x + clipRect.width; ++x) {
            int inBeat;
            int segment = this.getSegmentForX(x);
            if (waveBytes != null && segment >= 0 && segment < this.totalSegments(waveBytes)) {
                g.setColor(this.segmentColor(segment, waveBytes));
                int height = this.segmentHeight(segment, waveBytes) * maxHeight / 31;
                g.drawLine(x, axis - height, x, axis + height);
            }
            if (this.beatGrid.get() == null || (inBeat = this.beatGrid.get().findBeatAtTime(Util.halfFrameToTime(segment))) <= 0 || inBeat == lastBeat) continue;
            int beatWithinBar = this.beatGrid.get().getBeatWithinBar(inBeat);
            if (this.scale.get() <= 9 || beatWithinBar == 1) {
                g.setColor(beatWithinBar == 1 ? Color.RED : Color.WHITE);
                g.drawLine(x, axis - maxHeight - 2 - 4, x, axis - maxHeight - 2);
                g.drawLine(x, axis + maxHeight + 2, x, axis + maxHeight + 4 + 2);
            }
            lastBeat = inBeat;
        }
        if (cueList != null) {
            for (CueList.Entry entry : cueList.entries) {
                int x = this.millisecondsToX(entry.cueTime);
                if (x <= clipRect.x - 4 || x >= clipRect.x + clipRect.width + 4) continue;
                g.setColor(WaveformDetailComponent.cueColor(entry));
                for (int i = 0; i < 4; ++i) {
                    g.drawLine(x - 3 + i, axis - maxHeight - 4 - 4 + i, x + 3 - i, axis - maxHeight - 4 - 4 + i);
                }
            }
        }
        g.setColor(this.playing.get() ? PLAYBACK_MARKER_PLAYING : PLAYBACK_MARKER_STOPPED);
        g.fillRect(this.getWidth() / 2 - 1, 0, 2, this.getHeight());
    }

    @Override
    public String toString() {
        return "WaveformDetailComponent[metadata=" + this.metadata.get() + ", waveform=" + this.waveform.get() + ", beatGrid=" + this.beatGrid.get() + ", playbackPosition=" + this.playbackPosition.get() + ", playing=" + this.playing.get() + ", monitoredPlayer=" + this.monitoredPlayer.get() + "]";
    }
}

