/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.MediaDetailsListener;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.AlbumArt;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataCache;
import org.deepsymmetry.beatlink.data.MetadataCacheListener;
import org.deepsymmetry.beatlink.data.MetadataProvider;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(MetadataFinder.class);
    public static final int MENU_TIMEOUT = 20;
    private final Map<DeckReference, TrackMetadata> hotCache = new ConcurrentHashMap<DeckReference, TrackMetadata>();
    private final LinkedBlockingDeque<CdjStatus> pendingUpdates = new LinkedBlockingDeque(100);
    private final DeviceUpdateListener updateListener = new DeviceUpdateListener(){

        @Override
        public void received(DeviceUpdate update) {
            logger.debug("Received device update {}", (Object)update);
            if (update instanceof CdjStatus && !MetadataFinder.this.pendingUpdates.offerLast((CdjStatus)update)) {
                logger.warn("Discarding CDJ update because our queue is backed up.");
            }
        }
    };
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            logger.info("Processing device found, number:" + announcement.getNumber() + ", name:\"" + announcement.getName() + "\".");
            if ((announcement.getNumber() > 15 && announcement.getNumber() < 32 || announcement.getNumber() > 40) && announcement.getName().startsWith("rekordbox")) {
                logger.info("Recording rekordbox collection mount.");
                MetadataFinder.this.recordMount(SlotReference.getSlotReference(announcement.getNumber(), CdjStatus.TrackSourceSlot.COLLECTION));
            }
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            MetadataFinder.this.clearMetadata(announcement);
            if (announcement.getNumber() < 16) {
                MetadataFinder.this.removeMount(SlotReference.getSlotReference(announcement.getNumber(), CdjStatus.TrackSourceSlot.CD_SLOT));
                MetadataFinder.this.removeMount(SlotReference.getSlotReference(announcement.getNumber(), CdjStatus.TrackSourceSlot.USB_SLOT));
                MetadataFinder.this.removeMount(SlotReference.getSlotReference(announcement.getNumber(), CdjStatus.TrackSourceSlot.SD_SLOT));
                MetadataFinder.this.detachMetadataCache(SlotReference.getSlotReference(announcement.getNumber(), CdjStatus.TrackSourceSlot.USB_SLOT));
                MetadataFinder.this.detachMetadataCache(SlotReference.getSlotReference(announcement.getNumber(), CdjStatus.TrackSourceSlot.SD_SLOT));
            } else if ((announcement.getNumber() > 15 && announcement.getNumber() < 32 || announcement.getNumber() > 40) && announcement.getName().startsWith("rekordbox")) {
                MetadataFinder.this.removeMount(SlotReference.getSlotReference(announcement.getNumber(), CdjStatus.TrackSourceSlot.COLLECTION));
            }
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean passive = new AtomicBoolean(false);
    private Thread queueHandler;
    private final Set<Integer> activeRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<SlotReference, MetadataCache> metadataCacheFiles = new ConcurrentHashMap<SlotReference, MetadataCache>();
    private final Set<File> autoAttachCacheFiles = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger autoAttachProbeCount = new AtomicInteger(5);
    private final Set<SlotReference> mediaMounts = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<SlotReference, MediaDetails> mediaDetails = new ConcurrentHashMap<SlotReference, MediaDetails>();
    private final Set<MountListener> mountListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<MetadataCacheListener> cacheListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<TrackMetadataListener> trackListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, Set<MetadataProvider>> metadataProviders = new ConcurrentHashMap<String, Set<MetadataProvider>>();
    final MetadataProvider allMetadataProviders = new MetadataProvider(){

        @Override
        public List<MediaDetails> supportedMedia() {
            return Collections.emptyList();
        }

        @Override
        public TrackMetadata getTrackMetadata(MediaDetails sourceMedia, DataReference track) {
            TrackMetadata result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getTrackMetadata(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getTrackMetadata(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public AlbumArt getAlbumArt(MediaDetails sourceMedia, DataReference art) {
            AlbumArt result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getAlbumArt(sourceMedia, art);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getAlbumArt(sourceMedia, art);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public BeatGrid getBeatGrid(MediaDetails sourceMedia, DataReference track) {
            BeatGrid result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getBeatGrid(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getBeatGrid(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public CueList getCueList(MediaDetails sourceMedia, DataReference track) {
            CueList result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getCueList(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getCueList(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public WaveformPreview getWaveformPreview(MediaDetails sourceMedia, DataReference track) {
            WaveformPreview result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getWaveformPreview(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getWaveformPreview(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public WaveformDetail getWaveformDetail(MediaDetails sourceMedia, DataReference track) {
            WaveformDetail result;
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(sourceMedia)) {
                result = provider.getWaveformDetail(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            for (MetadataProvider provider : MetadataFinder.this.getMetadataProviders(null)) {
                result = provider.getWaveformDetail(sourceMedia, track);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    };
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("MetadataFinder won't automatically start just because {} has.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (MetadataFinder.this.isRunning()) {
                logger.info("MetadataFinder stopping because {} has.", (Object)sender);
                MetadataFinder.this.stop();
            }
        }
    };
    private static final MetadataFinder ourInstance = new MetadataFinder();

    public TrackMetadata requestMetadataFrom(CdjStatus status) {
        if (status.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.NO_TRACK || status.getRekordboxId() == 0) {
            return null;
        }
        DataReference track = new DataReference(status.getTrackSourcePlayer(), status.getTrackSourceSlot(), status.getRekordboxId());
        return this.requestMetadataFrom(track, status.getTrackType());
    }

    public TrackMetadata requestMetadataFrom(DataReference track, CdjStatus.TrackType trackType) {
        return this.requestMetadataInternal(track, trackType, false);
    }

    private TrackMetadata requestMetadataInternal(final DataReference track, final CdjStatus.TrackType trackType, boolean failIfPassive) {
        TrackMetadata provided;
        MetadataCache cache = this.getMetadataCache(SlotReference.getSlotReference(track));
        if (cache != null && trackType == CdjStatus.TrackType.REKORDBOX) {
            return cache.getTrackMetadata(null, track);
        }
        MediaDetails sourceDetails = this.getMediaDetailsFor(track.getSlotReference());
        if (sourceDetails != null && (provided = this.allMetadataProviders.getTrackMetadata(sourceDetails, track)) != null) {
            return provided;
        }
        if (this.passive.get() && failIfPassive && track.slot != CdjStatus.TrackSourceSlot.COLLECTION) {
            return null;
        }
        ConnectionManager.ClientTask<TrackMetadata> task = new ConnectionManager.ClientTask<TrackMetadata>(){

            @Override
            public TrackMetadata useClient(Client client) throws Exception {
                return MetadataFinder.this.queryMetadata(track, trackType, client);
            }
        };
        try {
            return ConnectionManager.getInstance().invokeWithClientSession(track.player, task, "requesting metadata");
        }
        catch (Exception e) {
            logger.error("Problem requesting metadata, returning null", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TrackMetadata queryMetadata(DataReference track, CdjStatus.TrackType trackType, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                Message.KnownType requestType = trackType == CdjStatus.TrackType.REKORDBOX ? Message.KnownType.REKORDBOX_METADATA_REQ : Message.KnownType.UNANALYZED_METADATA_REQ;
                Message response = client.menuRequestTyped(requestType, Message.MenuIdentifier.MAIN_MENU, track.slot, trackType, new NumberField(track.rekordboxId));
                long count = response.getMenuResultsCount();
                if (count == -1L) {
                    TrackMetadata trackMetadata = null;
                    return trackMetadata;
                }
                List<Message> items = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, track.slot, trackType, response);
                CueList cueList = this.getCueList(track.rekordboxId, track.slot, client);
                TrackMetadata trackMetadata = new TrackMetadata(track, trackType, items, cueList);
                return trackMetadata;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock the player for menu operations");
    }

    CueList getCueList(int rekordboxId, CdjStatus.TrackSourceSlot slot, Client client) throws IOException {
        Message response = client.simpleRequest(Message.KnownType.CUE_LIST_REQ, null, client.buildRMST(Message.MenuIdentifier.DATA, slot), new NumberField(rekordboxId));
        if (response.knownType == Message.KnownType.CUE_LIST) {
            return new CueList(response);
        }
        logger.error("Unexpected response type when requesting cue list: {}", (Object)response);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> getFullTrackList(CdjStatus.TrackSourceSlot slot, Client client, int sortOrder) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                Message response = client.menuRequest(Message.KnownType.TRACK_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slot, new NumberField(sortOrder));
                long count = response.getMenuResultsCount();
                if (count == -1L || count == 0L) {
                    List<Message> list = Collections.emptyList();
                    return list;
                }
                List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, CdjStatus.TrackType.REKORDBOX, response);
                return list;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock the player for menu operations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> getPlaylistItems(CdjStatus.TrackSourceSlot slot, int sortOrder, int playlistOrFolderId, boolean folder, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                Message response = client.menuRequest(Message.KnownType.PLAYLIST_REQ, Message.MenuIdentifier.MAIN_MENU, slot, new NumberField(sortOrder), new NumberField(playlistOrFolderId), new NumberField(folder ? 1L : 0L));
                long count = response.getMenuResultsCount();
                if (count == -1L || count == 0L) {
                    List<Message> list = Collections.emptyList();
                    return list;
                }
                List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, CdjStatus.TrackType.REKORDBOX, response);
                return list;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock player for menu operations.");
    }

    public List<Message> requestPlaylistItemsFrom(int player, final CdjStatus.TrackSourceSlot slot, final int sortOrder, final int playlistOrFolderId, final boolean folder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            @Override
            public List<Message> useClient(Client client) throws Exception {
                return MetadataFinder.this.getPlaylistItems(slot, sortOrder, playlistOrFolderId, folder, client);
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(player, task, "requesting playlist information");
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    public boolean isPassive() {
        return this.passive.get();
    }

    public void setPassive(boolean passive) {
        this.passive.set(passive);
    }

    private void clearDeck(CdjStatus update) {
        if (this.hotCache.remove(DeckReference.getDeckReference(update.getDeviceNumber(), 0)) != null) {
            this.deliverTrackMetadataUpdate(update.getDeviceNumber(), null);
        }
    }

    private void clearMetadata(DeviceAnnouncement announcement) {
        int player = announcement.getNumber();
        for (DeckReference deck : new HashSet<DeckReference>(this.hotCache.keySet())) {
            if (deck.player != player) continue;
            this.hotCache.remove(deck);
            if (deck.hotCue != 0) continue;
            this.deliverTrackMetadataUpdate(player, null);
        }
    }

    private void updateMetadata(CdjStatus update, TrackMetadata data) {
        this.hotCache.put(DeckReference.getDeckReference(update.getDeviceNumber(), 0), data);
        if (data.getCueList() != null) {
            for (CueList.Entry entry : data.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                this.hotCache.put(DeckReference.getDeckReference(update.getDeviceNumber(), entry.hotCueNumber), data);
            }
        }
        this.deliverTrackMetadataUpdate(update.getDeviceNumber(), data);
    }

    public Map<DeckReference, TrackMetadata> getLoadedTracks() {
        this.ensureRunning();
        return Collections.unmodifiableMap(new HashMap<DeckReference, TrackMetadata>(this.hotCache));
    }

    public TrackMetadata getLatestMetadataFor(int player) {
        this.ensureRunning();
        return this.hotCache.get(DeckReference.getDeckReference(player, 0));
    }

    public TrackMetadata getLatestMetadataFor(DeviceUpdate update) {
        return this.getLatestMetadataFor(update.getDeviceNumber());
    }

    public void attachMetadataCache(SlotReference slot, File file) throws IOException {
        this.ensureRunning();
        if (slot.player < 1 || slot.player > 4 || DeviceFinder.getInstance().getLatestAnnouncementFrom(slot.player) == null) {
            throw new IllegalArgumentException("unable to attach metadata cache for player " + slot.player);
        }
        if (slot.slot != CdjStatus.TrackSourceSlot.USB_SLOT && slot.slot != CdjStatus.TrackSourceSlot.SD_SLOT) {
            throw new IllegalArgumentException("unable to attach metadata cache for slot " + (Object)((Object)slot.slot));
        }
        MetadataCache cache = new MetadataCache(file);
        MediaDetails slotDetails = this.getMediaDetailsFor(slot);
        if (cache.sourceMedia != null && slotDetails != null) {
            if (!slotDetails.hashKey().equals(cache.sourceMedia.hashKey())) {
                throw new IllegalArgumentException("Cache was created for different media (" + cache.sourceMedia.hashKey() + ") than is in the slot (" + slotDetails.hashKey() + ").");
            }
            if (slotDetails.hasChanged(cache.sourceMedia)) {
                logger.warn("Media has changed (" + slotDetails + ") since cache was created (" + cache.sourceMedia + "). Attaching anyway as instructed.");
            }
        }
        this.attachMetadataCacheInternal(slot, cache);
    }

    void attachMetadataCacheInternal(SlotReference slot, MetadataCache cache) {
        MetadataCache oldCache = this.metadataCacheFiles.put(slot, cache);
        if (oldCache != null) {
            try {
                oldCache.close();
            }
            catch (IOException e) {
                logger.error("Problem closing previous metadata cache", (Throwable)e);
            }
        }
        this.deliverCacheUpdate(slot, cache);
    }

    public void detachMetadataCache(SlotReference slot) {
        MetadataCache oldCache = this.metadataCacheFiles.remove(slot);
        if (oldCache != null) {
            try {
                oldCache.close();
            }
            catch (IOException e) {
                logger.error("Problem closing metadata cache", (Throwable)e);
            }
            this.deliverCacheUpdate(slot, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAutoAttachCacheFile(File metadataCacheFile) throws IOException {
        MetadataCache opened = new MetadataCache(metadataCacheFile);
        try {
            if (opened.sourceMedia != null) {
                Iterator<File> iterator = this.autoAttachCacheFiles.iterator();
                while (iterator.hasNext()) {
                    File file = iterator.next();
                    if (file.equals(metadataCacheFile)) continue;
                    MetadataCache existing = new MetadataCache(file);
                    try {
                        if (existing.sourceMedia == null || !existing.sourceMedia.hashKey().equals(opened.sourceMedia.hashKey())) continue;
                        iterator.remove();
                    }
                    finally {
                        existing.close();
                    }
                }
            }
        }
        finally {
            opened.close();
        }
        if (this.autoAttachCacheFiles.add(metadataCacheFile)) {
            for (SlotReference slot : this.getMountedMediaSlots()) {
                MetadataCache.tryAutoAttaching(slot);
            }
        }
    }

    public void removeAutoAttacheCacheFile(File metadataCacheFile) {
        this.autoAttachCacheFiles.remove(metadataCacheFile);
    }

    public List<File> getAutoAttachCacheFiles() {
        ArrayList<File> currentFiles = new ArrayList<File>(this.autoAttachCacheFiles);
        Collections.sort(currentFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return Collections.unmodifiableList(currentFiles);
    }

    public void setAutoAttachProbeCount(int numTracks) {
        if (numTracks < 1) {
            throw new IllegalArgumentException("numTracks must be positive");
        }
        this.autoAttachProbeCount.set(numTracks);
    }

    public int getAutoAttachProbeCount() {
        return this.autoAttachProbeCount.get();
    }

    private void flushHotCacheSlot(SlotReference slot) {
        for (Map.Entry<DeckReference, TrackMetadata> entry : new HashMap<DeckReference, TrackMetadata>(this.hotCache).entrySet()) {
            if (slot != SlotReference.getSlotReference(entry.getValue().trackReference)) continue;
            logger.debug("Evicting cached metadata in response to unmount report {}", (Object)entry.getValue());
            this.hotCache.remove(entry.getKey());
        }
    }

    public MetadataCache getMetadataCache(SlotReference slot) {
        return this.metadataCacheFiles.get(slot);
    }

    private void recordMount(SlotReference slot) {
        if (this.mediaMounts.add(slot)) {
            this.deliverMountUpdate(slot, true);
        }
        if (!this.mediaDetails.containsKey(slot)) {
            try {
                VirtualCdj.getInstance().sendMediaQuery(slot);
            }
            catch (Exception e) {
                logger.warn("Problem trying to request media details for " + slot, (Throwable)e);
            }
        }
    }

    private void removeMount(SlotReference slot) {
        this.mediaDetails.remove(slot);
        if (this.mediaMounts.remove(slot)) {
            this.deliverMountUpdate(slot, false);
        }
    }

    public Set<SlotReference> getMountedMediaSlots() {
        return Collections.unmodifiableSet(new HashSet<SlotReference>(this.mediaMounts));
    }

    public Collection<MediaDetails> getMountedMediaDetails() {
        return Collections.unmodifiableCollection(this.mediaDetails.values());
    }

    public MediaDetails getMediaDetailsFor(SlotReference slot) {
        return this.mediaDetails.get(slot);
    }

    public void addMountListener(MountListener listener) {
        if (listener != null) {
            this.mountListeners.add(listener);
        }
    }

    public void removeMountListener(MountListener listener) {
        if (listener != null) {
            this.mountListeners.remove(listener);
        }
    }

    public Set<MountListener> getMountListeners() {
        return Collections.unmodifiableSet(new HashSet<MountListener>(this.mountListeners));
    }

    private void deliverMountUpdate(SlotReference slot, boolean mounted) {
        if (mounted) {
            logger.info("Reporting media mounted in " + slot);
        } else {
            logger.info("Reporting media removed from " + slot);
        }
        for (MountListener listener : this.getMountListeners()) {
            try {
                if (mounted) {
                    listener.mediaMounted(slot);
                    continue;
                }
                listener.mediaUnmounted(slot);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering mount update to listener", t);
            }
        }
        if (mounted) {
            MetadataCache.tryAutoAttaching(slot);
        }
    }

    public void addCacheListener(MetadataCacheListener listener) {
        if (listener != null) {
            this.cacheListeners.add(listener);
        }
    }

    public void removeCacheListener(MetadataCacheListener listener) {
        if (listener != null) {
            this.cacheListeners.remove(listener);
        }
    }

    public Set<MetadataCacheListener> getCacheListeners() {
        return Collections.unmodifiableSet(new HashSet<MetadataCacheListener>(this.cacheListeners));
    }

    private void deliverCacheUpdate(SlotReference slot, MetadataCache cache) {
        for (MetadataCacheListener listener : this.getCacheListeners()) {
            try {
                if (cache == null) {
                    listener.cacheDetached(slot);
                    continue;
                }
                listener.cacheAttached(slot, cache);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering metadata cache update to listener", t);
            }
        }
    }

    public void addTrackMetadataListener(TrackMetadataListener listener) {
        if (listener != null) {
            this.trackListeners.add(listener);
        }
    }

    public void removeTrackMetadataListener(TrackMetadataListener listener) {
        if (listener != null) {
            this.trackListeners.remove(listener);
        }
    }

    public Set<TrackMetadataListener> getTrackMetadataListeners() {
        return Collections.unmodifiableSet(new HashSet<TrackMetadataListener>(this.trackListeners));
    }

    private void deliverTrackMetadataUpdate(int player, TrackMetadata metadata) {
        if (!this.getTrackMetadataListeners().isEmpty()) {
            TrackMetadataUpdate update = new TrackMetadataUpdate(player, metadata);
            for (TrackMetadataListener listener : this.getTrackMetadataListeners()) {
                try {
                    listener.metadataChanged(update);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering track metadata update to listener", t);
                }
            }
        }
    }

    public void addMetadataProvider(MetadataProvider provider) {
        if (provider instanceof MetadataCache) {
            throw new IllegalArgumentException("Do not register MetadataCache instances using addMetadataProvider(), use attachMetadataCache() or addAutoAttachCacheFile() instead.");
        }
        List<MediaDetails> supportedMedia = provider.supportedMedia();
        if (supportedMedia == null || supportedMedia.isEmpty()) {
            this.addMetadataProviderForMedia("", provider);
        } else {
            for (MediaDetails details : supportedMedia) {
                this.addMetadataProviderForMedia(details.hashKey(), provider);
            }
        }
    }

    private void addMetadataProviderForMedia(String key, MetadataProvider provider) {
        if (!this.metadataProviders.containsKey(key)) {
            this.metadataProviders.put(key, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        Set<MetadataProvider> providers = this.metadataProviders.get(key);
        providers.add(provider);
    }

    public void removeMetadataProvider(MetadataProvider provider) {
        for (Set<MetadataProvider> providers : this.metadataProviders.values()) {
            providers.remove(provider);
        }
    }

    public Set<MetadataProvider> getMetadataProviders(MediaDetails sourceMedia) {
        String key = sourceMedia == null ? "" : sourceMedia.hashKey();
        Set<MetadataProvider> result = this.metadataProviders.get(key);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<MetadataProvider>(result));
    }

    private void handleUpdate(final CdjStatus update) {
        SlotReference slot;
        if (update.isLocalUsbEmpty()) {
            slot = SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.USB_SLOT);
            this.detachMetadataCache(slot);
            this.flushHotCacheSlot(slot);
            this.removeMount(slot);
        } else if (update.isLocalUsbLoaded()) {
            this.recordMount(SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.USB_SLOT));
        }
        if (update.isLocalSdEmpty()) {
            slot = SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.SD_SLOT);
            this.detachMetadataCache(slot);
            this.flushHotCacheSlot(slot);
            this.removeMount(slot);
        } else if (update.isLocalSdLoaded()) {
            this.recordMount(SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.SD_SLOT));
        }
        if (update.isDiscSlotEmpty()) {
            this.removeMount(SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.CD_SLOT));
        } else {
            this.recordMount(SlotReference.getSlotReference(update.getDeviceNumber(), CdjStatus.TrackSourceSlot.CD_SLOT));
        }
        if (update.getTrackType() == CdjStatus.TrackType.UNKNOWN || update.getTrackType() == CdjStatus.TrackType.NO_TRACK || update.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.NO_TRACK || update.getTrackSourceSlot() == CdjStatus.TrackSourceSlot.UNKNOWN || update.getRekordboxId() == 0) {
            this.clearDeck(update);
        } else {
            TrackMetadata lastMetadata = this.hotCache.get(DeckReference.getDeckReference(update.getDeviceNumber(), 0));
            final DataReference trackReference = new DataReference(update.getTrackSourcePlayer(), update.getTrackSourceSlot(), update.getRekordboxId());
            if (lastMetadata == null || !lastMetadata.trackReference.equals(trackReference)) {
                for (TrackMetadata cached : this.hotCache.values()) {
                    if (!cached.trackReference.equals(trackReference)) continue;
                    this.updateMetadata(update, cached);
                    return;
                }
                if (this.activeRequests.add(update.getTrackSourcePlayer())) {
                    this.clearDeck(update);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                TrackMetadata data = MetadataFinder.this.requestMetadataInternal(trackReference, update.getTrackType(), true);
                                if (data != null) {
                                    MetadataFinder.this.updateMetadata(update, data);
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Problem requesting track metadata from update" + update, (Throwable)e);
                            }
                            finally {
                                MetadataFinder.this.activeRequests.remove(update.getTrackSourcePlayer());
                            }
                        }
                    }, "MetadataFinder metadata request").start();
                }
            }
        }
    }

    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            ConnectionManager.getInstance().addLifecycleListener(this.lifecycleListener);
            ConnectionManager.getInstance().start();
            DeviceFinder.getInstance().start();
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            VirtualCdj.getInstance().addLifecycleListener(this.lifecycleListener);
            VirtualCdj.getInstance().start();
            VirtualCdj.getInstance().addUpdateListener(this.updateListener);
            this.queueHandler = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (MetadataFinder.this.isRunning()) {
                        try {
                            MetadataFinder.this.handleUpdate((CdjStatus)MetadataFinder.this.pendingUpdates.take());
                        }
                        catch (InterruptedException e) {
                            logger.debug("Interrupted, presumably due to MetadataFinder shutdown.", (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.error("Problem handling CDJ status update.", (Throwable)e);
                        }
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
            for (DeviceAnnouncement existingDevice : DeviceFinder.getInstance().getCurrentDevices()) {
                this.announcementListener.deviceFound(existingDevice);
            }
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            VirtualCdj.getInstance().removeUpdateListener(this.updateListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            final HashSet<DeckReference> dyingCache = new HashSet<DeckReference>(this.hotCache.keySet());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (DeckReference deck : dyingCache) {
                        if (deck.hotCue != 0) continue;
                        MetadataFinder.this.deliverTrackMetadataUpdate(deck.player, null);
                    }
                }
            });
            this.hotCache.clear();
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    public static MetadataFinder getInstance() {
        return ourInstance;
    }

    private MetadataFinder() {
        VirtualCdj.getInstance().addMediaDetailsListener(new MediaDetailsListener(){

            @Override
            public void detailsAvailable(MediaDetails details) {
                MetadataFinder.this.mediaDetails.put(details.slotReference, details);
                if (!MetadataFinder.this.mediaMounts.contains(details.slotReference)) {
                    logger.warn("Discarding media details reported for an unmounted media slot:" + details);
                    MetadataFinder.this.mediaDetails.remove(details.slotReference);
                }
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetadataFinder[").append("running:").append(this.isRunning()).append(", passive:").append(this.isPassive());
        if (this.isRunning()) {
            sb.append(", loadedTracks:").append(this.getLoadedTracks()).append(", mountedMediaSlots:").append(this.getMountedMediaSlots());
            sb.append(", mountedMediaDetails:").append(this.getMountedMediaDetails());
            sb.append(", metadataCacheFiles:").append(this.metadataCacheFiles);
        }
        return sb.append("]").toString();
    }
}

