/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridFinder;
import org.deepsymmetry.beatlink.data.BeatGridListener;
import org.deepsymmetry.beatlink.data.BeatGridUpdate;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.SignatureListener;
import org.deepsymmetry.beatlink.data.SignatureUpdate;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformDetailUpdate;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformListener;
import org.deepsymmetry.beatlink.data.WaveformPreviewUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(SignatureFinder.class);
    private final LinkedBlockingDeque<Integer> pendingUpdates = new LinkedBlockingDeque(20);
    private final Map<Integer, String> signatures = new ConcurrentHashMap<Integer, String>();
    private final TrackMetadataListener metadataListener = new TrackMetadataListener(){

        @Override
        public void metadataChanged(TrackMetadataUpdate update) {
            if (update.metadata == null) {
                SignatureFinder.this.clearSignature(update.player);
            } else {
                SignatureFinder.this.checkIfSignatureReady(update.player);
            }
        }
    };
    private final WaveformListener waveformListener = new WaveformListener(){

        @Override
        public void previewChanged(WaveformPreviewUpdate update) {
        }

        @Override
        public void detailChanged(WaveformDetailUpdate update) {
            if (update.detail == null) {
                SignatureFinder.this.clearSignature(update.player);
            } else {
                SignatureFinder.this.checkIfSignatureReady(update.player);
            }
        }
    };
    private final BeatGridListener beatGridListener = new BeatGridListener(){

        @Override
        public void beatGridChanged(BeatGridUpdate update) {
            if (update.beatGrid == null) {
                SignatureFinder.this.clearSignature(update.player);
            } else {
                SignatureFinder.this.checkIfSignatureReady(update.player);
            }
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread queueHandler;
    private final Set<SignatureListener> signatureListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("The SignatureFinder does not auto-start when {} does.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (SignatureFinder.this.isRunning()) {
                logger.info("SignatureFinder stopping because {} has.", (Object)sender);
                SignatureFinder.this.stop();
            }
        }
    };
    private static final SignatureFinder ourInstance = new SignatureFinder();

    private void clearSignature(int player) {
        if (this.signatures.remove(player) != null) {
            this.deliverSignatureUpdate(player, null);
        }
    }

    private void checkIfSignatureReady(int player) {
        if (!this.pendingUpdates.offerLast(player)) {
            logger.warn("Discarding signature check for player {} because our queue is backed up.", (Object)player);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    public Map<Integer, String> getSignatures() {
        this.ensureRunning();
        return Collections.unmodifiableMap(new HashMap<Integer, String>(this.signatures));
    }

    public String getLatestSignatureFor(int player) {
        this.ensureRunning();
        return this.signatures.get(player);
    }

    public String getLatestSignatureFor(DeviceUpdate update) {
        return this.getLatestSignatureFor(update.getDeviceNumber());
    }

    public void addSignatureListener(SignatureListener listener) {
        if (listener != null) {
            this.signatureListeners.add(listener);
        }
    }

    public void removeSignatureListener(SignatureListener listener) {
        if (listener != null) {
            this.signatureListeners.remove(listener);
        }
    }

    public Set<SignatureListener> getSignatureListeners() {
        return Collections.unmodifiableSet(new HashSet<SignatureListener>(this.signatureListeners));
    }

    private void deliverSignatureUpdate(final int player, final String signature) {
        final Set<SignatureListener> listeners = this.getSignatureListeners();
        if (!listeners.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SignatureUpdate update = new SignatureUpdate(player, signature);
                    for (SignatureListener listener : listeners) {
                        try {
                            listener.signatureChanged(update);
                        }
                        catch (Throwable t) {
                            logger.warn("Problem delivering track signature update to listener", t);
                        }
                    }
                }
            });
        }
    }

    private void checkExistingTracks() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry<DeckReference, TrackMetadata> entry : MetadataFinder.getInstance().getLoadedTracks().entrySet()) {
                    if (entry.getKey().hotCue != 0) continue;
                    SignatureFinder.this.checkIfSignatureReady(entry.getKey().player);
                }
            }
        });
    }

    private void digestInteger(MessageDigest digest, int value) {
        byte[] valueBytes = new byte[4];
        Util.numberToBytes(value, valueBytes, 0, 4);
        digest.update(valueBytes);
    }

    public String computeTrackSignature(String title, String artist, int duration, WaveformDetail waveformDetail, BeatGrid beatGrid) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(title.getBytes("UTF-8"));
            digest.update((byte)0);
            digest.update(artist.getBytes("UTF-8"));
            digest.update((byte)0);
            this.digestInteger(digest, duration);
            digest.update(waveformDetail.getData());
            for (int i = 1; i <= beatGrid.beatCount; ++i) {
                this.digestInteger(digest, beatGrid.getBeatWithinBar(i));
                this.digestInteger(digest, (int)beatGrid.getTimeWithinTrack(i));
            }
            byte[] result = digest.digest();
            StringBuilder hex = new StringBuilder(result.length * 2);
            for (byte aResult : result) {
                hex.append(Integer.toString((aResult & 0xFF) + 256, 16).substring(1));
            }
            return hex.toString();
        }
        catch (NullPointerException e) {
            logger.info("Returning null track signature because an input element was null.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Unable to obtain SHA-1 MessageDigest instance for computing track signatures.", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Unable to work with UTF-8 string encoding for computing track signatures.", (Throwable)e);
        }
        return null;
    }

    private void handleUpdate(int player) {
        String signature;
        TrackMetadata metadata = MetadataFinder.getInstance().getLatestMetadataFor(player);
        WaveformDetail waveformDetail = WaveformFinder.getInstance().getLatestDetailFor(player);
        BeatGrid beatGrid = BeatGridFinder.getInstance().getLatestBeatGridFor(player);
        if (metadata != null && waveformDetail != null && beatGrid != null && (signature = this.computeTrackSignature(metadata.getTitle(), metadata.getArtist().label, metadata.getDuration(), waveformDetail, beatGrid)) != null) {
            this.signatures.put(player, signature);
            this.deliverSignatureUpdate(player, signature);
        }
    }

    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            MetadataFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            MetadataFinder.getInstance().start();
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            WaveformFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            WaveformFinder.getInstance().setFindDetails(true);
            WaveformFinder.getInstance().start();
            WaveformFinder.getInstance().addWaveformListener(this.waveformListener);
            BeatGridFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            BeatGridFinder.getInstance().start();
            BeatGridFinder.getInstance().addBeatGridListener(this.beatGridListener);
            this.queueHandler = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (SignatureFinder.this.isRunning()) {
                        try {
                            SignatureFinder.this.handleUpdate((Integer)SignatureFinder.this.pendingUpdates.take());
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Throwable t) {
                            logger.error("Problem processing track signature update", t);
                        }
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
            this.checkExistingTracks();
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            WaveformFinder.getInstance().removeWaveformListener(this.waveformListener);
            BeatGridFinder.getInstance().removeBeatGridListener(this.beatGridListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            final HashSet<Integer> dyingSignatures = new HashSet<Integer>(this.signatures.keySet());
            this.signatures.clear();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Integer player : dyingSignatures) {
                        SignatureFinder.this.deliverSignatureUpdate(player, null);
                    }
                }
            });
        }
        this.deliverLifecycleAnnouncement(logger, false);
    }

    public static SignatureFinder getInstance() {
        return ourInstance;
    }

    private SignatureFinder() {
    }

    public String toString() {
        return "SignatureFinder[running:" + this.isRunning() + ", signatures:" + this.signatures + "]";
    }
}

