/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(DeviceFinder.class);
    public static final int ANNOUNCEMENT_PORT = 50000;
    public static final int MAXIMUM_AGE = 10000;
    private final AtomicReference<DatagramSocket> socket = new AtomicReference<Object>(null);
    private static final AtomicLong startTime = new AtomicLong();
    private static final AtomicLong firstDeviceTime = new AtomicLong(0L);
    private final Map<InetAddress, DeviceAnnouncement> devices = new ConcurrentHashMap<InetAddress, DeviceAnnouncement>();
    private final Set<InetAddress> ignoredAddresses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<DeviceAnnouncementListener> deviceListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final DeviceFinder ourInstance = new DeviceFinder();

    @Override
    public boolean isRunning() {
        return this.socket.get() != null;
    }

    public long getStartTime() {
        this.ensureRunning();
        return startTime.get();
    }

    public long getFirstDeviceTime() {
        this.ensureRunning();
        long result = firstDeviceTime.get();
        if (result == 0L) {
            throw new IllegalStateException("No device announcements have yet been seen");
        }
        return result;
    }

    private void expireDevices() {
        long now = System.currentTimeMillis();
        HashMap<InetAddress, DeviceAnnouncement> copy = new HashMap<InetAddress, DeviceAnnouncement>(this.devices);
        for (Map.Entry entry : copy.entrySet()) {
            if (now - ((DeviceAnnouncement)entry.getValue()).getTimestamp() <= 10000L) continue;
            this.devices.remove(entry.getKey());
            this.deliverLostAnnouncement((DeviceAnnouncement)entry.getValue());
        }
        if (this.devices.isEmpty()) {
            firstDeviceTime.set(0L);
        }
    }

    private void updateDevices(DeviceAnnouncement announcement) {
        firstDeviceTime.compareAndSet(0L, System.currentTimeMillis());
        this.devices.put(announcement.getAddress(), announcement);
    }

    private boolean isDeviceNew(DeviceAnnouncement announcement) {
        return !this.devices.containsKey(announcement.getAddress());
    }

    public void addIgnoredAddress(InetAddress address) {
        this.ignoredAddresses.add(address);
    }

    public void removeIgnoredAddress(InetAddress address) {
        this.ignoredAddresses.remove(address);
    }

    public boolean isAddressIgnored(InetAddress address) {
        return this.ignoredAddresses.contains(address);
    }

    public synchronized void start() throws SocketException {
        if (!this.isRunning()) {
            this.socket.set(new DatagramSocket(50000));
            startTime.set(System.currentTimeMillis());
            this.deliverLifecycleAnnouncement(logger, true);
            byte[] buffer = new byte[512];
            final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            Thread receiver = new Thread(null, new Runnable(){

                @Override
                public void run() {
                    while (DeviceFinder.this.isRunning()) {
                        boolean received;
                        try {
                            if (DeviceFinder.this.getCurrentDevices().isEmpty()) {
                                ((DatagramSocket)DeviceFinder.this.socket.get()).setSoTimeout(60000);
                            } else {
                                ((DatagramSocket)DeviceFinder.this.socket.get()).setSoTimeout(1000);
                            }
                            ((DatagramSocket)DeviceFinder.this.socket.get()).receive(packet);
                            received = !DeviceFinder.this.ignoredAddresses.contains(packet.getAddress());
                        }
                        catch (SocketTimeoutException ste) {
                            received = false;
                        }
                        catch (IOException e) {
                            if (DeviceFinder.this.isRunning()) {
                                logger.warn("Problem reading from DeviceAnnouncement socket, stopping", (Throwable)e);
                                DeviceFinder.this.stop();
                            }
                            received = false;
                        }
                        try {
                            Util.PacketType kind;
                            if (received && packet.getLength() == 54 && (kind = Util.validateHeader(packet, 50000)) == Util.PacketType.DEVICE_KEEP_ALIVE) {
                                if (packet.getLength() < 54) {
                                    logger.warn("Ignoring too-short " + kind.name + " packet; expected 54 bytes, but only got " + packet.getLength() + ".");
                                } else {
                                    if (packet.getLength() > 54) {
                                        logger.warn("Processing too-long " + kind.name + " packet; expected 54 bytes, but got " + packet.getLength() + ".");
                                    }
                                    DeviceAnnouncement announcement = new DeviceAnnouncement(packet);
                                    boolean foundNewDevice = DeviceFinder.this.isDeviceNew(announcement);
                                    DeviceFinder.this.updateDevices(announcement);
                                    if (foundNewDevice) {
                                        DeviceFinder.this.deliverFoundAnnouncement(announcement);
                                    }
                                }
                            }
                            DeviceFinder.this.expireDevices();
                        }
                        catch (Throwable t) {
                            logger.warn("Problem processing DeviceAnnouncement packet", t);
                        }
                    }
                }
            }, "beat-link DeviceFinder receiver");
            receiver.setDaemon(true);
            receiver.start();
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            final Set<DeviceAnnouncement> lastDevices = this.getCurrentDevices();
            this.socket.get().close();
            this.socket.set(null);
            this.devices.clear();
            firstDeviceTime.set(0L);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (DeviceAnnouncement announcement : lastDevices) {
                        DeviceFinder.this.deliverLostAnnouncement(announcement);
                    }
                }
            });
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    public Set<DeviceAnnouncement> getCurrentDevices() {
        if (!this.isRunning()) {
            throw new IllegalStateException("DeviceFinder is not active");
        }
        this.expireDevices();
        return Collections.unmodifiableSet(new HashSet<DeviceAnnouncement>(this.devices.values()));
    }

    public DeviceAnnouncement getLatestAnnouncementFrom(int deviceNumber) {
        this.ensureRunning();
        for (DeviceAnnouncement announcement : this.getCurrentDevices()) {
            if (announcement.getNumber() != deviceNumber) continue;
            return announcement;
        }
        return null;
    }

    public void addDeviceAnnouncementListener(DeviceAnnouncementListener listener) {
        if (listener != null) {
            this.deviceListeners.add(listener);
        }
    }

    public void removeDeviceAnnouncementListener(DeviceAnnouncementListener listener) {
        if (listener != null) {
            this.deviceListeners.remove(listener);
        }
    }

    public Set<DeviceAnnouncementListener> getDeviceAnnouncementListeners() {
        return Collections.unmodifiableSet(new HashSet<DeviceAnnouncementListener>(this.deviceListeners));
    }

    private void deliverFoundAnnouncement(final DeviceAnnouncement announcement) {
        for (final DeviceAnnouncementListener listener : this.getDeviceAnnouncementListeners()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.deviceFound(announcement);
                    }
                    catch (Throwable t) {
                        logger.warn("Problem delivering device found announcement to listener", t);
                    }
                }
            });
        }
    }

    private void deliverLostAnnouncement(final DeviceAnnouncement announcement) {
        for (final DeviceAnnouncementListener listener : this.getDeviceAnnouncementListeners()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.deviceLost(announcement);
                    }
                    catch (Throwable t) {
                        logger.warn("Problem delivering device lost announcement to listener", t);
                    }
                }
            });
        }
    }

    public static DeviceFinder getInstance() {
        return ourInstance;
    }

    private DeviceFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DeviceFinder[active:").append(this.isRunning());
        if (this.isRunning()) {
            sb.append(", startTime:").append(this.getStartTime()).append(", firstDeviceTime:").append(this.getFirstDeviceTime());
            sb.append(", currentDevices:").append(this.getCurrentDevices());
        }
        return sb.append("]").toString();
    }
}

