/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.deepsymmetry.beatlink.data.DataReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlbumArt {
    private static final Logger logger = LoggerFactory.getLogger(AlbumArt.class);
    public final DataReference artReference;
    private final ByteBuffer rawBytes;

    public ByteBuffer getRawBytes() {
        this.rawBytes.rewind();
        return this.rawBytes.slice();
    }

    public BufferedImage getImage() {
        ByteBuffer artwork = this.getRawBytes();
        artwork.rewind();
        byte[] imageBytes = new byte[artwork.remaining()];
        artwork.get(imageBytes);
        try {
            return ImageIO.read(new ByteArrayInputStream(imageBytes));
        }
        catch (IOException e) {
            logger.error("Weird! Caught exception creating image from artwork bytes", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlbumArt(DataReference artReference, File file) throws IOException {
        this.artReference = artReference;
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            byte[] bytes = new byte[(int)raf.length()];
            raf.readFully(bytes);
            this.rawBytes = ByteBuffer.wrap(bytes);
        }
        finally {
            raf.close();
        }
    }

    public AlbumArt(DataReference artReference, ByteBuffer rawBytes) {
        this.artReference = artReference;
        byte[] bytes = new byte[rawBytes.remaining()];
        rawBytes.get(bytes);
        this.rawBytes = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
    }

    public String toString() {
        return "AlbumArt[artReference=" + this.artReference + ", size=" + this.getRawBytes().remaining() + " bytes]";
    }
}

