/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;

public class CueList {
    public final Message rawMessage;
    public final List<ByteBuffer> rawTags;
    public final List<Entry> entries;

    public int getHotCueCount() {
        if (this.rawMessage != null) {
            return (int)((NumberField)this.rawMessage.arguments.get(5)).getValue();
        }
        int total = 0;
        for (Entry entry : this.entries) {
            if (entry.hotCueNumber <= 0) continue;
            ++total;
        }
        return total;
    }

    public int getMemoryPointCount() {
        if (this.rawMessage != null) {
            return (int)((NumberField)this.rawMessage.arguments.get(6)).getValue();
        }
        int total = 0;
        for (Entry entry : this.entries) {
            if (entry.hotCueNumber != 0) continue;
            ++total;
        }
        return total;
    }

    private List<Entry> sortEntries(List<Entry> loadedEntries) {
        Collections.sort(loadedEntries, new Comparator<Entry>(){

            @Override
            public int compare(Entry entry1, Entry entry2) {
                int result = (int)(entry1.cuePosition - entry2.cuePosition);
                if (result == 0) {
                    int h1 = entry1.hotCueNumber != 0 ? 1 : 0;
                    int h2 = entry2.hotCueNumber != 0 ? 1 : 0;
                    result = h1 - h2;
                }
                return result;
            }
        });
        return Collections.unmodifiableList(loadedEntries);
    }

    private void addEntriesFromTag(List<Entry> entries, RekordboxAnlz.CueTag tag) {
        for (RekordboxAnlz.CueEntry cueEntry : tag.cues()) {
            if (cueEntry.type() == RekordboxAnlz.CueEntryType.LOOP) {
                entries.add(new Entry((int)cueEntry.hotCue(), Util.timeToHalfFrame(cueEntry.time()), Util.timeToHalfFrame(cueEntry.loopTime())));
                continue;
            }
            entries.add(new Entry((int)cueEntry.hotCue(), Util.timeToHalfFrame(cueEntry.time())));
        }
    }

    public CueList(RekordboxAnlz anlzFile) {
        this.rawMessage = null;
        ArrayList<ByteBuffer> tagBuffers = new ArrayList<ByteBuffer>(2);
        ArrayList<Entry> mutableEntries = new ArrayList<Entry>();
        for (RekordboxAnlz.TaggedSection section : anlzFile.sections()) {
            if (!(section.body() instanceof RekordboxAnlz.CueTag)) continue;
            RekordboxAnlz.CueTag tag = (RekordboxAnlz.CueTag)section.body();
            tagBuffers.add(ByteBuffer.wrap(section._raw_body()).asReadOnlyBuffer());
            this.addEntriesFromTag(mutableEntries, tag);
        }
        this.entries = this.sortEntries(mutableEntries);
        this.rawTags = Collections.unmodifiableList(tagBuffers);
    }

    public CueList(List<ByteBuffer> rawTags) {
        this.rawMessage = null;
        this.rawTags = Collections.unmodifiableList(rawTags);
        ArrayList<Entry> mutableEntries = new ArrayList<Entry>();
        for (ByteBuffer buffer : rawTags) {
            RekordboxAnlz.CueTag tag = new RekordboxAnlz.CueTag((KaitaiStream)new ByteBufferKaitaiStream(buffer));
            this.addEntriesFromTag(mutableEntries, tag);
        }
        this.entries = this.sortEntries(mutableEntries);
    }

    public CueList(Message message) {
        this.rawMessage = message;
        this.rawTags = null;
        byte[] entryBytes = ((BinaryField)message.arguments.get(3)).getValueAsArray();
        int entryCount = entryBytes.length / 36;
        ArrayList<Entry> mutableEntries = new ArrayList<Entry>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            int offset = i * 36;
            byte cueFlag = entryBytes[offset + 1];
            byte hotCueNumber = entryBytes[offset + 2];
            if (cueFlag == 0 && hotCueNumber == 0) continue;
            long position = Util.bytesToNumberLittleEndian(entryBytes, offset + 12, 4);
            if (entryBytes[offset] != 0) {
                long endPosition = Util.bytesToNumberLittleEndian(entryBytes, offset + 16, 4);
                mutableEntries.add(new Entry(hotCueNumber, position, endPosition));
                continue;
            }
            mutableEntries.add(new Entry(hotCueNumber, position));
        }
        this.entries = this.sortEntries(mutableEntries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CueList cueList = (CueList)o;
        return this.entries != null ? this.entries.equals(cueList.entries) : cueList.entries == null;
    }

    public int hashCode() {
        return this.entries != null ? this.entries.hashCode() : 0;
    }

    public String toString() {
        return "Cue List[entries: " + this.entries + "]";
    }

    public static class Entry {
        public final int hotCueNumber;
        public final boolean isLoop;
        public final long cuePosition;
        public final long cueTime;
        public final long loopPosition;
        public final long loopTime;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.hotCueNumber != entry.hotCueNumber) {
                return false;
            }
            if (this.isLoop != entry.isLoop) {
                return false;
            }
            if (this.cuePosition != entry.cuePosition) {
                return false;
            }
            if (this.cueTime != entry.cueTime) {
                return false;
            }
            if (this.loopPosition != entry.loopPosition) {
                return false;
            }
            return this.loopTime == entry.loopTime;
        }

        public int hashCode() {
            int result = this.hotCueNumber;
            result = 31 * result + (this.isLoop ? 1 : 0);
            result = 31 * result + (int)(this.cuePosition ^ this.cuePosition >>> 32);
            result = 31 * result + (int)(this.cueTime ^ this.cueTime >>> 32);
            result = 31 * result + (int)(this.loopPosition ^ this.loopPosition >>> 32);
            result = 31 * result + (int)(this.loopTime ^ this.loopTime >>> 32);
            return result;
        }

        public Entry(int number, long position) {
            this.hotCueNumber = number;
            this.cuePosition = position;
            this.cueTime = Util.halfFrameToTime(position);
            this.isLoop = false;
            this.loopPosition = 0L;
            this.loopTime = 0L;
        }

        public Entry(int number, long startPosition, long endPosition) {
            this.hotCueNumber = number;
            this.cuePosition = startPosition;
            this.cueTime = Util.halfFrameToTime(startPosition);
            this.isLoop = true;
            this.loopPosition = endPosition;
            this.loopTime = Util.halfFrameToTime(endPosition);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.hotCueNumber == 0) {
                if (this.isLoop) {
                    sb.append("Loop[");
                } else {
                    sb.append("Memory Point[");
                }
            } else {
                sb.append("Hot Cue ").append((char)(this.hotCueNumber + 64)).append('[');
            }
            sb.append("time ").append(this.cueTime).append("ms");
            if (this.isLoop) {
                sb.append(", loop time ").append(this.loopTime).append("ms");
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

