/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.Color;
import java.nio.ByteBuffer;
import javax.swing.JComponent;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformPreviewComponent;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;

public class WaveformPreview {
    public static final int LEADING_DBSERVER_COLOR_JUNK_BYTES = 28;
    public final DataReference dataReference;
    public final Message rawMessage;
    private final ByteBuffer expandedData;
    public final boolean isColor;
    public final int segmentCount;
    public final int maxHeight;
    public static final Color INTENSE_COLOR = new Color(116, 246, 244);
    public static final Color NORMAL_COLOR = new Color(43, 89, 255);

    public ByteBuffer getData() {
        this.expandedData.rewind();
        return this.expandedData.slice();
    }

    public JComponent createViewComponent(TrackMetadata metadata) {
        return new WaveformPreviewComponent(this, metadata);
    }

    private int getSegmentCount() {
        return this.getData().remaining() / (this.isColor ? 6 : 2);
    }

    private int getMaxHeight() {
        int result = 0;
        for (int i = 0; i < this.segmentCount; ++i) {
            result = Math.max(result, this.segmentHeight(i, false));
        }
        return result;
    }

    WaveformPreview(DataReference reference, Message message) {
        this.isColor = message.knownType == Message.KnownType.ANLZ_TAG;
        this.dataReference = reference;
        this.rawMessage = message;
        ByteBuffer data = ((BinaryField)this.rawMessage.arguments.get(3)).getValue();
        data.position(this.isColor ? 28 : 0);
        this.expandedData = data.slice();
        this.segmentCount = this.getSegmentCount();
        this.maxHeight = this.getMaxHeight();
    }

    public WaveformPreview(DataReference reference, RekordboxAnlz anlzFile) {
        this.dataReference = reference;
        this.rawMessage = null;
        ByteBuffer found = null;
        boolean colorFound = false;
        for (RekordboxAnlz.TaggedSection section : anlzFile.sections()) {
            RekordboxAnlz.WaveColorPreviewTag tag;
            if (WaveformFinder.getInstance().isColorPreferred() && section.body() instanceof RekordboxAnlz.WaveColorPreviewTag) {
                tag = (RekordboxAnlz.WaveColorPreviewTag)section.body();
                found = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
                colorFound = true;
                break;
            }
            if (!(section.body() instanceof RekordboxAnlz.WavePreviewTag) || (tag = (RekordboxAnlz.WavePreviewTag)section.body()).lenPreview() < 400L) continue;
            byte[] tagBytes = tag.data();
            byte[] bytes = new byte[tagBytes.length * 2];
            for (int i = 0; i < tagBytes.length; ++i) {
                bytes[i * 2] = (byte)(tagBytes[i] & 0x1F);
                bytes[i * 2 + 1] = (byte)(tagBytes[i] >> 5 & 7);
            }
            found = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
        }
        this.expandedData = found;
        this.isColor = colorFound;
        if (this.expandedData == null) {
            throw new IllegalStateException("Could not construct WaveformPreview, missing from ANLZ file " + anlzFile);
        }
        this.segmentCount = this.getSegmentCount();
        this.maxHeight = this.getMaxHeight();
    }

    public WaveformPreview(DataReference reference, ByteBuffer data, boolean isColor) {
        this.dataReference = reference;
        this.rawMessage = null;
        this.isColor = isColor;
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        this.expandedData = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
        this.segmentCount = this.getSegmentCount();
        this.maxHeight = this.getMaxHeight();
    }

    public int segmentHeight(int segment, boolean front) {
        ByteBuffer bytes = this.getData();
        if (this.isColor) {
            int base = segment * 6;
            int frontHeight = Util.unsign(bytes.get(base + 5));
            if (front) {
                return frontHeight;
            }
            return Math.max(frontHeight, Math.max(Util.unsign(bytes.get(base + 3)), Util.unsign(bytes.get(base + 4))));
        }
        return this.getData().get(segment * 2) & 0x1F;
    }

    public Color segmentColor(int segment, boolean front) {
        ByteBuffer bytes = this.getData();
        if (this.isColor) {
            int base = segment * 6;
            int backHeight = this.segmentHeight(segment, false);
            if (backHeight == 0) {
                return Color.BLACK;
            }
            int maxLevel = front ? 255 : 191;
            int red = Util.unsign(bytes.get(base + 3)) * maxLevel / backHeight;
            int green = Util.unsign(bytes.get(base + 4)) * maxLevel / backHeight;
            int blue = Util.unsign(bytes.get(base + 5)) * maxLevel / backHeight;
            return new Color(red, green, blue);
        }
        int intensity = this.getData().get(segment * 2 + 1) & 7;
        return intensity >= 5 ? INTENSE_COLOR : NORMAL_COLOR;
    }

    public String toString() {
        return "WaveformPreview[dataReference=" + this.dataReference + ", isColor? " + this.isColor + ", size:" + this.getData().remaining() + ", segments:" + this.segmentCount + "]";
    }
}

