/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.Color;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.data.ColorItem;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.SearchableItem;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.deepsymmetry.beatlink.dbserver.StringField;
import org.deepsymmetry.cratedigger.Database;
import org.deepsymmetry.cratedigger.pdb.RekordboxPdb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackMetadata {
    private static final Logger logger = LoggerFactory.getLogger((String)TrackMetadata.class.getName());
    public final DataReference trackReference;
    public final CdjStatus.TrackType trackType;
    public final List<Message> rawItems;
    public final RekordboxPdb.TrackRow rawRow;
    private SearchableItem album;
    private SearchableItem artist;
    private ColorItem color;
    private String comment;
    private String dateAdded;
    private int duration;
    private SearchableItem genre;
    private SearchableItem key;
    private SearchableItem label;
    private SearchableItem originalArtist;
    private int rating;
    private SearchableItem remixer;
    private int tempo;
    private int year;
    private int bitRate;
    private String title;
    private int artworkId;
    private final CueList cueList;

    private SearchableItem buildSearchableItem(Message menuItem) {
        return new SearchableItem((int)((NumberField)menuItem.arguments.get(1)).getValue(), ((StringField)menuItem.arguments.get(3)).getValue());
    }

    private ColorItem buildColorItem(Message menuItem) {
        int colorId = (int)((NumberField)menuItem.arguments.get(1)).getValue();
        String label = ((StringField)menuItem.arguments.get(3)).getValue();
        return this.buildColorItem(colorId, label);
    }

    private ColorItem buildColorItem(int colorId, String label) {
        String colorName;
        Color color;
        switch (colorId) {
            case 0: {
                color = new Color(0, 0, 0, 0);
                colorName = "No Color";
                break;
            }
            case 1: {
                color = Color.PINK;
                colorName = "Pink";
                break;
            }
            case 2: {
                color = Color.RED;
                colorName = "Red";
                break;
            }
            case 3: {
                color = Color.ORANGE;
                colorName = "Orange";
                break;
            }
            case 4: {
                color = Color.YELLOW;
                colorName = "Yellow";
                break;
            }
            case 5: {
                color = Color.GREEN;
                colorName = "Green";
                break;
            }
            case 6: {
                color = Color.CYAN;
                colorName = "Aqua";
                break;
            }
            case 7: {
                color = Color.BLUE;
                colorName = "Blue";
                break;
            }
            case 8: {
                color = new Color(128, 0, 128);
                colorName = "Purple";
                break;
            }
            default: {
                color = new Color(0, 0, 0, 0);
                colorName = "Unknown Color";
            }
        }
        return new ColorItem(colorId, label, color, colorName);
    }

    public TrackMetadata(DataReference reference, Database database, CueList cueList) {
        RekordboxPdb.LabelRow labelRow;
        RekordboxPdb.AlbumRow albumRow;
        this.rawItems = null;
        this.rawRow = (RekordboxPdb.TrackRow)database.trackIndex.get(reference.rekordboxId);
        if (this.rawRow == null) {
            throw new NoSuchElementException("Track " + reference.rekordboxId + " not found in PDB file.");
        }
        this.trackReference = reference;
        this.trackType = CdjStatus.TrackType.REKORDBOX;
        this.cueList = cueList;
        this.title = Database.getText((RekordboxPdb.DeviceSqlString)this.rawRow.title());
        this.artworkId = (int)this.rawRow.artworkId();
        RekordboxPdb.ArtistRow artistRow = (RekordboxPdb.ArtistRow)database.artistIndex.get(this.rawRow.artistId());
        if (artistRow != null) {
            this.artist = new SearchableItem((int)artistRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)artistRow.name()));
        }
        if ((artistRow = (RekordboxPdb.ArtistRow)database.artistIndex.get(this.rawRow.originalArtistId())) != null) {
            this.originalArtist = new SearchableItem((int)artistRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)artistRow.name()));
        }
        if ((artistRow = (RekordboxPdb.ArtistRow)database.artistIndex.get(this.rawRow.originalArtistId())) != null) {
            this.remixer = new SearchableItem((int)artistRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)artistRow.name()));
        }
        if ((albumRow = (RekordboxPdb.AlbumRow)database.albumIndex.get(this.rawRow.albumId())) != null) {
            this.album = new SearchableItem((int)albumRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)albumRow.name()));
        }
        if ((labelRow = (RekordboxPdb.LabelRow)database.labelIndex.get(this.rawRow.labelId())) != null) {
            this.label = new SearchableItem((int)labelRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)labelRow.name()));
        }
        this.duration = this.rawRow.duration();
        this.tempo = (int)this.rawRow.tempo();
        this.comment = Database.getText((RekordboxPdb.DeviceSqlString)this.rawRow.comment());
        RekordboxPdb.KeyRow keyRow = (RekordboxPdb.KeyRow)database.musicalKeyIndex.get(this.rawRow.keyId());
        if (keyRow != null) {
            this.key = new SearchableItem((int)keyRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)keyRow.name()));
        }
        this.rating = this.rawRow.rating();
        RekordboxPdb.ColorRow colorRow = (RekordboxPdb.ColorRow)database.colorIndex.get(this.rawRow.colorId());
        this.color = colorRow != null ? this.buildColorItem(this.rawRow.colorId(), Database.getText((RekordboxPdb.DeviceSqlString)colorRow.name())) : this.buildColorItem(this.rawRow.colorId(), "");
        RekordboxPdb.GenreRow genreRow = (RekordboxPdb.GenreRow)database.genreIndex.get(this.rawRow.genreId());
        if (genreRow != null) {
            this.genre = new SearchableItem((int)genreRow.id(), Database.getText((RekordboxPdb.DeviceSqlString)genreRow.name()));
        }
        this.dateAdded = Database.getText((RekordboxPdb.DeviceSqlString)this.rawRow.dateAdded());
        this.bitRate = (int)this.rawRow.bitrate();
        this.year = this.rawRow.year();
    }

    TrackMetadata(DataReference reference, CdjStatus.TrackType trackType, List<Message> items, CueList cueList) {
        this.rawRow = null;
        this.trackReference = reference;
        this.trackType = trackType;
        this.cueList = cueList;
        this.rawItems = Collections.unmodifiableList(new LinkedList<Message>(items));
        for (Message item : items) {
            this.parseMetadataItem(item);
        }
        if (this.title == null) {
            this.title = "";
        }
        if (this.comment == null) {
            this.comment = "";
        }
        if (this.dateAdded == null) {
            this.dateAdded = "";
        }
    }

    private void parseMetadataItem(Message item) {
        switch (item.getMenuItemType()) {
            case TRACK_TITLE: {
                this.title = ((StringField)item.arguments.get(3)).getValue();
                this.artworkId = (int)((NumberField)item.arguments.get(8)).getValue();
                break;
            }
            case ARTIST: {
                this.artist = this.buildSearchableItem(item);
                break;
            }
            case ORIGINAL_ARTIST: {
                this.originalArtist = this.buildSearchableItem(item);
                break;
            }
            case REMIXER: {
                this.remixer = this.buildSearchableItem(item);
            }
            case ALBUM_TITLE: {
                this.album = this.buildSearchableItem(item);
                break;
            }
            case LABEL: {
                this.label = this.buildSearchableItem(item);
                break;
            }
            case DURATION: {
                this.duration = (int)((NumberField)item.arguments.get(1)).getValue();
                break;
            }
            case TEMPO: {
                this.tempo = (int)((NumberField)item.arguments.get(1)).getValue();
                break;
            }
            case COMMENT: {
                this.comment = ((StringField)item.arguments.get(3)).getValue();
                break;
            }
            case KEY: {
                this.key = this.buildSearchableItem(item);
                break;
            }
            case RATING: {
                this.rating = (int)((NumberField)item.arguments.get(1)).getValue();
                break;
            }
            case COLOR_NONE: 
            case COLOR_AQUA: 
            case COLOR_BLUE: 
            case COLOR_GREEN: 
            case COLOR_ORANGE: 
            case COLOR_PINK: 
            case COLOR_PURPLE: 
            case COLOR_RED: 
            case COLOR_YELLOW: {
                this.color = this.buildColorItem(item);
                break;
            }
            case GENRE: {
                this.genre = this.buildSearchableItem(item);
                break;
            }
            case DATE_ADDED: {
                this.dateAdded = ((StringField)item.arguments.get(3)).getValue();
                break;
            }
            case YEAR: {
                this.year = (int)((NumberField)item.arguments.get(1)).getValue();
                break;
            }
            case BIT_RATE: {
                this.bitRate = (int)((NumberField)item.arguments.get(1)).getValue();
                break;
            }
            default: {
                logger.warn("Ignoring track metadata item with unknown type: {}", (Object)item);
            }
        }
    }

    public SearchableItem getAlbum() {
        return this.album;
    }

    public SearchableItem getArtist() {
        return this.artist;
    }

    public int getArtworkId() {
        return this.artworkId;
    }

    public ColorItem getColor() {
        return this.color;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackMetadata metadata = (TrackMetadata)o;
        if (this.trackReference != metadata.trackReference) {
            return false;
        }
        if (this.trackType != metadata.trackType) {
            return false;
        }
        if (this.duration != metadata.duration) {
            return false;
        }
        if (this.rating != metadata.rating) {
            return false;
        }
        if (this.tempo != metadata.tempo) {
            return false;
        }
        if (this.artworkId != metadata.artworkId) {
            return false;
        }
        if (this.album != null ? !this.album.equals(metadata.album) : metadata.album != null) {
            return false;
        }
        if (this.artist != null ? !this.artist.equals(metadata.artist) : metadata.artist != null) {
            return false;
        }
        if (this.color != null ? !this.color.equals(metadata.color) : metadata.color != null) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(metadata.comment) : metadata.comment != null) {
            return false;
        }
        if (this.dateAdded != null ? !this.dateAdded.equals(metadata.dateAdded) : metadata.dateAdded != null) {
            return false;
        }
        if (this.genre != null ? !this.genre.equals(metadata.genre) : metadata.genre != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(metadata.key) : metadata.key != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(metadata.label) : metadata.label != null) {
            return false;
        }
        if (this.originalArtist != null ? !this.originalArtist.equals(metadata.originalArtist) : metadata.originalArtist != null) {
            return false;
        }
        if (this.remixer != null ? !this.remixer.equals(metadata.remixer) : metadata.remixer != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(metadata.title) : metadata.title != null) {
            return false;
        }
        return this.cueList != null ? this.cueList.equals(metadata.cueList) : metadata.cueList == null;
    }

    public int hashCode() {
        int result = this.album != null ? this.album.hashCode() : 0;
        result = 31 * result + (this.artist != null ? this.artist.hashCode() : 0);
        result = 31 * result + this.bitRate;
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 31 * result + (this.dateAdded != null ? this.dateAdded.hashCode() : 0);
        result = 31 * result + this.duration;
        result = 31 * result + (this.genre != null ? this.genre.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.originalArtist != null ? this.originalArtist.hashCode() : 0);
        result = 31 * result + this.rating;
        result = 31 * result + (this.remixer != null ? this.remixer.hashCode() : 0);
        result = 31 * result + this.tempo;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + this.artworkId;
        result = 31 * result + (this.cueList != null ? this.cueList.hashCode() : 0);
        result = 31 * result + this.trackReference.hashCode();
        result = 31 * result + this.trackType.hashCode();
        result = 31 * result + this.year;
        return result;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public CueList getCueList() {
        return this.cueList;
    }

    public String getDateAdded() {
        return this.dateAdded;
    }

    public int getDuration() {
        return this.duration;
    }

    public SearchableItem getGenre() {
        return this.genre;
    }

    public SearchableItem getKey() {
        return this.key;
    }

    public SearchableItem getLabel() {
        return this.label;
    }

    public SearchableItem getOriginalArtist() {
        return this.originalArtist;
    }

    public int getRating() {
        return this.rating;
    }

    public SearchableItem getRemixer() {
        return this.remixer;
    }

    public int getTempo() {
        return this.tempo;
    }

    public String getTitle() {
        return this.title;
    }

    public int getYear() {
        return this.year;
    }

    public String toString() {
        return "Track Metadata[trackReference: " + this.trackReference + ", TrackType: " + (Object)((Object)this.trackType) + ", Title: " + this.title + ", Artist: " + this.artist + ", Album: " + this.album + ", Remixer: " + this.remixer + ", Label: " + this.label + ", Original Artist: " + this.originalArtist + ", Date Added: " + this.dateAdded + ", Duration: " + this.duration + ", Tempo: " + this.tempo + ", Comment: " + this.comment + ", Key: " + this.key + ", Rating: " + this.rating + ", Color: " + this.color + ", Genre: " + this.genre + ", Year: " + this.year + ", Bit Rate: " + this.bitRate + ", Artwork ID: " + this.artworkId + ", Cue List: " + this.cueList + "]";
    }
}

