/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaDetails {
    private static final Logger logger = LoggerFactory.getLogger(MediaDetails.class);
    public final SlotReference slotReference;
    public final CdjStatus.TrackType mediaType;
    public final String name;
    public final String creationDate;
    public final int trackCount;
    public final int playlistCount;
    public final long totalSize;
    public final long freeSpace;
    private final ByteBuffer rawBytes;
    private static final Set<Integer> expectedMediaPacketSizes = new HashSet<Integer>(Collections.singletonList(192));
    public static final int MINIMUM_PACKET_SIZE = 192;

    public ByteBuffer getRawBytes() {
        this.rawBytes.rewind();
        return this.rawBytes.slice();
    }

    MediaDetails(DatagramPacket packet) {
        this(packet.getData(), packet.getLength());
    }

    public MediaDetails(byte[] packet, int packetLength) {
        byte[] packetCopy = new byte[packetLength];
        System.arraycopy(packet, 0, packetCopy, 0, packetLength);
        this.rawBytes = ByteBuffer.wrap(packetCopy).asReadOnlyBuffer();
        if (packetCopy.length < 192) {
            throw new IllegalArgumentException("Unable to create a MediaDetails object, packet too short: we need 192 bytes and were given only " + packetCopy.length);
        }
        int payloadLength = (int)Util.bytesToNumber(packetCopy, 34, 2);
        if (packetCopy.length != payloadLength + 36) {
            logger.warn("Received Media response packet with reported payload length of " + payloadLength + " and actual payload length of " + (packetCopy.length - 36));
        }
        if (!expectedMediaPacketSizes.contains(packetCopy.length)) {
            logger.warn("Processing Media response packets with unexpected lengths " + packetCopy.length + ".");
            expectedMediaPacketSizes.add(packetCopy.length);
        }
        byte hostPlayer = packetCopy[39];
        CdjStatus.TrackSourceSlot hostSLot = CdjStatus.TRACK_SOURCE_SLOT_MAP.get(packetCopy[43]);
        if (hostSLot == null) {
            throw new IllegalArgumentException("Unrecognized slot for media response:" + packetCopy[43]);
        }
        this.slotReference = SlotReference.getSlotReference(hostPlayer, hostSLot);
        CdjStatus.TrackType type = CdjStatus.TRACK_TYPE_MAP.get(packetCopy[170]);
        if (type == null) {
            throw new IllegalArgumentException("Unrecognized media type for media response:" + packetCopy[170]);
        }
        this.mediaType = type;
        if (hostPlayer >= 40) {
            this.name = "rekordbox mobile";
            this.creationDate = "";
        } else {
            try {
                this.name = new String(packetCopy, 44, 64, "UTF-16BE").trim();
                this.creationDate = new String(packetCopy, 108, 24, "UTF-16BE").trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Java no longer supports UTF-16BE encoding?!", e);
            }
        }
        this.trackCount = (int)Util.bytesToNumber(packetCopy, 166, 2);
        this.playlistCount = (int)Util.bytesToNumber(packetCopy, 174, 2);
        this.totalSize = Util.bytesToNumber(packetCopy, 176, 8);
        this.freeSpace = Util.bytesToNumber(packetCopy, 184, 8);
    }

    public String toString() {
        return "MediaDetails[slotReference:" + this.slotReference + ", name:" + this.name + ", creationDate:" + this.creationDate + ", mediaType:" + (Object)((Object)this.mediaType) + ", trackCount:" + this.trackCount + ", playlistCount:" + this.playlistCount + ", totalSize:" + this.totalSize + ", freeSpace:" + this.freeSpace + "]";
    }

    public String hashKey() {
        return this.creationDate + ":" + (Object)((Object)this.mediaType) + ":" + this.totalSize + ":" + this.name;
    }

    public boolean hasChanged(MediaDetails originalMedia) {
        if (!this.hashKey().equals(originalMedia.hashKey())) {
            throw new IllegalArgumentException("Can't compare media details with different hashKey values");
        }
        return this.playlistCount != originalMedia.playlistCount || this.trackCount != originalMedia.trackCount;
    }
}

