/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridListener;
import org.deepsymmetry.beatlink.data.BeatGridUpdate;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataCache;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeatGridFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(BeatGridFinder.class);
    private final Map<DeckReference, BeatGrid> hotCache = new ConcurrentHashMap<DeckReference, BeatGrid>();
    private final LinkedBlockingDeque<TrackMetadataUpdate> pendingUpdates = new LinkedBlockingDeque(100);
    private final TrackMetadataListener metadataListener = new TrackMetadataListener(){

        @Override
        public void metadataChanged(TrackMetadataUpdate update) {
            logger.debug("Received metadata update {}", (Object)update);
            if (!BeatGridFinder.this.pendingUpdates.offerLast(update)) {
                logger.warn("Discarding metadata update because our queue is backed up.");
            }
        }
    };
    private final MountListener mountListener = new MountListener(){

        @Override
        public void mediaMounted(SlotReference slot) {
            logger.debug("BeatGridFinder doesn't yet need to do anything in response to a media mount.");
        }

        @Override
        public void mediaUnmounted(SlotReference slot) {
            for (Map.Entry entry : new HashMap(BeatGridFinder.this.hotCache).entrySet()) {
                if (slot != SlotReference.getSlotReference(((BeatGrid)entry.getValue()).dataReference)) continue;
                logger.debug("Evicting cached beat grid in response to unmount report {}", entry.getValue());
                BeatGridFinder.this.hotCache.remove(entry.getKey());
            }
        }
    };
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            logger.debug("Currently nothing for BeatGridFinder to do when devices appear.");
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            logger.info("Clearing beat grids in response to the loss of a device, {}", (Object)announcement);
            BeatGridFinder.this.clearBeatGrids(announcement);
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread queueHandler;
    private final Set<Integer> activeRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<BeatGridListener> beatGridListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("The BeatGridFinder does not auto-start when {} does.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (BeatGridFinder.this.isRunning()) {
                logger.info("BeatGridFinder stopping because {} has.", (Object)sender);
                BeatGridFinder.this.stop();
            }
        }
    };
    private static final BeatGridFinder ourInstance = new BeatGridFinder();

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    private void clearDeck(TrackMetadataUpdate update) {
        if (this.hotCache.remove(DeckReference.getDeckReference(update.player, 0)) != null) {
            this.deliverBeatGridUpdate(update.player, null);
        }
    }

    private void clearBeatGrids(DeviceAnnouncement announcement) {
        int player = announcement.getNumber();
        for (DeckReference deck : new HashSet<DeckReference>(this.hotCache.keySet())) {
            if (deck.player != player) continue;
            this.hotCache.remove(deck);
            if (deck.hotCue != 0) continue;
            this.deliverBeatGridUpdate(player, null);
        }
    }

    private void updateBeatGrid(TrackMetadataUpdate update, BeatGrid beatGrid) {
        this.hotCache.put(DeckReference.getDeckReference(update.player, 0), beatGrid);
        if (update.metadata.getCueList() != null) {
            for (CueList.Entry entry : update.metadata.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                this.hotCache.put(DeckReference.getDeckReference(update.player, entry.hotCueNumber), beatGrid);
            }
        }
        this.deliverBeatGridUpdate(update.player, beatGrid);
    }

    public Map<DeckReference, BeatGrid> getLoadedBeatGrids() {
        this.ensureRunning();
        return Collections.unmodifiableMap(new HashMap<DeckReference, BeatGrid>(this.hotCache));
    }

    public BeatGrid getLatestBeatGridFor(int player) {
        this.ensureRunning();
        return this.hotCache.get(DeckReference.getDeckReference(player, 0));
    }

    public BeatGrid getLatestBeatGridFor(DeviceUpdate update) {
        BeatGrid result = this.getLatestBeatGridFor(update.getDeviceNumber());
        if (result != null && update instanceof CdjStatus && result.dataReference.rekordboxId != ((CdjStatus)update).getRekordboxId()) {
            return null;
        }
        return result;
    }

    private BeatGrid requestBeatGridInternal(final DataReference trackReference, boolean failIfPassive) {
        BeatGrid provided;
        MetadataCache cache = MetadataFinder.getInstance().getMetadataCache(SlotReference.getSlotReference(trackReference));
        if (cache != null) {
            return cache.getBeatGrid(null, trackReference);
        }
        MediaDetails sourceDetails = MetadataFinder.getInstance().getMediaDetailsFor(trackReference.getSlotReference());
        if (sourceDetails != null && (provided = MetadataFinder.getInstance().allMetadataProviders.getBeatGrid(sourceDetails, trackReference)) != null) {
            return provided;
        }
        if (MetadataFinder.getInstance().isPassive() && failIfPassive && trackReference.slot != CdjStatus.TrackSourceSlot.COLLECTION) {
            return null;
        }
        ConnectionManager.ClientTask<BeatGrid> task = new ConnectionManager.ClientTask<BeatGrid>(){

            @Override
            public BeatGrid useClient(Client client) throws Exception {
                return BeatGridFinder.this.getBeatGrid(trackReference.rekordboxId, SlotReference.getSlotReference(trackReference), client);
            }
        };
        try {
            return ConnectionManager.getInstance().invokeWithClientSession(trackReference.player, task, "requesting beat grid");
        }
        catch (Exception e) {
            logger.error("Problem requesting beat grid, returning null", (Throwable)e);
            return null;
        }
    }

    public BeatGrid requestBeatGridFrom(DataReference track) {
        for (BeatGrid cached : this.hotCache.values()) {
            if (!cached.dataReference.equals(track)) continue;
            return cached;
        }
        return this.requestBeatGridInternal(track, false);
    }

    BeatGrid getBeatGrid(int rekordboxId, SlotReference slot, Client client) throws IOException {
        Message response = client.simpleRequest(Message.KnownType.BEAT_GRID_REQ, null, client.buildRMST(Message.MenuIdentifier.DATA, slot.slot), new NumberField(rekordboxId));
        if (response.knownType == Message.KnownType.BEAT_GRID) {
            return new BeatGrid(new DataReference(slot, rekordboxId), response);
        }
        logger.error("Unexpected response type when requesting beat grid: {}", (Object)response);
        return null;
    }

    public void addBeatGridListener(BeatGridListener listener) {
        if (listener != null) {
            this.beatGridListeners.add(listener);
        }
    }

    public void removeBeatGridListener(BeatGridListener listener) {
        if (listener != null) {
            this.beatGridListeners.remove(listener);
        }
    }

    public Set<BeatGridListener> getBeatGridListeners() {
        return Collections.unmodifiableSet(new HashSet<BeatGridListener>(this.beatGridListeners));
    }

    private void deliverBeatGridUpdate(int player, BeatGrid beatGrid) {
        if (!this.getBeatGridListeners().isEmpty()) {
            BeatGridUpdate update = new BeatGridUpdate(player, beatGrid);
            for (BeatGridListener listener : this.getBeatGridListeners()) {
                try {
                    listener.beatGridChanged(update);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering beat grid update to listener", t);
                }
            }
        }
    }

    private void handleUpdate(final TrackMetadataUpdate update) {
        if (update.metadata == null || update.metadata.trackType != CdjStatus.TrackType.REKORDBOX) {
            this.clearDeck(update);
        } else {
            BeatGrid lastBeatGrid = this.hotCache.get(DeckReference.getDeckReference(update.player, 0));
            if (lastBeatGrid == null || !lastBeatGrid.dataReference.equals(update.metadata.trackReference)) {
                for (BeatGrid cached : this.hotCache.values()) {
                    if (!cached.dataReference.equals(update.metadata.trackReference)) continue;
                    this.updateBeatGrid(update, cached);
                    return;
                }
                if (this.activeRequests.add(update.player)) {
                    this.clearDeck(update);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BeatGrid grid = BeatGridFinder.this.requestBeatGridInternal(update.metadata.trackReference, true);
                                if (grid != null && grid.beatCount > 0) {
                                    BeatGridFinder.this.updateBeatGrid(update, grid);
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Problem requesting beat grid from update" + update, (Throwable)e);
                            }
                            finally {
                                BeatGridFinder.this.activeRequests.remove(update.player);
                            }
                        }
                    }, "Beat Grid request").start();
                }
            }
        }
    }

    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            ConnectionManager.getInstance().addLifecycleListener(this.lifecycleListener);
            ConnectionManager.getInstance().start();
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            MetadataFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            MetadataFinder.getInstance().start();
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            MetadataFinder.getInstance().addMountListener(this.mountListener);
            this.queueHandler = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (BeatGridFinder.this.isRunning()) {
                        try {
                            BeatGridFinder.this.handleUpdate((TrackMetadataUpdate)BeatGridFinder.this.pendingUpdates.take());
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (Throwable t) {
                            logger.error("Problem processing metadata update", t);
                        }
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry<DeckReference, TrackMetadata> entry : MetadataFinder.getInstance().getLoadedTracks().entrySet()) {
                        if (entry.getKey().hotCue != 0) continue;
                        BeatGridFinder.this.handleUpdate(new TrackMetadataUpdate(entry.getKey().player, entry.getValue()));
                    }
                }
            });
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            final HashSet<DeckReference> dyingCache = new HashSet<DeckReference>(this.hotCache.keySet());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (DeckReference deck : dyingCache) {
                        if (deck.hotCue != 0) continue;
                        BeatGridFinder.this.deliverBeatGridUpdate(deck.player, null);
                    }
                }
            });
            this.hotCache.clear();
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    public static BeatGridFinder getInstance() {
        return ourInstance;
    }

    private BeatGridFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BeatGridFinder[running:").append(this.isRunning()).append(", passive:");
        sb.append(MetadataFinder.getInstance().isPassive());
        if (this.isRunning()) {
            sb.append(", loadedBeatGrids:").append(this.getLoadedBeatGrids());
        }
        return sb.append("]").toString();
    }
}

