/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import io.kaitai.struct.KaitaiStream;
import io.kaitai.struct.RandomAccessFileKaitaiStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementAdapter;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.MediaDetailsListener;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.AlbumArt;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DatabaseListener;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.MetadataProvider;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.cratedigger.Database;
import org.deepsymmetry.cratedigger.FileFetcher;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.deepsymmetry.cratedigger.pdb.RekordboxPdb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrateDigger {
    private final Logger logger = LoggerFactory.getLogger(CrateDigger.class);
    private final AtomicInteger retryLimit = new AtomicInteger(3);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(final LifecycleParticipant sender) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        CrateDigger.this.logger.info("CrateDigger starting because {} has.", (Object)sender);
                        CrateDigger.this.start();
                    }
                    catch (Throwable t) {
                        CrateDigger.this.logger.error("Problem starting the CrateDigger in response to a lifecycle event.", t);
                    }
                }
            }).start();
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (CrateDigger.this.isRunning()) {
                CrateDigger.this.logger.info("CrateDigger stopping because {} has.", (Object)sender);
                CrateDigger.this.stop();
            }
        }
    };
    private final Set<SlotReference> mediaWithHiddenPioneerFolder = new HashSet<SlotReference>();
    private final Map<Integer, DeviceAnnouncement> addressBackup = new ConcurrentHashMap<Integer, DeviceAnnouncement>();
    private final MountListener mountListener = new MountListener(){

        @Override
        public void mediaMounted(SlotReference slot) {
            DeviceAnnouncement player = DeviceFinder.getInstance().getLatestAnnouncementFrom(slot.player);
            CrateDigger.this.addressBackup.put(slot.player, player);
            CrateDigger.this.logger.debug("Media mounted, waiting for details.");
        }

        @Override
        public void mediaUnmounted(SlotReference slot) {
            CrateDigger.this.mediaWithHiddenPioneerFolder.remove(slot);
            DeviceAnnouncement player = DeviceFinder.getInstance().getLatestAnnouncementFrom(slot.player);
            if (player == null) {
                CrateDigger.this.logger.info("Received an unmount for a player we can't find, it must have left network.");
                player = (DeviceAnnouncement)CrateDigger.this.addressBackup.get(slot.player);
            }
            if (player != null) {
                FileFetcher.getInstance().removePlayer(player.getAddress());
            } else {
                CrateDigger.this.logger.warn("Unable to clear FileFetcher connections for player that we can't find backup address for!");
            }
            Database database = (Database)CrateDigger.this.databases.remove(slot);
            if (database != null) {
                CrateDigger.this.deliverDatabaseUpdate(slot, database, false);
                try {
                    database.close();
                }
                catch (IOException e) {
                    CrateDigger.this.logger.error("Problem closing parsed rekordbox database export.", (Throwable)e);
                }
                database.sourceFile.delete();
            }
            String prefix = CrateDigger.this.slotPrefix(slot);
            File[] files = CrateDigger.this.downloadDirectory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().startsWith(prefix)) continue;
                    file.delete();
                }
            }
        }
    };
    private final DeviceAnnouncementListener deviceListener = new DeviceAnnouncementAdapter(){

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            FileFetcher.getInstance().removePlayer(announcement.getAddress());
        }
    };
    private final Set<SlotReference> activeRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<SlotReference, Database> databases = new ConcurrentHashMap<SlotReference, Database>();
    private static final long RETRY_BACKOFF = 2000L;
    private static final long MAX_RETRY_INTERVAL = 6000L;
    private final MediaDetailsListener mediaDetailsListener = new MediaDetailsListener(){

        @Override
        public void detailsAvailable(final MediaDetails details) {
            if (CrateDigger.this.isRunning() && details.mediaType == CdjStatus.TrackType.REKORDBOX && details.slotReference.slot != CdjStatus.TrackSourceSlot.COLLECTION && !CrateDigger.this.databases.containsKey(details.slotReference) && CrateDigger.this.activeRequests.add(details.slotReference)) {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        File file = null;
                        try {
                            file = new File(CrateDigger.this.downloadDirectory, CrateDigger.this.slotPrefix(details.slotReference) + "export.pdb");
                            CrateDigger.this.logger.info("Fetching rekordbox export.pdb from player " + details.slotReference.player + ", slot " + (Object)((Object)details.slotReference.slot));
                            long started = System.nanoTime();
                            CrateDigger.this.fetchFile(details.slotReference, "PIONEER/rekordbox/export.pdb", file);
                            long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - started);
                            CrateDigger.this.logger.info("Finished fetching export.pdb from player " + details.slotReference.player + ", slot " + (Object)((Object)details.slotReference.slot) + "; received " + CrateDigger.humanReadableByteCount(file.length(), true) + " in " + duration + "ms, " + CrateDigger.humanReadableByteCount(file.length() * 1000L / duration, true) + "/s.");
                            started = System.nanoTime();
                            Database database = new Database(file);
                            duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - started);
                            CrateDigger.this.logger.info("Parsing database took " + duration + "ms, " + (long)(database.trackIndex.size() * 1000) / duration + " tracks/s");
                            CrateDigger.this.databases.put(details.slotReference, database);
                            CrateDigger.this.deliverDatabaseUpdate(details.slotReference, database, true);
                        }
                        catch (Throwable t) {
                            CrateDigger.this.logger.error("Problem fetching rekordbox database for media " + details + ", will not offer metadata for it.", t);
                            if (file != null) {
                                file.delete();
                            }
                        }
                        finally {
                            CrateDigger.this.activeRequests.remove(details.slotReference);
                        }
                    }
                }).start();
            }
        }
    };
    private final MetadataProvider metadataProvider = new MetadataProvider(){

        @Override
        public List<MediaDetails> supportedMedia() {
            return null;
        }

        @Override
        public TrackMetadata getTrackMetadata(MediaDetails sourceMedia, DataReference track) {
            Database database = CrateDigger.this.findDatabase(track);
            if (database != null) {
                try {
                    return new TrackMetadata(track, database, this.getCueList(sourceMedia, track));
                }
                catch (Exception e) {
                    CrateDigger.this.logger.error("Problem fetching metadata for track " + track + " from database " + database, (Throwable)e);
                }
            }
            return null;
        }

        @Override
        public AlbumArt getAlbumArt(MediaDetails sourceMedia, DataReference art) {
            block5: {
                File file = null;
                Database database = CrateDigger.this.findDatabase(art);
                if (database != null) {
                    try {
                        RekordboxPdb.ArtworkRow artworkRow = (RekordboxPdb.ArtworkRow)database.artworkIndex.get(art.rekordboxId);
                        if (artworkRow != null) {
                            file = new File(CrateDigger.this.downloadDirectory, CrateDigger.this.slotPrefix(art.getSlotReference()) + "art-" + art.rekordboxId + ".jpg");
                            if (file.canRead()) {
                                return new AlbumArt(art, file);
                            }
                            file.deleteOnExit();
                            CrateDigger.this.fetchFile(art.getSlotReference(), Database.getText((RekordboxPdb.DeviceSqlString)artworkRow.path()), file);
                            return new AlbumArt(art, file);
                        }
                        CrateDigger.this.logger.warn("Unable to find artwork " + art + " in database " + database);
                    }
                    catch (Exception e) {
                        CrateDigger.this.logger.warn("Problem fetching artwork " + art + " from database " + database, (Throwable)e);
                        if (file == null) break block5;
                        file.delete();
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BeatGrid getBeatGrid(MediaDetails sourceMedia, DataReference track) {
            block6: {
                Database database = CrateDigger.this.findDatabase(track);
                if (database != null) {
                    BeatGrid beatGrid;
                    RekordboxAnlz file = CrateDigger.this.findTrackAnalysis(track, database);
                    if (file == null) break block6;
                    try {
                        beatGrid = new BeatGrid(track, file);
                    }
                    catch (Throwable throwable) {
                        try {
                            file._io().close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            CrateDigger.this.logger.error("Problem fetching beat grid for track " + track + " from database " + database, (Throwable)e);
                        }
                    }
                    file._io().close();
                    return beatGrid;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CueList getCueList(MediaDetails sourceMedia, DataReference track) {
            block7: {
                Database database = CrateDigger.this.findDatabase(track);
                if (database != null) {
                    CueList cueList;
                    RekordboxAnlz file = CrateDigger.this.findExtendedAnalysis(track, database);
                    if (file == null) {
                        file = CrateDigger.this.findTrackAnalysis(track, database);
                    }
                    if (file == null) break block7;
                    try {
                        cueList = new CueList(file);
                    }
                    catch (Throwable throwable) {
                        try {
                            file._io().close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            CrateDigger.this.logger.error("Problem fetching cue list for track " + track + " from database " + database, (Throwable)e);
                        }
                    }
                    file._io().close();
                    return cueList;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WaveformPreview getWaveformPreview(MediaDetails sourceMedia, DataReference track) {
            block13: {
                Database database = CrateDigger.this.findDatabase(track);
                if (database != null) {
                    WaveformPreview waveformPreview;
                    RekordboxAnlz file;
                    block12: {
                        WaveformPreview waveformPreview2;
                        file = CrateDigger.this.findExtendedAnalysis(track, database);
                        if (file == null) break block12;
                        try {
                            waveformPreview2 = new WaveformPreview(track, file);
                        }
                        catch (Throwable throwable) {
                            try {
                                file._io().close();
                                throw throwable;
                            }
                            catch (IllegalStateException e) {
                                CrateDigger.this.logger.info("No color preview waveform found, checking for blue version.");
                                break block12;
                            }
                            catch (Exception e) {
                                CrateDigger.this.logger.error("Problem fetching color waveform preview for track " + track + " from database " + database, (Throwable)e);
                            }
                        }
                        file._io().close();
                        return waveformPreview2;
                    }
                    file = CrateDigger.this.findTrackAnalysis(track, database);
                    if (file == null) break block13;
                    try {
                        waveformPreview = new WaveformPreview(track, file);
                    }
                    catch (Throwable throwable) {
                        try {
                            file._io().close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            CrateDigger.this.logger.error("Problem fetching waveform preview for track " + track + " from database " + database, (Throwable)e);
                        }
                    }
                    file._io().close();
                    return waveformPreview;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WaveformDetail getWaveformDetail(MediaDetails sourceMedia, DataReference track) {
            block6: {
                Database database = CrateDigger.this.findDatabase(track);
                if (database != null) {
                    WaveformDetail waveformDetail;
                    RekordboxAnlz file = CrateDigger.this.findExtendedAnalysis(track, database);
                    if (file == null) break block6;
                    try {
                        waveformDetail = new WaveformDetail(track, file);
                    }
                    catch (Throwable throwable) {
                        try {
                            file._io().close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            CrateDigger.this.logger.error("Problem fetching waveform preview for track " + track + " from database " + database, (Throwable)e);
                        }
                    }
                    file._io().close();
                    return waveformDetail;
                }
            }
            return null;
        }
    };
    private static final CrateDigger instance = new CrateDigger();
    public final File downloadDirectory;
    private static final int TEMP_DIR_ATTEMPTS = 1000;
    private final Set<DatabaseListener> dbListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    public void setRetryLimit(int limit) {
        if (limit < 1 || limit > 10) {
            throw new IllegalArgumentException("limit must be between 1 and 10");
        }
        this.retryLimit.set(limit);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    private String mountPath(CdjStatus.TrackSourceSlot slot) {
        switch (slot) {
            case SD_SLOT: {
                return "/B/";
            }
            case USB_SLOT: {
                return "/C/";
            }
        }
        throw new IllegalArgumentException("Don't know how to NFS mount filesystem for slot " + (Object)((Object)slot));
    }

    private void fetchFile(SlotReference slot, String path, File destination) throws IOException {
        destination.deleteOnExit();
        DeviceAnnouncement player = DeviceFinder.getInstance().getLatestAnnouncementFrom(slot.player);
        if (player == null) {
            throw new IOException("Cannot fetch file from player that is not found on the network; slot: " + slot);
        }
        int triesMade = 0;
        if (path.startsWith("PIONEER/") && this.mediaWithHiddenPioneerFolder.contains(slot)) {
            path = "." + path;
        }
        while (triesMade < this.getRetryLimit()) {
            try {
                FileFetcher.getInstance().fetch(player.getAddress(), this.mountPath(slot.slot), path, destination);
                return;
            }
            catch (IOException e) {
                if (path.startsWith("PIONEER/") && e.getMessage().contains("lookup of element \"PIONEER\" returned status")) {
                    this.mediaWithHiddenPioneerFolder.add(slot);
                    this.fetchFile(slot, "." + path, destination);
                    return;
                }
                if (++triesMade < this.getRetryLimit()) {
                    this.logger.warn("Attempt to fetch file from player failed, tries left: " + (this.getRetryLimit() - triesMade), (Throwable)e);
                    try {
                        Thread.sleep(Math.min(6000L, (long)triesMade * 2000L));
                    }
                    catch (InterruptedException ie) {
                        this.logger.warn("Interrupted while sleeping between file fetch attempts. Retrying immediately.");
                    }
                    continue;
                }
                throw e;
            }
        }
    }

    private String slotPrefix(SlotReference slotReference) {
        return "player-" + slotReference.player + "-slot-" + slotReference.slot.protocolValue + "-";
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public Database findDatabase(DataReference reference) {
        return this.databases.get(reference.getSlotReference());
    }

    public Database findDatabase(SlotReference slot) {
        return this.databases.get(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private RekordboxAnlz findTrackAnalysis(DataReference track, Database database) {
        File file = null;
        try {
            String filePath;
            RekordboxPdb.TrackRow trackRow;
            block9: {
                RekordboxAnlz rekordboxAnlz;
                trackRow = (RekordboxPdb.TrackRow)database.trackIndex.get(track.rekordboxId);
                if (trackRow == null) {
                    this.logger.warn("Unable to find track " + track + " in database " + database);
                    return null;
                }
                file = new File(this.downloadDirectory, this.slotPrefix(track.getSlotReference()) + "track-" + track.rekordboxId + "-anlz.dat");
                filePath = file.getCanonicalPath();
                try {
                    Object object = Util.allocateNamedLock(filePath);
                    // MONITORENTER : object
                    if (!file.canRead()) break block9;
                    rekordboxAnlz = new RekordboxAnlz((KaitaiStream)new RandomAccessFileKaitaiStream(filePath));
                    // MONITOREXIT : object
                }
                catch (Throwable throwable) {
                    Util.freeNamedLock(filePath);
                    throw throwable;
                }
                Util.freeNamedLock(filePath);
                return rekordboxAnlz;
            }
            file.deleteOnExit();
            this.fetchFile(track.getSlotReference(), Database.getText((RekordboxPdb.DeviceSqlString)trackRow.analyzePath()), file);
            RekordboxAnlz rekordboxAnlz = new RekordboxAnlz((KaitaiStream)new RandomAccessFileKaitaiStream(filePath));
            // MONITOREXIT : object
            Util.freeNamedLock(filePath);
            return rekordboxAnlz;
        }
        catch (Exception e) {
            this.logger.error("Problem fetching analysis file for track " + track + " from database " + database, (Throwable)e);
            if (file == null) return null;
            file.delete();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private RekordboxAnlz findExtendedAnalysis(DataReference track, Database database) {
        File file = null;
        try {
            String filePath;
            RekordboxPdb.TrackRow trackRow;
            block9: {
                RekordboxAnlz rekordboxAnlz;
                trackRow = (RekordboxPdb.TrackRow)database.trackIndex.get(track.rekordboxId);
                if (trackRow == null) {
                    this.logger.warn("Unable to find track " + track + " in database " + database);
                    return null;
                }
                file = new File(this.downloadDirectory, this.slotPrefix(track.getSlotReference()) + "track-" + track.rekordboxId + "-anlz.ext");
                filePath = file.getCanonicalPath();
                try {
                    Object object = Util.allocateNamedLock(filePath);
                    // MONITORENTER : object
                    if (!file.canRead()) break block9;
                    rekordboxAnlz = new RekordboxAnlz((KaitaiStream)new RandomAccessFileKaitaiStream(filePath));
                    // MONITOREXIT : object
                }
                catch (Throwable throwable) {
                    Util.freeNamedLock(filePath);
                    throw throwable;
                }
                Util.freeNamedLock(filePath);
                return rekordboxAnlz;
            }
            file.deleteOnExit();
            String analyzePath = Database.getText((RekordboxPdb.DeviceSqlString)trackRow.analyzePath());
            String extendedPath = analyzePath.replaceAll("\\.DAT$", ".EXT");
            this.fetchFile(track.getSlotReference(), extendedPath, file);
            RekordboxAnlz rekordboxAnlz = new RekordboxAnlz((KaitaiStream)new RandomAccessFileKaitaiStream(filePath));
            // MONITOREXIT : object
            Util.freeNamedLock(filePath);
            return rekordboxAnlz;
        }
        catch (Exception e) {
            this.logger.error("Problem fetching extended analysis file for track " + track + " from database " + database, (Throwable)e);
            if (file == null) return null;
            file.delete();
        }
        return null;
    }

    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            MetadataFinder.getInstance().start();
            this.running.set(true);
            for (MediaDetails details : MetadataFinder.getInstance().getMountedMediaDetails()) {
                this.mediaDetailsListener.detailsAvailable(details);
            }
            MetadataFinder.getInstance().addMetadataProvider(this.metadataProvider);
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.running.set(false);
            MetadataFinder.getInstance().removeMetadataProvider(this.metadataProvider);
            for (Database database : this.databases.values()) {
                database.sourceFile.delete();
            }
            this.databases.clear();
        }
    }

    public static CrateDigger getInstance() {
        return instance;
    }

    private File createDownloadDirectory() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = "bl-" + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 1000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create download directory within 1000 attempts.");
    }

    public void addDatabaseListener(DatabaseListener listener) {
        if (listener != null) {
            this.dbListeners.add(listener);
        }
    }

    public void removeDatabaseListener(DatabaseListener listener) {
        if (listener != null) {
            this.dbListeners.remove(listener);
        }
    }

    public Set<DatabaseListener> getDatabaseListeners() {
        return Collections.unmodifiableSet(new HashSet<DatabaseListener>(this.dbListeners));
    }

    private void deliverDatabaseUpdate(SlotReference slot, Database database, boolean available) {
        for (DatabaseListener listener : this.getDatabaseListeners()) {
            try {
                if (available) {
                    listener.databaseMounted(slot, database);
                    continue;
                }
                listener.databaseUnmounted(slot, database);
            }
            catch (Throwable t) {
                this.logger.warn("Problem delivering rekordbox database availability update to listener", t);
            }
        }
    }

    private CrateDigger() {
        MetadataFinder.getInstance().addLifecycleListener(this.lifecycleListener);
        MetadataFinder.getInstance().addMountListener(this.mountListener);
        DeviceFinder.getInstance().addDeviceAnnouncementListener(this.deviceListener);
        VirtualCdj.getInstance().addMediaDetailsListener(this.mediaDetailsListener);
        this.downloadDirectory = this.createDownloadDirectory();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CrateDigger[").append("running: ").append(this.isRunning());
        if (this.isRunning()) {
            sb.append(", databases mounted: ").append(this.databases.size());
            sb.append(", download directory: ").append(this.downloadDirectory.getAbsolutePath());
            sb.append(", media using hidden PIONEER folder: ").append(this.mediaWithHiddenPioneerFolder);
        }
        return sb.append("]").toString();
    }
}

