/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CueList {
    private static final Logger logger = LoggerFactory.getLogger(CueList.class);
    public final Message rawMessage;
    public final List<ByteBuffer> rawTags;
    public final List<ByteBuffer> rawExtendedTags;
    public final List<Entry> entries;
    public static final Comparator<Entry> TIME_ONLY_COMPARATOR = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry1, Entry entry2) {
            return (int)(entry1.cuePosition - entry2.cuePosition);
        }
    };
    public static final Comparator<Entry> SORT_COMPARATOR = new Comparator<Entry>(){

        @Override
        public int compare(Entry entry1, Entry entry2) {
            int result = (int)(entry1.cuePosition - entry2.cuePosition);
            if (result == 0) {
                int h1 = entry1.hotCueNumber != 0 ? 1 : 0;
                int h2 = entry2.hotCueNumber != 0 ? 1 : 0;
                result = h1 - h2;
            }
            return result;
        }
    };

    public int getHotCueCount() {
        if (this.rawMessage != null) {
            return (int)((NumberField)this.rawMessage.arguments.get(5)).getValue();
        }
        int total = 0;
        for (Entry entry : this.entries) {
            if (entry.hotCueNumber <= 0) continue;
            ++total;
        }
        return total;
    }

    public int getMemoryPointCount() {
        if (this.rawMessage != null) {
            return (int)((NumberField)this.rawMessage.arguments.get(6)).getValue();
        }
        int total = 0;
        for (Entry entry : this.entries) {
            if (entry.hotCueNumber != 0) continue;
            ++total;
        }
        return total;
    }

    public Entry findEntryBefore(long milliseconds) {
        Entry target = new Entry(0, Util.timeToHalfFrameRounded(milliseconds), "", null, null);
        int index = Collections.binarySearch(this.entries, target, TIME_ONLY_COMPARATOR);
        if (index >= 0) {
            return this.entries.get(index);
        }
        if ((index = -(index + 1)) > 0) {
            return this.entries.get(index - 1);
        }
        return null;
    }

    public Entry findEntryAfter(long milliseconds) {
        Entry target = new Entry(0, Util.timeToHalfFrameRounded(milliseconds), "", null, null);
        int index = Collections.binarySearch(this.entries, target, TIME_ONLY_COMPARATOR);
        if (index >= 0) {
            return this.entries.get(index);
        }
        if ((index = -(index + 1)) < this.entries.size()) {
            return this.entries.get(index);
        }
        return null;
    }

    private List<Entry> sortEntries(List<Entry> loadedEntries) {
        Collections.sort(loadedEntries, SORT_COMPARATOR);
        return Collections.unmodifiableList(loadedEntries);
    }

    private void addEntriesFromTag(List<Entry> entries, RekordboxAnlz.CueTag tag) {
        for (RekordboxAnlz.CueEntry cueEntry : tag.cues()) {
            if (cueEntry.type() == RekordboxAnlz.CueEntryType.LOOP) {
                entries.add(new Entry((int)cueEntry.hotCue(), Util.timeToHalfFrame(cueEntry.time()), Util.timeToHalfFrame(cueEntry.loopTime()), "", null, null));
                continue;
            }
            entries.add(new Entry((int)cueEntry.hotCue(), Util.timeToHalfFrame(cueEntry.time()), "", null, null));
        }
    }

    private Color expectedEmbeddedColor(int colorCode) {
        switch (colorCode) {
            case 49: {
                return new Color(255, 0, 161);
            }
            case 56: {
                return new Color(131, 0, 255);
            }
            case 60: {
                return new Color(128, 0, 255);
            }
            case 62: {
                return new Color(51, 0, 255);
            }
            case 1: {
                return new Color(0, 0, 255);
            }
            case 5: {
                return new Color(80, 7, 255);
            }
            case 9: {
                return new Color(0, 224, 255);
            }
            case 14: {
                return new Color(31, 255, 163);
            }
            case 18: {
                return new Color(0, 255, 71);
            }
            case 22: {
                return new Color(26, 255, 0);
            }
            case 26: {
                return new Color(128, 255, 0);
            }
            case 30: {
                return new Color(230, 255, 0);
            }
            case 32: {
                return new Color(255, 232, 0);
            }
            case 38: {
                return new Color(255, 94, 0);
            }
            case 42: {
                return new Color(255, 0, 0);
            }
            case 45: {
                return new Color(255, 0, 115);
            }
            case 0: {
                return Color.green;
            }
        }
        return null;
    }

    private Color findEmbeddedColor(RekordboxAnlz.CueExtendedEntry entry) {
        if (entry.colorRed() == 0 && entry.colorGreen() == 0 && entry.colorBlue() == 0) {
            return null;
        }
        return new Color(entry.colorRed(), entry.colorGreen(), entry.colorBlue());
    }

    public static Color findRekordboxColor(int colorCode) {
        switch (colorCode) {
            case 49: {
                return new Color(222, 68, 207);
            }
            case 56: {
                return new Color(132, 50, 255);
            }
            case 60: {
                return new Color(170, 114, 255);
            }
            case 62: {
                return new Color(100, 115, 255);
            }
            case 1: {
                return new Color(48, 90, 255);
            }
            case 5: {
                return new Color(80, 180, 255);
            }
            case 9: {
                return new Color(0, 224, 255);
            }
            case 14: {
                return new Color(31, 163, 146);
            }
            case 18: {
                return new Color(16, 177, 118);
            }
            case 22: {
                return new Color(40, 226, 20);
            }
            case 26: {
                return new Color(162, 221, 22);
            }
            case 30: {
                return new Color(180, 190, 4);
            }
            case 32: {
                return new Color(195, 175, 4);
            }
            case 38: {
                return new Color(224, 100, 27);
            }
            case 42: {
                return new Color(229, 40, 40);
            }
            case 45: {
                return new Color(254, 18, 122);
            }
            case 0: {
                return null;
            }
        }
        logger.warn("Unrecognized rekordbox color code, " + colorCode + ", returning null.");
        return null;
    }

    private void addEntriesFromTag(List<Entry> entries, RekordboxAnlz.CueExtendedTag tag) {
        for (RekordboxAnlz.CueExtendedEntry cueEntry : tag.cues()) {
            Color embeddedColor = this.findEmbeddedColor(cueEntry);
            Color expectedColor = this.expectedEmbeddedColor(cueEntry.colorCode());
            Color rekordboxColor = CueList.findRekordboxColor(cueEntry.colorCode());
            if ((embeddedColor == null && expectedColor != null || embeddedColor != null && !embeddedColor.equals(expectedColor)) && (cueEntry.colorCode() != 0 || embeddedColor != null)) {
                logger.warn("Was expecting embedded color " + expectedColor + " for rekordbox color code " + cueEntry.colorCode() + ", but found color " + embeddedColor);
            }
            if (cueEntry.type() == RekordboxAnlz.CueEntryType.LOOP) {
                entries.add(new Entry((int)cueEntry.hotCue(), Util.timeToHalfFrame(cueEntry.time()), Util.timeToHalfFrame(cueEntry.loopTime()), cueEntry.comment(), embeddedColor, rekordboxColor));
                continue;
            }
            entries.add(new Entry((int)cueEntry.hotCue(), Util.timeToHalfFrame(cueEntry.time()), cueEntry.comment(), embeddedColor, rekordboxColor));
        }
    }

    public CueList(RekordboxAnlz anlzFile) {
        RekordboxAnlz.CueExtendedTag tag;
        this.rawMessage = null;
        ArrayList<ByteBuffer> tagBuffers = new ArrayList<ByteBuffer>(2);
        ArrayList<ByteBuffer> extendedTagBuffers = new ArrayList<ByteBuffer>(2);
        ArrayList<Entry> mutableEntries = new ArrayList<Entry>();
        for (RekordboxAnlz.TaggedSection section : anlzFile.sections()) {
            if (!(section.body() instanceof RekordboxAnlz.CueExtendedTag)) continue;
            tag = (RekordboxAnlz.CueExtendedTag)section.body();
            extendedTagBuffers.add(ByteBuffer.wrap(section._raw_body()).asReadOnlyBuffer());
            this.addEntriesFromTag(mutableEntries, tag);
        }
        for (RekordboxAnlz.TaggedSection section : anlzFile.sections()) {
            if (!(section.body() instanceof RekordboxAnlz.CueTag)) continue;
            tag = (RekordboxAnlz.CueTag)section.body();
            tagBuffers.add(ByteBuffer.wrap(section._raw_body()).asReadOnlyBuffer());
            if (!extendedTagBuffers.isEmpty()) continue;
            this.addEntriesFromTag(mutableEntries, (RekordboxAnlz.CueTag)tag);
        }
        this.entries = this.sortEntries(mutableEntries);
        this.rawTags = Collections.unmodifiableList(tagBuffers);
        this.rawExtendedTags = Collections.unmodifiableList(extendedTagBuffers);
    }

    public CueList(List<ByteBuffer> rawTags) {
        this(rawTags, Collections.emptyList());
    }

    public CueList(List<ByteBuffer> rawTags, List<ByteBuffer> rawExtendedTags) {
        this.rawMessage = null;
        this.rawTags = Collections.unmodifiableList(rawTags);
        this.rawExtendedTags = Collections.unmodifiableList(rawExtendedTags);
        ArrayList<Entry> mutableEntries = new ArrayList<Entry>();
        if (rawExtendedTags.isEmpty()) {
            for (ByteBuffer buffer : rawTags) {
                RekordboxAnlz.CueTag tag = new RekordboxAnlz.CueTag((KaitaiStream)new ByteBufferKaitaiStream(buffer));
                this.addEntriesFromTag(mutableEntries, tag);
            }
        } else {
            for (ByteBuffer buffer : rawExtendedTags) {
                RekordboxAnlz.CueExtendedTag tag = new RekordboxAnlz.CueExtendedTag((KaitaiStream)new ByteBufferKaitaiStream(buffer));
                this.addEntriesFromTag(mutableEntries, tag);
            }
        }
        this.entries = this.sortEntries(mutableEntries);
    }

    public CueList(Message message) {
        this.rawMessage = message;
        this.rawTags = null;
        this.rawExtendedTags = null;
        this.entries = message.knownType == Message.KnownType.CUE_LIST ? this.parseNexusEntries(message) : this.parseNxs2Entries(message);
    }

    private List<Entry> parseNexusEntries(Message message) {
        byte[] entryBytes = ((BinaryField)message.arguments.get(3)).getValueAsArray();
        int entryCount = entryBytes.length / 36;
        ArrayList<Entry> mutableEntries = new ArrayList<Entry>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            int offset = i * 36;
            byte cueFlag = entryBytes[offset + 1];
            byte hotCueNumber = entryBytes[offset + 2];
            if (cueFlag == 0 && hotCueNumber == 0) continue;
            long position = Util.bytesToNumberLittleEndian(entryBytes, offset + 12, 4);
            if (entryBytes[offset] != 0) {
                long endPosition = Util.bytesToNumberLittleEndian(entryBytes, offset + 16, 4);
                mutableEntries.add(new Entry(hotCueNumber, position, endPosition, "", null, null));
                continue;
            }
            mutableEntries.add(new Entry(hotCueNumber, position, "", null, null));
        }
        return this.sortEntries(mutableEntries);
    }

    private List<Entry> parseNxs2Entries(Message message) {
        byte[] entryBytes = ((BinaryField)message.arguments.get(3)).getValueAsArray();
        int entryCount = (int)((NumberField)message.arguments.get(4)).getValue();
        ArrayList<Entry> mutableEntries = new ArrayList<Entry>(entryCount);
        int offset = 0;
        for (int i = 0; i < entryCount; ++i) {
            int entrySize = (int)Util.bytesToNumberLittleEndian(entryBytes, offset, 4);
            byte cueFlag = entryBytes[offset + 6];
            byte hotCueNumber = entryBytes[offset + 4];
            if (cueFlag != 0 || hotCueNumber != 0) {
                Color embeddedColor;
                long position = Util.timeToHalfFrame(Util.bytesToNumberLittleEndian(entryBytes, offset + 12, 4));
                String comment = "";
                int commentSize = (int)Util.bytesToNumberLittleEndian(entryBytes, offset + 72, 2);
                if (commentSize > 0) {
                    try {
                        comment = new String(entryBytes, offset + 74, commentSize - 2, "UTF-16LE");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException("Java no longer supports UTF-16LE encoding?!", e);
                    }
                }
                int colorCode = Util.unsign(entryBytes[offset + commentSize + 78]);
                int red = Util.unsign(entryBytes[offset + commentSize + 79]);
                int green = Util.unsign(entryBytes[offset + commentSize + 80]);
                int blue = Util.unsign(entryBytes[offset + commentSize + 81]);
                Color rekordboxColor = CueList.findRekordboxColor(colorCode);
                Color expectedColor = this.expectedEmbeddedColor(colorCode);
                Color color = embeddedColor = red == 0 && green == 0 && blue == 0 ? null : new Color(red, green, blue);
                if ((embeddedColor == null && expectedColor != null || embeddedColor != null && !embeddedColor.equals(expectedColor)) && (colorCode != 0 || embeddedColor != null)) {
                    logger.warn("Was expecting embedded color " + expectedColor + " for rekordbox color code " + colorCode + ", but found color " + embeddedColor);
                }
                if (cueFlag == 2) {
                    long endPosition = Util.timeToHalfFrame(Util.bytesToNumberLittleEndian(entryBytes, offset + 16, 4));
                    mutableEntries.add(new Entry(hotCueNumber, position, endPosition, comment, embeddedColor, rekordboxColor));
                } else {
                    mutableEntries.add(new Entry(hotCueNumber, position, comment, embeddedColor, rekordboxColor));
                }
            }
            offset += entrySize;
        }
        return this.sortEntries(mutableEntries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CueList cueList = (CueList)o;
        return this.entries != null ? this.entries.equals(cueList.entries) : cueList.entries == null;
    }

    public int hashCode() {
        return this.entries != null ? this.entries.hashCode() : 0;
    }

    public String toString() {
        return "Cue List[entries: " + this.entries + "]";
    }

    public static class Entry {
        public final int hotCueNumber;
        public final boolean isLoop;
        public final long cuePosition;
        public final long cueTime;
        public final long loopPosition;
        public final long loopTime;
        public final String comment;
        public final Color embeddedColor;
        public final Color rekordboxColor;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.hotCueNumber != entry.hotCueNumber) {
                return false;
            }
            if (this.isLoop != entry.isLoop) {
                return false;
            }
            if (this.cuePosition != entry.cuePosition) {
                return false;
            }
            if (this.cueTime != entry.cueTime) {
                return false;
            }
            if (this.loopPosition != entry.loopPosition) {
                return false;
            }
            return this.loopTime == entry.loopTime;
        }

        public int hashCode() {
            int result = this.hotCueNumber;
            result = 31 * result + (this.isLoop ? 1 : 0);
            result = 31 * result + (int)(this.cuePosition ^ this.cuePosition >>> 32);
            result = 31 * result + (int)(this.cueTime ^ this.cueTime >>> 32);
            result = 31 * result + (int)(this.loopPosition ^ this.loopPosition >>> 32);
            result = 31 * result + (int)(this.loopTime ^ this.loopTime >>> 32);
            return result;
        }

        public Entry(int number, long position, String comment, Color embeddedColor, Color rekordboxColor) {
            if (comment == null) {
                throw new NullPointerException("comment must not be null");
            }
            this.hotCueNumber = number;
            this.cuePosition = position;
            this.cueTime = Util.halfFrameToTime(position);
            this.isLoop = false;
            this.loopPosition = 0L;
            this.loopTime = 0L;
            this.comment = comment.trim();
            this.embeddedColor = embeddedColor;
            this.rekordboxColor = rekordboxColor;
        }

        public Entry(int number, long startPosition, long endPosition, String comment, Color embeddedColor, Color rekordboxColor) {
            if (comment == null) {
                throw new NullPointerException("comment must not be null");
            }
            this.hotCueNumber = number;
            this.cuePosition = startPosition;
            this.cueTime = Util.halfFrameToTime(startPosition);
            this.isLoop = true;
            this.loopPosition = endPosition;
            this.loopTime = Util.halfFrameToTime(endPosition);
            this.comment = comment.trim();
            this.embeddedColor = embeddedColor;
            this.rekordboxColor = rekordboxColor;
        }

        public Color getNexusColor() {
            if (this.hotCueNumber > 0) {
                return Color.GREEN;
            }
            if (this.isLoop) {
                return Color.ORANGE;
            }
            return Color.RED;
        }

        public Color getColor() {
            if (this.rekordboxColor != null) {
                return this.rekordboxColor;
            }
            if (this.embeddedColor != null) {
                return this.embeddedColor;
            }
            return this.getNexusColor();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.hotCueNumber == 0) {
                if (this.isLoop) {
                    sb.append("Loop[");
                } else {
                    sb.append("Memory Point[");
                }
            } else {
                sb.append("Hot Cue ").append((char)(this.hotCueNumber + 64)).append('[');
            }
            sb.append("time ").append(this.cueTime).append("ms");
            if (this.isLoop) {
                sb.append(", loop time ").append(this.loopTime).append("ms");
            }
            if (!this.comment.isEmpty()) {
                sb.append(", comment ").append(this.comment);
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

