/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.dbserver;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.dbserver.Field;

public class BinaryField
extends Field {
    private final byte typeTag = (byte)20;
    private final int size;
    private final ByteBuffer value;
    private final ByteBuffer buffer;

    private ByteBuffer extractValue() {
        this.buffer.rewind();
        if (this.buffer.capacity() > 0) {
            this.buffer.get();
            this.buffer.getInt();
        }
        return this.buffer.slice();
    }

    public ByteBuffer getValue() {
        this.value.rewind();
        return this.value.slice();
    }

    public byte[] getValueAsArray() {
        ByteBuffer buffer = this.getValue();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    public BinaryField(DataInputStream is) throws IOException {
        byte[] sizeBytes = new byte[4];
        is.readFully(sizeBytes);
        this.size = (int)Util.bytesToNumber(sizeBytes, 0, 4);
        byte[] bufBytes = new byte[this.size + 5];
        bufBytes[0] = 20;
        System.arraycopy(sizeBytes, 0, bufBytes, 1, 4);
        is.readFully(bufBytes, 5, this.size);
        this.buffer = ByteBuffer.wrap(bufBytes).asReadOnlyBuffer();
        this.value = this.extractValue();
    }

    public BinaryField(byte[] bytes) {
        ByteBuffer scratch;
        this.size = bytes.length;
        if (this.size > 0) {
            scratch = ByteBuffer.allocate(this.size + 5);
            scratch.put((byte)20);
            scratch.putInt(this.size);
            scratch.put(bytes);
        } else {
            scratch = ByteBuffer.allocate(0);
        }
        this.buffer = scratch.asReadOnlyBuffer();
        this.value = this.extractValue();
    }

    @Override
    public byte getTypeTag() {
        return 20;
    }

    @Override
    public byte getArgumentTag() {
        return 3;
    }

    @Override
    public ByteBuffer getBytes() {
        this.buffer.rewind();
        return this.buffer.slice();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String toString() {
        return "BinaryField[ size: " + this.size + ", bytes: " + this.getHexString() + "]";
    }
}

