/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.deepsymmetry.beatlink.Beat;
import org.deepsymmetry.beatlink.BeatFinder;
import org.deepsymmetry.beatlink.BeatSender;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceReference;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.FaderStartListener;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MasterHandoffListener;
import org.deepsymmetry.beatlink.MasterListener;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.MediaDetailsListener;
import org.deepsymmetry.beatlink.MixerStatus;
import org.deepsymmetry.beatlink.OnAirListener;
import org.deepsymmetry.beatlink.PlayerSettings;
import org.deepsymmetry.beatlink.SyncListener;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.electro.Metronome;
import org.deepsymmetry.electro.Snapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualCdj
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(VirtualCdj.class);
    public static final int UPDATE_PORT = 50002;
    public static final int MAC_ADDRESS_OFFSET = 38;
    private final AtomicReference<DatagramSocket> socket = new AtomicReference();
    private final AtomicReference<InetAddress> broadcastAddress = new AtomicReference();
    private final Map<DeviceReference, DeviceUpdate> updates = new ConcurrentHashMap<DeviceReference, DeviceUpdate>();
    private final AtomicBoolean useStandardPlayerNumber = new AtomicBoolean(false);
    private final AtomicInteger announceInterval = new AtomicInteger(1500);
    private static final byte[] keepAliveBytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 6, 0, 98, 101, 97, 116, 45, 108, 105, 110, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0};
    public static final int DEVICE_NAME_OFFSET = 12;
    public static final int DEVICE_NAME_LENGTH = 20;
    public static final int DEVICE_NUMBER_OFFSET = 36;
    private static final byte[] helloBytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 10, 0, 98, 101, 97, 116, 45, 108, 105, 110, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 37, 1};
    private static final byte[] claimStage1bytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 0, 0, 98, 101, 97, 116, 45, 108, 105, 110, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 44, 13, 1, 0, 0, 0, 0, 0, 0};
    private static final byte[] claimStage2bytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 2, 0, 98, 101, 97, 116, 45, 108, 105, 110, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 1, 0};
    private static final byte[] claimStage3bytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 4, 0, 98, 101, 97, 116, 45, 108, 105, 110, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 38, 13, 0};
    private static final byte[] assignmentRequestBytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 2, 1, 98, 101, 97, 116, 45, 108, 105, 110, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0};
    private static final byte[] deviceNumberDefenseBytes = new byte[]{81, 115, 112, 116, 49, 87, 109, 74, 79, 76, 8, 0, 98, 101, 97, 116, 45, 108, 105, 110, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 41, 0, 0, 0, 0, 0};
    private final AtomicReference<DeviceUpdate> tempoMaster = new AtomicReference();
    private final AtomicLong tempoEpsilon = new AtomicLong(Double.doubleToLongBits(1.0E-4));
    private final AtomicLong masterTempo = new AtomicLong();
    private static final long SELF_ASSIGNMENT_WATCH_PERIOD = 4000L;
    private List<NetworkInterface> matchingInterfaces = null;
    private InterfaceAddress matchedAddress = null;
    private final AtomicInteger claimingNumber = new AtomicInteger(0);
    private final AtomicBoolean claimRejected = new AtomicBoolean(false);
    private final AtomicInteger mixerAssigned = new AtomicInteger(0);
    private final LifecycleListener deviceFinderLifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("VirtualCDJ doesn't have anything to do when the DeviceFinder starts");
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (VirtualCdj.this.isRunning()) {
                logger.info("VirtualCDJ stopping because DeviceFinder has stopped.");
                VirtualCdj.this.stop();
            }
        }
    };
    private final Set<MasterListener> masterListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<DeviceUpdateListener> updateListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<MediaDetailsListener> detailsListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final byte[] MEDIA_QUERY_PAYLOAD = new byte[]{1, 0, 13, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] SYNC_CONTROL_PAYLOAD = new byte[]{1, 0, 13, 0, 8, 0, 0, 0, 13, 0, 0, 0, 15};
    private static final byte[] FADER_START_PAYLOAD = new byte[]{1, 0, 13, 0, 4, 2, 2, 2, 2};
    private static final byte[] CHANNELS_ON_AIR_PAYLOAD = new byte[]{1, 0, 13, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] LOAD_TRACK_PAYLOAD = new byte[]{1, 0, 13, 0, 52, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] YIELD_ACK_PAYLOAD = new byte[]{1, 0, 13, 0, 8, 0, 0, 0, 13, 0, 0, 0, 1};
    private static final byte[] LOAD_SETTINGS_PAYLOAD = new byte[]{2, 13, 13, 0, 80, 18, 52, 86, 120, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int statusInterval = 200;
    private final LifecycleListener beatFinderLifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("VirtualCDJ doesn't have anything to do when the BeatFinder starts");
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (VirtualCdj.this.isSendingStatus()) {
                logger.info("VirtualCDJ no longer sending status updates because BeatFinder has stopped.");
                try {
                    VirtualCdj.this.setSendingStatus(false);
                }
                catch (Exception e) {
                    logger.error("Problem stopping sending status packets when the BeatFinder stopped", (Throwable)e);
                }
            }
        }
    };
    private final AtomicReference<BeatSender> beatSender = new AtomicReference();
    private static final byte[] BEAT_PAYLOAD = new byte[]{1, 0, 13, 0, 60, 1, 1, 1, 1, 2, 2, 2, 2, 16, 16, 16, 16, 4, 4, 4, 4, 32, 32, 32, 32, 8, 8, 8, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 16, 0, 0, 0, 0, 0, 0, 11, 0, 0, 13};
    private AtomicBoolean sendingStatus = null;
    private final Metronome metronome = new Metronome();
    private final AtomicReference<Snapshot> whereStopped = new AtomicReference<Snapshot>(this.metronome.getSnapshot(this.metronome.getStartTime()));
    private final AtomicBoolean playing = new AtomicBoolean(false);
    private final AtomicBoolean master = new AtomicBoolean(false);
    private static final byte[] MASTER_HANDOFF_REQUEST_PAYLOAD = new byte[]{1, 0, 13, 0, 4, 0, 0, 0, 13};
    private final AtomicInteger requestingMasterRoleFromPlayer = new AtomicInteger(0);
    private final MasterListener ourSyncMasterListener = new MasterListener(){

        @Override
        public void masterChanged(DeviceUpdate update) {
        }

        @Override
        public void tempoChanged(double tempo) {
            if (!VirtualCdj.this.isTempoMaster()) {
                VirtualCdj.this.metronome.setTempo(tempo);
            }
        }

        @Override
        public void newBeat(Beat beat) {
            if (!VirtualCdj.this.isTempoMaster()) {
                VirtualCdj.this.metronome.setBeatPhase(0.0);
            }
        }
    };
    private final AtomicBoolean synced = new AtomicBoolean(false);
    private final AtomicBoolean onAir = new AtomicBoolean(false);
    public final int MAX_BEAT = 65536;
    private final AtomicInteger syncCounter = new AtomicInteger(1);
    private final AtomicInteger largestSyncCounter = new AtomicInteger(1);
    private final AtomicInteger nextMaster = new AtomicInteger(255);
    private final AtomicInteger masterYieldedFrom = new AtomicInteger(0);
    private final AtomicInteger packetCounter = new AtomicInteger(0);
    private static final byte[] STATUS_PAYLOAD = new byte[]{1, 4, 0, 0, -8, 0, 0, 1, 0, 0, 3, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, -96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 0, 0, 0, 4, 0, 0, 0, 4, 0, 1, 0, 0, 0, 0, 0, 0, 49, 46, 52, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 16, 0, 0, -128, 0, 0, 0, 127, -1, -1, -1, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 15, 1, 0, 0, 18, 52, 86, 120, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 7, 97, 0, 0, 6, 47};
    private static final VirtualCdj ourInstance = new VirtualCdj();

    @Override
    public boolean isRunning() {
        return this.socket.get() != null && this.claimingNumber.get() == 0;
    }

    public InetAddress getLocalAddress() {
        this.ensureRunning();
        return this.socket.get().getLocalAddress();
    }

    public InetAddress getBroadcastAddress() {
        this.ensureRunning();
        return this.broadcastAddress.get();
    }

    public void setUseStandardPlayerNumber(boolean attempt) {
        this.useStandardPlayerNumber.set(attempt);
    }

    public boolean getUseStandardPlayerNumber() {
        return this.useStandardPlayerNumber.get();
    }

    public synchronized byte getDeviceNumber() {
        return keepAliveBytes[36];
    }

    public synchronized void setDeviceNumber(byte number) {
        if (this.isRunning()) {
            throw new IllegalStateException("Can't change device number once started.");
        }
        VirtualCdj.keepAliveBytes[36] = number;
    }

    public int getAnnounceInterval() {
        return this.announceInterval.get();
    }

    public void setAnnounceInterval(int interval) {
        if (interval < 200 || interval > 2000) {
            throw new IllegalArgumentException("Interval must be between 200 and 2000");
        }
        this.announceInterval.set(interval);
    }

    public static String getDeviceName() {
        return new String(keepAliveBytes, 12, 20).trim();
    }

    public synchronized void setDeviceName(String name) {
        if (name.getBytes().length > 20) {
            throw new IllegalArgumentException("name cannot be more than 20 bytes long");
        }
        Arrays.fill(keepAliveBytes, 12, 20, (byte)0);
        System.arraycopy(name.getBytes(), 0, keepAliveBytes, 12, name.getBytes().length);
    }

    public DeviceUpdate getTempoMaster() {
        this.ensureRunning();
        return this.tempoMaster.get();
    }

    private void setTempoMaster(DeviceUpdate newMaster) {
        DeviceUpdate oldMaster = this.tempoMaster.getAndSet(newMaster);
        if (newMaster == null && oldMaster != null || newMaster != null && (oldMaster == null || !newMaster.getAddress().equals(oldMaster.getAddress()) || newMaster.getDeviceNumber() != oldMaster.getDeviceNumber())) {
            this.deliverMasterChangedAnnouncement(newMaster);
        }
    }

    public double getTempoEpsilon() {
        return Double.longBitsToDouble(this.tempoEpsilon.get());
    }

    public void setTempoEpsilon(double epsilon) {
        this.tempoEpsilon.set(Double.doubleToLongBits(epsilon));
    }

    public double getMasterTempo() {
        this.ensureRunning();
        return Double.longBitsToDouble(this.masterTempo.get());
    }

    private void setMasterTempo(double newTempo) {
        double oldTempo = Double.longBitsToDouble(this.masterTempo.getAndSet(Double.doubleToLongBits(newTempo)));
        if (this.getTempoMaster() != null && Math.abs(newTempo - oldTempo) > this.getTempoEpsilon()) {
            if (this.isSynced()) {
                this.metronome.setTempo(newTempo);
                this.notifyBeatSenderOfChange();
            }
            this.deliverTempoChangedAnnouncement(newTempo);
        }
    }

    private DeviceUpdate buildUpdate(DatagramPacket packet) {
        int length = packet.getLength();
        Util.PacketType kind = Util.validateHeader(packet, 50002);
        if (kind == null) {
            logger.warn("Ignoring unrecognized packet sent to update port.");
            return null;
        }
        switch (kind) {
            case MIXER_STATUS: {
                if (length != 56) {
                    logger.warn("Processing a Mixer Status packet with unexpected length " + length + ", expected 56 bytes.");
                }
                if (length >= 56) {
                    return new MixerStatus(packet);
                }
                logger.warn("Ignoring too-short Mixer Status packet.");
                return null;
            }
            case CDJ_STATUS: {
                if (length >= 204) {
                    return new CdjStatus(packet);
                }
                logger.warn("Ignoring too-short CDJ Status packet with length " + length + " (we need " + 204 + " bytes).");
                return null;
            }
            case LOAD_TRACK_ACK: {
                logger.info("Received track load acknowledgment from player " + packet.getData()[33]);
                return null;
            }
            case MEDIA_QUERY: {
                logger.warn("Received a media query packet, we don\u2019t yet support responding to this.");
                return null;
            }
            case MEDIA_RESPONSE: {
                this.deliverMediaDetailsUpdate(new MediaDetails(packet));
                return null;
            }
        }
        logger.warn("Ignoring " + kind.name + " packet sent to update port.");
        return null;
    }

    private void processUpdate(DeviceUpdate update) {
        int syncNumber;
        this.updates.put(DeviceReference.getDeviceReference(update), update);
        if (update instanceof CdjStatus && (syncNumber = ((CdjStatus)update).getSyncNumber()) > this.largestSyncCounter.get()) {
            this.largestSyncCounter.set(syncNumber);
        }
        if (update.isTempoMaster()) {
            Integer packetYieldingTo = update.getDeviceMasterIsBeingYieldedTo();
            if (packetYieldingTo == null) {
                if (this.master.get()) {
                    if (this.nextMaster.get() == update.deviceNumber) {
                        this.syncCounter.set(this.largestSyncCounter.get() + 1);
                    } else if (this.nextMaster.get() == 255) {
                        logger.warn("Saw master asserted by player " + update.deviceNumber + " when we were not yielding it.");
                    } else {
                        logger.warn("Expected to yield master role to player " + this.nextMaster.get() + " but saw master asserted by player " + update.deviceNumber);
                    }
                }
                this.master.set(false);
                this.nextMaster.set(255);
                this.setTempoMaster(update);
                if (update.getBpm() != 65535) {
                    this.setMasterTempo(update.getEffectiveTempo());
                }
            } else if (packetYieldingTo.intValue() == this.getDeviceNumber()) {
                if (update.deviceNumber != this.masterYieldedFrom.get()) {
                    if (this.masterYieldedFrom.get() == 0) {
                        logger.info("Accepting unsolicited Master yield; we must be the only synced device playing.");
                    } else {
                        logger.warn("Expected player " + this.masterYieldedFrom.get() + " to yield master to us, but player " + update.deviceNumber + " did.");
                    }
                }
                this.master.set(true);
                this.masterYieldedFrom.set(0);
                this.setTempoMaster(null);
                this.setMasterTempo(this.getTempo());
            }
        } else {
            DeviceUpdate oldMaster = this.getTempoMaster();
            if (oldMaster != null && oldMaster.getAddress().equals(update.getAddress()) && oldMaster.getDeviceNumber() == update.getDeviceNumber()) {
                this.setTempoMaster(null);
            }
        }
        this.deliverDeviceUpdate(update);
    }

    void processBeat(Beat beat) {
        if (this.isRunning() && beat.isTempoMaster()) {
            this.setMasterTempo(beat.getEffectiveTempo());
            this.deliverBeatAnnouncement(beat);
        }
    }

    private InterfaceAddress findMatchingAddress(DeviceAnnouncement aDevice, NetworkInterface networkInterface) {
        for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
            if (address.getBroadcast() == null || !Util.sameNetwork(address.getNetworkPrefixLength(), aDevice.getAddress(), address.getAddress())) continue;
            return address;
        }
        return null;
    }

    private boolean selfAssignDeviceNumber() {
        int startingNumber;
        long started;
        long now = System.currentTimeMillis();
        if (now - (started = DeviceFinder.getInstance().getFirstDeviceTime()) < 4000L) {
            try {
                Thread.sleep(4000L - (now - started));
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted waiting to self-assign device number, giving up.");
                return false;
            }
        }
        if (this.claimingNumber.get() == 0 && !this.getUseStandardPlayerNumber()) {
            this.claimingNumber.set(4);
        }
        HashSet<Integer> numbersUsed = new HashSet<Integer>();
        for (DeviceAnnouncement device : DeviceFinder.getInstance().getCurrentDevices()) {
            numbersUsed.add(device.getDeviceNumber());
        }
        for (int result = startingNumber = this.claimingNumber.get() + 1; result < 16; ++result) {
            if (numbersUsed.contains(result)) continue;
            this.claimingNumber.set(result);
            if (this.getUseStandardPlayerNumber() && result > 4) {
                logger.warn("Unable to self-assign a standard player number, all are in use. Trying number " + result + ".");
            }
            return true;
        }
        logger.warn("Found no unused device numbers between " + startingNumber + " and 15, giving up.");
        return false;
    }

    public List<NetworkInterface> getMatchingInterfaces() {
        this.ensureRunning();
        return Collections.unmodifiableList(this.matchingInterfaces);
    }

    private void requestNumberFromMixer(InetAddress mixerAddress) {
        DatagramSocket currentSocket = this.socket.get();
        if (currentSocket == null) {
            logger.warn("Gave up before sending device number request to mixer.");
            return;
        }
        Arrays.fill(assignmentRequestBytes, 12, 20, (byte)0);
        System.arraycopy(VirtualCdj.getDeviceName().getBytes(), 0, assignmentRequestBytes, 12, VirtualCdj.getDeviceName().getBytes().length);
        System.arraycopy(this.matchedAddress.getAddress().getAddress(), 0, assignmentRequestBytes, 36, 4);
        System.arraycopy(keepAliveBytes, 38, assignmentRequestBytes, 40, 6);
        VirtualCdj.assignmentRequestBytes[49] = keepAliveBytes[36] == 0 ? 1 : 2;
        VirtualCdj.assignmentRequestBytes[47] = 1;
        try {
            DatagramPacket announcement = new DatagramPacket(assignmentRequestBytes, assignmentRequestBytes.length, mixerAddress, 50000);
            logger.debug("Sending device number request to mixer at address " + announcement.getAddress().getHostAddress() + ", port " + announcement.getPort());
            currentSocket.send(announcement);
        }
        catch (Exception e) {
            logger.warn("Unable to send device number request to mixer.", (Throwable)e);
        }
    }

    void defendDeviceNumber(InetAddress invaderAddress) {
        DatagramSocket currentSocket = this.socket.get();
        if (currentSocket == null) {
            logger.warn("Went offline before we could defend our device number.");
            return;
        }
        Arrays.fill(deviceNumberDefenseBytes, 12, 20, (byte)0);
        System.arraycopy(VirtualCdj.getDeviceName().getBytes(), 0, deviceNumberDefenseBytes, 12, VirtualCdj.getDeviceName().getBytes().length);
        VirtualCdj.deviceNumberDefenseBytes[36] = keepAliveBytes[36];
        System.arraycopy(this.matchedAddress.getAddress().getAddress(), 0, deviceNumberDefenseBytes, 37, 4);
        try {
            DatagramPacket defense = new DatagramPacket(deviceNumberDefenseBytes, deviceNumberDefenseBytes.length, invaderAddress, 50000);
            logger.info("Sending device number defense packet to invader at address " + defense.getAddress().getHostAddress() + ", port " + defense.getPort());
            currentSocket.send(defense);
        }
        catch (Exception e) {
            logger.error("Unable to send device defense packet.", (Throwable)e);
        }
    }

    private boolean claimDeviceNumber() {
        this.claimRejected.set(false);
        this.mixerAssigned.set(0);
        Arrays.fill(helloBytes, 12, 20, (byte)0);
        System.arraycopy(VirtualCdj.getDeviceName().getBytes(), 0, helloBytes, 12, VirtualCdj.getDeviceName().getBytes().length);
        for (int i = 1; i <= 3; ++i) {
            try {
                logger.debug("Sending hello packet " + i);
                DatagramPacket announcement = new DatagramPacket(helloBytes, helloBytes.length, this.broadcastAddress.get(), 50000);
                this.socket.get().send(announcement);
                Thread.sleep(300L);
                continue;
            }
            catch (Exception e) {
                logger.warn("Unable to send hello packet to network, failing to go online.", (Throwable)e);
                return false;
            }
        }
        this.claimingNumber.set(this.getDeviceNumber());
        boolean claimed = false;
        block9: while (!claimed) {
            DatagramPacket announcement;
            int i;
            if (this.getDeviceNumber() == 0 && !this.selfAssignDeviceNumber()) {
                this.claimingNumber.set(0);
                return false;
            }
            Arrays.fill(claimStage1bytes, 12, 20, (byte)0);
            System.arraycopy(VirtualCdj.getDeviceName().getBytes(), 0, claimStage1bytes, 12, VirtualCdj.getDeviceName().getBytes().length);
            System.arraycopy(keepAliveBytes, 38, claimStage1bytes, 38, 6);
            for (i = 1; i <= 3 && this.mixerAssigned.get() == 0; ++i) {
                VirtualCdj.claimStage1bytes[36] = (byte)i;
                try {
                    logger.debug("Sending claim stage 1 packet " + i);
                    announcement = new DatagramPacket(claimStage1bytes, claimStage1bytes.length, this.broadcastAddress.get(), 50000);
                    this.socket.get().send(announcement);
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    logger.warn("Unable to send device number claim stage 1 packet to network, failing to go online.", (Throwable)e);
                    this.claimingNumber.set(0);
                    return false;
                }
                if (!this.claimRejected.get()) continue;
                if (this.getDeviceNumber() == 0) continue block9;
                logger.warn("Unable to use device number " + this.getDeviceNumber() + ", another device has it. Failing to go online.");
                this.claimingNumber.set(0);
                return false;
            }
            Arrays.fill(claimStage2bytes, 12, 20, (byte)0);
            System.arraycopy(VirtualCdj.getDeviceName().getBytes(), 0, claimStage2bytes, 12, VirtualCdj.getDeviceName().getBytes().length);
            System.arraycopy(this.matchedAddress.getAddress().getAddress(), 0, claimStage2bytes, 36, 4);
            System.arraycopy(keepAliveBytes, 38, claimStage2bytes, 40, 6);
            VirtualCdj.claimStage2bytes[46] = (byte)this.claimingNumber.get();
            VirtualCdj.claimStage2bytes[49] = this.getDeviceNumber() == 0 ? 1 : 2;
            for (i = 1; i <= 3 && this.mixerAssigned.get() == 0; ++i) {
                VirtualCdj.claimStage2bytes[47] = (byte)i;
                try {
                    logger.debug("Sending claim stage 2 packet " + i + " for device " + claimStage2bytes[46]);
                    announcement = new DatagramPacket(claimStage2bytes, claimStage2bytes.length, this.broadcastAddress.get(), 50000);
                    this.socket.get().send(announcement);
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    logger.warn("Unable to send device number claim stage 2 packet to network, failing to go online.", (Throwable)e);
                    this.claimingNumber.set(0);
                    return false;
                }
                if (!this.claimRejected.get()) continue;
                if (this.getDeviceNumber() == 0) continue block9;
                logger.warn("Unable to use device number " + this.getDeviceNumber() + ", another device has it. Failing to go online.");
                this.claimingNumber.set(0);
                return false;
            }
            int assigned = this.mixerAssigned.getAndSet(0);
            if (assigned > 0) {
                this.claimingNumber.set(assigned);
            }
            Arrays.fill(claimStage3bytes, 12, 20, (byte)0);
            System.arraycopy(VirtualCdj.getDeviceName().getBytes(), 0, claimStage3bytes, 12, VirtualCdj.getDeviceName().getBytes().length);
            VirtualCdj.claimStage3bytes[36] = (byte)this.claimingNumber.get();
            for (int i2 = 1; i2 <= 3 && this.mixerAssigned.get() == 0; ++i2) {
                VirtualCdj.claimStage3bytes[37] = (byte)i2;
                try {
                    logger.debug("Sending claim stage 3 packet " + i2 + " for device " + claimStage3bytes[36]);
                    DatagramPacket announcement2 = new DatagramPacket(claimStage3bytes, claimStage3bytes.length, this.broadcastAddress.get(), 50000);
                    this.socket.get().send(announcement2);
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    logger.warn("Unable to send device number claim stage 3 packet to network, failing to go online.", (Throwable)e);
                    this.claimingNumber.set(0);
                    return false;
                }
                if (!this.claimRejected.get()) continue;
                if (this.getDeviceNumber() == 0) continue block9;
                logger.warn("Unable to use device number " + this.getDeviceNumber() + ", another device has it. Failing to go online.");
                this.claimingNumber.set(0);
                return false;
            }
            claimed = true;
        }
        VirtualCdj.keepAliveBytes[36] = (byte)this.claimingNumber.getAndSet(0);
        this.mixerAssigned.set(0);
        return true;
    }

    private boolean createVirtualCdj() throws SocketException {
        this.matchingInterfaces = new ArrayList<NetworkInterface>();
        this.matchedAddress = null;
        DeviceAnnouncement aDevice = DeviceFinder.getInstance().getCurrentDevices().iterator().next();
        for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            InterfaceAddress candidate = this.findMatchingAddress(aDevice, networkInterface);
            if (candidate == null) continue;
            if (this.matchedAddress == null) {
                this.matchedAddress = candidate;
            }
            this.matchingInterfaces.add(networkInterface);
        }
        if (this.matchedAddress == null) {
            logger.warn("Unable to find network interface to communicate with " + aDevice + ", giving up.");
            return false;
        }
        logger.info("Found matching network interface " + this.matchingInterfaces.get(0).getDisplayName() + " (" + this.matchingInterfaces.get(0).getName() + "), will use address " + this.matchedAddress);
        if (this.matchingInterfaces.size() > 1) {
            ListIterator<NetworkInterface> it = this.matchingInterfaces.listIterator(1);
            while (it.hasNext()) {
                NetworkInterface extra = it.next();
                logger.warn("Network interface " + extra.getDisplayName() + " (" + extra.getName() + ") sees same network: we will likely get duplicate DJ Link packets, causing severe problems.");
            }
        }
        System.arraycopy(this.matchingInterfaces.get(0).getHardwareAddress(), 0, keepAliveBytes, 38, 6);
        System.arraycopy(this.matchedAddress.getAddress().getAddress(), 0, keepAliveBytes, 44, 4);
        this.broadcastAddress.set(this.matchedAddress.getBroadcast());
        this.socket.set(new DatagramSocket(50002, this.matchedAddress.getAddress()));
        DeviceFinder.getInstance().addIgnoredAddress(this.socket.get().getLocalAddress());
        if (!this.claimDeviceNumber()) {
            logger.warn("Unable to allocate a device number for the Virtual CDJ, giving up.");
            DeviceFinder.getInstance().removeIgnoredAddress(this.socket.get().getLocalAddress());
            this.socket.get().close();
            this.socket.set(null);
            return false;
        }
        byte[] buffer = new byte[512];
        final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        Thread receiver = new Thread(null, new Runnable(){

            @Override
            public void run() {
                while (VirtualCdj.this.isRunning()) {
                    boolean received;
                    try {
                        ((DatagramSocket)VirtualCdj.this.socket.get()).receive(packet);
                        received = true;
                    }
                    catch (IOException e) {
                        if (VirtualCdj.this.isRunning()) {
                            logger.warn("Problem reading from DeviceStatus socket, flushing DeviceFinder due to likely network change and shutting down.", (Throwable)e);
                            DeviceFinder.getInstance().flush();
                            VirtualCdj.this.stop();
                        }
                        received = false;
                    }
                    try {
                        DeviceUpdate update;
                        if (!received || packet.getAddress() == ((DatagramSocket)VirtualCdj.this.socket.get()).getLocalAddress() || (update = VirtualCdj.this.buildUpdate(packet)) == null) continue;
                        VirtualCdj.this.processUpdate(update);
                    }
                    catch (Throwable t) {
                        logger.warn("Problem processing device update packet", t);
                    }
                }
            }
        }, "beat-link VirtualCdj status receiver");
        receiver.setDaemon(true);
        receiver.setPriority(10);
        receiver.start();
        Thread announcer = new Thread(null, new Runnable(){

            @Override
            public void run() {
                while (VirtualCdj.this.isRunning()) {
                    VirtualCdj.this.sendAnnouncement((InetAddress)VirtualCdj.this.broadcastAddress.get());
                }
            }
        }, "beat-link VirtualCdj announcement sender");
        announcer.setDaemon(true);
        announcer.start();
        this.deliverLifecycleAnnouncement(logger, true);
        return true;
    }

    public Set<DeviceAnnouncement> findUnreachablePlayers() {
        this.ensureRunning();
        HashSet<DeviceAnnouncement> result = new HashSet<DeviceAnnouncement>();
        for (DeviceAnnouncement candidate : DeviceFinder.getInstance().getCurrentDevices()) {
            if (Util.sameNetwork(this.matchedAddress.getNetworkPrefixLength(), this.matchedAddress.getAddress(), candidate.getAddress())) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableSet(result);
    }

    public synchronized boolean start() throws SocketException {
        if (!this.isRunning()) {
            DeviceFinder.getInstance().addLifecycleListener(this.deviceFinderLifecycleListener);
            DeviceFinder.getInstance().start();
            for (int i = 0; DeviceFinder.getInstance().getCurrentDevices().isEmpty() && i < 20; ++i) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted waiting for devices, giving up", (Throwable)e);
                    return false;
                }
            }
            if (DeviceFinder.getInstance().getCurrentDevices().isEmpty()) {
                logger.warn("No DJ Link devices found, giving up");
                return false;
            }
            return this.createVirtualCdj();
        }
        return true;
    }

    public synchronized boolean start(byte deviceNumber) throws SocketException {
        if (!this.isRunning()) {
            this.setDeviceNumber(deviceNumber);
            return this.start();
        }
        return true;
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            try {
                this.setSendingStatus(false);
            }
            catch (Throwable t) {
                logger.error("Problem stopping sending status during shutdown", t);
            }
            DeviceFinder.getInstance().removeIgnoredAddress(this.socket.get().getLocalAddress());
            this.socket.get().close();
            this.socket.set(null);
            this.broadcastAddress.set(null);
            this.updates.clear();
            this.setTempoMaster(null);
            this.setDeviceNumber((byte)0);
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    private void sendAnnouncement(InetAddress broadcastAddress) {
        try {
            DatagramPacket announcement = new DatagramPacket(keepAliveBytes, keepAliveBytes.length, broadcastAddress, 50000);
            this.socket.get().send(announcement);
            Thread.sleep(this.getAnnounceInterval());
        }
        catch (Throwable t) {
            logger.warn("Unable to send announcement packet, flushing DeviceFinder due to likely network change and shutting down.", t);
            DeviceFinder.getInstance().flush();
            this.stop();
        }
    }

    public Set<DeviceUpdate> getLatestStatus() {
        this.ensureRunning();
        HashSet<DeviceUpdate> result = new HashSet<DeviceUpdate>();
        long now = System.currentTimeMillis();
        for (DeviceUpdate update : this.updates.values()) {
            if (now - update.getTimestamp() > 10000L) continue;
            result.add(update);
        }
        return Collections.unmodifiableSet(result);
    }

    public DeviceUpdate getLatestStatusFor(DeviceUpdate device) {
        this.ensureRunning();
        return this.updates.get(DeviceReference.getDeviceReference(device));
    }

    public DeviceUpdate getLatestStatusFor(DeviceAnnouncement device) {
        this.ensureRunning();
        return this.updates.get(DeviceReference.getDeviceReference(device));
    }

    public DeviceUpdate getLatestStatusFor(int deviceNumber) {
        this.ensureRunning();
        for (DeviceUpdate update : this.updates.values()) {
            if (update.getDeviceNumber() != deviceNumber) continue;
            return update;
        }
        return null;
    }

    public void addMasterListener(MasterListener listener) {
        if (listener != null) {
            this.masterListeners.add(listener);
        }
    }

    public void removeMasterListener(MasterListener listener) {
        if (listener != null) {
            this.masterListeners.remove(listener);
        }
    }

    public Set<MasterListener> getMasterListeners() {
        return Collections.unmodifiableSet(new HashSet<MasterListener>(this.masterListeners));
    }

    private void deliverMasterChangedAnnouncement(DeviceUpdate update) {
        for (MasterListener listener : this.getMasterListeners()) {
            try {
                listener.masterChanged(update);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering master changed announcement to listener", t);
            }
        }
    }

    private void deliverTempoChangedAnnouncement(double tempo) {
        for (MasterListener listener : this.getMasterListeners()) {
            try {
                listener.tempoChanged(tempo);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering tempo changed announcement to listener", t);
            }
        }
    }

    private void deliverBeatAnnouncement(Beat beat) {
        for (MasterListener listener : this.getMasterListeners()) {
            try {
                listener.newBeat(beat);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering master beat announcement to listener", t);
            }
        }
    }

    public void addUpdateListener(DeviceUpdateListener listener) {
        if (listener != null) {
            this.updateListeners.add(listener);
        }
    }

    public void removeUpdateListener(DeviceUpdateListener listener) {
        if (listener != null) {
            this.updateListeners.remove(listener);
        }
    }

    public Set<DeviceUpdateListener> getUpdateListeners() {
        return Collections.unmodifiableSet(new HashSet<DeviceUpdateListener>(this.updateListeners));
    }

    private void deliverDeviceUpdate(DeviceUpdate update) {
        for (DeviceUpdateListener listener : this.getUpdateListeners()) {
            try {
                listener.received(update);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering device update to listener", t);
            }
        }
    }

    public void addMediaDetailsListener(MediaDetailsListener listener) {
        if (listener != null) {
            this.detailsListeners.add(listener);
        }
    }

    public void removeMediaDetailsListener(MediaDetailsListener listener) {
        if (listener != null) {
            this.detailsListeners.remove(listener);
        }
    }

    public Set<MediaDetailsListener> getMediaDetailsListeners() {
        return Collections.unmodifiableSet(new HashSet<MediaDetailsListener>(this.detailsListeners));
    }

    private void deliverMediaDetailsUpdate(MediaDetails details) {
        for (MediaDetailsListener listener : this.getMediaDetailsListeners()) {
            try {
                listener.detailsAvailable(details);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering media details response to listener", t);
            }
        }
    }

    private void assembleAndSendPacket(Util.PacketType kind, byte[] payload, InetAddress destination, int port) throws IOException {
        DatagramPacket packet = Util.buildPacket(kind, ByteBuffer.wrap(keepAliveBytes, 12, 20).asReadOnlyBuffer(), ByteBuffer.wrap(payload));
        packet.setAddress(destination);
        packet.setPort(port);
        this.socket.get().send(packet);
    }

    public void sendMediaQuery(SlotReference slot) throws IOException {
        DeviceAnnouncement announcement = DeviceFinder.getInstance().getLatestAnnouncementFrom(slot.player);
        if (announcement == null) {
            throw new IllegalArgumentException("Device for " + slot + " not found on network.");
        }
        this.ensureRunning();
        byte[] payload = new byte[MEDIA_QUERY_PAYLOAD.length];
        System.arraycopy(MEDIA_QUERY_PAYLOAD, 0, payload, 0, MEDIA_QUERY_PAYLOAD.length);
        payload[2] = this.getDeviceNumber();
        System.arraycopy(keepAliveBytes, 44, payload, 5, 4);
        payload[12] = (byte)slot.player;
        payload[16] = slot.slot.protocolValue;
        this.assembleAndSendPacket(Util.PacketType.MEDIA_QUERY, payload, announcement.getAddress(), 50002);
    }

    private void sendSyncControlCommand(DeviceUpdate target, byte command) throws IOException {
        this.ensureRunning();
        byte[] payload = new byte[SYNC_CONTROL_PAYLOAD.length];
        System.arraycopy(SYNC_CONTROL_PAYLOAD, 0, payload, 0, SYNC_CONTROL_PAYLOAD.length);
        payload[2] = this.getDeviceNumber();
        payload[8] = this.getDeviceNumber();
        payload[12] = command;
        this.assembleAndSendPacket(Util.PacketType.SYNC_CONTROL, payload, target.getAddress(), 50001);
    }

    public void sendSyncModeCommand(int deviceNumber, boolean synced) throws IOException {
        DeviceUpdate update = this.getLatestStatusFor(deviceNumber);
        if (update == null) {
            throw new IllegalArgumentException("Device " + deviceNumber + " not found on network.");
        }
        this.sendSyncModeCommand(update, synced);
    }

    public void sendSyncModeCommand(DeviceUpdate target, boolean synced) throws IOException {
        this.sendSyncControlCommand(target, synced ? (byte)16 : 32);
    }

    public void appointTempoMaster(int deviceNumber) throws IOException {
        DeviceUpdate update = this.getLatestStatusFor(deviceNumber);
        if (update == null) {
            throw new IllegalArgumentException("Device " + deviceNumber + " not found on network.");
        }
        this.appointTempoMaster(update);
    }

    public void appointTempoMaster(DeviceUpdate target) throws IOException {
        this.sendSyncControlCommand(target, (byte)1);
    }

    public void sendFaderStartCommand(Set<Integer> deviceNumbersToStart, Set<Integer> deviceNumbersToStop) throws IOException {
        this.ensureRunning();
        byte[] payload = new byte[FADER_START_PAYLOAD.length];
        System.arraycopy(FADER_START_PAYLOAD, 0, payload, 0, FADER_START_PAYLOAD.length);
        payload[2] = this.getDeviceNumber();
        for (int i = 1; i <= 4; ++i) {
            if (deviceNumbersToStart.contains(i)) {
                payload[i + 4] = 0;
            }
            if (!deviceNumbersToStop.contains(i)) continue;
            payload[i + 4] = 1;
        }
        this.assembleAndSendPacket(Util.PacketType.FADER_START_COMMAND, payload, this.getBroadcastAddress(), 50001);
    }

    public void sendOnAirCommand(Set<Integer> deviceNumbersOnAir) throws IOException {
        this.ensureRunning();
        byte[] payload = new byte[CHANNELS_ON_AIR_PAYLOAD.length];
        System.arraycopy(CHANNELS_ON_AIR_PAYLOAD, 0, payload, 0, CHANNELS_ON_AIR_PAYLOAD.length);
        payload[2] = this.getDeviceNumber();
        for (int i = 1; i <= 4; ++i) {
            if (!deviceNumbersOnAir.contains(i)) continue;
            payload[i + 4] = 1;
        }
        this.assembleAndSendPacket(Util.PacketType.CHANNELS_ON_AIR, payload, this.getBroadcastAddress(), 50001);
    }

    public void sendLoadTrackCommand(int targetPlayer, int rekordboxId, int sourcePlayer, CdjStatus.TrackSourceSlot sourceSlot, CdjStatus.TrackType sourceType) throws IOException {
        DeviceUpdate update = this.getLatestStatusFor(targetPlayer);
        if (update == null) {
            throw new IllegalArgumentException("Device " + targetPlayer + " not found on network.");
        }
        this.sendLoadTrackCommand(update, rekordboxId, sourcePlayer, sourceSlot, sourceType);
    }

    public void sendLoadTrackCommand(DeviceUpdate target, int rekordboxId, int sourcePlayer, CdjStatus.TrackSourceSlot sourceSlot, CdjStatus.TrackType sourceType) throws IOException {
        this.ensureRunning();
        byte[] payload = new byte[LOAD_TRACK_PAYLOAD.length];
        System.arraycopy(LOAD_TRACK_PAYLOAD, 0, payload, 0, LOAD_TRACK_PAYLOAD.length);
        payload[2] = this.getDeviceNumber();
        payload[5] = this.getDeviceNumber();
        payload[9] = (byte)sourcePlayer;
        payload[10] = sourceSlot.protocolValue;
        payload[11] = sourceType.protocolValue;
        payload[33] = (byte)(target.getDeviceNumber() - 1);
        if (target.deviceName.startsWith("XDJ-XZ")) {
            byte number;
            payload[1] = 1;
            payload[44] = 50;
            for (DeviceAnnouncement device : DeviceFinder.getInstance().getCurrentDevices()) {
                number = (byte)device.getDeviceNumber();
                if (number < 17 || number >= 32) continue;
                payload[2] = number;
                payload[5] = number;
                break;
            }
            if (payload[2] == this.getDeviceNumber()) {
                for (DeviceAnnouncement device : DeviceFinder.getInstance().getCurrentDevices()) {
                    number = (byte)device.getDeviceNumber();
                    if (number < 41 || number >= 48) continue;
                    payload[2] = number;
                    payload[5] = number;
                    break;
                }
            }
        }
        Util.numberToBytes(rekordboxId, payload, 13, 4);
        this.assembleAndSendPacket(Util.PacketType.LOAD_TRACK_COMMAND, payload, target.getAddress(), 50002);
    }

    public void sendLoadSettingsCommand(int targetPlayer, PlayerSettings settings) throws IOException {
        DeviceUpdate update = this.getLatestStatusFor(targetPlayer);
        if (update == null) {
            throw new IllegalArgumentException("Device " + targetPlayer + " not found on network.");
        }
        this.sendLoadSettingsCommand(update, settings);
    }

    public void sendLoadSettingsCommand(DeviceUpdate target, PlayerSettings settings) throws IOException {
        this.ensureRunning();
        byte[] payload = new byte[LOAD_SETTINGS_PAYLOAD.length];
        System.arraycopy(LOAD_SETTINGS_PAYLOAD, 0, payload, 0, LOAD_SETTINGS_PAYLOAD.length);
        Util.setPayloadByte(payload, 32, this.getDeviceNumber());
        Util.setPayloadByte(payload, 33, (byte)target.getDeviceNumber());
        Util.setPayloadByte(payload, 44, settings.onAirDisplay.protocolValue);
        Util.setPayloadByte(payload, 45, settings.lcdBrightness.protocolValue);
        Util.setPayloadByte(payload, 46, settings.quantize.protocolValue);
        Util.setPayloadByte(payload, 47, settings.autoCueLevel.protocolValue);
        Util.setPayloadByte(payload, 48, settings.language.protocolValue);
        Util.setPayloadByte(payload, 50, settings.jogRingIllumination.protocolValue);
        Util.setPayloadByte(payload, 51, settings.jogRingIndicator.protocolValue);
        Util.setPayloadByte(payload, 52, settings.slipFlashing.protocolValue);
        Util.setPayloadByte(payload, 56, settings.discSlotIllumination.protocolValue);
        Util.setPayloadByte(payload, 57, settings.ejectLoadLock.protocolValue);
        Util.setPayloadByte(payload, 58, settings.sync.protocolValue);
        Util.setPayloadByte(payload, 59, settings.autoPlayMode.protocolValue);
        Util.setPayloadByte(payload, 60, settings.quantizeBeatValue.protocolValue);
        Util.setPayloadByte(payload, 61, settings.autoLoadMode.protocolValue);
        Util.setPayloadByte(payload, 62, settings.hotCueColor.protocolValue);
        Util.setPayloadByte(payload, 65, settings.needleLock.protocolValue);
        Util.setPayloadByte(payload, 68, settings.timeDisplayMode.protocolValue);
        Util.setPayloadByte(payload, 69, settings.jogMode.protocolValue);
        Util.setPayloadByte(payload, 70, settings.autoCue.protocolValue);
        Util.setPayloadByte(payload, 71, settings.masterTempo.protocolValue);
        Util.setPayloadByte(payload, 72, settings.tempoRange.protocolValue);
        Util.setPayloadByte(payload, 73, settings.phaseMeterType.protocolValue);
        Util.setPayloadByte(payload, 76, settings.vinylSpeedAdjust.protocolValue);
        Util.setPayloadByte(payload, 77, settings.jogWheelDisplay.protocolValue);
        Util.setPayloadByte(payload, 78, settings.padButtonBrightness.protocolValue);
        Util.setPayloadByte(payload, 79, settings.jogWheelLcdBrightness.protocolValue);
        this.assembleAndSendPacket(Util.PacketType.LOAD_SETTINGS_COMMAND, payload, target.getAddress(), 50002);
    }

    public synchronized int getStatusInterval() {
        return this.statusInterval;
    }

    public synchronized void setStatusInterval(int interval) {
        if (interval < 20 || interval > 2000) {
            throw new IllegalArgumentException("interval must be between 20 and 2000");
        }
        this.statusInterval = interval;
    }

    private void notifyBeatSenderOfChange() {
        BeatSender activeSender = this.beatSender.get();
        if (activeSender != null) {
            activeSender.timelineChanged();
        }
    }

    public long sendBeat() {
        return this.sendBeat(this.getPlaybackPosition());
    }

    public long sendBeat(Snapshot snapshot) {
        byte[] payload = new byte[BEAT_PAYLOAD.length];
        System.arraycopy(BEAT_PAYLOAD, 0, payload, 0, BEAT_PAYLOAD.length);
        payload[2] = this.getDeviceNumber();
        Util.numberToBytes((int)snapshot.getBeatInterval(), payload, 5, 4);
        Util.numberToBytes((int)(snapshot.getBeatInterval() * 2.0), payload, 9, 4);
        Util.numberToBytes((int)(snapshot.getBeatInterval() * 4.0), payload, 17, 4);
        Util.numberToBytes((int)(snapshot.getBeatInterval() * 8.0), payload, 25, 4);
        int beatsLeft = 5 - snapshot.getBeatWithinBar();
        int nextBar = (int)(snapshot.getBeatInterval() * (double)beatsLeft);
        Util.numberToBytes(nextBar, payload, 13, 4);
        Util.numberToBytes(nextBar + (int)snapshot.getBarInterval(), payload, 21, 4);
        Util.numberToBytes((int)Math.round(snapshot.getTempo() * 100.0), payload, 59, 2);
        payload[61] = (byte)snapshot.getBeatWithinBar();
        payload[64] = this.getDeviceNumber();
        try {
            this.assembleAndSendPacket(Util.PacketType.BEAT, payload, this.broadcastAddress.get(), 50001);
        }
        catch (IOException e) {
            logger.error("VirtualCdj Failed to send beat packet.", (Throwable)e);
        }
        return snapshot.getBeat();
    }

    public synchronized void setSendingStatus(boolean send) throws IOException {
        if (this.isSendingStatus() == send) {
            return;
        }
        if (send) {
            AtomicBoolean stillRunning;
            this.ensureRunning();
            if (this.getDeviceNumber() < 1 || this.getDeviceNumber() > 4) {
                throw new IllegalStateException("Can only send status when using a standard player number, 1 through 4.");
            }
            BeatFinder.getInstance().start();
            BeatFinder.getInstance().addLifecycleListener(this.beatFinderLifecycleListener);
            this.sendingStatus = stillRunning = new AtomicBoolean(true);
            Thread sender = new Thread(null, new Runnable(){

                @Override
                public void run() {
                    while (stillRunning.get()) {
                        VirtualCdj.this.sendStatus();
                        try {
                            Thread.sleep(VirtualCdj.this.getStatusInterval());
                        }
                        catch (InterruptedException e) {
                            logger.warn("beat-link VirtualCDJ status sender thread was interrupted; continuing");
                        }
                    }
                }
            }, "beat-link VirtualCdj status sender");
            sender.setDaemon(true);
            sender.start();
            if (this.isSynced()) {
                this.addMasterListener(this.ourSyncMasterListener);
            }
            if (this.isPlaying()) {
                this.beatSender.set(new BeatSender(this.metronome));
            }
        } else {
            BeatFinder.getInstance().removeLifecycleListener(this.beatFinderLifecycleListener);
            this.removeMasterListener(this.ourSyncMasterListener);
            this.sendingStatus.set(false);
            this.sendingStatus = null;
            BeatSender activeSender = this.beatSender.get();
            if (activeSender != null) {
                activeSender.shutDown();
                this.beatSender.set(null);
            }
        }
    }

    public synchronized boolean isSendingStatus() {
        return this.sendingStatus != null;
    }

    public void setPlaying(boolean playing) {
        if (this.playing.get() == playing) {
            return;
        }
        this.playing.set(playing);
        if (playing) {
            this.metronome.jumpToBeat(this.whereStopped.get().getBeat());
            if (this.isSendingStatus()) {
                this.beatSender.set(new BeatSender(this.metronome));
            }
        } else {
            BeatSender activeSender = this.beatSender.get();
            if (activeSender != null) {
                activeSender.shutDown();
                this.beatSender.set(null);
            }
            this.whereStopped.set(this.metronome.getSnapshot());
        }
    }

    public boolean isPlaying() {
        return this.playing.get();
    }

    public Snapshot getPlaybackPosition() {
        if (this.playing.get()) {
            return this.metronome.getSnapshot();
        }
        return this.whereStopped.get();
    }

    public void adjustPlaybackPosition(int ms) {
        if (ms != 0) {
            this.metronome.adjustStart((long)(-ms));
            if (this.metronome.getBeat() < 1L) {
                this.metronome.adjustStart(Math.round(Metronome.beatsToMilliseconds((long)this.metronome.getBeatsPerBar(), (double)this.metronome.getTempo())));
            }
            this.notifyBeatSenderOfChange();
        }
    }

    public synchronized void becomeTempoMaster() throws IOException {
        logger.debug("Trying to become master.");
        if (!this.isSendingStatus()) {
            throw new IllegalStateException("Must be sending status updates to become the tempo master.");
        }
        DeviceUpdate currentMaster = this.getTempoMaster();
        if (currentMaster != null) {
            byte[] payload = new byte[MASTER_HANDOFF_REQUEST_PAYLOAD.length];
            System.arraycopy(MASTER_HANDOFF_REQUEST_PAYLOAD, 0, payload, 0, MASTER_HANDOFF_REQUEST_PAYLOAD.length);
            payload[2] = this.getDeviceNumber();
            payload[8] = this.getDeviceNumber();
            if (logger.isDebugEnabled()) {
                logger.debug("Sending master yield request to player " + currentMaster);
            }
            this.requestingMasterRoleFromPlayer.set(currentMaster.deviceNumber);
            this.assembleAndSendPacket(Util.PacketType.MASTER_HANDOFF_REQUEST, payload, currentMaster.address, 50001);
        } else if (!this.master.get()) {
            this.requestingMasterRoleFromPlayer.set(0);
            this.setMasterTempo(this.getTempo());
            this.master.set(true);
        }
    }

    public boolean isTempoMaster() {
        return this.master.get();
    }

    public synchronized void setSynced(boolean sync) {
        if (this.synced.get() != sync) {
            if (sync && this.isSendingStatus()) {
                this.addMasterListener(this.ourSyncMasterListener);
            } else {
                this.removeMasterListener(this.ourSyncMasterListener);
            }
            if (!this.isTempoMaster() && this.getTempoMaster() != null) {
                this.setTempo(this.getMasterTempo());
            }
        }
        this.synced.set(sync);
    }

    public boolean isSynced() {
        return this.synced.get();
    }

    public void setOnAir(boolean audible) {
        this.onAir.set(audible);
    }

    public boolean isOnAir() {
        return this.onAir.get();
    }

    public void setTempo(double bpm) {
        if (bpm == 0.0) {
            throw new IllegalArgumentException("Tempo cannot be zero.");
        }
        double oldTempo = this.metronome.getTempo();
        this.metronome.setTempo(bpm);
        this.notifyBeatSenderOfChange();
        if (this.isTempoMaster() && Math.abs(bpm - oldTempo) > this.getTempoEpsilon()) {
            this.deliverTempoChangedAnnouncement(bpm);
        }
    }

    public double getTempo() {
        return this.metronome.getTempo();
    }

    private int wrapBeat(int beat) {
        if (beat <= 65536) {
            return beat;
        }
        return (beat - 1) % 65536 + 1;
    }

    public synchronized void jumpToBeat(int beat) {
        beat = beat < 1 ? 1 : this.wrapBeat(beat);
        if (this.playing.get()) {
            this.metronome.jumpToBeat((long)beat);
        } else {
            this.whereStopped.set(this.metronome.getSnapshot(this.metronome.getTimeOfBeat((long)beat)));
        }
    }

    private Snapshot avoidBeatPacket() {
        Snapshot playState = this.getPlaybackPosition();
        double distance = playState.distanceFromBeat();
        while (this.playing.get() && (distance < 0.0 && Math.abs(distance) <= 5.0 || distance >= 0.0 && distance <= 11.0)) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while sleeping to avoid beat packet; ignoring.", (Throwable)e);
            }
            playState = this.getPlaybackPosition();
            distance = playState.distanceFromBeat();
        }
        return playState;
    }

    private void sendStatus() {
        Snapshot playState = this.avoidBeatPacket();
        boolean playing = this.playing.get();
        byte[] payload = new byte[STATUS_PAYLOAD.length];
        System.arraycopy(STATUS_PAYLOAD, 0, payload, 0, STATUS_PAYLOAD.length);
        payload[2] = this.getDeviceNumber();
        payload[5] = payload[2];
        payload[8] = (byte)(playing ? 1 : 0);
        payload[9] = payload[2];
        payload[92] = (byte)(playing ? 3 : 5);
        Util.numberToBytes(this.syncCounter.get(), payload, 101, 4);
        payload[106] = (byte)(132 + (playing ? 64 : 0) + (this.master.get() ? 32 : 0) + (this.synced.get() ? 16 : 0) + (this.onAir.get() ? 8 : 0));
        payload[108] = (byte)(playing ? 122 : 126);
        Util.numberToBytes((int)Math.round(this.getTempo() * 100.0), payload, 115, 2);
        payload[126] = (byte)(playing ? 9 : 1);
        payload[127] = (byte)(this.master.get() ? 1 : 0);
        payload[128] = (byte)this.nextMaster.get();
        Util.numberToBytes((int)playState.getBeat(), payload, 129, 4);
        payload[135] = (byte)playState.getBeatWithinBar();
        Util.numberToBytes(this.packetCounter.incrementAndGet(), payload, 169, 4);
        DatagramPacket packet = Util.buildPacket(Util.PacketType.CDJ_STATUS, ByteBuffer.wrap(keepAliveBytes, 12, 20).asReadOnlyBuffer(), ByteBuffer.wrap(payload));
        packet.setPort(50002);
        for (DeviceAnnouncement device : DeviceFinder.getInstance().getCurrentDevices()) {
            packet.setAddress(device.getAddress());
            try {
                this.socket.get().send(packet);
            }
            catch (IOException e) {
                logger.warn("Unable to send status packet to " + device, (Throwable)e);
            }
        }
    }

    public static VirtualCdj getInstance() {
        return ourInstance;
    }

    private VirtualCdj() {
        this.masterTempo.set(Double.doubleToLongBits(0.0));
        BeatFinder.getInstance().addOnAirListener(new OnAirListener(){

            @Override
            public void channelsOnAir(Set<Integer> audibleChannels) {
                VirtualCdj.this.setOnAir(audibleChannels.contains(VirtualCdj.this.getDeviceNumber()));
            }
        });
        BeatFinder.getInstance().addFaderStartListener(new FaderStartListener(){

            @Override
            public void fadersChanged(Set<Integer> playersToStart, Set<Integer> playersToStop) {
                if (playersToStart.contains(VirtualCdj.this.getDeviceNumber())) {
                    VirtualCdj.this.setPlaying(true);
                } else if (playersToStop.contains(VirtualCdj.this.getDeviceNumber())) {
                    VirtualCdj.this.setPlaying(false);
                }
            }
        });
        BeatFinder.getInstance().addSyncListener(new SyncListener(){

            @Override
            public void setSyncMode(boolean synced) {
                VirtualCdj.this.setSynced(synced);
            }

            @Override
            public void becomeMaster() {
                logger.debug("Received packet telling us to become master.");
                if (VirtualCdj.this.isSendingStatus()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                VirtualCdj.this.becomeTempoMaster();
                            }
                            catch (Throwable t) {
                                logger.error("Problem becoming tempo master in response to sync command packet", t);
                            }
                        }
                    }).start();
                } else {
                    logger.warn("Ignoring sync command to become tempo master, since we are not sending status packets.");
                }
            }
        });
        BeatFinder.getInstance().addMasterHandoffListener(new MasterHandoffListener(){

            @Override
            public void yieldMasterTo(int deviceNumber) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received instruction to yield master to device " + deviceNumber);
                }
                if (VirtualCdj.this.isTempoMaster()) {
                    if (VirtualCdj.this.isSendingStatus() && VirtualCdj.this.getDeviceNumber() != deviceNumber) {
                        VirtualCdj.this.nextMaster.set(deviceNumber);
                        DeviceUpdate lastStatusFromNewMaster = VirtualCdj.this.getLatestStatusFor(deviceNumber);
                        if (lastStatusFromNewMaster == null) {
                            logger.warn("Unable to send master yield response to device " + deviceNumber + ": no status updates have been received from it!");
                        } else {
                            byte[] payload = new byte[YIELD_ACK_PAYLOAD.length];
                            System.arraycopy(YIELD_ACK_PAYLOAD, 0, payload, 0, YIELD_ACK_PAYLOAD.length);
                            payload[2] = VirtualCdj.this.getDeviceNumber();
                            payload[8] = VirtualCdj.this.getDeviceNumber();
                            try {
                                VirtualCdj.this.assembleAndSendPacket(Util.PacketType.MASTER_HANDOFF_RESPONSE, payload, lastStatusFromNewMaster.getAddress(), 50002);
                            }
                            catch (Throwable t) {
                                logger.error("Problem sending master yield acknowledgment to player " + deviceNumber, t);
                            }
                        }
                    }
                } else {
                    logger.warn("Ignoring instruction to yield master to device " + deviceNumber + ": we were not tempo master.");
                }
            }

            @Override
            public void yieldResponse(int deviceNumber, boolean yielded) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received yield response of " + yielded + " from device " + deviceNumber);
                }
                if (yielded) {
                    if (VirtualCdj.this.isSendingStatus()) {
                        if (deviceNumber == VirtualCdj.this.requestingMasterRoleFromPlayer.get()) {
                            VirtualCdj.this.requestingMasterRoleFromPlayer.set(0);
                            VirtualCdj.this.masterYieldedFrom.set(deviceNumber);
                        } else if (VirtualCdj.this.requestingMasterRoleFromPlayer.get() == 0) {
                            logger.warn("Ignoring master yield response from player " + deviceNumber + " because we are not trying to become tempo master.");
                        } else {
                            logger.warn("Ignoring master yield response from player " + deviceNumber + " because we asked player " + VirtualCdj.this.requestingMasterRoleFromPlayer.get());
                        }
                    } else {
                        logger.warn("Ignoring master yield response because we are not sending status.");
                    }
                } else {
                    logger.warn("Ignoring master yield response with unexpected non-yielding value.");
                }
            }
        });
    }

    private void handleDeviceClaimPacket(DatagramPacket packet, int deviceOffset) {
        if (packet.getData().length < deviceOffset + 1) {
            logger.warn("Ignoring too-short device claim packet.");
            return;
        }
        if (this.isRunning() && this.getDeviceNumber() == packet.getData()[deviceOffset]) {
            this.defendDeviceNumber(packet.getAddress());
        }
    }

    void handleSpecialAnnouncementPacket(Util.PacketType kind, DatagramPacket packet) {
        if (kind == Util.PacketType.DEVICE_NUMBER_STAGE_1) {
            logger.debug("Received device number claim stage 1 packet.");
        } else if (kind == Util.PacketType.DEVICE_NUMBER_STAGE_2) {
            this.handleDeviceClaimPacket(packet, 46);
        } else if (kind == Util.PacketType.DEVICE_NUMBER_STAGE_3) {
            this.handleDeviceClaimPacket(packet, 36);
        } else if (kind == Util.PacketType.DEVICE_NUMBER_WILL_ASSIGN) {
            logger.debug("The mixer at address " + packet.getAddress().getHostAddress() + " wants to assign us a specific device number.");
            if (this.claimingNumber.get() != 0) {
                this.requestNumberFromMixer(packet.getAddress());
            } else {
                logger.warn("Ignoring mixer device number assignment offer; we are not claiming a device number!");
            }
        } else if (kind == Util.PacketType.DEVICE_NUMBER_ASSIGN) {
            this.mixerAssigned.set(packet.getData()[36]);
            if (this.mixerAssigned.get() == 0) {
                logger.debug("Mixer at address " + packet.getAddress().getHostAddress() + " told us to use any device.");
            } else {
                logger.info("Mixer at address " + packet.getAddress().getHostAddress() + " told us to use device number " + this.mixerAssigned.get());
            }
        } else if (kind == Util.PacketType.DEVICE_NUMBER_ASSIGNMENT_FINISHED) {
            this.mixerAssigned.set(this.claimingNumber.get());
            logger.info("Mixer confirmed device assignment.");
        } else if (kind == Util.PacketType.DEVICE_NUMBER_IN_USE) {
            byte defendedDevice = packet.getData()[36];
            if (defendedDevice == 0) {
                logger.warn("Ignoring unexplained attempt to defend device 0.");
            } else if (defendedDevice == this.claimingNumber.get()) {
                logger.warn("Another device is defending device number " + defendedDevice + ", so we can't use it.");
                this.claimRejected.set(true);
            } else if (this.isRunning()) {
                if (defendedDevice == this.getDeviceNumber()) {
                    logger.warn("Another device has claimed it owns our device number, shutting down.");
                    this.stop();
                } else {
                    logger.warn("Another device is defending a number we are not using, ignoring: " + defendedDevice);
                }
            } else {
                logger.warn("Received device number defense message for device number " + defendedDevice + " when we are not even running!");
            }
        } else {
            logger.warn("Received unrecognized special announcement packet type: " + (Object)((Object)kind));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualCdj[number:").append(this.getDeviceNumber()).append(", name:").append(VirtualCdj.getDeviceName());
        sb.append(", announceInterval:").append(this.getAnnounceInterval());
        sb.append(", useStandardPlayerNumber:").append(this.getUseStandardPlayerNumber());
        sb.append(", tempoEpsilon:").append(this.getTempoEpsilon()).append(", active:").append(this.isRunning());
        if (this.isRunning()) {
            sb.append(", localAddress:").append(this.getLocalAddress().getHostAddress());
            sb.append(", broadcastAddress:").append(this.getBroadcastAddress().getHostAddress());
            sb.append(", latestStatus:").append(this.getLatestStatus()).append(", masterTempo:").append(this.getMasterTempo());
            sb.append(", tempoMaster:").append(this.getTempoMaster());
            sb.append(", isSendingStatus:").append(this.isSendingStatus());
            if (this.isSendingStatus()) {
                sb.append(", isSynced:").append(this.isSynced());
                sb.append(", isTempoMaster:").append(this.isTempoMaster());
                sb.append(", isPlaying:").append(this.isPlaying());
                sb.append(", isOnAir:").append(this.isOnAir());
                sb.append(", metronome:").append(this.metronome);
            }
        }
        return sb.append("]").toString();
    }
}

