/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.AlbumArt;
import org.deepsymmetry.beatlink.data.ArtFinder;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridFinder;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.MetadataCacheCreationListener;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.MetadataProvider;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Field;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MetadataCache
implements MetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(MetadataCache.class);
    private final ZipFile zipFile;
    public final int sourcePlaylist;
    public final int trackCount;
    public final MediaDetails sourceMedia;
    public static final String CACHE_FORMAT_IDENTIFIER = "BeatLink Metadata Cache version 1";
    private static final String CACHE_PREFIX = "BLTMetaCache/";
    private static final String CACHE_FORMAT_ENTRY = "BLTMetaCache/version";
    private static final String CACHE_DETAILS_ENTRY = "BLTMetaCache/mediaDetails";
    private static final String CACHE_METADATA_ENTRY_PREFIX = "BLTMetaCache/metadata/";
    private static final String CACHE_ART_ENTRY_PREFIX = "BLTMetaCache/artwork/";
    private static final String CACHE_BEAT_GRID_ENTRY_PREFIX = "BLTMetaCache/beatGrid/";
    private static final String CACHE_CUE_LIST_ENTRY_PREFIX = "BLTMetaCache/cueList/";
    private static final String CACHE_WAVEFORM_PREVIEW_ENTRY_PREFIX = "BLTMetaCache/wavePrev/";
    private static final String CACHE_WAVEFORM_DETAIL_ENTRY_PREFIX = "BLTMetaCache/waveform/";
    private static final Message MENU_FOOTER_MESSAGE = new Message(0L, Message.KnownType.MENU_FOOTER, new Field[0]);
    private static final AtomicLong cachePauseInterval = new AtomicLong(50L);

    public MetadataCache(File file) throws IOException {
        this.zipFile = new ZipFile(file, 1);
        String tag = this.getCacheFormatEntry();
        if (tag == null || !tag.startsWith(CACHE_FORMAT_IDENTIFIER)) {
            try {
                this.zipFile.close();
            }
            catch (Exception e) {
                logger.error("Problem re-closing newly opened candidate metadata cache", (Throwable)e);
            }
            throw new IOException("File does not contain a Beat Link metadata cache: " + file + " (looking for format identifier \"" + CACHE_FORMAT_IDENTIFIER + "\", found: " + tag);
        }
        String[] pieces = tag.split(":");
        this.sourcePlaylist = Integer.parseInt(pieces[1]);
        this.trackCount = Integer.parseInt(pieces[2]);
        this.sourceMedia = this.getCacheMediaDetails();
    }

    public void close() throws IOException {
        this.zipFile.close();
    }

    public String getName() {
        return this.zipFile.getName();
    }

    static String getMetadataEntryName(int rekordboxId) {
        return CACHE_METADATA_ENTRY_PREFIX + rekordboxId;
    }

    static String getArtworkEntryName(int artworkId) {
        return CACHE_ART_ENTRY_PREFIX + artworkId + ".jpg";
    }

    static String getBeatGridEntryName(int rekordboxId) {
        return CACHE_BEAT_GRID_ENTRY_PREFIX + rekordboxId;
    }

    static String getCueListEntryName(int rekordboxId) {
        return CACHE_CUE_LIST_ENTRY_PREFIX + rekordboxId;
    }

    static String getWaveformPreviewEntryName(int rekordboxId) {
        return CACHE_WAVEFORM_PREVIEW_ENTRY_PREFIX + rekordboxId;
    }

    static String getWaveformDetailEntryName(int rekordboxId) {
        return CACHE_WAVEFORM_DETAIL_ENTRY_PREFIX + rekordboxId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyTracksToCache(List<Message> trackListEntries, int playlistId, Client client, SlotReference slot, File cache, MetadataCacheCreationListener listener) throws IOException, TimeoutException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        ZipOutputStream zos = null;
        Channel channel = null;
        HashSet<Integer> tracksAdded = new HashSet<Integer>();
        HashSet<Integer> artworkAdded = new HashSet<Integer>();
        try {
            fos = new FileOutputStream(cache);
            bos = new BufferedOutputStream(fos);
            zos = new ZipOutputStream(bos);
            zos.setMethod(8);
            MetadataCache.addCacheFormatEntry(trackListEntries, playlistId, zos);
            channel = Channels.newChannel(zos);
            MetadataCache.addCacheDetailsEntry(slot, zos, (WritableByteChannel)channel);
            int totalToCopy = trackListEntries.size();
            TrackMetadata lastTrackAdded = null;
            int tracksCopied = 0;
            for (Message entry : trackListEntries) {
                int rekordboxId;
                if (entry.getMenuItemType() == Message.MenuItemType.UNKNOWN) {
                    logger.warn("Encountered unrecognized track list entry item type: {}", (Object)entry);
                }
                if (!tracksAdded.contains(rekordboxId = (int)((NumberField)entry.arguments.get(1)).getValue())) {
                    lastTrackAdded = MetadataCache.copyTrackToCache(client, slot, zos, (WritableByteChannel)channel, artworkAdded, rekordboxId);
                    tracksAdded.add(rekordboxId);
                }
                if (listener != null && !listener.cacheCreationContinuing(lastTrackAdded, ++tracksCopied, totalToCopy)) {
                    logger.info("Track metadata cache creation canceled by listener");
                    if (!cache.delete()) {
                        logger.warn("Unable to delete metadata cache file, {}", (Object)cache);
                    }
                    return;
                }
                Thread.sleep(MetadataCache.getCachePauseInterval());
            }
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while building metadata cache file, aborting", (Throwable)e);
            if (!cache.delete()) {
                logger.warn("Unable to delete metadata cache file, {}", (Object)cache);
            }
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Exception e) {
                logger.error("Problem closing byte channel for writing to metadata cache", (Throwable)e);
            }
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (Exception e) {
                logger.error("Problem closing Zip Output Stream of metadata cache", (Throwable)e);
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                logger.error("Problem closing Buffered Output Stream of metadata cache", (Throwable)e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                logger.error("Problem closing File Output Stream of metadata cache", (Throwable)e);
            }
        }
    }

    private static void addCacheFormatEntry(List<Message> trackListEntries, int playlistId, ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry(CACHE_FORMAT_ENTRY));
        String formatEntry = "BeatLink Metadata Cache version 1:" + playlistId + ":" + trackListEntries.size();
        zos.write(formatEntry.getBytes("UTF-8"));
    }

    private static void addCacheDetailsEntry(SlotReference slot, ZipOutputStream zos, WritableByteChannel channel) throws IOException {
        MediaDetails details = MetadataFinder.getInstance().getMediaDetailsFor(slot);
        if (details != null) {
            zos.putNextEntry(new ZipEntry(CACHE_DETAILS_ENTRY));
            Util.writeFully(details.getRawBytes(), channel);
        }
    }

    private static TrackMetadata copyTrackToCache(Client client, SlotReference slot, ZipOutputStream zos, WritableByteChannel channel, Set<Integer> artworkAdded, int rekordboxId) throws IOException, TimeoutException, InterruptedException {
        WaveformDetail detail;
        WaveformPreview preview;
        CueList cueList;
        BeatGrid beatGrid;
        TrackMetadata track = MetadataFinder.getInstance().queryMetadata(new DataReference(slot, rekordboxId), CdjStatus.TrackType.REKORDBOX, client);
        if (track != null) {
            logger.debug("Adding metadata with ID {}", (Object)track.trackReference.rekordboxId);
            zos.putNextEntry(new ZipEntry(MetadataCache.getMetadataEntryName(track.trackReference.rekordboxId)));
            for (Message metadataItem : track.rawItems) {
                metadataItem.write(channel);
            }
        } else {
            logger.warn("Unable to retrieve metadata with ID {}", (Object)rekordboxId);
            return null;
        }
        MENU_FOOTER_MESSAGE.write(channel);
        if (track.getArtworkId() != 0 && !artworkAdded.contains(track.getArtworkId())) {
            logger.debug("Adding artwork with ID {}", (Object)track.getArtworkId());
            zos.putNextEntry(new ZipEntry(MetadataCache.getArtworkEntryName(track.getArtworkId())));
            AlbumArt art = ArtFinder.getInstance().getArtwork(track.getArtworkId(), slot, CdjStatus.TrackType.REKORDBOX, client);
            if (art != null) {
                Util.writeFully(art.getRawBytes(), channel);
                artworkAdded.add(track.getArtworkId());
            }
        }
        if ((beatGrid = BeatGridFinder.getInstance().getBeatGrid(rekordboxId, slot, client)) != null) {
            logger.debug("Adding beat grid with ID {}", (Object)rekordboxId);
            zos.putNextEntry(new ZipEntry(MetadataCache.getBeatGridEntryName(rekordboxId)));
            Util.writeFully(beatGrid.getRawData(), channel);
        }
        if ((cueList = MetadataFinder.getInstance().getCueList(rekordboxId, slot.slot, client)) != null) {
            logger.debug("Adding cue list entry with ID {}", (Object)rekordboxId);
            zos.putNextEntry(new ZipEntry(MetadataCache.getCueListEntryName(rekordboxId)));
            cueList.rawMessage.write(channel);
        }
        if ((preview = WaveformFinder.getInstance().getWaveformPreview(rekordboxId, slot, client)) != null) {
            logger.debug("Adding waveform preview entry with ID {}", (Object)rekordboxId);
            zos.putNextEntry(new ZipEntry(MetadataCache.getWaveformPreviewEntryName(rekordboxId)));
            preview.rawMessage.write(channel);
        }
        if ((detail = WaveformFinder.getInstance().getWaveformDetail(rekordboxId, slot, client)) != null) {
            logger.debug("Adding waveform detail entry with ID {}", (Object)rekordboxId);
            zos.putNextEntry(new ZipEntry(MetadataCache.getWaveformDetailEntryName(rekordboxId)));
            detail.rawMessage.write(channel);
        }
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCacheFormatEntry() throws IOException {
        ZipEntry zipEntry = this.zipFile.getEntry(CACHE_FORMAT_ENTRY);
        InputStream is = this.zipFile.getInputStream(zipEntry);
        try {
            Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
            String tag = null;
            if (s.hasNext()) {
                tag = s.next();
            }
            String string = tag;
            return string;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaDetails getCacheMediaDetails() throws IOException {
        ZipEntry zipEntry = this.zipFile.getEntry(CACHE_DETAILS_ENTRY);
        if (zipEntry == null) {
            return null;
        }
        InputStream is = this.zipFile.getInputStream(zipEntry);
        try {
            MediaDetails mediaDetails;
            DataInputStream dis = new DataInputStream(is);
            try {
                byte[] detailBytes = new byte[(int)zipEntry.getSize()];
                dis.readFully(detailBytes);
                mediaDetails = new MediaDetails(detailBytes, detailBytes.length);
            }
            catch (Throwable throwable) {
                dis.close();
                throw throwable;
            }
            dis.close();
            return mediaDetails;
        }
        finally {
            is.close();
        }
    }

    public List<Integer> getTrackIds() {
        ArrayList<Integer> results = new ArrayList<Integer>(this.trackCount);
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            String idPart;
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(CACHE_METADATA_ENTRY_PREFIX) || (idPart = entry.getName().substring(CACHE_METADATA_ENTRY_PREFIX.length())).length() <= 0) continue;
            results.add(Integer.valueOf(idPart));
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<MediaDetails> supportedMedia() {
        if (this.sourceMedia != null) {
            return Collections.singletonList(this.sourceMedia);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackMetadata getTrackMetadata(MediaDetails sourceMedia, DataReference track) {
        ZipEntry entry = this.zipFile.getEntry(MetadataCache.getMetadataEntryName(track.rekordboxId));
        if (entry != null) {
            FilterInputStream is = null;
            try {
                is = new DataInputStream(this.zipFile.getInputStream(entry));
                LinkedList<Message> items = new LinkedList<Message>();
                Message current = Message.read((DataInputStream)is);
                while (current.messageType.getValue() == Message.KnownType.MENU_ITEM.protocolValue) {
                    items.add(current);
                    current = Message.read((DataInputStream)is);
                }
                TrackMetadata trackMetadata = new TrackMetadata(track, CdjStatus.TrackType.REKORDBOX, items, this.getCueList(sourceMedia, track));
                return trackMetadata;
            }
            catch (IOException e) {
                logger.error("Problem reading metadata from cache file, returning null", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing ZipFile input stream for reading metadata entry", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlbumArt getAlbumArt(MediaDetails sourceMedia, DataReference art) {
        ZipEntry entry = this.zipFile.getEntry(MetadataCache.getArtworkEntryName(art.rekordboxId));
        if (entry != null) {
            FilterInputStream is = null;
            try {
                is = new DataInputStream(this.zipFile.getInputStream(entry));
                byte[] imageBytes = new byte[(int)entry.getSize()];
                ((DataInputStream)is).readFully(imageBytes);
                AlbumArt albumArt = new AlbumArt(art, ByteBuffer.wrap(imageBytes).asReadOnlyBuffer());
                return albumArt;
            }
            catch (IOException e) {
                logger.error("Problem reading artwork from cache file, returning null", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing ZipFile input stream for reading artwork entry", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeatGrid getBeatGrid(MediaDetails sourceMedia, DataReference track) {
        ZipEntry entry = this.zipFile.getEntry(MetadataCache.getBeatGridEntryName(track.rekordboxId));
        if (entry != null) {
            FilterInputStream is = null;
            try {
                is = new DataInputStream(this.zipFile.getInputStream(entry));
                byte[] gridBytes = new byte[(int)entry.getSize()];
                ((DataInputStream)is).readFully(gridBytes);
                BeatGrid beatGrid = new BeatGrid(track, ByteBuffer.wrap(gridBytes).asReadOnlyBuffer());
                return beatGrid;
            }
            catch (IOException e) {
                logger.error("Problem reading beat grid from cache file, returning null", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing ZipFile input stream for reading beat grid entry", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CueList getCueList(MediaDetails sourceMedia, DataReference track) {
        ZipEntry entry = this.zipFile.getEntry(MetadataCache.getCueListEntryName(track.rekordboxId));
        if (entry != null) {
            FilterInputStream is = null;
            try {
                is = new DataInputStream(this.zipFile.getInputStream(entry));
                Message message = Message.read((DataInputStream)is);
                CueList cueList = new CueList(message);
                return cueList;
            }
            catch (IOException e) {
                logger.error("Problem reading cue list from cache file, returning null", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing ZipFile input stream for reading cue list", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WaveformPreview getWaveformPreview(MediaDetails sourceMedia, DataReference track) {
        ZipEntry entry = this.zipFile.getEntry(MetadataCache.getWaveformPreviewEntryName(track.rekordboxId));
        if (entry != null) {
            FilterInputStream is = null;
            try {
                is = new DataInputStream(this.zipFile.getInputStream(entry));
                Message message = Message.read((DataInputStream)is);
                WaveformPreview waveformPreview = new WaveformPreview(track, message);
                return waveformPreview;
            }
            catch (IOException e) {
                logger.error("Problem reading waveform preview from cache file, returning null", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing ZipFile input stream for waveform preview", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WaveformDetail getWaveformDetail(MediaDetails sourceMedia, DataReference track) {
        ZipEntry entry = this.zipFile.getEntry(MetadataCache.getWaveformDetailEntryName(track.rekordboxId));
        if (entry != null) {
            FilterInputStream is = null;
            try {
                is = new DataInputStream(this.zipFile.getInputStream(entry));
                Message message = Message.read((DataInputStream)is);
                WaveformDetail waveformDetail = new WaveformDetail(track, message);
                return waveformDetail;
            }
            catch (IOException e) {
                logger.error("Problem reading waveform detail from cache file, returning null", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Problem closing ZipFile input stream for waveform detail", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    public static void createMetadataCache(SlotReference slot, int playlistId, File cache) throws Exception {
        MetadataCache.createMetadataCache(slot, playlistId, cache, null);
    }

    public static void setCachePauseInterval(long milliseconds) {
        cachePauseInterval.set(milliseconds);
    }

    public static long getCachePauseInterval() {
        return cachePauseInterval.get();
    }

    public static void createMetadataCache(final SlotReference slot, final int playlistId, final File cache, final MetadataCacheCreationListener listener) throws Exception {
        ConnectionManager.ClientTask<Object> task = new ConnectionManager.ClientTask<Object>(){

            @Override
            public Object useClient(Client client) throws Exception {
                List<Message> trackList = playlistId == 0 ? MetadataFinder.getInstance().getFullTrackList(slot.slot, client, 0) : MetadataFinder.getInstance().getPlaylistItems(slot.slot, 0, playlistId, false, client);
                MetadataCache.copyTracksToCache(trackList, playlistId, client, slot, cache, listener);
                return null;
            }
        };
        if (cache.exists() && !cache.delete()) {
            logger.warn("Unable to delete cache file, {}", (Object)cache);
        }
        ConnectionManager.getInstance().invokeWithClientSession(slot.player, task, "building metadata cache");
    }

    static void tryAutoAttaching(final SlotReference slot) {
        if (!MetadataFinder.getInstance().getMountedMediaSlots().contains(slot)) {
            logger.error("Unable to auto-attach cache to empty slot {}", (Object)slot);
            return;
        }
        if (MetadataFinder.getInstance().getMetadataCache(slot) != null) {
            logger.info("Not auto-attaching to slot {}; already has a cache attached.", (Object)slot);
            return;
        }
        if (MetadataFinder.getInstance().getAutoAttachCacheFiles().isEmpty()) {
            logger.debug("No auto-attach files configured.");
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    try {
                        Thread.sleep(5L);
                        MediaDetails details = MetadataFinder.getInstance().getMediaDetailsFor(slot);
                        if (details == null || details.mediaType != CdjStatus.TrackType.REKORDBOX) break block6;
                        boolean attached = false;
                        for (File file : MetadataFinder.getInstance().getAutoAttachCacheFiles()) {
                            MetadataCache cache = new MetadataCache(file);
                            try {
                                if (cache.sourceMedia == null || !cache.sourceMedia.hashKey().equals(details.hashKey())) continue;
                                boolean changed = cache.sourceMedia.hasChanged(details);
                                logger.info("Auto-attaching metadata cache " + cache.getName() + " to slot " + slot + " based on media details " + (changed ? "(changed since created)!" : "(unchanged)."));
                                MetadataFinder.getInstance().attachMetadataCacheInternal(slot, cache);
                                attached = true;
                                return;
                            }
                            finally {
                                if (attached) continue;
                                cache.close();
                            }
                        }
                        ConnectionManager.ClientTask<Object> task = new ConnectionManager.ClientTask<Object>(){

                            @Override
                            public Object useClient(Client client) throws Exception {
                                MetadataCache.tryAutoAttachingWithConnection(slot, client);
                                return null;
                            }
                        };
                        ConnectionManager.getInstance().invokeWithClientSession(slot.player, task, "trying to auto-attach metadata cache");
                    }
                    catch (Exception e) {
                        logger.error("Problem trying to auto-attach metadata cache for slot " + slot, (Throwable)e);
                    }
                }
            }
        }, "Metadata cache file auto-attachment attempt").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void tryAutoAttachingWithConnection(SlotReference slot, Client client) throws IOException, InterruptedException, TimeoutException {
        MetadataCache match;
        Map<Integer, LinkedList<MetadataCache>> candidateGroups;
        block29: {
            Iterator<Map.Entry<Integer, LinkedList<MetadataCache>>> candidate;
            block28: {
                Iterator<Object> iterator;
                candidateGroups = MetadataCache.gatherCandidateAttachmentGroups();
                match = null;
                try {
                    for (Map.Entry<Integer, LinkedList<MetadataCache>> entry : candidateGroups.entrySet()) {
                        ArrayList<Integer> tracksToSample;
                        LinkedList<MetadataCache> candidates;
                        if (!client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                            throw new TimeoutException("Unable to lock player for menu operations.");
                        }
                        try {
                            int playlistId = entry.getKey();
                            candidates = entry.getValue();
                            long l = MetadataCache.getTrackCount(slot.slot, client, playlistId);
                            if (l == -1L || l == 0L) {
                                for (MetadataCache candidate2 : candidates) {
                                    candidate2.close();
                                }
                                candidates.clear();
                            }
                            Iterator candidateIterator = candidates.iterator();
                            while (candidateIterator.hasNext()) {
                                MetadataCache candidate2;
                                candidate2 = (MetadataCache)candidateIterator.next();
                                if ((long)candidate2.trackCount == l) continue;
                                candidate2.close();
                                candidateIterator.remove();
                            }
                            if (candidates.isEmpty()) continue;
                            tracksToSample = MetadataCache.chooseTrackSample(slot, client, (int)l);
                        }
                        finally {
                            client.unlockForMenuOperations();
                            continue;
                        }
                        iterator = tracksToSample.iterator();
                        while (iterator.hasNext()) {
                            int n = iterator.next();
                            logger.info("Comparing track " + n + " with " + candidates.size() + " metadata cache file(s).");
                            DataReference reference = new DataReference(slot, n);
                            TrackMetadata track = MetadataFinder.getInstance().queryMetadata(reference, CdjStatus.TrackType.REKORDBOX, client);
                            if (track == null) {
                                logger.warn("Unable to retrieve metadata when attempting cache auto-attach for slot {}, giving up", (Object)slot);
                                candidate = candidateGroups.entrySet().iterator();
                                break block28;
                            }
                            for (int i = candidates.size() - 1; i >= 0; --i) {
                                MetadataCache candidate3 = candidates.get(i);
                                if (track.equals(candidate3.getTrackMetadata(null, reference))) continue;
                                candidate3.close();
                                candidates.remove(i);
                            }
                            if (!candidates.isEmpty()) continue;
                        }
                        if (candidates.isEmpty()) continue;
                        match = candidates.get(0);
                        logger.info("Auto-attaching metadata cache " + match.getName() + " to slot " + slot);
                        MetadataFinder.getInstance().attachMetadataCacheInternal(slot, match);
                        iterator = candidateGroups.entrySet().iterator();
                    }
                    break block29;
                }
                catch (Throwable throwable) {
                    Iterator<Map.Entry<Integer, LinkedList<MetadataCache>>> iterator2 = candidateGroups.entrySet().iterator();
                    block14: while (true) {
                        if (!iterator2.hasNext()) {
                            throw throwable;
                        }
                        Map.Entry<Integer, LinkedList<MetadataCache>> entry = iterator2.next();
                        Iterator iterator3 = entry.getValue().iterator();
                        while (true) {
                            if (!iterator3.hasNext()) continue block14;
                            MetadataCache candidate4 = (MetadataCache)iterator3.next();
                            if (candidate4 == match) continue;
                            candidate4.close();
                        }
                        break;
                    }
                }
                {
                    block12: while (true) {
                        if (!iterator.hasNext()) {
                            return;
                        }
                        Map.Entry entry = (Map.Entry)iterator.next();
                        Iterator iterator4 = ((LinkedList)entry.getValue()).iterator();
                        while (true) {
                            if (!iterator4.hasNext()) continue block12;
                            MetadataCache candidate5 = (MetadataCache)iterator4.next();
                            if (candidate5 == match) continue;
                            candidate5.close();
                        }
                        break;
                    }
                    break;
                }
            }
            block16: while (true) {
                if (!candidate.hasNext()) {
                    return;
                }
                Map.Entry<Integer, LinkedList<MetadataCache>> entry = candidate.next();
                Iterator iterator = entry.getValue().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block16;
                    MetadataCache candidate6 = (MetadataCache)iterator.next();
                    if (candidate6 == match) continue;
                    candidate6.close();
                }
                break;
            }
        }
        Iterator<Map.Entry<Integer, LinkedList<MetadataCache>>> iterator = candidateGroups.entrySet().iterator();
        block18: while (iterator.hasNext()) {
            Map.Entry<Integer, LinkedList<MetadataCache>> entry;
            entry = iterator.next();
            Iterator iterator5 = entry.getValue().iterator();
            while (true) {
                if (!iterator5.hasNext()) continue block18;
                MetadataCache candidate = (MetadataCache)iterator5.next();
                if (candidate == match) continue;
                candidate.close();
            }
            break;
        }
        return;
    }

    private static Map<Integer, LinkedList<MetadataCache>> gatherCandidateAttachmentGroups() {
        TreeMap<Integer, LinkedList<MetadataCache>> candidateGroups = new TreeMap<Integer, LinkedList<MetadataCache>>();
        Iterator<File> iterator = MetadataFinder.getInstance().getAutoAttachCacheFiles().iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                MetadataCache candidate = new MetadataCache(file);
                if (candidateGroups.get(candidate.sourcePlaylist) == null) {
                    candidateGroups.put(candidate.sourcePlaylist, new LinkedList());
                }
                ((LinkedList)candidateGroups.get(candidate.sourcePlaylist)).add(candidate);
            }
            catch (Exception e) {
                logger.error("Unable to open metadata cache file " + file + ", discarding", (Throwable)e);
                iterator.remove();
            }
        }
        return candidateGroups;
    }

    private static ArrayList<Integer> chooseTrackSample(SlotReference slot, Client client, int count) throws IOException {
        int tracksLeft = count;
        int samplesNeeded = Math.min(tracksLeft, MetadataFinder.getInstance().getAutoAttachProbeCount());
        ArrayList<Integer> tracksToSample = new ArrayList<Integer>(samplesNeeded);
        int offset = 0;
        Random random = new Random();
        while (samplesNeeded > 0) {
            int rand = random.nextInt(tracksLeft);
            if (rand < samplesNeeded) {
                --samplesNeeded;
                tracksToSample.add(MetadataCache.findTrackIdAtOffset(slot, client, offset));
            }
            --tracksLeft;
            ++offset;
        }
        return tracksToSample;
    }

    private static long getTrackCount(CdjStatus.TrackSourceSlot slot, Client client, int playlistId) throws IOException {
        Message response = playlistId == 0 ? client.menuRequest(Message.KnownType.TRACK_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slot, NumberField.WORD_0) : client.menuRequest(Message.KnownType.PLAYLIST_REQ, Message.MenuIdentifier.MAIN_MENU, slot, NumberField.WORD_0, new NumberField(playlistId), NumberField.WORD_0);
        return response.getMenuResultsCount();
    }

    private static int findTrackIdAtOffset(SlotReference slot, Client client, int offset) throws IOException {
        Message entry = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot.slot, CdjStatus.TrackType.REKORDBOX, offset, 1).get(0);
        if (entry.getMenuItemType() == Message.MenuItemType.UNKNOWN) {
            logger.warn("Encountered unrecognized track list entry item type: {}", (Object)entry);
        }
        return (int)((NumberField)entry.arguments.get(1)).getValue();
    }
}

