/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridFinder;
import org.deepsymmetry.beatlink.data.BeatGridListener;
import org.deepsymmetry.beatlink.data.BeatGridUpdate;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.OverlayPainter;
import org.deepsymmetry.beatlink.data.PlaybackState;
import org.deepsymmetry.beatlink.data.RepaintDelegate;
import org.deepsymmetry.beatlink.data.TimeFinder;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformDetailComponent;
import org.deepsymmetry.beatlink.data.WaveformDetailUpdate;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformListener;
import org.deepsymmetry.beatlink.data.WaveformPreview;
import org.deepsymmetry.beatlink.data.WaveformPreviewUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveformPreviewComponent
extends JComponent {
    private static final Logger logger = LoggerFactory.getLogger(WaveformPreviewComponent.class);
    private static final int CUE_MARKER_TOP = 4;
    private static final int CUE_MARKER_HEIGHT = 4;
    private static final int POSITION_MARKER_TOP = 8;
    private static final int WAVEFORM_TOP = 10;
    private static final int MIN_WAVEFORM_HEIGHT = 31;
    public static final int MIN_WAVEFORM_WIDTH = 200;
    private static final int PLAYBACK_BAR_HEIGHT = 4;
    private static final int MINUTE_MARKER_HEIGHT = 4;
    private static final int WAVEFORM_MARGIN = 4;
    public static final Color BRIGHT_PLAYED = new Color(255, 255, 255, 75);
    public static final Color DIM_PLAYED = new Color(255, 255, 255, 35);
    public static final Color DIM_UNPLAYED = new Color(255, 255, 255, 170);
    private final AtomicInteger monitoredPlayer = new AtomicInteger(0);
    private final AtomicReference<Color> backgroundColor = new AtomicReference<Color>(Color.BLACK);
    private final AtomicReference<Color> indicatorColor = new AtomicReference<Color>(Color.WHITE);
    private final AtomicReference<Color> emphasisColor = new AtomicReference<Color>(Color.RED);
    private final AtomicReference<WaveformPreview> preview = new AtomicReference();
    private final AtomicReference<Image> waveformImage = new AtomicReference();
    private final Map<Integer, PlaybackState> playbackStateMap = new ConcurrentHashMap<Integer, PlaybackState>(4);
    private final AtomicInteger duration = new AtomicInteger(0);
    private final AtomicReference<BeatGrid> beatGrid = new AtomicReference();
    private final AtomicReference<CueList> cueList = new AtomicReference();
    private final AtomicReference<OverlayPainter> overlayPainter = new AtomicReference();
    private final AtomicReference<RepaintDelegate> repaintDelegate = new AtomicReference();
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private final AtomicBoolean animating = new AtomicBoolean(false);
    private final TrackMetadataListener metadataListener = new TrackMetadataListener(){

        @Override
        public void metadataChanged(TrackMetadataUpdate update) {
            if (update.player == WaveformPreviewComponent.this.getMonitoredPlayer()) {
                if (update.metadata != null) {
                    WaveformPreviewComponent.this.duration.set(update.metadata.getDuration());
                    WaveformPreviewComponent.this.cueList.set(update.metadata.getCueList());
                } else {
                    WaveformPreviewComponent.this.duration.set(0);
                    WaveformPreviewComponent.this.cueList.set(null);
                }
                WaveformPreviewComponent.this.repaint();
            }
        }
    };
    private final WaveformListener waveformListener = new WaveformListener(){

        @Override
        public void previewChanged(WaveformPreviewUpdate update) {
            if (update.player == WaveformPreviewComponent.this.getMonitoredPlayer()) {
                WaveformPreviewComponent.this.updateWaveform(update.preview);
                WaveformPreviewComponent.this.repaint();
            }
        }

        @Override
        public void detailChanged(WaveformDetailUpdate update) {
        }
    };
    private final BeatGridListener beatGridListener = new BeatGridListener(){

        @Override
        public void beatGridChanged(BeatGridUpdate update) {
            if (update.player == WaveformPreviewComponent.this.getMonitoredPlayer()) {
                WaveformPreviewComponent.this.beatGrid.set(update.beatGrid);
                WaveformPreviewComponent.this.repaint();
            }
        }
    };
    private final DeviceUpdateListener updateListener = new DeviceUpdateListener(){

        @Override
        public void received(DeviceUpdate update) {
            if (update instanceof CdjStatus && update.getDeviceNumber() == WaveformPreviewComponent.this.getMonitoredPlayer() && WaveformPreviewComponent.this.duration.get() > 0 && WaveformPreviewComponent.this.beatGrid.get() != null) {
                CdjStatus status = (CdjStatus)update;
                WaveformPreviewComponent.this.setPlaying(status.isPlaying());
            }
        }
    };

    private int waveformHeight() {
        return this.getHeight() - 8 - 9 - 4 - 4;
    }

    private int waveformWidth() {
        return this.getWidth() - 8;
    }

    private int playbackBarTop() {
        return 10 + this.waveformHeight() + 3;
    }

    private int minuteMarkerTop() {
        return this.playbackBarTop() + 4 + 3;
    }

    private int positionMarkerHeight() {
        return this.minuteMarkerTop() - 8 - 1;
    }

    public CueList getCueList() {
        return this.cueList.get();
    }

    public void setOverlayPainter(OverlayPainter painter) {
        this.overlayPainter.set(painter);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor.set(color);
        this.updateWaveform(this.preview.get());
    }

    public Color getIndicatorColor() {
        return this.indicatorColor.get();
    }

    public void setIndicatorColor(Color color) {
        this.indicatorColor.set(color);
    }

    public Color getEmphasisColor() {
        return this.emphasisColor.get();
    }

    public void setEmphasisColor(Color color) {
        this.emphasisColor.set(color);
    }

    public PlaybackState getFurthestPlaybackState() {
        PlaybackState result = null;
        for (PlaybackState state : this.playbackStateMap.values()) {
            if (result != null && result.position >= state.position) continue;
            result = state;
        }
        return result;
    }

    public void setRepaintDelegate(RepaintDelegate delegate) {
        this.repaintDelegate.set(delegate);
    }

    private void delegatingRepaint(int x, int y, int width, int height) {
        RepaintDelegate delegate = this.repaintDelegate.get();
        if (delegate != null) {
            delegate.repaint(x, y, width, height);
        } else {
            this.repaint(x, y, width, height);
        }
    }

    private void repaintDueToPlaybackStateChange(long oldMaxPosition, long newMaxPosition, PlaybackState oldState, PlaybackState newState) {
        if (this.duration.get() > 0) {
            int right;
            int left;
            int width = this.waveformWidth() + 8;
            if (oldMaxPosition > newMaxPosition) {
                left = Math.max(0, Math.min(width, this.millisecondsToX(newMaxPosition) - 6));
                right = Math.max(0, Math.min(width, this.millisecondsToX(oldMaxPosition) + 6));
                this.delegatingRepaint(left, 0, right - left, this.getHeight());
            } else if (newMaxPosition > oldMaxPosition) {
                left = Math.max(0, Math.min(width, this.millisecondsToX(oldMaxPosition) - 6));
                right = Math.max(0, Math.min(width, this.millisecondsToX(newMaxPosition) + 6));
                this.delegatingRepaint(left, 0, right - left, this.getHeight());
            }
            if (oldState != null && (newState == null || newState.position != oldState.position)) {
                left = Math.max(0, Math.min(width, this.millisecondsToX(oldState.position) - 6));
                right = Math.max(0, Math.min(width, this.millisecondsToX(oldState.position) + 6));
                this.delegatingRepaint(left, 0, right - left, this.getHeight());
            }
            if (newState != null && (oldState == null || newState.position != oldState.position)) {
                left = Math.max(0, Math.min(width, this.millisecondsToX(newState.position) - 6));
                right = Math.max(0, Math.min(width, this.millisecondsToX(newState.position) + 6));
                this.delegatingRepaint(left, 0, right - left, this.getHeight());
            }
        }
    }

    public synchronized void setPlaybackState(int player, long position, boolean playing) {
        if (this.getMonitoredPlayer() != 0 && player != this.getMonitoredPlayer()) {
            throw new IllegalStateException("Cannot setPlaybackState for another player when monitoring player " + this.getMonitoredPlayer());
        }
        if (player < 1) {
            throw new IllegalArgumentException("player must be positive");
        }
        long oldMaxPosition = 0L;
        PlaybackState furthestState = this.getFurthestPlaybackState();
        if (furthestState != null) {
            oldMaxPosition = furthestState.position;
        }
        PlaybackState newState = new PlaybackState(player, position, playing);
        PlaybackState oldState = this.playbackStateMap.put(player, newState);
        long newMaxPosition = 0L;
        furthestState = this.getFurthestPlaybackState();
        if (furthestState != null) {
            newMaxPosition = furthestState.position;
        }
        this.repaintDueToPlaybackStateChange(oldMaxPosition, newMaxPosition, oldState, newState);
    }

    public synchronized void clearPlaybackState(int player) {
        long oldMaxPosition = 0L;
        PlaybackState furthestState = this.getFurthestPlaybackState();
        if (furthestState != null) {
            oldMaxPosition = furthestState.position;
        }
        PlaybackState oldState = this.playbackStateMap.remove(player);
        long newMaxPosition = 0L;
        furthestState = this.getFurthestPlaybackState();
        if (furthestState != null) {
            newMaxPosition = furthestState.position;
        }
        this.repaintDueToPlaybackStateChange(oldMaxPosition, newMaxPosition, oldState, null);
    }

    public synchronized void clearPlaybackState() {
        for (PlaybackState state : this.playbackStateMap.values()) {
            this.clearPlaybackState(state.player);
        }
    }

    public PlaybackState getPlaybackState(int player) {
        return this.playbackStateMap.get(player);
    }

    public Set<PlaybackState> getPlaybackState() {
        HashSet<PlaybackState> result = new HashSet<PlaybackState>(this.playbackStateMap.values());
        return Collections.unmodifiableSet(result);
    }

    private PlaybackState currentSimpleState() {
        if (!this.playbackStateMap.isEmpty()) {
            return this.playbackStateMap.values().iterator().next();
        }
        return null;
    }

    private void setPlaybackPosition(long milliseconds) {
        PlaybackState oldState = this.currentSimpleState();
        if (oldState != null && oldState.position != milliseconds) {
            this.setPlaybackState(oldState.player, milliseconds, oldState.playing);
        }
    }

    private void setPlaying(boolean playing) {
        PlaybackState oldState = this.currentSimpleState();
        if (oldState != null && oldState.playing != playing) {
            this.setPlaybackState(oldState.player, oldState.position, playing);
        }
    }

    private void updateWaveform(WaveformPreview preview) {
        this.preview.set(preview);
        if (preview == null) {
            this.waveformImage.set(null);
        } else {
            BufferedImage image = new BufferedImage(preview.segmentCount, preview.maxHeight, 2);
            Graphics g = image.getGraphics();
            g.setColor(TRANSPARENT);
            g.fillRect(0, 0, preview.segmentCount, preview.maxHeight);
            for (int segment = 0; segment < preview.segmentCount; ++segment) {
                g.setColor(preview.segmentColor(segment, false));
                g.drawLine(segment, preview.maxHeight, segment, preview.maxHeight - preview.segmentHeight(segment, false));
                if (!preview.isColor) continue;
                g.setColor(preview.segmentColor(segment, true));
                g.drawLine(segment, preview.maxHeight, segment, preview.maxHeight - preview.segmentHeight(segment, true));
            }
            this.waveformImage.set(image);
        }
    }

    public void setWaveformPreview(WaveformPreview preview, TrackMetadata metadata) {
        this.updateWaveform(preview);
        this.duration.set(metadata.getDuration());
        this.cueList.set(metadata.getCueList());
        this.clearPlaybackState();
        this.repaint();
    }

    public void setWaveformPreview(WaveformPreview preview, int duration, CueList cueList) {
        this.updateWaveform(preview);
        this.duration.set(duration);
        this.cueList.set(cueList);
        this.clearPlaybackState();
        this.repaint();
    }

    public synchronized void setMonitoredPlayer(int player) {
        if (player < 0) {
            throw new IllegalArgumentException("player cannot be negative");
        }
        this.clearPlaybackState();
        this.monitoredPlayer.set(player);
        if (player > 0) {
            this.setPlaybackState(player, 0L, false);
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            TrackMetadata knownMetadata = null;
            if (MetadataFinder.getInstance().isRunning()) {
                knownMetadata = MetadataFinder.getInstance().getLatestMetadataFor(player);
            }
            if (knownMetadata == null) {
                this.duration.set(0);
                this.cueList.set(null);
            } else {
                this.duration.set(knownMetadata.getDuration());
                this.cueList.set(knownMetadata.getCueList());
            }
            WaveformFinder.getInstance().addWaveformListener(this.waveformListener);
            if (WaveformFinder.getInstance().isRunning()) {
                this.updateWaveform(WaveformFinder.getInstance().getLatestPreviewFor(player));
            } else {
                this.updateWaveform(null);
            }
            BeatGridFinder.getInstance().addBeatGridListener(this.beatGridListener);
            if (BeatGridFinder.getInstance().isRunning()) {
                this.beatGrid.set(BeatGridFinder.getInstance().getLatestBeatGridFor(player));
            } else {
                this.beatGrid.set(null);
            }
            VirtualCdj.getInstance().addUpdateListener(this.updateListener);
            try {
                TimeFinder.getInstance().start();
                if (!this.animating.getAndSet(true)) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (WaveformPreviewComponent.this.animating.get()) {
                                try {
                                    Thread.sleep(33L);
                                }
                                catch (InterruptedException e) {
                                    logger.warn("Waveform animation thread interrupted; ending");
                                    WaveformPreviewComponent.this.animating.set(false);
                                }
                                WaveformPreviewComponent.this.setPlaybackPosition(TimeFinder.getInstance().getTimeFor(WaveformPreviewComponent.this.getMonitoredPlayer()));
                            }
                        }
                    }).start();
                }
            }
            catch (Exception e) {
                logger.error("Unable to start the TimeFinder to animate the waveform preview");
                this.animating.set(false);
            }
        } else {
            this.animating.set(false);
            VirtualCdj.getInstance().removeUpdateListener(this.updateListener);
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            WaveformFinder.getInstance().removeWaveformListener(this.waveformListener);
            this.duration.set(0);
            this.updateWaveform(null);
            this.beatGrid.set(null);
        }
        this.repaint();
    }

    public int getMonitoredPlayer() {
        return this.monitoredPlayer.get();
    }

    public WaveformPreviewComponent(int player) {
        this.setMonitoredPlayer(player);
    }

    public WaveformPreviewComponent(WaveformPreview preview, TrackMetadata metadata) {
        this.updateWaveform(preview);
        this.duration.set(metadata.getDuration());
    }

    public WaveformPreviewComponent(WaveformPreview preview, int duration, CueList cueList) {
        this.updateWaveform(preview);
        this.duration.set(duration);
        this.cueList.set(cueList);
    }

    private int heightGivenWaveformHeight(int waveformHeight) {
        return waveformHeight + 8 + 9 + 4 + 4;
    }

    private int widthGivenWaveformWidth(int waveformWidth) {
        return waveformWidth + 8;
    }

    @Override
    public Dimension getPreferredSize() {
        int wavePreferredHeight = this.preview.get() == null ? 31 : this.preview.get().maxHeight;
        int wavePreferredWidth = this.preview.get() == null ? 400 : this.preview.get().segmentCount;
        return new Dimension(this.widthGivenWaveformWidth(wavePreferredWidth), this.heightGivenWaveformHeight(wavePreferredHeight));
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.widthGivenWaveformWidth(200), this.heightGivenWaveformHeight(31));
    }

    public int millisecondsToX(long milliseconds) {
        if (this.duration.get() < 1) {
            return 0;
        }
        long result = milliseconds * (long)this.waveformWidth() / (long)(this.duration.get() * 1000);
        return 4 + Math.max(0, Math.min(this.waveformWidth(), (int)result));
    }

    public long getTimeForX(int x) {
        if (this.duration.get() < 1) {
            return 0L;
        }
        return (x - 4) * this.duration.get() * 1000 / this.waveformWidth();
    }

    @Override
    protected synchronized void paintComponent(Graphics g) {
        OverlayPainter painter;
        Rectangle clipRect = g.getClipBounds();
        g.setColor(this.backgroundColor.get());
        g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        Image image = this.waveformImage.get();
        if (image != null) {
            g.drawImage(image, 4, 10, this.waveformWidth(), this.waveformHeight(), null);
        }
        Color brightPlayed = Util.buildColor(this.indicatorColor.get(), BRIGHT_PLAYED);
        Color dimPlayed = Util.buildColor(this.indicatorColor.get(), DIM_PLAYED);
        Color dimUnplayed = Util.buildColor(this.indicatorColor.get(), DIM_UNPLAYED);
        for (int x = clipRect.x; x <= clipRect.x + clipRect.width; ++x) {
            int segment = x - 4;
            if (segment < 0 || segment >= this.waveformWidth() || this.duration.get() <= 0) continue;
            long maxPosition = 0L;
            PlaybackState furthestState = this.getFurthestPlaybackState();
            if (furthestState != null) {
                maxPosition = furthestState.position;
            }
            if (x < this.millisecondsToX(maxPosition) - 1) {
                g.setColor(x % 2 == 0 ? brightPlayed : dimPlayed);
                if (x == 4) {
                    g.drawLine(x, this.playbackBarTop(), x, this.playbackBarTop() + 4);
                    continue;
                }
                g.drawLine(x, this.playbackBarTop(), x, this.playbackBarTop());
                g.drawLine(x, this.playbackBarTop() + 4, x, this.playbackBarTop() + 4);
                continue;
            }
            if (x <= this.millisecondsToX(maxPosition) + 1) continue;
            g.setColor(x % 2 == 0 ? this.indicatorColor.get() : dimUnplayed);
            g.drawLine(x, this.playbackBarTop(), x, this.playbackBarTop() + 4);
        }
        if (this.duration.get() > 0) {
            g.setColor(this.indicatorColor.get());
            for (int time = 60; time < this.duration.get(); time += 60) {
                int x = this.millisecondsToX(time * 1000);
                g.drawLine(x, this.minuteMarkerTop(), x, this.minuteMarkerTop() + 4);
            }
            g.setColor(Util.buildColor(this.indicatorColor.get(), WaveformDetailComponent.PLAYBACK_MARKER_STOPPED));
            for (PlaybackState state : this.playbackStateMap.values()) {
                if (state.playing) continue;
                g.fillRect(this.millisecondsToX(state.position) - 1, 8, 2, this.positionMarkerHeight());
            }
            g.setColor(Util.buildColor(this.emphasisColor.get(), WaveformDetailComponent.PLAYBACK_MARKER_PLAYING));
            for (PlaybackState state : this.playbackStateMap.values()) {
                if (!state.playing) continue;
                g.fillRect(this.millisecondsToX(state.position) - 1, 8, 2, this.positionMarkerHeight());
            }
        }
        if (this.cueList.get() != null) {
            this.drawCueList(g, clipRect);
        }
        if ((painter = this.overlayPainter.get()) != null) {
            painter.paintOverlay(this, g);
        }
    }

    private void drawCueList(Graphics g, Rectangle clipRect) {
        for (CueList.Entry entry : this.cueList.get().entries) {
            int x = this.millisecondsToX(entry.cueTime);
            if (x <= clipRect.x - 4 || x >= clipRect.x + clipRect.width + 4) continue;
            g.setColor(entry.getColor());
            for (int i = 0; i < 4; ++i) {
                g.drawLine(x - 3 + i, 4 + i, x + 3 - i, 4 + i);
            }
        }
    }

    @Override
    public String toString() {
        return "WaveformPreviewComponent[duration=" + this.duration.get() + ", waveformPreview=" + this.preview.get() + ", beatGrid=" + this.beatGrid.get() + ", cueList=" + this.cueList.get() + ", playbackStateMap=" + this.playbackStateMap + ", monitoredPlayer=" + this.getMonitoredPlayer() + "]";
    }
}

