/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.dbserver;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.Field;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.deepsymmetry.beatlink.dbserver.StringField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message {
    private static final Logger logger = LoggerFactory.getLogger((String)Client.class.getName());
    public static final NumberField MESSAGE_START = new NumberField(-2027730514L, 4);
    public static final Map<Long, KnownType> KNOWN_TYPE_MAP;
    public static final int ALNZ_FILE_TYPE_DAT = 0x544144;
    public static final int ALNZ_FILE_TYPE_EXT = 0x545845;
    public static final int ANLZ_FILE_TAG_COLOR_WAVEFORM_PREVIEW = 878073680;
    public static final int ANLZ_FILE_TAG_COLOR_WAVEFORM_DETAIL = 894850896;
    public static final int ANLZ_FILE_TAG_CUE_COMMENT = 844055376;
    public static final Map<Long, MenuItemType> MENU_ITEM_TYPE_MAP;
    public final NumberField transaction;
    public final NumberField messageType;
    public final KnownType knownType;
    public final NumberField argumentCount;
    public final List<Field> arguments;
    public final List<Field> fields;
    public static final Map<Byte, MenuIdentifier> MENU_IDENTIFIER_MAP;
    public static final long NO_MENU_RESULTS_AVAILABLE = -1L;

    public Message(long transaction, long messageType, Field ... arguments) {
        this(new NumberField(transaction, 4), new NumberField(messageType, 2), arguments);
    }

    public Message(long transaction, KnownType messageType, Field ... arguments) {
        this(transaction, messageType.protocolValue, arguments);
    }

    public Message(NumberField transaction, NumberField messageType, Field ... arguments) {
        if (transaction.getSize() != 4L) {
            throw new IllegalArgumentException("Message transaction sequence number must be 4 bytes long");
        }
        if (messageType.getSize() != 2L) {
            throw new IllegalArgumentException("Message type must be 2 bytes long");
        }
        if (arguments.length > 12) {
            throw new IllegalArgumentException("Messages cannot have more than 12 arguments");
        }
        this.transaction = transaction;
        this.messageType = messageType;
        this.knownType = KNOWN_TYPE_MAP.get(messageType.getValue());
        this.argumentCount = new NumberField(arguments.length, 1);
        this.arguments = Collections.unmodifiableList(Arrays.asList((Object[])arguments.clone()));
        byte[] argTags = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (int i = 0; i < arguments.length; ++i) {
            argTags[i] = arguments[i].getArgumentTag();
        }
        Field[] allFields = new Field[arguments.length + 5];
        allFields[0] = MESSAGE_START;
        allFields[1] = transaction;
        allFields[2] = messageType;
        allFields[3] = this.argumentCount;
        allFields[4] = new BinaryField(argTags);
        System.arraycopy(arguments, 0, allFields, 5, arguments.length);
        this.fields = Collections.unmodifiableList(Arrays.asList(allFields));
    }

    public static Message read(DataInputStream is) throws IOException {
        Field start = Field.read(is);
        if (!(start instanceof NumberField)) {
            throw new IOException("Did not find number field reading start of message; got: " + start);
        }
        if (start.getSize() != 4L) {
            throw new IOException("Number field to start message must be of size 4, got: " + start);
        }
        if (((NumberField)start).getValue() != MESSAGE_START.getValue()) {
            throw new IOException("Number field had wrong value to start message. Expected: " + MESSAGE_START + ", got: " + start);
        }
        Field transaction = Field.read(is);
        if (!(transaction instanceof NumberField)) {
            throw new IOException("Did not find number field reading transaction ID of message; got: " + transaction);
        }
        if (transaction.getSize() != 4L) {
            throw new IOException("Transaction number field of message must be of size 4, got: " + transaction);
        }
        Field type = Field.read(is);
        if (!(type instanceof NumberField)) {
            throw new IOException("Did not find number field reading type of message; got: " + type);
        }
        if (type.getSize() != 2L) {
            throw new IOException("Type field of message must be of size 2, got: " + type);
        }
        Field argCountField = Field.read(is);
        if (!(argCountField instanceof NumberField)) {
            throw new IOException("Did not find number field reading argument count of message; got: " + argCountField);
        }
        if (argCountField.getSize() != 1L) {
            throw new IOException("Argument count field of message must be of size 1, got: " + argCountField);
        }
        int argCount = (int)((NumberField)argCountField).getValue();
        if (argCount < 0 || argCount > 12) {
            throw new IOException("Illegal argument count while reading message; must be between 0 and 12, got: " + argCount);
        }
        Field argTypes = Field.read(is);
        if (!(argTypes instanceof BinaryField)) {
            throw new IOException("Did not find binary field reading argument types of message, got: " + argTypes);
        }
        byte[] argTags = new byte[argCount];
        ((BinaryField)argTypes).getValue().get(argTags);
        Field[] arguments = new Field[argCount];
        Field lastArg = null;
        for (int i = 0; i < argCount; ++i) {
            arguments[i] = argTags[i] == 3 && lastArg instanceof NumberField && ((NumberField)lastArg).getValue() == 0L ? new BinaryField(new byte[0]) : Field.read(is);
            lastArg = arguments[i];
            if (lastArg.getArgumentTag() == argTags[i]) continue;
            throw new IOException("Found argument of wrong type reading message. Expected tag: " + argTags[i] + " and got: " + arguments[i].getArgumentTag());
        }
        Message result = new Message((NumberField)transaction, (NumberField)type, arguments);
        logger.debug("Received> {}", (Object)result);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Message: [transaction: ").append(this.transaction.getValue());
        result.append(String.format(", type: 0x%04x (", this.messageType.getValue()));
        if (this.knownType != null) {
            result.append(this.knownType.description);
        } else {
            result.append("unknown");
        }
        result.append("), arg count: ").append(this.argumentCount.getValue()).append(String.format(", arguments:%n", new Object[0]));
        for (int i = 0; i < this.arguments.size(); ++i) {
            Field arg = this.arguments.get(i);
            result.append(String.format("%4d: ", i + 1));
            if (arg instanceof NumberField) {
                long value = ((NumberField)arg).getValue();
                result.append(String.format("number: %10d (0x%08x)", value, value));
            } else if (arg instanceof BinaryField) {
                ByteBuffer bytes = ((BinaryField)arg).getValue();
                byte[] array = new byte[bytes.remaining()];
                bytes.get(array);
                result.append(String.format("blob length %d:", arg.getSize()));
                for (byte b : array) {
                    result.append(String.format(" %02x", b));
                }
            } else if (arg instanceof StringField) {
                result.append(String.format("string length %d: \"%s\"", arg.getSize(), ((StringField)arg).getValue()));
            } else {
                result.append("unknown: ").append(arg);
            }
            String argDescription = "unknown";
            if (this.knownType != null) {
                argDescription = this.knownType.describeArgument(i);
                if (this.knownType == KnownType.MENU_ITEM && i == 6 && arg instanceof NumberField) {
                    String itemType = "unknown";
                    MenuItemType match = MENU_ITEM_TYPE_MAP.get(((NumberField)arg).getValue());
                    if (match != null) {
                        itemType = match.name();
                    }
                    argDescription = argDescription + ": " + itemType;
                }
            }
            result.append(String.format(" [%s]%n", argDescription));
        }
        return result.append("]").toString();
    }

    public long getMenuResultsCount() {
        if (this.knownType != KnownType.MENU_AVAILABLE) {
            throw new IllegalArgumentException("getMenuResultsCount() can only be used with MENU_AVAILABLE responses.");
        }
        NumberField count = (NumberField)this.arguments.get(1);
        return count.getValue();
    }

    public MenuItemType getMenuItemType() {
        if (this.knownType != KnownType.MENU_ITEM) {
            throw new IllegalArgumentException("getMenuItemType() can only be used with MENU_ITEM responses.");
        }
        NumberField type = (NumberField)this.arguments.get(6);
        MenuItemType result = MENU_ITEM_TYPE_MAP.get(type.getValue());
        if (result == null) {
            return MenuItemType.UNKNOWN;
        }
        return result;
    }

    public void write(WritableByteChannel channel) throws IOException {
        logger.debug("Writing> {}", (Object)this);
        for (Field field : this.fields) {
            field.write(channel);
        }
    }

    static {
        HashMap<Long, MenuItemType> scratch = new HashMap<Long, MenuItemType>();
        for (KnownType knownType : KnownType.values()) {
            scratch.put(knownType.protocolValue, (MenuItemType)((Object)knownType));
        }
        KNOWN_TYPE_MAP = Collections.unmodifiableMap(scratch);
        scratch = new HashMap();
        for (Enum enum_ : MenuItemType.values()) {
            scratch.put(((MenuItemType)enum_).protocolValue, (MenuItemType)enum_);
        }
        MENU_ITEM_TYPE_MAP = scratch;
        scratch = new HashMap();
        for (Enum enum_ : MenuIdentifier.values()) {
            scratch.put((Long)((MenuIdentifier)enum_).protocolValue, (MenuItemType)enum_);
        }
        MENU_IDENTIFIER_MAP = scratch;
    }

    public static enum MenuIdentifier {
        MAIN_MENU(1),
        SUB_MENU(2),
        TRACK_INFO(3),
        SORT_MENU(5),
        DATA(8);

        public final byte protocolValue;

        private MenuIdentifier(int value) {
            this.protocolValue = (byte)value;
        }
    }

    public static enum MenuItemType {
        FOLDER(1L),
        ALBUM_TITLE(2L),
        DISC(3L),
        TRACK_TITLE(4L),
        GENRE(6L),
        ARTIST(7L),
        PLAYLIST(8L),
        RATING(10L),
        DURATION(11L),
        TEMPO(13L),
        LABEL(14L),
        KEY(15L),
        BIT_RATE(16L),
        YEAR(17L),
        COLOR_NONE(19L),
        COLOR_PINK(20L),
        COLOR_RED(21L),
        COLOR_ORANGE(22L),
        COLOR_YELLOW(23L),
        COLOR_GREEN(24L),
        COLOR_AQUA(25L),
        COLOR_BLUE(26L),
        COLOR_PURPLE(27L),
        COMMENT(35L),
        HISTORY_PLAYLIST(36L),
        ORIGINAL_ARTIST(40L),
        REMIXER(41L),
        DATE_ADDED(46L),
        GENRE_MENU(128L),
        ARTIST_MENU(129L),
        ALBUM_MENU(130L),
        TRACK_MENU(131L),
        PLAYLIST_MENU(132L),
        BPM_MENU(133L),
        RATING_MENU(134L),
        YEAR_MENU(135L),
        REMIXER_MENU(136L),
        LABEL_MENU(137L),
        ORIGINAL_ARTIST_MENU(138L),
        KEY_MENU(139L),
        COLOR_MENU(142L),
        FOLDER_MENU(144L),
        SEARCH_MENU(145L),
        TIME_MENU(146L),
        BIT_RATE_MENU(147L),
        FILENAME_MENU(148L),
        HISTORY_MENU(149L),
        HOT_CUE_BANK_MENU(152L),
        ALL(160L),
        TRACK_TITLE_AND_ALBUM(516L),
        TRACK_TITLE_AND_GENRE(1540L),
        TRACK_TITLE_AND_ARTIST(1796L),
        TRACK_TITLE_AND_TIME(2820L),
        TRACK_TITLE_AND_RATING(2564L),
        TRACK_TITLE_AND_BPM(3332L),
        TRACK_TITLE_AND_LABEL(3588L),
        TRACK_TITLE_AND_RATE(4100L),
        TRACK_LIST_ENTRY_BY_COLOR(6660L),
        TRACK_TITLE_AND_COMMENT(8964L),
        TRACK_TITLE_AND_ORIGINAL_ARTIST(10244L),
        TRACK_TITLE_AND_REMIXER(10500L),
        TRACK_TITLE_AND_DJ_PLAY_COUNT(10756L),
        TRACK_TITLE_AND_DATE_ADDED(11780L),
        UNKNOWN(-1L);

        public final long protocolValue;

        private MenuItemType(long value) {
            this.protocolValue = value;
        }
    }

    public static enum KnownType {
        SETUP_REQ(0L, "setup request", "requesting player"),
        INVALID_DATA(1L, "invalid data", new String[0]),
        TEARDOWN_REQ(256L, "teardown request", new String[0]),
        ROOT_MENU_REQ(4096L, "root menu request", "r:m:s:t", "sort order", "magic constant?"),
        GENRE_MENU_REQ(4097L, "genre menu request", "r:m:s:t", "sort order"),
        ARTIST_MENU_REQ(4098L, "artist menu request", "r:m:s:t", "sort order"),
        ALBUM_MENU_REQ(4099L, "album menu request", "r:m:s:t", "sort order"),
        TRACK_MENU_REQ(4100L, "track menu request", "r:m:s:t", "sort order"),
        BPM_MENU_REQ(4102L, "bpm menu request", "r:m:s:t", "sort order"),
        RATING_MENU_REQ(4103L, "rating menu request", "r:m:s:t", "sort order"),
        YEAR_MENU_REQ(4104L, "year menu request", "r:m:s:t", "sort order"),
        LABEL_MENU_REQ(4106L, "label menu request", "r:m:s:t", "sort order"),
        COLOR_MENU_REQ(4109L, "color menu request", "r:m:s:t", "sort order"),
        TIME_MENU_REQ(4112L, "time menu request", "r:m:s:t", "sort order"),
        BIT_RATE_MENU_REQ(4113L, "bit rate menu request", "r:m:s:t", "sort order"),
        HISTORY_MENU_REQ(4114L, "history menu request", "r:m:s:t", "sort order"),
        FILENAME_MENU_REQ(4115L, "filename menu request", "r:m:s:t", "sort order"),
        KEY_MENU_REQ(4116L, "key menu request", "r:m:s:t", "sort order"),
        ARTIST_MENU_FOR_GENRE_REQ(4353L, "artist menu for genre request", "r:m:s:t", "sort", "genre ID"),
        ALBUM_MENU_FOR_ARTIST_REQ(4354L, "album menu for artist request", "r:m:s:t", "sort", "artist ID"),
        TRACK_MENU_FOR_ALBUM_REQ(4355L, "track menu for album request", "r:m:s:t", "sort", "album ID"),
        PLAYLIST_REQ(4357L, "playlist/folder request", "r:m:s:t", "sort order", "playlist/folder ID", "0=playlist, 1=folder"),
        BPM_RANGE_REQ(4358L, "bpm range request", "r:m:s:t", "sort order", "tempo"),
        TRACK_MENU_FOR_RATING_REQ(4359L, "track menu for rating request", "r:m:s:t", "sort", "rating ID"),
        YEAR_MENU_FOR_DECADE_REQ(4360L, "year menu for decade request", "r:m:s:t", "sort", "decade"),
        ARTIST_MENU_FOR_LABEL_REQ(4362L, "artist menu for genre request", "r:m:s:t", "sort", "label ID, or -1 for ALL"),
        TRACK_MENU_FOR_COLOR_REQ(4365L, "track menu for color request", "r:m:s:t", "sort", "color ID"),
        TRACK_MENU_FOR_TIME_REQ(4368L, "track menu for time request", "r:m:s:t", "sort", "minutes"),
        TRACK_MENU_FOR_BIT_RATE_REQ(4369L, "track menu for bit rate request", "r:m:s:t", "sort", "bit rate"),
        TRACK_MENU_FOR_HISTORY_REQ(4370L, "track menu for history entry request", "r:m:s:t", "sort", "history ID"),
        NEIGHBOR_MENU_FOR_KEY(4372L, "neighbor menu for key request", "r:m:s:t", "sort", "key ID"),
        ALBUM_MENU_FOR_GENRE_AND_ARTIST(4609L, "album menu for genre and artist request", "r:m:s:t:", "sort", "genre ID", "artist ID, or -1 for ALL"),
        TRACK_MENU_FOR_ARTIST_AND_ALBUM(4610L, "track menu for artist and album request", "r:m:s:t:", "sort", "artist ID", "album ID, or -1 for ALL"),
        TRACK_MENU_FOR_BPM_AND_DISTANCE(4614L, "track menu for BPM and distance request", "r:m:s:t:", "sort", "bpm ID", "distance (+/- %, can range from 0-6)"),
        TRACK_MENU_FOR_DECADE_YEAR_REQ(4616L, "track menu for decade and year request", "r:m:s:t", "sort", "decade", "year, or -1 for ALL"),
        ALBUM_MENU_FOR_LABEL_AND_ARTIST(4618L, "album menu for label and artist request", "r:m:s:t:", "sort", "label ID", "artist ID, or -1 for ALL"),
        TRACK_MENU_FOR_KEY_AND_DISTANCE(4628L, "track menu for key and distance request", "r:m:s:t:", "sort", "key ID", "distance (around circle of fifths)"),
        SEARCH_MENU(4864L, "search by substring request", "r:m:s:t", "sort", "search string byte size", "search string (must be uppercase", "unknown (0)"),
        TRACK_MENU_FOR_GENRE_ARTIST_AND_ALBUM(4865L, "track menu for genre, artist and album request", "r:m:s:t:", "sort", "genre ID", "artist ID, or -1 for ALL", "album ID, or -1 for ALL"),
        ORIGINAL_ARTIST_MENU_REQ(4866L, "original artist menu request", "r:m:s:t", "sort order"),
        TRACK_MENU_FOR_LABEL_ARTIST_AND_ALBUM(4874L, "track menu for label, artist and album request", "r:m:s:t:", "sort", "label ID", "artist ID, or -1 for ALL", "album ID, or -1 for ALL"),
        ALBUM_MENU_FOR_ORIGINAL_ARTIST_REQ(5122L, "album menu for original artist request", "r:m:s:t", "sort", "artist ID"),
        TRACK_MENU_FOR_ORIGINAL_ARTIST_AND_ALBUM(5378L, "track menu for original artist and album request", "r:m:s:t:", "sort", "artist ID", "album ID, or -1 for ALL"),
        REMIXER_MENU_REQ(5634L, "remixer menu request", "r:m:s:t", "sort order"),
        ALBUM_MENU_FOR_REMIXER_REQ(5890L, "album menu for remixer request", "r:m:s:t", "sort", "artist ID"),
        TRACK_MENU_FOR_REMIXER_AND_ALBUM(6146L, "track menu for remixer and album request", "r:m:s:t:", "sort", "artist ID", "album ID, or -1 for ALL"),
        REKORDBOX_METADATA_REQ(8194L, "rekordbox track metadata request", "r:m:s:t", "rekordbox id"),
        ALBUM_ART_REQ(8195L, "album art request", "r:m:s:t", "artwork id"),
        WAVE_PREVIEW_REQ(8196L, "track waveform preview request", "r:m:s:t", "unknown (4)", "rekordbox id", "unknown (0)"),
        FOLDER_MENU_REQ(8198L, "folder menu request", "r:m:s:t", "sort order?", "folder id (-1 for root)", "unknown (0)"),
        CUE_LIST_REQ(8452L, "track cue list request", "r:m:s:t", "rekordbox id"),
        UNANALYZED_METADATA_REQ(8706L, "unanalyzed track metadata request", "r:m:s:t", "track number"),
        BEAT_GRID_REQ(8708L, "beat grid request", "r:m:s:t", "rekordbox id"),
        WAVE_DETAIL_REQ(10500L, "track waveform detail request", "r:m:s:t", "rekordbox id"),
        CUE_LIST_EXT_REQ(11012L, "track extended cue list request", "r:m:s:t", "rekordbox id", "unknown (0)"),
        ANLZ_TAG_REQ(11268L, "anlz file tag content request", "r:m:s:t", "rekordbox id", "tag type", "file extension"),
        RENDER_MENU_REQ(12288L, "render items from last requested menu", "r:m:s:t", "offset", "limit", "unknown (0)", "len_a (=limit)?", "unknown (0)"),
        MENU_AVAILABLE(16384L, "requested menu is available", "request type", "# items available"),
        MENU_HEADER(16385L, "rendered menu header", new String[0]),
        ALBUM_ART(16386L, "album art", "request type", "unknown (0)", "image length", "image bytes"),
        UNAVAILABLE(16387L, "requested media unavailable", "request type"),
        MENU_ITEM(16641L, "rendered menu item", "numeric 1 (parent id, e.g. artist for track)", "numeric 2 (this id)", "label 1 byte size", "label 1", "label 2 byte size", "label 2", "item type", "flags? byte 3 is 1 when track played", "album art id", "playlist position"),
        MENU_FOOTER(16897L, "rendered menu footer", new String[0]),
        WAVE_PREVIEW(17410L, "track waveform preview", "request type", "unknown (0)", "waveform length", "waveform bytes"),
        BEAT_GRID(17922L, "beat grid", "request type", "unknown (0)", "beat grid length", "beat grid bytes", "unknown (0)"),
        CUE_LIST(18178L, "memory points, loops, and hot cues", "request type", "unknown", "blob 1 length", "blob 1", "unknown (0x24)", "unknown", "unknown", "blob 2 length", "blob 2"),
        WAVE_DETAIL(18946L, "track waveform detail", "request type", "unknown (0)", "waveform length", "waveform bytes"),
        CUE_LIST_EXT(19970L, "extended memory points, loops, and hot cues", "request type", "unknown (0)", "blob length", "blob", "entry count"),
        ANLZ_TAG(20226L, "anlz file tag content", "request type", "unknown (0)", "tag length", "tag bytes", "unknown (1)");

        public final long protocolValue;
        public final String description;
        private final String[] arguments;

        private KnownType(long value, String description, String ... arguments) {
            this.protocolValue = value;
            this.description = description;
            this.arguments = (String[])arguments.clone();
        }

        public String describeArgument(int index) {
            if (index < 0 || index >= this.arguments.length) {
                return "unknown";
            }
            return this.arguments[index];
        }

        public List<String> arguments() {
            return Collections.unmodifiableList(Arrays.asList(this.arguments));
        }
    }
}

