/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.electro.Metronome;
import org.deepsymmetry.electro.Snapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BeatSender {
    private static final Logger logger = LoggerFactory.getLogger(BeatSender.class);
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final Thread thread;
    private final Metronome metronome;
    private final AtomicReference<Long> lastBeatSent = new AtomicReference();
    public static final long BEAT_THRESHOLD = 10L;
    public static final int SLEEP_THRESHOLD = 5;
    private final Runnable beatLoop = new Runnable(){

        @Override
        public void run() {
            while (BeatSender.this.running.get()) {
                long sleepMilliseconds;
                Snapshot snapshot = BeatSender.this.metronome.getSnapshot();
                if (BeatSender.this.lastBeatSent.get() != null && (snapshot.getBeatPhase() > 0.5 || snapshot.getBeat() != ((Long)BeatSender.this.lastBeatSent.get()).longValue())) {
                    BeatSender.this.lastBeatSent.set(null);
                }
                long currentBeatDue = snapshot.getTimeOfBeat(snapshot.getBeat());
                long nextBeatDue = snapshot.getTimeOfBeat(snapshot.getBeat() + 1L);
                long distanceIntoCurrentBeat = snapshot.getInstant() - currentBeatDue;
                if (distanceIntoCurrentBeat < 10L && (BeatSender.this.lastBeatSent.get() == null || ((Long)BeatSender.this.lastBeatSent.get()).longValue() != snapshot.getBeat())) {
                    BeatSender.this.lastBeatSent.set(VirtualCdj.getInstance().sendBeat(snapshot));
                }
                if ((sleepMilliseconds = nextBeatDue - System.currentTimeMillis()) > 5L) {
                    try {
                        Thread.sleep(sleepMilliseconds - 5L);
                    }
                    catch (InterruptedException e) {
                        logger.info("BeatSender thread interrupted, re-evaluating time until next beat.");
                    }
                    continue;
                }
                long targetTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(sleepMilliseconds);
                while (!Thread.interrupted() && System.nanoTime() < targetTime) {
                }
            }
        }
    };

    void timelineChanged() {
        if (!this.running.get()) {
            logger.warn("BeatSender ignoring timelineChanged() call because it has been shut down.");
            return;
        }
        this.thread.interrupt();
    }

    void shutDown() {
        this.running.set(false);
        this.thread.interrupt();
    }

    BeatSender(Metronome metronome) {
        this.metronome = metronome;
        this.thread = new Thread(this.beatLoop, "beat-link VirtualCdj beat sender");
        this.thread.setPriority(6);
        this.thread.setDaemon(true);
        this.thread.start();
    }
}

